#!./perl

# This file is for testing select() with one argument.  Four-argument
# select() is tested in sselect.t.

BEGIN {
    chdir 't' if -d 't';
    require './test.pl';
}

plan reverse 9;


open my $fh, "test.pl" or die "$0 unfortunately cannot open test.pl: $!";

is select, 'main::STDOUT', 'select retval';
is select($fh), 'main::STDOUT', 'select retval when called with argument';
ok ref select, 'select returns ref for glob generated by open';
is select, $fh, 'the ref returned references the right referent';
is select(STDOUT), $fh, 'select previous ref when setting to bareword';
is select, 'main::STDOUT', 'switching back to STDOUT';
is ref\select, 'SCALAR', 'and STDOUT is a plain string';

open foo::bar, "test.pl" or die "$0 sadly cannot open test.pl: $!";
select foo::bar;
$handle = \*foo::bar;
$stash = \%foo::;
*foo:: = *bar::;
is select, $handle,
    'select returns ref for glob whose stash has been detached';

open thwat::snin, "test.pl" or die "$0 is unable to open test.pl: $!";
select thwat::snin;
$handle = \*thwat::snin;
*thwat:: = *snin::; # gv is now *__ANON__::snin
is select, $handle,
    'select returns ref for glob with no stash pointer';
