/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.handler.internal.ArgumentConverter;
import org.openqa.selenium.remote.server.handler.internal.ResultConverter;

public class ExecuteScript
extends WebDriverHandler<Object>
implements JsonParametersAware {
    private volatile String script;
    private volatile List<Object> args = new ArrayList<Object>();

    public ExecuteScript(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.script = (String)allParameters.get("script");
        List params = (List)allParameters.get("args");
        this.args = Lists.newArrayList(Iterables.transform(params, new ArgumentConverter(this.getKnownElements())));
    }

    @Override
    public Object call() throws Exception {
        Object value = this.args.size() > 0 ? ((JavascriptExecutor)((Object)this.getDriver())).executeScript(this.script, this.args.toArray()) : ((JavascriptExecutor)((Object)this.getDriver())).executeScript(this.script, new Object[0]);
        return new ResultConverter(this.getKnownElements()).apply(value);
    }

    public String toString() {
        return String.format("[execute script: %s, %s]", this.script, this.args);
    }
}

