/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SequenceOutputter
extends SequenceWriter {
    private List<Item> list;
    private Controller controller;

    public SequenceOutputter(PipelineConfiguration pipe) {
        super(pipe);
        this.list = new ArrayList<Item>(50);
    }

    public SequenceOutputter(PipelineConfiguration pipe, Controller controller, int estimatedSize) {
        super(pipe);
        this.list = new ArrayList<Item>(estimatedSize);
        this.controller = controller;
    }

    public SequenceOutputter(PipelineConfiguration pipe, Controller controller) {
        super(pipe);
        this.list = new ArrayList<Item>(50);
        this.controller = controller;
    }

    public static SequenceOutputter allocateSequenceOutputter(XPathContext context, int hostLang) {
        Controller controller = context.getController();
        SequenceOutputter seq = controller.allocateSequenceOutputter(20);
        seq.getPipelineConfiguration().setHostLanguage(hostLang);
        return seq;
    }

    public void reset() {
        this.list = new ArrayList<Item>(Math.min(this.list.size() + 10, 50));
        if (this.controller != null && this.adviseReuse()) {
            this.controller.reuseSequenceOutputter(this);
        }
    }

    @Override
    public void write(Item item) {
        this.list.add(item);
    }

    public ValueRepresentation<Item> getSequence() {
        switch (this.list.size()) {
            case 0: {
                return EmptySequence.getInstance();
            }
            case 1: {
                return this.list.get(0);
            }
        }
        return new SequenceExtent<Item>(this.list);
    }

    public SequenceIterator<? extends Item> iterate() {
        if (this.list.isEmpty()) {
            return EmptyIterator.emptyIterator();
        }
        return new ListIterator<Item>(this.list);
    }

    public List<Item> getList() {
        return this.list;
    }

    public Item getFirstItem() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(0);
    }

    public Item popLastItem() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.remove(this.list.size() - 1);
    }
}

