#![allow(non_camel_case_types)]
#![allow(clippy::unreadable_literal)]

#[cfg(any(target_os = "android", all(unix, not(target_vendor = "apple"))))]
extern crate freetype;

#[cfg(target_vendor = "apple")]
pub mod coretext;

#[cfg(any(target_os = "android", all(unix, not(target_vendor = "apple"))))]
extern "C" {
    pub fn hb_ft_font_create_referenced(face: freetype::freetype::FT_Face) -> *mut hb_font_t;
}

/* automatically generated by rust-bindgen */

pub const HB_FEATURE_GLOBAL_START: u32 = 0;
pub const HB_UNICODE_MAX: u32 = 1114111;
pub const HB_BUFFER_REPLACEMENT_CODEPOINT_DEFAULT: u32 = 65533;
pub const HB_OT_MAX_TAGS_PER_SCRIPT: u32 = 3;
pub const HB_OT_MAX_TAGS_PER_LANGUAGE: u32 = 3;
pub const HB_OT_LAYOUT_NO_SCRIPT_INDEX: u32 = 65535;
pub const HB_OT_LAYOUT_NO_FEATURE_INDEX: u32 = 65535;
pub const HB_OT_LAYOUT_DEFAULT_LANGUAGE_INDEX: u32 = 65535;
pub const HB_OT_LAYOUT_NO_VARIATIONS_INDEX: u32 = 4294967295;
pub const HB_AAT_LAYOUT_NO_SELECTOR_INDEX: u32 = 65535;
pub type hb_bool_t = ::std::os::raw::c_int;
pub type hb_codepoint_t = u32;
pub type hb_position_t = i32;
pub type hb_mask_t = u32;
#[repr(C)]
#[derive(Copy, Clone)]
pub union _hb_var_int_t {
    pub u32: u32,
    pub i32: i32,
    pub u16: [u16; 2usize],
    pub i16: [i16; 2usize],
    pub u8: [u8; 4usize],
    pub i8: [i8; 4usize],
    _bindgen_union_align: u32,
}
#[allow(non_snake_case)]
#[test]
fn bindgen_test_layout__hb_var_int_t() {
    assert_eq!(
        ::std::mem::size_of::<_hb_var_int_t>(),
        4usize,
        concat!("Size of: ", stringify!(_hb_var_int_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_hb_var_int_t>(),
        4usize,
        concat!("Alignment of ", stringify!(_hb_var_int_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_hb_var_int_t>())).u32 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_hb_var_int_t),
            "::",
            stringify!(u32)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_hb_var_int_t>())).i32 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_hb_var_int_t),
            "::",
            stringify!(i32)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_hb_var_int_t>())).u16 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_hb_var_int_t),
            "::",
            stringify!(u16)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_hb_var_int_t>())).i16 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_hb_var_int_t),
            "::",
            stringify!(i16)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_hb_var_int_t>())).u8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_hb_var_int_t),
            "::",
            stringify!(u8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_hb_var_int_t>())).i8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_hb_var_int_t),
            "::",
            stringify!(i8)
        )
    );
}
impl ::std::fmt::Debug for _hb_var_int_t {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        write!(f, "_hb_var_int_t {{ ... }}")
    }
}
pub type hb_var_int_t = _hb_var_int_t;
pub type hb_tag_t = u32;
extern "C" {
    pub fn hb_tag_from_string(
        str: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_tag_t;
}
extern "C" {
    pub fn hb_tag_to_string(tag: hb_tag_t, buf: *mut ::std::os::raw::c_char);
}
pub const HB_DIRECTION_INVALID: hb_direction_t = 0;
pub const HB_DIRECTION_LTR: hb_direction_t = 4;
pub const HB_DIRECTION_RTL: hb_direction_t = 5;
pub const HB_DIRECTION_TTB: hb_direction_t = 6;
pub const HB_DIRECTION_BTT: hb_direction_t = 7;
/// hb_direction_t:
/// @HB_DIRECTION_INVALID: Initial, unset direction.
/// @HB_DIRECTION_LTR: Text is set horizontally from left to right.
/// @HB_DIRECTION_RTL: Text is set horizontally from right to left.
/// @HB_DIRECTION_TTB: Text is set vertically from top to bottom.
/// @HB_DIRECTION_BTT: Text is set vertically from bottom to top.
pub type hb_direction_t = u32;
extern "C" {
    pub fn hb_direction_from_string(
        str: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_direction_t;
}
extern "C" {
    pub fn hb_direction_to_string(direction: hb_direction_t) -> *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_language_impl_t {
    _unused: [u8; 0],
}
pub type hb_language_t = *const hb_language_impl_t;
extern "C" {
    pub fn hb_language_from_string(
        str: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_language_t;
}
extern "C" {
    pub fn hb_language_to_string(language: hb_language_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_language_get_default() -> hb_language_t;
}
pub const HB_SCRIPT_COMMON: hb_script_t = 1517910393;
pub const HB_SCRIPT_INHERITED: hb_script_t = 1516858984;
pub const HB_SCRIPT_UNKNOWN: hb_script_t = 1517976186;
pub const HB_SCRIPT_ARABIC: hb_script_t = 1098015074;
pub const HB_SCRIPT_ARMENIAN: hb_script_t = 1098018158;
pub const HB_SCRIPT_BENGALI: hb_script_t = 1113943655;
pub const HB_SCRIPT_CYRILLIC: hb_script_t = 1132032620;
pub const HB_SCRIPT_DEVANAGARI: hb_script_t = 1147500129;
pub const HB_SCRIPT_GEORGIAN: hb_script_t = 1197830002;
pub const HB_SCRIPT_GREEK: hb_script_t = 1198679403;
pub const HB_SCRIPT_GUJARATI: hb_script_t = 1198877298;
pub const HB_SCRIPT_GURMUKHI: hb_script_t = 1198879349;
pub const HB_SCRIPT_HANGUL: hb_script_t = 1214344807;
pub const HB_SCRIPT_HAN: hb_script_t = 1214344809;
pub const HB_SCRIPT_HEBREW: hb_script_t = 1214603890;
pub const HB_SCRIPT_HIRAGANA: hb_script_t = 1214870113;
pub const HB_SCRIPT_KANNADA: hb_script_t = 1265525857;
pub const HB_SCRIPT_KATAKANA: hb_script_t = 1264676449;
pub const HB_SCRIPT_LAO: hb_script_t = 1281453935;
pub const HB_SCRIPT_LATIN: hb_script_t = 1281455214;
pub const HB_SCRIPT_MALAYALAM: hb_script_t = 1298954605;
pub const HB_SCRIPT_ORIYA: hb_script_t = 1332902241;
pub const HB_SCRIPT_TAMIL: hb_script_t = 1415671148;
pub const HB_SCRIPT_TELUGU: hb_script_t = 1415933045;
pub const HB_SCRIPT_THAI: hb_script_t = 1416126825;
pub const HB_SCRIPT_TIBETAN: hb_script_t = 1416192628;
pub const HB_SCRIPT_BOPOMOFO: hb_script_t = 1114599535;
pub const HB_SCRIPT_BRAILLE: hb_script_t = 1114792297;
pub const HB_SCRIPT_CANADIAN_SYLLABICS: hb_script_t = 1130458739;
pub const HB_SCRIPT_CHEROKEE: hb_script_t = 1130915186;
pub const HB_SCRIPT_ETHIOPIC: hb_script_t = 1165256809;
pub const HB_SCRIPT_KHMER: hb_script_t = 1265134962;
pub const HB_SCRIPT_MONGOLIAN: hb_script_t = 1299148391;
pub const HB_SCRIPT_MYANMAR: hb_script_t = 1299803506;
pub const HB_SCRIPT_OGHAM: hb_script_t = 1332175213;
pub const HB_SCRIPT_RUNIC: hb_script_t = 1383427698;
pub const HB_SCRIPT_SINHALA: hb_script_t = 1399418472;
pub const HB_SCRIPT_SYRIAC: hb_script_t = 1400468067;
pub const HB_SCRIPT_THAANA: hb_script_t = 1416126817;
pub const HB_SCRIPT_YI: hb_script_t = 1500080489;
pub const HB_SCRIPT_DESERET: hb_script_t = 1148416628;
pub const HB_SCRIPT_GOTHIC: hb_script_t = 1198486632;
pub const HB_SCRIPT_OLD_ITALIC: hb_script_t = 1232363884;
pub const HB_SCRIPT_BUHID: hb_script_t = 1114990692;
pub const HB_SCRIPT_HANUNOO: hb_script_t = 1214344815;
pub const HB_SCRIPT_TAGALOG: hb_script_t = 1416064103;
pub const HB_SCRIPT_TAGBANWA: hb_script_t = 1415669602;
pub const HB_SCRIPT_CYPRIOT: hb_script_t = 1131442804;
pub const HB_SCRIPT_LIMBU: hb_script_t = 1281977698;
pub const HB_SCRIPT_LINEAR_B: hb_script_t = 1281977954;
pub const HB_SCRIPT_OSMANYA: hb_script_t = 1332964705;
pub const HB_SCRIPT_SHAVIAN: hb_script_t = 1399349623;
pub const HB_SCRIPT_TAI_LE: hb_script_t = 1415670885;
pub const HB_SCRIPT_UGARITIC: hb_script_t = 1432838514;
pub const HB_SCRIPT_BUGINESE: hb_script_t = 1114990441;
pub const HB_SCRIPT_COPTIC: hb_script_t = 1131376756;
pub const HB_SCRIPT_GLAGOLITIC: hb_script_t = 1198285159;
pub const HB_SCRIPT_KHAROSHTHI: hb_script_t = 1265131890;
pub const HB_SCRIPT_NEW_TAI_LUE: hb_script_t = 1415670901;
pub const HB_SCRIPT_OLD_PERSIAN: hb_script_t = 1483761007;
pub const HB_SCRIPT_SYLOTI_NAGRI: hb_script_t = 1400466543;
pub const HB_SCRIPT_TIFINAGH: hb_script_t = 1415999079;
pub const HB_SCRIPT_BALINESE: hb_script_t = 1113681001;
pub const HB_SCRIPT_CUNEIFORM: hb_script_t = 1483961720;
pub const HB_SCRIPT_NKO: hb_script_t = 1315663727;
pub const HB_SCRIPT_PHAGS_PA: hb_script_t = 1349017959;
pub const HB_SCRIPT_PHOENICIAN: hb_script_t = 1349021304;
pub const HB_SCRIPT_CARIAN: hb_script_t = 1130459753;
pub const HB_SCRIPT_CHAM: hb_script_t = 1130914157;
pub const HB_SCRIPT_KAYAH_LI: hb_script_t = 1264675945;
pub const HB_SCRIPT_LEPCHA: hb_script_t = 1281716323;
pub const HB_SCRIPT_LYCIAN: hb_script_t = 1283023721;
pub const HB_SCRIPT_LYDIAN: hb_script_t = 1283023977;
pub const HB_SCRIPT_OL_CHIKI: hb_script_t = 1332503403;
pub const HB_SCRIPT_REJANG: hb_script_t = 1382706791;
pub const HB_SCRIPT_SAURASHTRA: hb_script_t = 1398895986;
pub const HB_SCRIPT_SUNDANESE: hb_script_t = 1400204900;
pub const HB_SCRIPT_VAI: hb_script_t = 1449224553;
pub const HB_SCRIPT_AVESTAN: hb_script_t = 1098281844;
pub const HB_SCRIPT_BAMUM: hb_script_t = 1113681269;
pub const HB_SCRIPT_EGYPTIAN_HIEROGLYPHS: hb_script_t = 1164409200;
pub const HB_SCRIPT_IMPERIAL_ARAMAIC: hb_script_t = 1098018153;
pub const HB_SCRIPT_INSCRIPTIONAL_PAHLAVI: hb_script_t = 1349020777;
pub const HB_SCRIPT_INSCRIPTIONAL_PARTHIAN: hb_script_t = 1349678185;
pub const HB_SCRIPT_JAVANESE: hb_script_t = 1247901281;
pub const HB_SCRIPT_KAITHI: hb_script_t = 1265920105;
pub const HB_SCRIPT_LISU: hb_script_t = 1281979253;
pub const HB_SCRIPT_MEETEI_MAYEK: hb_script_t = 1299473769;
pub const HB_SCRIPT_OLD_SOUTH_ARABIAN: hb_script_t = 1398895202;
pub const HB_SCRIPT_OLD_TURKIC: hb_script_t = 1332898664;
pub const HB_SCRIPT_SAMARITAN: hb_script_t = 1398893938;
pub const HB_SCRIPT_TAI_THAM: hb_script_t = 1281453665;
pub const HB_SCRIPT_TAI_VIET: hb_script_t = 1415673460;
pub const HB_SCRIPT_BATAK: hb_script_t = 1113683051;
pub const HB_SCRIPT_BRAHMI: hb_script_t = 1114792296;
pub const HB_SCRIPT_MANDAIC: hb_script_t = 1298230884;
pub const HB_SCRIPT_CHAKMA: hb_script_t = 1130457965;
pub const HB_SCRIPT_MEROITIC_CURSIVE: hb_script_t = 1298494051;
pub const HB_SCRIPT_MEROITIC_HIEROGLYPHS: hb_script_t = 1298494063;
pub const HB_SCRIPT_MIAO: hb_script_t = 1349284452;
pub const HB_SCRIPT_SHARADA: hb_script_t = 1399353956;
pub const HB_SCRIPT_SORA_SOMPENG: hb_script_t = 1399812705;
pub const HB_SCRIPT_TAKRI: hb_script_t = 1415670642;
pub const HB_SCRIPT_BASSA_VAH: hb_script_t = 1113682803;
pub const HB_SCRIPT_CAUCASIAN_ALBANIAN: hb_script_t = 1097295970;
pub const HB_SCRIPT_DUPLOYAN: hb_script_t = 1148547180;
pub const HB_SCRIPT_ELBASAN: hb_script_t = 1164730977;
pub const HB_SCRIPT_GRANTHA: hb_script_t = 1198678382;
pub const HB_SCRIPT_KHOJKI: hb_script_t = 1265135466;
pub const HB_SCRIPT_KHUDAWADI: hb_script_t = 1399418468;
pub const HB_SCRIPT_LINEAR_A: hb_script_t = 1281977953;
pub const HB_SCRIPT_MAHAJANI: hb_script_t = 1298229354;
pub const HB_SCRIPT_MANICHAEAN: hb_script_t = 1298230889;
pub const HB_SCRIPT_MENDE_KIKAKUI: hb_script_t = 1298493028;
pub const HB_SCRIPT_MODI: hb_script_t = 1299145833;
pub const HB_SCRIPT_MRO: hb_script_t = 1299345263;
pub const HB_SCRIPT_NABATAEAN: hb_script_t = 1315070324;
pub const HB_SCRIPT_OLD_NORTH_ARABIAN: hb_script_t = 1315009122;
pub const HB_SCRIPT_OLD_PERMIC: hb_script_t = 1348825709;
pub const HB_SCRIPT_PAHAWH_HMONG: hb_script_t = 1215131239;
pub const HB_SCRIPT_PALMYRENE: hb_script_t = 1348562029;
pub const HB_SCRIPT_PAU_CIN_HAU: hb_script_t = 1348564323;
pub const HB_SCRIPT_PSALTER_PAHLAVI: hb_script_t = 1349020784;
pub const HB_SCRIPT_SIDDHAM: hb_script_t = 1399415908;
pub const HB_SCRIPT_TIRHUTA: hb_script_t = 1416196712;
pub const HB_SCRIPT_WARANG_CITI: hb_script_t = 1466004065;
pub const HB_SCRIPT_AHOM: hb_script_t = 1097363309;
pub const HB_SCRIPT_ANATOLIAN_HIEROGLYPHS: hb_script_t = 1215067511;
pub const HB_SCRIPT_HATRAN: hb_script_t = 1214346354;
pub const HB_SCRIPT_MULTANI: hb_script_t = 1299541108;
pub const HB_SCRIPT_OLD_HUNGARIAN: hb_script_t = 1215655527;
pub const HB_SCRIPT_SIGNWRITING: hb_script_t = 1399287415;
pub const HB_SCRIPT_ADLAM: hb_script_t = 1097100397;
pub const HB_SCRIPT_BHAIKSUKI: hb_script_t = 1114139507;
pub const HB_SCRIPT_MARCHEN: hb_script_t = 1298231907;
pub const HB_SCRIPT_OSAGE: hb_script_t = 1332963173;
pub const HB_SCRIPT_TANGUT: hb_script_t = 1415671399;
pub const HB_SCRIPT_NEWA: hb_script_t = 1315272545;
pub const HB_SCRIPT_MASARAM_GONDI: hb_script_t = 1198485101;
pub const HB_SCRIPT_NUSHU: hb_script_t = 1316186229;
pub const HB_SCRIPT_SOYOMBO: hb_script_t = 1399814511;
pub const HB_SCRIPT_ZANABAZAR_SQUARE: hb_script_t = 1516334690;
pub const HB_SCRIPT_DOGRA: hb_script_t = 1148151666;
pub const HB_SCRIPT_GUNJALA_GONDI: hb_script_t = 1198485095;
pub const HB_SCRIPT_HANIFI_ROHINGYA: hb_script_t = 1383032935;
pub const HB_SCRIPT_MAKASAR: hb_script_t = 1298230113;
pub const HB_SCRIPT_MEDEFAIDRIN: hb_script_t = 1298490470;
pub const HB_SCRIPT_OLD_SOGDIAN: hb_script_t = 1399809903;
pub const HB_SCRIPT_SOGDIAN: hb_script_t = 1399809892;
pub const HB_SCRIPT_ELYMAIC: hb_script_t = 1164736877;
pub const HB_SCRIPT_NANDINAGARI: hb_script_t = 1315008100;
pub const HB_SCRIPT_NYIAKENG_PUACHUE_HMONG: hb_script_t = 1215131248;
pub const HB_SCRIPT_WANCHO: hb_script_t = 1466132591;
pub const HB_SCRIPT_INVALID: hb_script_t = 0;
pub const _HB_SCRIPT_MAX_VALUE: hb_script_t = 2147483647;
pub const _HB_SCRIPT_MAX_VALUE_SIGNED: hb_script_t = 2147483647;
pub type hb_script_t = u32;
extern "C" {
    pub fn hb_script_from_iso15924_tag(tag: hb_tag_t) -> hb_script_t;
}
extern "C" {
    pub fn hb_script_from_string(
        str: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_script_t;
}
extern "C" {
    pub fn hb_script_to_iso15924_tag(script: hb_script_t) -> hb_tag_t;
}
extern "C" {
    pub fn hb_script_get_horizontal_direction(script: hb_script_t) -> hb_direction_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_user_data_key_t {
    pub unused: ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_hb_user_data_key_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_user_data_key_t>(),
        1usize,
        concat!("Size of: ", stringify!(hb_user_data_key_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_user_data_key_t>(),
        1usize,
        concat!("Alignment of ", stringify!(hb_user_data_key_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_user_data_key_t>())).unused as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_user_data_key_t),
            "::",
            stringify!(unused)
        )
    );
}
pub type hb_destroy_func_t =
    ::std::option::Option<unsafe extern "C" fn(user_data: *mut ::std::os::raw::c_void)>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_feature_t {
    pub tag: hb_tag_t,
    pub value: u32,
    pub start: ::std::os::raw::c_uint,
    pub end: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_hb_feature_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_feature_t>(),
        16usize,
        concat!("Size of: ", stringify!(hb_feature_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_feature_t>(),
        4usize,
        concat!("Alignment of ", stringify!(hb_feature_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_feature_t>())).tag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_feature_t),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_feature_t>())).value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_feature_t),
            "::",
            stringify!(value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_feature_t>())).start as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_feature_t),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_feature_t>())).end as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_feature_t),
            "::",
            stringify!(end)
        )
    );
}
extern "C" {
    pub fn hb_feature_from_string(
        str: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        feature: *mut hb_feature_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_feature_to_string(
        feature: *mut hb_feature_t,
        buf: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    );
}
/// hb_variation_t:
///
/// Since: 1.4.2
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_variation_t {
    pub tag: hb_tag_t,
    pub value: ::std::os::raw::c_float,
}
#[test]
fn bindgen_test_layout_hb_variation_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_variation_t>(),
        8usize,
        concat!("Size of: ", stringify!(hb_variation_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_variation_t>(),
        4usize,
        concat!("Alignment of ", stringify!(hb_variation_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_variation_t>())).tag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_variation_t),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_variation_t>())).value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_variation_t),
            "::",
            stringify!(value)
        )
    );
}
extern "C" {
    pub fn hb_variation_from_string(
        str: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        variation: *mut hb_variation_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_variation_to_string(
        variation: *mut hb_variation_t,
        buf: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    );
}
/// hb_color_t:
///
/// Data type for holding color values.
///
/// Since: 2.1.0
pub type hb_color_t = u32;
extern "C" {
    pub fn hb_color_get_alpha(color: hb_color_t) -> u8;
}
extern "C" {
    pub fn hb_color_get_red(color: hb_color_t) -> u8;
}
extern "C" {
    pub fn hb_color_get_green(color: hb_color_t) -> u8;
}
extern "C" {
    pub fn hb_color_get_blue(color: hb_color_t) -> u8;
}
pub const HB_MEMORY_MODE_DUPLICATE: hb_memory_mode_t = 0;
pub const HB_MEMORY_MODE_READONLY: hb_memory_mode_t = 1;
pub const HB_MEMORY_MODE_WRITABLE: hb_memory_mode_t = 2;
pub const HB_MEMORY_MODE_READONLY_MAY_MAKE_WRITABLE: hb_memory_mode_t = 3;
pub type hb_memory_mode_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_blob_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_blob_create(
        data: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_uint,
        mode: hb_memory_mode_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    ) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_create_from_file(file_name: *const ::std::os::raw::c_char) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_create_sub_blob(
        parent: *mut hb_blob_t,
        offset: ::std::os::raw::c_uint,
        length: ::std::os::raw::c_uint,
    ) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_copy_writable_or_fail(blob: *mut hb_blob_t) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_get_empty() -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_reference(blob: *mut hb_blob_t) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_blob_destroy(blob: *mut hb_blob_t);
}
extern "C" {
    pub fn hb_blob_set_user_data(
        blob: *mut hb_blob_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_blob_get_user_data(
        blob: *mut hb_blob_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_blob_make_immutable(blob: *mut hb_blob_t);
}
extern "C" {
    pub fn hb_blob_is_immutable(blob: *mut hb_blob_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_blob_get_length(blob: *mut hb_blob_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_blob_get_data(
        blob: *mut hb_blob_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_blob_get_data_writable(
        blob: *mut hb_blob_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_char;
}
pub const HB_UNICODE_GENERAL_CATEGORY_CONTROL: hb_unicode_general_category_t = 0;
pub const HB_UNICODE_GENERAL_CATEGORY_FORMAT: hb_unicode_general_category_t = 1;
pub const HB_UNICODE_GENERAL_CATEGORY_UNASSIGNED: hb_unicode_general_category_t = 2;
pub const HB_UNICODE_GENERAL_CATEGORY_PRIVATE_USE: hb_unicode_general_category_t = 3;
pub const HB_UNICODE_GENERAL_CATEGORY_SURROGATE: hb_unicode_general_category_t = 4;
pub const HB_UNICODE_GENERAL_CATEGORY_LOWERCASE_LETTER: hb_unicode_general_category_t = 5;
pub const HB_UNICODE_GENERAL_CATEGORY_MODIFIER_LETTER: hb_unicode_general_category_t = 6;
pub const HB_UNICODE_GENERAL_CATEGORY_OTHER_LETTER: hb_unicode_general_category_t = 7;
pub const HB_UNICODE_GENERAL_CATEGORY_TITLECASE_LETTER: hb_unicode_general_category_t = 8;
pub const HB_UNICODE_GENERAL_CATEGORY_UPPERCASE_LETTER: hb_unicode_general_category_t = 9;
pub const HB_UNICODE_GENERAL_CATEGORY_SPACING_MARK: hb_unicode_general_category_t = 10;
pub const HB_UNICODE_GENERAL_CATEGORY_ENCLOSING_MARK: hb_unicode_general_category_t = 11;
pub const HB_UNICODE_GENERAL_CATEGORY_NON_SPACING_MARK: hb_unicode_general_category_t = 12;
pub const HB_UNICODE_GENERAL_CATEGORY_DECIMAL_NUMBER: hb_unicode_general_category_t = 13;
pub const HB_UNICODE_GENERAL_CATEGORY_LETTER_NUMBER: hb_unicode_general_category_t = 14;
pub const HB_UNICODE_GENERAL_CATEGORY_OTHER_NUMBER: hb_unicode_general_category_t = 15;
pub const HB_UNICODE_GENERAL_CATEGORY_CONNECT_PUNCTUATION: hb_unicode_general_category_t = 16;
pub const HB_UNICODE_GENERAL_CATEGORY_DASH_PUNCTUATION: hb_unicode_general_category_t = 17;
pub const HB_UNICODE_GENERAL_CATEGORY_CLOSE_PUNCTUATION: hb_unicode_general_category_t = 18;
pub const HB_UNICODE_GENERAL_CATEGORY_FINAL_PUNCTUATION: hb_unicode_general_category_t = 19;
pub const HB_UNICODE_GENERAL_CATEGORY_INITIAL_PUNCTUATION: hb_unicode_general_category_t = 20;
pub const HB_UNICODE_GENERAL_CATEGORY_OTHER_PUNCTUATION: hb_unicode_general_category_t = 21;
pub const HB_UNICODE_GENERAL_CATEGORY_OPEN_PUNCTUATION: hb_unicode_general_category_t = 22;
pub const HB_UNICODE_GENERAL_CATEGORY_CURRENCY_SYMBOL: hb_unicode_general_category_t = 23;
pub const HB_UNICODE_GENERAL_CATEGORY_MODIFIER_SYMBOL: hb_unicode_general_category_t = 24;
pub const HB_UNICODE_GENERAL_CATEGORY_MATH_SYMBOL: hb_unicode_general_category_t = 25;
pub const HB_UNICODE_GENERAL_CATEGORY_OTHER_SYMBOL: hb_unicode_general_category_t = 26;
pub const HB_UNICODE_GENERAL_CATEGORY_LINE_SEPARATOR: hb_unicode_general_category_t = 27;
pub const HB_UNICODE_GENERAL_CATEGORY_PARAGRAPH_SEPARATOR: hb_unicode_general_category_t = 28;
pub const HB_UNICODE_GENERAL_CATEGORY_SPACE_SEPARATOR: hb_unicode_general_category_t = 29;
pub type hb_unicode_general_category_t = u32;
pub const HB_UNICODE_COMBINING_CLASS_NOT_REORDERED: hb_unicode_combining_class_t = 0;
pub const HB_UNICODE_COMBINING_CLASS_OVERLAY: hb_unicode_combining_class_t = 1;
pub const HB_UNICODE_COMBINING_CLASS_NUKTA: hb_unicode_combining_class_t = 7;
pub const HB_UNICODE_COMBINING_CLASS_KANA_VOICING: hb_unicode_combining_class_t = 8;
pub const HB_UNICODE_COMBINING_CLASS_VIRAMA: hb_unicode_combining_class_t = 9;
pub const HB_UNICODE_COMBINING_CLASS_CCC10: hb_unicode_combining_class_t = 10;
pub const HB_UNICODE_COMBINING_CLASS_CCC11: hb_unicode_combining_class_t = 11;
pub const HB_UNICODE_COMBINING_CLASS_CCC12: hb_unicode_combining_class_t = 12;
pub const HB_UNICODE_COMBINING_CLASS_CCC13: hb_unicode_combining_class_t = 13;
pub const HB_UNICODE_COMBINING_CLASS_CCC14: hb_unicode_combining_class_t = 14;
pub const HB_UNICODE_COMBINING_CLASS_CCC15: hb_unicode_combining_class_t = 15;
pub const HB_UNICODE_COMBINING_CLASS_CCC16: hb_unicode_combining_class_t = 16;
pub const HB_UNICODE_COMBINING_CLASS_CCC17: hb_unicode_combining_class_t = 17;
pub const HB_UNICODE_COMBINING_CLASS_CCC18: hb_unicode_combining_class_t = 18;
pub const HB_UNICODE_COMBINING_CLASS_CCC19: hb_unicode_combining_class_t = 19;
pub const HB_UNICODE_COMBINING_CLASS_CCC20: hb_unicode_combining_class_t = 20;
pub const HB_UNICODE_COMBINING_CLASS_CCC21: hb_unicode_combining_class_t = 21;
pub const HB_UNICODE_COMBINING_CLASS_CCC22: hb_unicode_combining_class_t = 22;
pub const HB_UNICODE_COMBINING_CLASS_CCC23: hb_unicode_combining_class_t = 23;
pub const HB_UNICODE_COMBINING_CLASS_CCC24: hb_unicode_combining_class_t = 24;
pub const HB_UNICODE_COMBINING_CLASS_CCC25: hb_unicode_combining_class_t = 25;
pub const HB_UNICODE_COMBINING_CLASS_CCC26: hb_unicode_combining_class_t = 26;
pub const HB_UNICODE_COMBINING_CLASS_CCC27: hb_unicode_combining_class_t = 27;
pub const HB_UNICODE_COMBINING_CLASS_CCC28: hb_unicode_combining_class_t = 28;
pub const HB_UNICODE_COMBINING_CLASS_CCC29: hb_unicode_combining_class_t = 29;
pub const HB_UNICODE_COMBINING_CLASS_CCC30: hb_unicode_combining_class_t = 30;
pub const HB_UNICODE_COMBINING_CLASS_CCC31: hb_unicode_combining_class_t = 31;
pub const HB_UNICODE_COMBINING_CLASS_CCC32: hb_unicode_combining_class_t = 32;
pub const HB_UNICODE_COMBINING_CLASS_CCC33: hb_unicode_combining_class_t = 33;
pub const HB_UNICODE_COMBINING_CLASS_CCC34: hb_unicode_combining_class_t = 34;
pub const HB_UNICODE_COMBINING_CLASS_CCC35: hb_unicode_combining_class_t = 35;
pub const HB_UNICODE_COMBINING_CLASS_CCC36: hb_unicode_combining_class_t = 36;
pub const HB_UNICODE_COMBINING_CLASS_CCC84: hb_unicode_combining_class_t = 84;
pub const HB_UNICODE_COMBINING_CLASS_CCC91: hb_unicode_combining_class_t = 91;
pub const HB_UNICODE_COMBINING_CLASS_CCC103: hb_unicode_combining_class_t = 103;
pub const HB_UNICODE_COMBINING_CLASS_CCC107: hb_unicode_combining_class_t = 107;
pub const HB_UNICODE_COMBINING_CLASS_CCC118: hb_unicode_combining_class_t = 118;
pub const HB_UNICODE_COMBINING_CLASS_CCC122: hb_unicode_combining_class_t = 122;
pub const HB_UNICODE_COMBINING_CLASS_CCC129: hb_unicode_combining_class_t = 129;
pub const HB_UNICODE_COMBINING_CLASS_CCC130: hb_unicode_combining_class_t = 130;
pub const HB_UNICODE_COMBINING_CLASS_CCC133: hb_unicode_combining_class_t = 132;
pub const HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW_LEFT: hb_unicode_combining_class_t = 200;
pub const HB_UNICODE_COMBINING_CLASS_ATTACHED_BELOW: hb_unicode_combining_class_t = 202;
pub const HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE: hb_unicode_combining_class_t = 214;
pub const HB_UNICODE_COMBINING_CLASS_ATTACHED_ABOVE_RIGHT: hb_unicode_combining_class_t = 216;
pub const HB_UNICODE_COMBINING_CLASS_BELOW_LEFT: hb_unicode_combining_class_t = 218;
pub const HB_UNICODE_COMBINING_CLASS_BELOW: hb_unicode_combining_class_t = 220;
pub const HB_UNICODE_COMBINING_CLASS_BELOW_RIGHT: hb_unicode_combining_class_t = 222;
pub const HB_UNICODE_COMBINING_CLASS_LEFT: hb_unicode_combining_class_t = 224;
pub const HB_UNICODE_COMBINING_CLASS_RIGHT: hb_unicode_combining_class_t = 226;
pub const HB_UNICODE_COMBINING_CLASS_ABOVE_LEFT: hb_unicode_combining_class_t = 228;
pub const HB_UNICODE_COMBINING_CLASS_ABOVE: hb_unicode_combining_class_t = 230;
pub const HB_UNICODE_COMBINING_CLASS_ABOVE_RIGHT: hb_unicode_combining_class_t = 232;
pub const HB_UNICODE_COMBINING_CLASS_DOUBLE_BELOW: hb_unicode_combining_class_t = 233;
pub const HB_UNICODE_COMBINING_CLASS_DOUBLE_ABOVE: hb_unicode_combining_class_t = 234;
pub const HB_UNICODE_COMBINING_CLASS_IOTA_SUBSCRIPT: hb_unicode_combining_class_t = 240;
pub const HB_UNICODE_COMBINING_CLASS_INVALID: hb_unicode_combining_class_t = 255;
pub type hb_unicode_combining_class_t = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_unicode_funcs_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_unicode_funcs_get_default() -> *mut hb_unicode_funcs_t;
}
extern "C" {
    pub fn hb_unicode_funcs_create(parent: *mut hb_unicode_funcs_t) -> *mut hb_unicode_funcs_t;
}
extern "C" {
    pub fn hb_unicode_funcs_get_empty() -> *mut hb_unicode_funcs_t;
}
extern "C" {
    pub fn hb_unicode_funcs_reference(ufuncs: *mut hb_unicode_funcs_t) -> *mut hb_unicode_funcs_t;
}
extern "C" {
    pub fn hb_unicode_funcs_destroy(ufuncs: *mut hb_unicode_funcs_t);
}
extern "C" {
    pub fn hb_unicode_funcs_set_user_data(
        ufuncs: *mut hb_unicode_funcs_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_unicode_funcs_get_user_data(
        ufuncs: *mut hb_unicode_funcs_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_unicode_funcs_make_immutable(ufuncs: *mut hb_unicode_funcs_t);
}
extern "C" {
    pub fn hb_unicode_funcs_is_immutable(ufuncs: *mut hb_unicode_funcs_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_unicode_funcs_get_parent(ufuncs: *mut hb_unicode_funcs_t) -> *mut hb_unicode_funcs_t;
}
pub type hb_unicode_combining_class_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_unicode_combining_class_t,
>;
pub type hb_unicode_general_category_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_unicode_general_category_t,
>;
pub type hb_unicode_mirroring_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_codepoint_t,
>;
pub type hb_unicode_script_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_script_t,
>;
pub type hb_unicode_compose_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        a: hb_codepoint_t,
        b: hb_codepoint_t,
        ab: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_unicode_decompose_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        ufuncs: *mut hb_unicode_funcs_t,
        ab: hb_codepoint_t,
        a: *mut hb_codepoint_t,
        b: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
extern "C" {
    /// hb_unicode_funcs_set_combining_class_func:
    /// @ufuncs: a Unicode function structure
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_unicode_funcs_set_combining_class_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_combining_class_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_unicode_funcs_set_general_category_func:
    /// @ufuncs: a Unicode function structure
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_unicode_funcs_set_general_category_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_general_category_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_unicode_funcs_set_mirroring_func:
    /// @ufuncs: a Unicode function structure
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_unicode_funcs_set_mirroring_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_mirroring_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_unicode_funcs_set_script_func:
    /// @ufuncs: a Unicode function structure
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_unicode_funcs_set_script_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_script_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_unicode_funcs_set_compose_func:
    /// @ufuncs: a Unicode function structure
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_unicode_funcs_set_compose_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_compose_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_unicode_funcs_set_decompose_func:
    /// @ufuncs: a Unicode function structure
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_unicode_funcs_set_decompose_func(
        ufuncs: *mut hb_unicode_funcs_t,
        func: hb_unicode_decompose_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_unicode_combining_class:
    ///
    /// Since: 0.9.2
    pub fn hb_unicode_combining_class(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_unicode_combining_class_t;
}
extern "C" {
    /// hb_unicode_general_category:
    ///
    /// Since: 0.9.2
    pub fn hb_unicode_general_category(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_unicode_general_category_t;
}
extern "C" {
    /// hb_unicode_mirroring:
    ///
    /// Since: 0.9.2
    pub fn hb_unicode_mirroring(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_codepoint_t;
}
extern "C" {
    /// hb_unicode_script:
    ///
    /// Since: 0.9.2
    pub fn hb_unicode_script(
        ufuncs: *mut hb_unicode_funcs_t,
        unicode: hb_codepoint_t,
    ) -> hb_script_t;
}
extern "C" {
    pub fn hb_unicode_compose(
        ufuncs: *mut hb_unicode_funcs_t,
        a: hb_codepoint_t,
        b: hb_codepoint_t,
        ab: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_unicode_decompose(
        ufuncs: *mut hb_unicode_funcs_t,
        ab: hb_codepoint_t,
        a: *mut hb_codepoint_t,
        b: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_set_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_set_create() -> *mut hb_set_t;
}
extern "C" {
    pub fn hb_set_get_empty() -> *mut hb_set_t;
}
extern "C" {
    pub fn hb_set_reference(set: *mut hb_set_t) -> *mut hb_set_t;
}
extern "C" {
    pub fn hb_set_destroy(set: *mut hb_set_t);
}
extern "C" {
    pub fn hb_set_set_user_data(
        set: *mut hb_set_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_get_user_data(
        set: *mut hb_set_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_set_allocation_successful(set: *const hb_set_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_clear(set: *mut hb_set_t);
}
extern "C" {
    pub fn hb_set_is_empty(set: *const hb_set_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_has(set: *const hb_set_t, codepoint: hb_codepoint_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_add(set: *mut hb_set_t, codepoint: hb_codepoint_t);
}
extern "C" {
    pub fn hb_set_add_range(set: *mut hb_set_t, first: hb_codepoint_t, last: hb_codepoint_t);
}
extern "C" {
    pub fn hb_set_del(set: *mut hb_set_t, codepoint: hb_codepoint_t);
}
extern "C" {
    pub fn hb_set_del_range(set: *mut hb_set_t, first: hb_codepoint_t, last: hb_codepoint_t);
}
extern "C" {
    pub fn hb_set_is_equal(set: *const hb_set_t, other: *const hb_set_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_is_subset(set: *const hb_set_t, larger_set: *const hb_set_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_set(set: *mut hb_set_t, other: *const hb_set_t);
}
extern "C" {
    pub fn hb_set_union(set: *mut hb_set_t, other: *const hb_set_t);
}
extern "C" {
    pub fn hb_set_intersect(set: *mut hb_set_t, other: *const hb_set_t);
}
extern "C" {
    pub fn hb_set_subtract(set: *mut hb_set_t, other: *const hb_set_t);
}
extern "C" {
    pub fn hb_set_symmetric_difference(set: *mut hb_set_t, other: *const hb_set_t);
}
extern "C" {
    pub fn hb_set_get_population(set: *const hb_set_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_set_get_min(set: *const hb_set_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_set_get_max(set: *const hb_set_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_set_next(set: *const hb_set_t, codepoint: *mut hb_codepoint_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_previous(set: *const hb_set_t, codepoint: *mut hb_codepoint_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_next_range(
        set: *const hb_set_t,
        first: *mut hb_codepoint_t,
        last: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_set_previous_range(
        set: *const hb_set_t,
        first: *mut hb_codepoint_t,
        last: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_face_count(blob: *mut hb_blob_t) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_face_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_face_create(blob: *mut hb_blob_t, index: ::std::os::raw::c_uint) -> *mut hb_face_t;
}
pub type hb_reference_table_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        face: *mut hb_face_t,
        tag: hb_tag_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> *mut hb_blob_t,
>;
extern "C" {
    pub fn hb_face_create_for_tables(
        reference_table_func: hb_reference_table_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    ) -> *mut hb_face_t;
}
extern "C" {
    pub fn hb_face_get_empty() -> *mut hb_face_t;
}
extern "C" {
    pub fn hb_face_reference(face: *mut hb_face_t) -> *mut hb_face_t;
}
extern "C" {
    pub fn hb_face_destroy(face: *mut hb_face_t);
}
extern "C" {
    pub fn hb_face_set_user_data(
        face: *mut hb_face_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_face_get_user_data(
        face: *const hb_face_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_face_make_immutable(face: *mut hb_face_t);
}
extern "C" {
    pub fn hb_face_is_immutable(face: *const hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_face_reference_table(face: *const hb_face_t, tag: hb_tag_t) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_face_reference_blob(face: *mut hb_face_t) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_face_set_index(face: *mut hb_face_t, index: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn hb_face_get_index(face: *const hb_face_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_face_set_upem(face: *mut hb_face_t, upem: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn hb_face_get_upem(face: *const hb_face_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_face_set_glyph_count(face: *mut hb_face_t, glyph_count: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn hb_face_get_glyph_count(face: *const hb_face_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_face_get_table_tags(
        face: *const hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        table_count: *mut ::std::os::raw::c_uint,
        table_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_face_collect_unicodes(face: *mut hb_face_t, out: *mut hb_set_t);
}
extern "C" {
    pub fn hb_face_collect_variation_selectors(face: *mut hb_face_t, out: *mut hb_set_t);
}
extern "C" {
    pub fn hb_face_collect_variation_unicodes(
        face: *mut hb_face_t,
        variation_selector: hb_codepoint_t,
        out: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_face_builder_create() -> *mut hb_face_t;
}
extern "C" {
    pub fn hb_face_builder_add_table(
        face: *mut hb_face_t,
        tag: hb_tag_t,
        blob: *mut hb_blob_t,
    ) -> hb_bool_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_font_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_font_funcs_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_font_funcs_create() -> *mut hb_font_funcs_t;
}
extern "C" {
    pub fn hb_font_funcs_get_empty() -> *mut hb_font_funcs_t;
}
extern "C" {
    pub fn hb_font_funcs_reference(ffuncs: *mut hb_font_funcs_t) -> *mut hb_font_funcs_t;
}
extern "C" {
    pub fn hb_font_funcs_destroy(ffuncs: *mut hb_font_funcs_t);
}
extern "C" {
    pub fn hb_font_funcs_set_user_data(
        ffuncs: *mut hb_font_funcs_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_funcs_get_user_data(
        ffuncs: *mut hb_font_funcs_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_font_funcs_make_immutable(ffuncs: *mut hb_font_funcs_t);
}
extern "C" {
    pub fn hb_font_funcs_is_immutable(ffuncs: *mut hb_font_funcs_t) -> hb_bool_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_font_extents_t {
    pub ascender: hb_position_t,
    pub descender: hb_position_t,
    pub line_gap: hb_position_t,
    pub reserved9: hb_position_t,
    pub reserved8: hb_position_t,
    pub reserved7: hb_position_t,
    pub reserved6: hb_position_t,
    pub reserved5: hb_position_t,
    pub reserved4: hb_position_t,
    pub reserved3: hb_position_t,
    pub reserved2: hb_position_t,
    pub reserved1: hb_position_t,
}
#[test]
fn bindgen_test_layout_hb_font_extents_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_font_extents_t>(),
        48usize,
        concat!("Size of: ", stringify!(hb_font_extents_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_font_extents_t>(),
        4usize,
        concat!("Alignment of ", stringify!(hb_font_extents_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).ascender as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(ascender)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).descender as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(descender)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).line_gap as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(line_gap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).reserved9 as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(reserved9)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).reserved8 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(reserved8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).reserved7 as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(reserved7)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).reserved6 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(reserved6)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).reserved5 as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(reserved5)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).reserved4 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(reserved4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).reserved3 as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(reserved3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).reserved2 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(reserved2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_font_extents_t>())).reserved1 as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_font_extents_t),
            "::",
            stringify!(reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_glyph_extents_t {
    pub x_bearing: hb_position_t,
    pub y_bearing: hb_position_t,
    pub width: hb_position_t,
    pub height: hb_position_t,
}
#[test]
fn bindgen_test_layout_hb_glyph_extents_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_glyph_extents_t>(),
        16usize,
        concat!("Size of: ", stringify!(hb_glyph_extents_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_glyph_extents_t>(),
        4usize,
        concat!("Alignment of ", stringify!(hb_glyph_extents_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_extents_t>())).x_bearing as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_extents_t),
            "::",
            stringify!(x_bearing)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_extents_t>())).y_bearing as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_extents_t),
            "::",
            stringify!(y_bearing)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_extents_t>())).width as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_extents_t),
            "::",
            stringify!(width)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_extents_t>())).height as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_extents_t),
            "::",
            stringify!(height)
        )
    );
}
pub type hb_font_get_font_extents_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        extents: *mut hb_font_extents_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_font_h_extents_func_t = hb_font_get_font_extents_func_t;
pub type hb_font_get_font_v_extents_func_t = hb_font_get_font_extents_func_t;
pub type hb_font_get_nominal_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        unicode: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_variation_glyph_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_nominal_glyphs_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        count: ::std::os::raw::c_uint,
        first_unicode: *const hb_codepoint_t,
        unicode_stride: ::std::os::raw::c_uint,
        first_glyph: *mut hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        user_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_uint,
>;
pub type hb_font_get_glyph_advance_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_position_t,
>;
pub type hb_font_get_glyph_h_advance_func_t = hb_font_get_glyph_advance_func_t;
pub type hb_font_get_glyph_v_advance_func_t = hb_font_get_glyph_advance_func_t;
pub type hb_font_get_glyph_advances_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
        user_data: *mut ::std::os::raw::c_void,
    ),
>;
pub type hb_font_get_glyph_h_advances_func_t = hb_font_get_glyph_advances_func_t;
pub type hb_font_get_glyph_v_advances_func_t = hb_font_get_glyph_advances_func_t;
pub type hb_font_get_glyph_origin_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_glyph_h_origin_func_t = hb_font_get_glyph_origin_func_t;
pub type hb_font_get_glyph_v_origin_func_t = hb_font_get_glyph_origin_func_t;
pub type hb_font_get_glyph_kerning_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        first_glyph: hb_codepoint_t,
        second_glyph: hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_position_t,
>;
pub type hb_font_get_glyph_h_kerning_func_t = hb_font_get_glyph_kerning_func_t;
pub type hb_font_get_glyph_extents_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        extents: *mut hb_glyph_extents_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_glyph_contour_point_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        point_index: ::std::os::raw::c_uint,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_glyph_name_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        glyph: hb_codepoint_t,
        name: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
pub type hb_font_get_glyph_from_name_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        name: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        glyph: *mut hb_codepoint_t,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
extern "C" {
    /// hb_font_funcs_set_font_h_extents_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 1.1.2
    pub fn hb_font_funcs_set_font_h_extents_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_font_h_extents_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_font_v_extents_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 1.1.2
    pub fn hb_font_funcs_set_font_v_extents_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_font_v_extents_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_nominal_glyph_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 1.2.3
    pub fn hb_font_funcs_set_nominal_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_nominal_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_nominal_glyphs_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 2.0.0
    pub fn hb_font_funcs_set_nominal_glyphs_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_nominal_glyphs_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_variation_glyph_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 1.2.3
    pub fn hb_font_funcs_set_variation_glyph_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_variation_glyph_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_h_advance_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_font_funcs_set_glyph_h_advance_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_advance_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_v_advance_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_font_funcs_set_glyph_v_advance_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_advance_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_h_advances_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 1.8.6
    pub fn hb_font_funcs_set_glyph_h_advances_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_advances_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_v_advances_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 1.8.6
    pub fn hb_font_funcs_set_glyph_v_advances_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_advances_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_h_origin_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_font_funcs_set_glyph_h_origin_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_origin_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_v_origin_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_font_funcs_set_glyph_v_origin_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_v_origin_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_h_kerning_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_font_funcs_set_glyph_h_kerning_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_h_kerning_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_extents_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_font_funcs_set_glyph_extents_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_extents_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_contour_point_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_font_funcs_set_glyph_contour_point_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_contour_point_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_name_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_font_funcs_set_glyph_name_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_name_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    /// hb_font_funcs_set_glyph_from_name_func:
    /// @ffuncs: font functions.
    /// @func: (closure user_data) (destroy destroy) (scope notified):
    /// @user_data:
    /// @destroy:
    ///
    ///
    ///
    /// Since: 0.9.2
    pub fn hb_font_funcs_set_glyph_from_name_func(
        ffuncs: *mut hb_font_funcs_t,
        func: hb_font_get_glyph_from_name_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_font_get_h_extents(
        font: *mut hb_font_t,
        extents: *mut hb_font_extents_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_v_extents(
        font: *mut hb_font_t,
        extents: *mut hb_font_extents_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_nominal_glyph(
        font: *mut hb_font_t,
        unicode: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_variation_glyph(
        font: *mut hb_font_t,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_h_advance(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_font_get_glyph_v_advance(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_font_get_glyph_h_advances(
        font: *mut hb_font_t,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_v_advances(
        font: *mut hb_font_t,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_h_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_v_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_h_kerning(
        font: *mut hb_font_t,
        left_glyph: hb_codepoint_t,
        right_glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_font_get_glyph_extents(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        extents: *mut hb_glyph_extents_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_contour_point(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        point_index: ::std::os::raw::c_uint,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_name(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        name: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_from_name(
        font: *mut hb_font_t,
        name: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph(
        font: *mut hb_font_t,
        unicode: hb_codepoint_t,
        variation_selector: hb_codepoint_t,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_extents_for_direction(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        extents: *mut hb_font_extents_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_advance_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_advances_for_direction(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        count: ::std::os::raw::c_uint,
        first_glyph: *const hb_codepoint_t,
        glyph_stride: ::std::os::raw::c_uint,
        first_advance: *mut hb_position_t,
        advance_stride: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_origin_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_font_add_glyph_origin_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_font_subtract_glyph_origin_for_direction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_kerning_for_direction(
        font: *mut hb_font_t,
        first_glyph: hb_codepoint_t,
        second_glyph: hb_codepoint_t,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    );
}
extern "C" {
    pub fn hb_font_get_glyph_extents_for_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        extents: *mut hb_glyph_extents_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_glyph_contour_point_for_origin(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        point_index: ::std::os::raw::c_uint,
        direction: hb_direction_t,
        x: *mut hb_position_t,
        y: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_glyph_to_string(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        s: *mut ::std::os::raw::c_char,
        size: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_glyph_from_string(
        font: *mut hb_font_t,
        s: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        glyph: *mut hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_create(face: *mut hb_face_t) -> *mut hb_font_t;
}
extern "C" {
    pub fn hb_font_create_sub_font(parent: *mut hb_font_t) -> *mut hb_font_t;
}
extern "C" {
    pub fn hb_font_get_empty() -> *mut hb_font_t;
}
extern "C" {
    pub fn hb_font_reference(font: *mut hb_font_t) -> *mut hb_font_t;
}
extern "C" {
    pub fn hb_font_destroy(font: *mut hb_font_t);
}
extern "C" {
    pub fn hb_font_set_user_data(
        font: *mut hb_font_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_get_user_data(
        font: *mut hb_font_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_font_make_immutable(font: *mut hb_font_t);
}
extern "C" {
    pub fn hb_font_is_immutable(font: *mut hb_font_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_font_set_parent(font: *mut hb_font_t, parent: *mut hb_font_t);
}
extern "C" {
    pub fn hb_font_get_parent(font: *mut hb_font_t) -> *mut hb_font_t;
}
extern "C" {
    pub fn hb_font_set_face(font: *mut hb_font_t, face: *mut hb_face_t);
}
extern "C" {
    pub fn hb_font_get_face(font: *mut hb_font_t) -> *mut hb_face_t;
}
extern "C" {
    pub fn hb_font_set_funcs(
        font: *mut hb_font_t,
        klass: *mut hb_font_funcs_t,
        font_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_font_set_funcs_data(
        font: *mut hb_font_t,
        font_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
extern "C" {
    pub fn hb_font_set_scale(
        font: *mut hb_font_t,
        x_scale: ::std::os::raw::c_int,
        y_scale: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_font_get_scale(
        font: *mut hb_font_t,
        x_scale: *mut ::std::os::raw::c_int,
        y_scale: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_font_set_ppem(
        font: *mut hb_font_t,
        x_ppem: ::std::os::raw::c_uint,
        y_ppem: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_ppem(
        font: *mut hb_font_t,
        x_ppem: *mut ::std::os::raw::c_uint,
        y_ppem: *mut ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_set_ptem(font: *mut hb_font_t, ptem: ::std::os::raw::c_float);
}
extern "C" {
    pub fn hb_font_get_ptem(font: *mut hb_font_t) -> ::std::os::raw::c_float;
}
extern "C" {
    pub fn hb_font_set_variations(
        font: *mut hb_font_t,
        variations: *const hb_variation_t,
        variations_length: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_set_var_coords_design(
        font: *mut hb_font_t,
        coords: *const ::std::os::raw::c_float,
        coords_length: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_set_var_coords_normalized(
        font: *mut hb_font_t,
        coords: *const ::std::os::raw::c_int,
        coords_length: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_font_get_var_coords_normalized(
        font: *mut hb_font_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_int;
}
/// hb_glyph_info_t:
/// @codepoint: either a Unicode code point (before shaping) or a glyph index
///             (after shaping).
/// @mask:
/// @cluster: the index of the character in the original text that corresponds
///           to this `hb_glyph_info_t`, or whatever the client passes to
///           hb_buffer_add(). More than one `hb_glyph_info_t` can have the same
///           @cluster value, if they resulted from the same character (e.g. one
///           to many glyph substitution), and when more than one character gets
///           merged in the same glyph (e.g. many to one glyph substitution) the
///           `hb_glyph_info_t` will have the smallest cluster value of them.
///           By default some characters are merged into the same cluster
///           (e.g. combining marks have the same cluster as their bases)
///           even if they are separate glyphs, hb_buffer_set_cluster_level()
///           allow selecting more fine-grained cluster handling.
///
/// The `hb_glyph_info_t` is the structure that holds information about the
/// glyphs and their relation to input text.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_glyph_info_t {
    pub codepoint: hb_codepoint_t,
    pub mask: hb_mask_t,
    pub cluster: u32,
    pub var1: hb_var_int_t,
    pub var2: hb_var_int_t,
}
#[test]
fn bindgen_test_layout_hb_glyph_info_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_glyph_info_t>(),
        20usize,
        concat!("Size of: ", stringify!(hb_glyph_info_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_glyph_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(hb_glyph_info_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_info_t>())).codepoint as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_info_t),
            "::",
            stringify!(codepoint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_info_t>())).mask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_info_t),
            "::",
            stringify!(mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_info_t>())).cluster as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_info_t),
            "::",
            stringify!(cluster)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_info_t>())).var1 as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_info_t),
            "::",
            stringify!(var1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_info_t>())).var2 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_info_t),
            "::",
            stringify!(var2)
        )
    );
}
pub const HB_GLYPH_FLAG_UNSAFE_TO_BREAK: hb_glyph_flags_t = 1;
pub const HB_GLYPH_FLAG_DEFINED: hb_glyph_flags_t = 1;
/// hb_glyph_flags_t:
/// @HB_GLYPH_FLAG_UNSAFE_TO_BREAK: Indicates that if input text is broken at the
/// beginning of the cluster this glyph is part of,
/// then both sides need to be re-shaped, as the
/// result might be different.  On the flip side,
/// it means that when this flag is not present,
/// then it's safe to break the glyph-run at the
/// beginning of this cluster, and the two sides
/// represent the exact same result one would get
/// if breaking input text at the beginning of
/// this cluster and shaping the two sides
/// separately.  This can be used to optimize
/// paragraph layout, by avoiding re-shaping
/// of each line after line-breaking, or limiting
/// the reshaping to a small piece around the
/// breaking point only.
/// @HB_GLYPH_FLAG_DEFINED: All the currently defined flags.
///
/// Since: 1.5.0
pub type hb_glyph_flags_t = u32;
extern "C" {
    pub fn hb_glyph_info_get_glyph_flags(info: *const hb_glyph_info_t) -> hb_glyph_flags_t;
}
/// hb_glyph_position_t:
/// @x_advance: how much the line advances after drawing this glyph when setting
///             text in horizontal direction.
/// @y_advance: how much the line advances after drawing this glyph when setting
///             text in vertical direction.
/// @x_offset: how much the glyph moves on the X-axis before drawing it, this
///            should not affect how much the line advances.
/// @y_offset: how much the glyph moves on the Y-axis before drawing it, this
///            should not affect how much the line advances.
///
/// The `hb_glyph_position_t` is the structure that holds the positions of the
/// glyph in both horizontal and vertical directions. All positions in
/// `hb_glyph_position_t` are relative to the current point.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_glyph_position_t {
    pub x_advance: hb_position_t,
    pub y_advance: hb_position_t,
    pub x_offset: hb_position_t,
    pub y_offset: hb_position_t,
    pub var: hb_var_int_t,
}
#[test]
fn bindgen_test_layout_hb_glyph_position_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_glyph_position_t>(),
        20usize,
        concat!("Size of: ", stringify!(hb_glyph_position_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_glyph_position_t>(),
        4usize,
        concat!("Alignment of ", stringify!(hb_glyph_position_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_position_t>())).x_advance as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_position_t),
            "::",
            stringify!(x_advance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_position_t>())).y_advance as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_position_t),
            "::",
            stringify!(y_advance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_position_t>())).x_offset as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_position_t),
            "::",
            stringify!(x_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_position_t>())).y_offset as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_position_t),
            "::",
            stringify!(y_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_glyph_position_t>())).var as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_glyph_position_t),
            "::",
            stringify!(var)
        )
    );
}
/// hb_segment_properties_t:
/// @direction: the `hb_direction_t` of the buffer, see hb_buffer_set_direction().
/// @script: the `hb_script_t` of the buffer, see hb_buffer_set_script().
/// @language: the `hb_language_t` of the buffer, see hb_buffer_set_language().
///
/// The structure that holds various text properties of an `hb_buffer_t`. Can be
/// set and retrieved using hb_buffer_set_segment_properties() and
/// hb_buffer_get_segment_properties(), respectively.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_segment_properties_t {
    pub direction: hb_direction_t,
    pub script: hb_script_t,
    pub language: hb_language_t,
    pub reserved1: *mut ::std::os::raw::c_void,
    pub reserved2: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_hb_segment_properties_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_segment_properties_t>(),
        32usize,
        concat!("Size of: ", stringify!(hb_segment_properties_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_segment_properties_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hb_segment_properties_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_segment_properties_t>())).direction as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_segment_properties_t),
            "::",
            stringify!(direction)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_segment_properties_t>())).script as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_segment_properties_t),
            "::",
            stringify!(script)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_segment_properties_t>())).language as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_segment_properties_t),
            "::",
            stringify!(language)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_segment_properties_t>())).reserved1 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_segment_properties_t),
            "::",
            stringify!(reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_segment_properties_t>())).reserved2 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_segment_properties_t),
            "::",
            stringify!(reserved2)
        )
    );
}
extern "C" {
    pub fn hb_segment_properties_equal(
        a: *const hb_segment_properties_t,
        b: *const hb_segment_properties_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_segment_properties_hash(p: *const hb_segment_properties_t) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_buffer_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_buffer_create() -> *mut hb_buffer_t;
}
extern "C" {
    pub fn hb_buffer_get_empty() -> *mut hb_buffer_t;
}
extern "C" {
    pub fn hb_buffer_reference(buffer: *mut hb_buffer_t) -> *mut hb_buffer_t;
}
extern "C" {
    pub fn hb_buffer_destroy(buffer: *mut hb_buffer_t);
}
extern "C" {
    pub fn hb_buffer_set_user_data(
        buffer: *mut hb_buffer_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_buffer_get_user_data(
        buffer: *mut hb_buffer_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
pub const HB_BUFFER_CONTENT_TYPE_INVALID: hb_buffer_content_type_t = 0;
pub const HB_BUFFER_CONTENT_TYPE_UNICODE: hb_buffer_content_type_t = 1;
pub const HB_BUFFER_CONTENT_TYPE_GLYPHS: hb_buffer_content_type_t = 2;
/// hb_buffer_content_type_t:
/// @HB_BUFFER_CONTENT_TYPE_INVALID: Initial value for new buffer.
/// @HB_BUFFER_CONTENT_TYPE_UNICODE: The buffer contains input characters (before shaping).
/// @HB_BUFFER_CONTENT_TYPE_GLYPHS: The buffer contains output glyphs (after shaping).
pub type hb_buffer_content_type_t = u32;
extern "C" {
    pub fn hb_buffer_set_content_type(
        buffer: *mut hb_buffer_t,
        content_type: hb_buffer_content_type_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_content_type(buffer: *mut hb_buffer_t) -> hb_buffer_content_type_t;
}
extern "C" {
    pub fn hb_buffer_set_unicode_funcs(
        buffer: *mut hb_buffer_t,
        unicode_funcs: *mut hb_unicode_funcs_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_unicode_funcs(buffer: *mut hb_buffer_t) -> *mut hb_unicode_funcs_t;
}
extern "C" {
    pub fn hb_buffer_set_direction(buffer: *mut hb_buffer_t, direction: hb_direction_t);
}
extern "C" {
    pub fn hb_buffer_get_direction(buffer: *mut hb_buffer_t) -> hb_direction_t;
}
extern "C" {
    pub fn hb_buffer_set_script(buffer: *mut hb_buffer_t, script: hb_script_t);
}
extern "C" {
    pub fn hb_buffer_get_script(buffer: *mut hb_buffer_t) -> hb_script_t;
}
extern "C" {
    pub fn hb_buffer_set_language(buffer: *mut hb_buffer_t, language: hb_language_t);
}
extern "C" {
    pub fn hb_buffer_get_language(buffer: *mut hb_buffer_t) -> hb_language_t;
}
extern "C" {
    pub fn hb_buffer_set_segment_properties(
        buffer: *mut hb_buffer_t,
        props: *const hb_segment_properties_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_segment_properties(
        buffer: *mut hb_buffer_t,
        props: *mut hb_segment_properties_t,
    );
}
extern "C" {
    pub fn hb_buffer_guess_segment_properties(buffer: *mut hb_buffer_t);
}
pub const HB_BUFFER_FLAG_DEFAULT: hb_buffer_flags_t = 0;
pub const HB_BUFFER_FLAG_BOT: hb_buffer_flags_t = 1;
pub const HB_BUFFER_FLAG_EOT: hb_buffer_flags_t = 2;
pub const HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES: hb_buffer_flags_t = 4;
pub const HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES: hb_buffer_flags_t = 8;
pub const HB_BUFFER_FLAG_DO_NOT_INSERT_DOTTED_CIRCLE: hb_buffer_flags_t = 16;
/// hb_buffer_flags_t:
/// @HB_BUFFER_FLAG_DEFAULT: the default buffer flag.
/// @HB_BUFFER_FLAG_BOT: flag indicating that special handling of the beginning
///                      of text paragraph can be applied to this buffer. Should usually
///                      be set, unless you are passing to the buffer only part
///                      of the text without the full context.
/// @HB_BUFFER_FLAG_EOT: flag indicating that special handling of the end of text
/// paragraph can be applied to this buffer, similar to
/// @HB_BUFFER_FLAG_BOT.
/// @HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES:
/// flag indication that character with Default_Ignorable
/// Unicode property should use the corresponding glyph
/// from the font, instead of hiding them (done by
/// replacing them with the space glyph and zeroing the
/// advance width.)  This flag takes precedence over
/// @HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES.
/// @HB_BUFFER_FLAG_REMOVE_DEFAULT_IGNORABLES:
/// flag indication that character with Default_Ignorable
/// Unicode property should be removed from glyph string
/// instead of hiding them (done by replacing them with the
/// space glyph and zeroing the advance width.)
/// @HB_BUFFER_FLAG_PRESERVE_DEFAULT_IGNORABLES takes
/// precedence over this flag. Since: 1.8.0
/// @HB_BUFFER_FLAG_DO_NOT_INSERT_DOTTED_CIRCLE:
///    flag indicating that a dotted circle should
///    not be inserted in the rendering of incorrect
///    character sequences (such at <0905 093E>). Since: 2.4
///
/// Since: 0.9.20
pub type hb_buffer_flags_t = u32;
extern "C" {
    pub fn hb_buffer_set_flags(buffer: *mut hb_buffer_t, flags: hb_buffer_flags_t);
}
extern "C" {
    pub fn hb_buffer_get_flags(buffer: *mut hb_buffer_t) -> hb_buffer_flags_t;
}
pub const HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES: hb_buffer_cluster_level_t = 0;
pub const HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS: hb_buffer_cluster_level_t = 1;
pub const HB_BUFFER_CLUSTER_LEVEL_CHARACTERS: hb_buffer_cluster_level_t = 2;
pub const HB_BUFFER_CLUSTER_LEVEL_DEFAULT: hb_buffer_cluster_level_t = 0;
/// hb_buffer_cluster_level_t:
/// @HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES: Return cluster values grouped by graphemes into
/// monotone order.
/// @HB_BUFFER_CLUSTER_LEVEL_MONOTONE_CHARACTERS: Return cluster values grouped into monotone order.
/// @HB_BUFFER_CLUSTER_LEVEL_CHARACTERS: Don't group cluster values.
/// @HB_BUFFER_CLUSTER_LEVEL_DEFAULT: Default cluster level,
/// equal to @HB_BUFFER_CLUSTER_LEVEL_MONOTONE_GRAPHEMES.
///
/// Since: 0.9.42
pub type hb_buffer_cluster_level_t = u32;
extern "C" {
    pub fn hb_buffer_set_cluster_level(
        buffer: *mut hb_buffer_t,
        cluster_level: hb_buffer_cluster_level_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_cluster_level(buffer: *mut hb_buffer_t) -> hb_buffer_cluster_level_t;
}
extern "C" {
    pub fn hb_buffer_set_replacement_codepoint(
        buffer: *mut hb_buffer_t,
        replacement: hb_codepoint_t,
    );
}
extern "C" {
    pub fn hb_buffer_get_replacement_codepoint(buffer: *mut hb_buffer_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_buffer_set_invisible_glyph(buffer: *mut hb_buffer_t, invisible: hb_codepoint_t);
}
extern "C" {
    pub fn hb_buffer_get_invisible_glyph(buffer: *mut hb_buffer_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_buffer_reset(buffer: *mut hb_buffer_t);
}
extern "C" {
    pub fn hb_buffer_clear_contents(buffer: *mut hb_buffer_t);
}
extern "C" {
    pub fn hb_buffer_pre_allocate(
        buffer: *mut hb_buffer_t,
        size: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_buffer_allocation_successful(buffer: *mut hb_buffer_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_buffer_reverse(buffer: *mut hb_buffer_t);
}
extern "C" {
    pub fn hb_buffer_reverse_range(
        buffer: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_buffer_reverse_clusters(buffer: *mut hb_buffer_t);
}
extern "C" {
    pub fn hb_buffer_add(
        buffer: *mut hb_buffer_t,
        codepoint: hb_codepoint_t,
        cluster: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_buffer_add_utf8(
        buffer: *mut hb_buffer_t,
        text: *const ::std::os::raw::c_char,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_buffer_add_utf16(
        buffer: *mut hb_buffer_t,
        text: *const u16,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_buffer_add_utf32(
        buffer: *mut hb_buffer_t,
        text: *const u32,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_buffer_add_latin1(
        buffer: *mut hb_buffer_t,
        text: *const u8,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_buffer_add_codepoints(
        buffer: *mut hb_buffer_t,
        text: *const hb_codepoint_t,
        text_length: ::std::os::raw::c_int,
        item_offset: ::std::os::raw::c_uint,
        item_length: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn hb_buffer_append(
        buffer: *mut hb_buffer_t,
        source: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_buffer_set_length(
        buffer: *mut hb_buffer_t,
        length: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_buffer_get_length(buffer: *mut hb_buffer_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_buffer_get_glyph_infos(
        buffer: *mut hb_buffer_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *mut hb_glyph_info_t;
}
extern "C" {
    pub fn hb_buffer_get_glyph_positions(
        buffer: *mut hb_buffer_t,
        length: *mut ::std::os::raw::c_uint,
    ) -> *mut hb_glyph_position_t;
}
extern "C" {
    pub fn hb_buffer_normalize_glyphs(buffer: *mut hb_buffer_t);
}
pub const HB_BUFFER_SERIALIZE_FLAG_DEFAULT: hb_buffer_serialize_flags_t = 0;
pub const HB_BUFFER_SERIALIZE_FLAG_NO_CLUSTERS: hb_buffer_serialize_flags_t = 1;
pub const HB_BUFFER_SERIALIZE_FLAG_NO_POSITIONS: hb_buffer_serialize_flags_t = 2;
pub const HB_BUFFER_SERIALIZE_FLAG_NO_GLYPH_NAMES: hb_buffer_serialize_flags_t = 4;
pub const HB_BUFFER_SERIALIZE_FLAG_GLYPH_EXTENTS: hb_buffer_serialize_flags_t = 8;
pub const HB_BUFFER_SERIALIZE_FLAG_GLYPH_FLAGS: hb_buffer_serialize_flags_t = 16;
pub const HB_BUFFER_SERIALIZE_FLAG_NO_ADVANCES: hb_buffer_serialize_flags_t = 32;
/// hb_buffer_serialize_flags_t:
/// @HB_BUFFER_SERIALIZE_FLAG_DEFAULT: serialize glyph names, clusters and positions.
/// @HB_BUFFER_SERIALIZE_FLAG_NO_CLUSTERS: do not serialize glyph cluster.
/// @HB_BUFFER_SERIALIZE_FLAG_NO_POSITIONS: do not serialize glyph position information.
/// @HB_BUFFER_SERIALIZE_FLAG_NO_GLYPH_NAMES: do no serialize glyph name.
/// @HB_BUFFER_SERIALIZE_FLAG_GLYPH_EXTENTS: serialize glyph extents.
/// @HB_BUFFER_SERIALIZE_FLAG_GLYPH_FLAGS: serialize glyph flags. Since: 1.5.0
/// @HB_BUFFER_SERIALIZE_FLAG_NO_ADVANCES: do not serialize glyph advances,
/// glyph offsets will reflect absolute glyph positions. Since: 1.8.0
///
/// Flags that control what glyph information are serialized in hb_buffer_serialize_glyphs().
///
/// Since: 0.9.20
pub type hb_buffer_serialize_flags_t = u32;
pub const HB_BUFFER_SERIALIZE_FORMAT_TEXT: hb_buffer_serialize_format_t = 1413830740;
pub const HB_BUFFER_SERIALIZE_FORMAT_JSON: hb_buffer_serialize_format_t = 1246973774;
pub const HB_BUFFER_SERIALIZE_FORMAT_INVALID: hb_buffer_serialize_format_t = 0;
/// hb_buffer_serialize_format_t:
/// @HB_BUFFER_SERIALIZE_FORMAT_TEXT: a human-readable, plain text format.
/// @HB_BUFFER_SERIALIZE_FORMAT_JSON: a machine-readable JSON format.
/// @HB_BUFFER_SERIALIZE_FORMAT_INVALID: invalid format.
///
/// The buffer serialization and de-serialization format used in
/// hb_buffer_serialize_glyphs() and hb_buffer_deserialize_glyphs().
///
/// Since: 0.9.2
pub type hb_buffer_serialize_format_t = u32;
extern "C" {
    pub fn hb_buffer_serialize_format_from_string(
        str: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> hb_buffer_serialize_format_t;
}
extern "C" {
    pub fn hb_buffer_serialize_format_to_string(
        format: hb_buffer_serialize_format_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_buffer_serialize_list_formats() -> *mut *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_buffer_serialize_glyphs(
        buffer: *mut hb_buffer_t,
        start: ::std::os::raw::c_uint,
        end: ::std::os::raw::c_uint,
        buf: *mut ::std::os::raw::c_char,
        buf_size: ::std::os::raw::c_uint,
        buf_consumed: *mut ::std::os::raw::c_uint,
        font: *mut hb_font_t,
        format: hb_buffer_serialize_format_t,
        flags: hb_buffer_serialize_flags_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_buffer_deserialize_glyphs(
        buffer: *mut hb_buffer_t,
        buf: *const ::std::os::raw::c_char,
        buf_len: ::std::os::raw::c_int,
        end_ptr: *mut *const ::std::os::raw::c_char,
        font: *mut hb_font_t,
        format: hb_buffer_serialize_format_t,
    ) -> hb_bool_t;
}
pub const HB_BUFFER_DIFF_FLAG_EQUAL: hb_buffer_diff_flags_t = 0;
pub const HB_BUFFER_DIFF_FLAG_CONTENT_TYPE_MISMATCH: hb_buffer_diff_flags_t = 1;
pub const HB_BUFFER_DIFF_FLAG_LENGTH_MISMATCH: hb_buffer_diff_flags_t = 2;
pub const HB_BUFFER_DIFF_FLAG_NOTDEF_PRESENT: hb_buffer_diff_flags_t = 4;
pub const HB_BUFFER_DIFF_FLAG_DOTTED_CIRCLE_PRESENT: hb_buffer_diff_flags_t = 8;
pub const HB_BUFFER_DIFF_FLAG_CODEPOINT_MISMATCH: hb_buffer_diff_flags_t = 16;
pub const HB_BUFFER_DIFF_FLAG_CLUSTER_MISMATCH: hb_buffer_diff_flags_t = 32;
pub const HB_BUFFER_DIFF_FLAG_GLYPH_FLAGS_MISMATCH: hb_buffer_diff_flags_t = 64;
pub const HB_BUFFER_DIFF_FLAG_POSITION_MISMATCH: hb_buffer_diff_flags_t = 128;
pub type hb_buffer_diff_flags_t = u32;
extern "C" {
    pub fn hb_buffer_diff(
        buffer: *mut hb_buffer_t,
        reference: *mut hb_buffer_t,
        dottedcircle_glyph: hb_codepoint_t,
        position_fuzz: ::std::os::raw::c_uint,
    ) -> hb_buffer_diff_flags_t;
}
pub type hb_buffer_message_func_t = ::std::option::Option<
    unsafe extern "C" fn(
        buffer: *mut hb_buffer_t,
        font: *mut hb_font_t,
        message: *const ::std::os::raw::c_char,
        user_data: *mut ::std::os::raw::c_void,
    ) -> hb_bool_t,
>;
extern "C" {
    pub fn hb_buffer_set_message_func(
        buffer: *mut hb_buffer_t,
        func: hb_buffer_message_func_t,
        user_data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_map_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_map_create() -> *mut hb_map_t;
}
extern "C" {
    pub fn hb_map_get_empty() -> *mut hb_map_t;
}
extern "C" {
    pub fn hb_map_reference(map: *mut hb_map_t) -> *mut hb_map_t;
}
extern "C" {
    pub fn hb_map_destroy(map: *mut hb_map_t);
}
extern "C" {
    pub fn hb_map_set_user_data(
        map: *mut hb_map_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_map_get_user_data(
        map: *mut hb_map_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_map_allocation_successful(map: *const hb_map_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_map_clear(map: *mut hb_map_t);
}
extern "C" {
    pub fn hb_map_is_empty(map: *const hb_map_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_map_get_population(map: *const hb_map_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_map_set(map: *mut hb_map_t, key: hb_codepoint_t, value: hb_codepoint_t);
}
extern "C" {
    pub fn hb_map_get(map: *const hb_map_t, key: hb_codepoint_t) -> hb_codepoint_t;
}
extern "C" {
    pub fn hb_map_del(map: *mut hb_map_t, key: hb_codepoint_t);
}
extern "C" {
    pub fn hb_map_has(map: *const hb_map_t, key: hb_codepoint_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_shape(
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_shape_full(
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_shape_list_shapers() -> *mut *const ::std::os::raw::c_char;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_shape_plan_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hb_shape_plan_create(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_create_cached(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_create2(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        coords: *const ::std::os::raw::c_int,
        num_coords: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_create_cached2(
        face: *mut hb_face_t,
        props: *const hb_segment_properties_t,
        user_features: *const hb_feature_t,
        num_user_features: ::std::os::raw::c_uint,
        coords: *const ::std::os::raw::c_int,
        num_coords: ::std::os::raw::c_uint,
        shaper_list: *const *const ::std::os::raw::c_char,
    ) -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_get_empty() -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_reference(shape_plan: *mut hb_shape_plan_t) -> *mut hb_shape_plan_t;
}
extern "C" {
    pub fn hb_shape_plan_destroy(shape_plan: *mut hb_shape_plan_t);
}
extern "C" {
    pub fn hb_shape_plan_set_user_data(
        shape_plan: *mut hb_shape_plan_t,
        key: *mut hb_user_data_key_t,
        data: *mut ::std::os::raw::c_void,
        destroy: hb_destroy_func_t,
        replace: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_shape_plan_get_user_data(
        shape_plan: *mut hb_shape_plan_t,
        key: *mut hb_user_data_key_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn hb_shape_plan_execute(
        shape_plan: *mut hb_shape_plan_t,
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_shape_plan_get_shaper(
        shape_plan: *mut hb_shape_plan_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_version(
        major: *mut ::std::os::raw::c_uint,
        minor: *mut ::std::os::raw::c_uint,
        micro: *mut ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_version_string() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hb_version_atleast(
        major: ::std::os::raw::c_uint,
        minor: ::std::os::raw::c_uint,
        micro: ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
pub const HB_OT_NAME_ID_COPYRIGHT: hb_ot_name_id_t = 0;
pub const HB_OT_NAME_ID_FONT_FAMILY: hb_ot_name_id_t = 1;
pub const HB_OT_NAME_ID_FONT_SUBFAMILY: hb_ot_name_id_t = 2;
pub const HB_OT_NAME_ID_UNIQUE_ID: hb_ot_name_id_t = 3;
pub const HB_OT_NAME_ID_FULL_NAME: hb_ot_name_id_t = 4;
pub const HB_OT_NAME_ID_VERSION_STRING: hb_ot_name_id_t = 5;
pub const HB_OT_NAME_ID_POSTSCRIPT_NAME: hb_ot_name_id_t = 6;
pub const HB_OT_NAME_ID_TRADEMARK: hb_ot_name_id_t = 7;
pub const HB_OT_NAME_ID_MANUFACTURER: hb_ot_name_id_t = 8;
pub const HB_OT_NAME_ID_DESIGNER: hb_ot_name_id_t = 9;
pub const HB_OT_NAME_ID_DESCRIPTION: hb_ot_name_id_t = 10;
pub const HB_OT_NAME_ID_VENDOR_URL: hb_ot_name_id_t = 11;
pub const HB_OT_NAME_ID_DESIGNER_URL: hb_ot_name_id_t = 12;
pub const HB_OT_NAME_ID_LICENSE: hb_ot_name_id_t = 13;
pub const HB_OT_NAME_ID_LICENSE_URL: hb_ot_name_id_t = 14;
pub const HB_OT_NAME_ID_TYPOGRAPHIC_FAMILY: hb_ot_name_id_t = 16;
pub const HB_OT_NAME_ID_TYPOGRAPHIC_SUBFAMILY: hb_ot_name_id_t = 17;
pub const HB_OT_NAME_ID_MAC_FULL_NAME: hb_ot_name_id_t = 18;
pub const HB_OT_NAME_ID_SAMPLE_TEXT: hb_ot_name_id_t = 19;
pub const HB_OT_NAME_ID_CID_FINDFONT_NAME: hb_ot_name_id_t = 20;
pub const HB_OT_NAME_ID_WWS_FAMILY: hb_ot_name_id_t = 21;
pub const HB_OT_NAME_ID_WWS_SUBFAMILY: hb_ot_name_id_t = 22;
pub const HB_OT_NAME_ID_LIGHT_BACKGROUND: hb_ot_name_id_t = 23;
pub const HB_OT_NAME_ID_DARK_BACKGROUND: hb_ot_name_id_t = 24;
pub const HB_OT_NAME_ID_VARIATIONS_PS_PREFIX: hb_ot_name_id_t = 25;
pub const HB_OT_NAME_ID_INVALID: hb_ot_name_id_t = 65535;
/// hb_ot_name_id_t:
/// @HB_OT_NAME_ID_INVALID: Value to represent a nonexistent name ID.
///
/// An integral type representing an OpenType 'name' table name identifier.
/// There are predefined name IDs, as well as name IDs return from other
/// API.  These can be used to fetch name strings from a font face.
///
/// Since: 2.0.0
pub type hb_ot_name_id_t = ::std::os::raw::c_uint;
/// hb_ot_name_entry_t:
/// @name_id: name ID
/// @language: language
///
/// Structure representing a name ID in a particular language.
///
/// Since: 2.1.0
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hb_ot_name_entry_t {
    pub name_id: hb_ot_name_id_t,
    pub var: hb_var_int_t,
    pub language: hb_language_t,
}
#[test]
fn bindgen_test_layout_hb_ot_name_entry_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_ot_name_entry_t>(),
        16usize,
        concat!("Size of: ", stringify!(hb_ot_name_entry_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_ot_name_entry_t>(),
        8usize,
        concat!("Alignment of ", stringify!(hb_ot_name_entry_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_name_entry_t>())).name_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_name_entry_t),
            "::",
            stringify!(name_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_name_entry_t>())).var as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_name_entry_t),
            "::",
            stringify!(var)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_name_entry_t>())).language as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_name_entry_t),
            "::",
            stringify!(language)
        )
    );
}
extern "C" {
    pub fn hb_ot_name_list_names(
        face: *mut hb_face_t,
        num_entries: *mut ::std::os::raw::c_uint,
    ) -> *const hb_ot_name_entry_t;
}
extern "C" {
    pub fn hb_ot_name_get_utf8(
        face: *mut hb_face_t,
        name_id: hb_ot_name_id_t,
        language: hb_language_t,
        text_size: *mut ::std::os::raw::c_uint,
        text: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_name_get_utf16(
        face: *mut hb_face_t,
        name_id: hb_ot_name_id_t,
        language: hb_language_t,
        text_size: *mut ::std::os::raw::c_uint,
        text: *mut u16,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_name_get_utf32(
        face: *mut hb_face_t,
        name_id: hb_ot_name_id_t,
        language: hb_language_t,
        text_size: *mut ::std::os::raw::c_uint,
        text: *mut u32,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_color_has_palettes(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_color_palette_get_count(face: *mut hb_face_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_color_palette_get_name_id(
        face: *mut hb_face_t,
        palette_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
extern "C" {
    pub fn hb_ot_color_palette_color_get_name_id(
        face: *mut hb_face_t,
        color_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
pub const HB_OT_COLOR_PALETTE_FLAG_DEFAULT: hb_ot_color_palette_flags_t = 0;
pub const HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_LIGHT_BACKGROUND: hb_ot_color_palette_flags_t = 1;
pub const HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_DARK_BACKGROUND: hb_ot_color_palette_flags_t = 2;
/// hb_ot_color_palette_flags_t:
/// @HB_OT_COLOR_PALETTE_FLAG_DEFAULT: default indicating that there is nothing special
/// to note about a color palette.
/// @HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_LIGHT_BACKGROUND: flag indicating that the color
/// palette is appropriate to use when displaying the font on a light background such as white.
/// @HB_OT_COLOR_PALETTE_FLAG_USABLE_WITH_DARK_BACKGROUND: flag indicating that the color
/// palette is appropriate to use when displaying the font on a dark background such as black.
///
/// Since: 2.1.0
pub type hb_ot_color_palette_flags_t = u32;
extern "C" {
    pub fn hb_ot_color_palette_get_flags(
        face: *mut hb_face_t,
        palette_index: ::std::os::raw::c_uint,
    ) -> hb_ot_color_palette_flags_t;
}
extern "C" {
    pub fn hb_ot_color_palette_get_colors(
        face: *mut hb_face_t,
        palette_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        color_count: *mut ::std::os::raw::c_uint,
        colors: *mut hb_color_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_color_has_layers(face: *mut hb_face_t) -> hb_bool_t;
}
/// hb_ot_color_layer_t:
///
/// Pairs of glyph and color index.
///
/// Since: 2.1.0
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_color_layer_t {
    pub glyph: hb_codepoint_t,
    pub color_index: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_hb_ot_color_layer_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_ot_color_layer_t>(),
        8usize,
        concat!("Size of: ", stringify!(hb_ot_color_layer_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_ot_color_layer_t>(),
        4usize,
        concat!("Alignment of ", stringify!(hb_ot_color_layer_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_color_layer_t>())).glyph as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_color_layer_t),
            "::",
            stringify!(glyph)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_color_layer_t>())).color_index as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_color_layer_t),
            "::",
            stringify!(color_index)
        )
    );
}
extern "C" {
    pub fn hb_ot_color_glyph_get_layers(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        layer_count: *mut ::std::os::raw::c_uint,
        layers: *mut hb_ot_color_layer_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_color_has_svg(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_color_glyph_reference_svg(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
    ) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_ot_color_has_png(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_color_glyph_reference_png(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> *mut hb_blob_t;
}
extern "C" {
    pub fn hb_ot_font_set_funcs(font: *mut hb_font_t);
}
extern "C" {
    pub fn hb_ot_tags_from_script_and_language(
        script: hb_script_t,
        language: hb_language_t,
        script_count: *mut ::std::os::raw::c_uint,
        script_tags: *mut hb_tag_t,
        language_count: *mut ::std::os::raw::c_uint,
        language_tags: *mut hb_tag_t,
    );
}
extern "C" {
    pub fn hb_ot_tag_to_script(tag: hb_tag_t) -> hb_script_t;
}
extern "C" {
    pub fn hb_ot_tag_to_language(tag: hb_tag_t) -> hb_language_t;
}
extern "C" {
    pub fn hb_ot_tags_to_script_and_language(
        script_tag: hb_tag_t,
        language_tag: hb_tag_t,
        script: *mut hb_script_t,
        language: *mut hb_language_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_has_glyph_classes(face: *mut hb_face_t) -> hb_bool_t;
}
pub const HB_OT_LAYOUT_GLYPH_CLASS_UNCLASSIFIED: hb_ot_layout_glyph_class_t = 0;
pub const HB_OT_LAYOUT_GLYPH_CLASS_BASE_GLYPH: hb_ot_layout_glyph_class_t = 1;
pub const HB_OT_LAYOUT_GLYPH_CLASS_LIGATURE: hb_ot_layout_glyph_class_t = 2;
pub const HB_OT_LAYOUT_GLYPH_CLASS_MARK: hb_ot_layout_glyph_class_t = 3;
pub const HB_OT_LAYOUT_GLYPH_CLASS_COMPONENT: hb_ot_layout_glyph_class_t = 4;
/// hb_ot_layout_glyph_class_t:
/// @HB_OT_LAYOUT_GLYPH_CLASS_UNCLASSIFIED: Glyphs not matching the other classifications
/// @HB_OT_LAYOUT_GLYPH_CLASS_BASE_GLYPH: Spacing, single characters, capable of accepting marks
/// @HB_OT_LAYOUT_GLYPH_CLASS_LIGATURE: Glyphs that represent ligation of multiple characters
/// @HB_OT_LAYOUT_GLYPH_CLASS_MARK: Non-spacing, combining glyphs that represent marks
/// @HB_OT_LAYOUT_GLYPH_CLASS_COMPONENT: Spacing glyphs that represent part of a single character
///
/// The GDEF classes defined for glyphs.
///
pub type hb_ot_layout_glyph_class_t = u32;
extern "C" {
    pub fn hb_ot_layout_get_glyph_class(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
    ) -> hb_ot_layout_glyph_class_t;
}
extern "C" {
    pub fn hb_ot_layout_get_glyphs_in_class(
        face: *mut hb_face_t,
        klass: hb_ot_layout_glyph_class_t,
        glyphs: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_get_attach_points(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        point_count: *mut ::std::os::raw::c_uint,
        point_array: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_get_ligature_carets(
        font: *mut hb_font_t,
        direction: hb_direction_t,
        glyph: hb_codepoint_t,
        start_offset: ::std::os::raw::c_uint,
        caret_count: *mut ::std::os::raw::c_uint,
        caret_array: *mut hb_position_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_table_get_script_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        start_offset: ::std::os::raw::c_uint,
        script_count: *mut ::std::os::raw::c_uint,
        script_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_table_find_script(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_tag: hb_tag_t,
        script_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_table_select_script(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_count: ::std::os::raw::c_uint,
        script_tags: *const hb_tag_t,
        script_index: *mut ::std::os::raw::c_uint,
        chosen_script: *mut hb_tag_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_table_get_feature_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        feature_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_script_get_language_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        language_count: *mut ::std::os::raw::c_uint,
        language_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_script_select_language(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_count: ::std::os::raw::c_uint,
        language_tags: *const hb_tag_t,
        language_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_language_get_required_feature_index(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_language_get_required_feature(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_index: *mut ::std::os::raw::c_uint,
        feature_tag: *mut hb_tag_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_language_get_feature_indexes(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        feature_indexes: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_language_get_feature_tags(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        feature_tags: *mut hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_language_find_feature(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        script_index: ::std::os::raw::c_uint,
        language_index: ::std::os::raw::c_uint,
        feature_tag: hb_tag_t,
        feature_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_feature_get_lookups(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        lookup_count: *mut ::std::os::raw::c_uint,
        lookup_indexes: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_table_get_lookup_count(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_collect_features(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        scripts: *const hb_tag_t,
        languages: *const hb_tag_t,
        features: *const hb_tag_t,
        feature_indexes: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_collect_lookups(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        scripts: *const hb_tag_t,
        languages: *const hb_tag_t,
        features: *const hb_tag_t,
        lookup_indexes: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_lookup_collect_glyphs(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        lookup_index: ::std::os::raw::c_uint,
        glyphs_before: *mut hb_set_t,
        glyphs_input: *mut hb_set_t,
        glyphs_after: *mut hb_set_t,
        glyphs_output: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_table_find_feature_variations(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        coords: *const ::std::os::raw::c_int,
        num_coords: ::std::os::raw::c_uint,
        variations_index: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_feature_with_variations_get_lookups(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        variations_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        lookup_count: *mut ::std::os::raw::c_uint,
        lookup_indexes: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_layout_has_substitution(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_lookup_would_substitute(
        face: *mut hb_face_t,
        lookup_index: ::std::os::raw::c_uint,
        glyphs: *const hb_codepoint_t,
        glyphs_length: ::std::os::raw::c_uint,
        zero_context: hb_bool_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_lookup_substitute_closure(
        face: *mut hb_face_t,
        lookup_index: ::std::os::raw::c_uint,
        glyphs: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_lookups_substitute_closure(
        face: *mut hb_face_t,
        lookups: *const hb_set_t,
        glyphs: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_layout_has_positioning(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_get_size_params(
        face: *mut hb_face_t,
        design_size: *mut ::std::os::raw::c_uint,
        subfamily_id: *mut ::std::os::raw::c_uint,
        subfamily_name_id: *mut hb_ot_name_id_t,
        range_start: *mut ::std::os::raw::c_uint,
        range_end: *mut ::std::os::raw::c_uint,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_feature_get_name_ids(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        label_id: *mut hb_ot_name_id_t,
        tooltip_id: *mut hb_ot_name_id_t,
        sample_id: *mut hb_ot_name_id_t,
        num_named_parameters: *mut ::std::os::raw::c_uint,
        first_param_id: *mut hb_ot_name_id_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_layout_feature_get_characters(
        face: *mut hb_face_t,
        table_tag: hb_tag_t,
        feature_index: ::std::os::raw::c_uint,
        start_offset: ::std::os::raw::c_uint,
        char_count: *mut ::std::os::raw::c_uint,
        characters: *mut hb_codepoint_t,
    ) -> ::std::os::raw::c_uint;
}
pub const HB_OT_LAYOUT_BASELINE_TAG_ROMAN: hb_ot_layout_baseline_tag_t = 1919905134;
pub const HB_OT_LAYOUT_BASELINE_TAG_HANGING: hb_ot_layout_baseline_tag_t = 1751215719;
pub const HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_BOTTOM_OR_LEFT: hb_ot_layout_baseline_tag_t =
    1768121954;
pub const HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_TOP_OR_RIGHT: hb_ot_layout_baseline_tag_t =
    1768121972;
pub const HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_BOTTOM_OR_LEFT: hb_ot_layout_baseline_tag_t =
    1768187247;
pub const HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_TOP_OR_RIGHT: hb_ot_layout_baseline_tag_t =
    1768191088;
pub const HB_OT_LAYOUT_BASELINE_TAG_MATH: hb_ot_layout_baseline_tag_t = 1835103336;
pub const _HB_OT_LAYOUT_BASELINE_TAG_MAX_VALUE: hb_ot_layout_baseline_tag_t = 2147483647;
/// hb_ot_layout_baseline_tag_t:
/// @HB_OT_LAYOUT_BASELINE_TAG_ROMAN: The baseline used by alphabetic scripts such as Latin, Cyrillic and Greek.
/// In vertical writing mode, the alphabetic baseline for characters rotated 90 degrees clockwise.
/// (This would not apply to alphabetic characters that remain upright in vertical writing mode, since these
/// characters are not rotated.)
/// @HB_OT_LAYOUT_BASELINE_TAG_HANGING: The hanging baseline. In horizontal direction, this is the horizontal
/// line from which syllables seem, to hang in Tibetan and other similar scripts. In vertical writing mode,
/// for Tibetan (or some other similar script) characters rotated 90 degrees clockwise.
/// @HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_BOTTOM_OR_LEFT: Ideographic character face bottom or left edge,
/// if the direction is horizontal or vertical, respectively.
/// @HB_OT_LAYOUT_BASELINE_TAG_IDEO_FACE_TOP_OR_RIGHT: Ideographic character face top or right edge,
/// if the direction is horizontal or vertical, respectively.
/// @HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_BOTTOM_OR_LEFT: Ideographic em-box bottom or left edge,
/// if the direction is horizontal or vertical, respectively.
/// @HB_OT_LAYOUT_BASELINE_TAG_IDEO_EMBOX_TOP_OR_RIGHT: Ideographic em-box top or right edge baseline,
/// if the direction is horizontal or vertical, respectively.
/// @HB_OT_LAYOUT_BASELINE_TAG_MATH: The baseline about which mathematical characters are centered.
/// In vertical writing mode when mathematical characters rotated 90 degrees clockwise, are centered.
///
/// Baseline tags from https://docs.microsoft.com/en-us/typography/opentype/spec/baselinetags
///
/// Since: 2.6.0
pub type hb_ot_layout_baseline_tag_t = u32;
extern "C" {
    pub fn hb_ot_layout_get_baseline(
        font: *mut hb_font_t,
        baseline_tag: hb_ot_layout_baseline_tag_t,
        direction: hb_direction_t,
        script_tag: hb_tag_t,
        language_tag: hb_tag_t,
        coord: *mut hb_position_t,
    ) -> hb_bool_t;
}
pub const HB_OT_MATH_CONSTANT_SCRIPT_PERCENT_SCALE_DOWN: hb_ot_math_constant_t = 0;
pub const HB_OT_MATH_CONSTANT_SCRIPT_SCRIPT_PERCENT_SCALE_DOWN: hb_ot_math_constant_t = 1;
pub const HB_OT_MATH_CONSTANT_DELIMITED_SUB_FORMULA_MIN_HEIGHT: hb_ot_math_constant_t = 2;
pub const HB_OT_MATH_CONSTANT_DISPLAY_OPERATOR_MIN_HEIGHT: hb_ot_math_constant_t = 3;
pub const HB_OT_MATH_CONSTANT_MATH_LEADING: hb_ot_math_constant_t = 4;
pub const HB_OT_MATH_CONSTANT_AXIS_HEIGHT: hb_ot_math_constant_t = 5;
pub const HB_OT_MATH_CONSTANT_ACCENT_BASE_HEIGHT: hb_ot_math_constant_t = 6;
pub const HB_OT_MATH_CONSTANT_FLATTENED_ACCENT_BASE_HEIGHT: hb_ot_math_constant_t = 7;
pub const HB_OT_MATH_CONSTANT_SUBSCRIPT_SHIFT_DOWN: hb_ot_math_constant_t = 8;
pub const HB_OT_MATH_CONSTANT_SUBSCRIPT_TOP_MAX: hb_ot_math_constant_t = 9;
pub const HB_OT_MATH_CONSTANT_SUBSCRIPT_BASELINE_DROP_MIN: hb_ot_math_constant_t = 10;
pub const HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP: hb_ot_math_constant_t = 11;
pub const HB_OT_MATH_CONSTANT_SUPERSCRIPT_SHIFT_UP_CRAMPED: hb_ot_math_constant_t = 12;
pub const HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MIN: hb_ot_math_constant_t = 13;
pub const HB_OT_MATH_CONSTANT_SUPERSCRIPT_BASELINE_DROP_MAX: hb_ot_math_constant_t = 14;
pub const HB_OT_MATH_CONSTANT_SUB_SUPERSCRIPT_GAP_MIN: hb_ot_math_constant_t = 15;
pub const HB_OT_MATH_CONSTANT_SUPERSCRIPT_BOTTOM_MAX_WITH_SUBSCRIPT: hb_ot_math_constant_t = 16;
pub const HB_OT_MATH_CONSTANT_SPACE_AFTER_SCRIPT: hb_ot_math_constant_t = 17;
pub const HB_OT_MATH_CONSTANT_UPPER_LIMIT_GAP_MIN: hb_ot_math_constant_t = 18;
pub const HB_OT_MATH_CONSTANT_UPPER_LIMIT_BASELINE_RISE_MIN: hb_ot_math_constant_t = 19;
pub const HB_OT_MATH_CONSTANT_LOWER_LIMIT_GAP_MIN: hb_ot_math_constant_t = 20;
pub const HB_OT_MATH_CONSTANT_LOWER_LIMIT_BASELINE_DROP_MIN: hb_ot_math_constant_t = 21;
pub const HB_OT_MATH_CONSTANT_STACK_TOP_SHIFT_UP: hb_ot_math_constant_t = 22;
pub const HB_OT_MATH_CONSTANT_STACK_TOP_DISPLAY_STYLE_SHIFT_UP: hb_ot_math_constant_t = 23;
pub const HB_OT_MATH_CONSTANT_STACK_BOTTOM_SHIFT_DOWN: hb_ot_math_constant_t = 24;
pub const HB_OT_MATH_CONSTANT_STACK_BOTTOM_DISPLAY_STYLE_SHIFT_DOWN: hb_ot_math_constant_t = 25;
pub const HB_OT_MATH_CONSTANT_STACK_GAP_MIN: hb_ot_math_constant_t = 26;
pub const HB_OT_MATH_CONSTANT_STACK_DISPLAY_STYLE_GAP_MIN: hb_ot_math_constant_t = 27;
pub const HB_OT_MATH_CONSTANT_STRETCH_STACK_TOP_SHIFT_UP: hb_ot_math_constant_t = 28;
pub const HB_OT_MATH_CONSTANT_STRETCH_STACK_BOTTOM_SHIFT_DOWN: hb_ot_math_constant_t = 29;
pub const HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_ABOVE_MIN: hb_ot_math_constant_t = 30;
pub const HB_OT_MATH_CONSTANT_STRETCH_STACK_GAP_BELOW_MIN: hb_ot_math_constant_t = 31;
pub const HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_SHIFT_UP: hb_ot_math_constant_t = 32;
pub const HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_DISPLAY_STYLE_SHIFT_UP: hb_ot_math_constant_t = 33;
pub const HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_SHIFT_DOWN: hb_ot_math_constant_t = 34;
pub const HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_DISPLAY_STYLE_SHIFT_DOWN: hb_ot_math_constant_t =
    35;
pub const HB_OT_MATH_CONSTANT_FRACTION_NUMERATOR_GAP_MIN: hb_ot_math_constant_t = 36;
pub const HB_OT_MATH_CONSTANT_FRACTION_NUM_DISPLAY_STYLE_GAP_MIN: hb_ot_math_constant_t = 37;
pub const HB_OT_MATH_CONSTANT_FRACTION_RULE_THICKNESS: hb_ot_math_constant_t = 38;
pub const HB_OT_MATH_CONSTANT_FRACTION_DENOMINATOR_GAP_MIN: hb_ot_math_constant_t = 39;
pub const HB_OT_MATH_CONSTANT_FRACTION_DENOM_DISPLAY_STYLE_GAP_MIN: hb_ot_math_constant_t = 40;
pub const HB_OT_MATH_CONSTANT_SKEWED_FRACTION_HORIZONTAL_GAP: hb_ot_math_constant_t = 41;
pub const HB_OT_MATH_CONSTANT_SKEWED_FRACTION_VERTICAL_GAP: hb_ot_math_constant_t = 42;
pub const HB_OT_MATH_CONSTANT_OVERBAR_VERTICAL_GAP: hb_ot_math_constant_t = 43;
pub const HB_OT_MATH_CONSTANT_OVERBAR_RULE_THICKNESS: hb_ot_math_constant_t = 44;
pub const HB_OT_MATH_CONSTANT_OVERBAR_EXTRA_ASCENDER: hb_ot_math_constant_t = 45;
pub const HB_OT_MATH_CONSTANT_UNDERBAR_VERTICAL_GAP: hb_ot_math_constant_t = 46;
pub const HB_OT_MATH_CONSTANT_UNDERBAR_RULE_THICKNESS: hb_ot_math_constant_t = 47;
pub const HB_OT_MATH_CONSTANT_UNDERBAR_EXTRA_DESCENDER: hb_ot_math_constant_t = 48;
pub const HB_OT_MATH_CONSTANT_RADICAL_VERTICAL_GAP: hb_ot_math_constant_t = 49;
pub const HB_OT_MATH_CONSTANT_RADICAL_DISPLAY_STYLE_VERTICAL_GAP: hb_ot_math_constant_t = 50;
pub const HB_OT_MATH_CONSTANT_RADICAL_RULE_THICKNESS: hb_ot_math_constant_t = 51;
pub const HB_OT_MATH_CONSTANT_RADICAL_EXTRA_ASCENDER: hb_ot_math_constant_t = 52;
pub const HB_OT_MATH_CONSTANT_RADICAL_KERN_BEFORE_DEGREE: hb_ot_math_constant_t = 53;
pub const HB_OT_MATH_CONSTANT_RADICAL_KERN_AFTER_DEGREE: hb_ot_math_constant_t = 54;
pub const HB_OT_MATH_CONSTANT_RADICAL_DEGREE_BOTTOM_RAISE_PERCENT: hb_ot_math_constant_t = 55;
/// hb_ot_math_constant_t:
///
/// The 'MATH' table constants specified at
/// https://docs.microsoft.com/en-us/typography/opentype/spec/math
///
/// Since: 1.3.3
pub type hb_ot_math_constant_t = u32;
pub const HB_OT_MATH_KERN_TOP_RIGHT: hb_ot_math_kern_t = 0;
pub const HB_OT_MATH_KERN_TOP_LEFT: hb_ot_math_kern_t = 1;
pub const HB_OT_MATH_KERN_BOTTOM_RIGHT: hb_ot_math_kern_t = 2;
pub const HB_OT_MATH_KERN_BOTTOM_LEFT: hb_ot_math_kern_t = 3;
/// hb_ot_math_kern_t:
///
/// The math kerning-table types defined for the four corners
/// of a glyph.
///
/// Since: 1.3.3
pub type hb_ot_math_kern_t = u32;
/// hb_ot_math_glyph_variant_t:
/// @glyph: The glyph index of the variant
/// @advance: The advance width of the variant
///
/// Data type to hold math-variant information for a glyph.
///
/// Since: 1.3.3
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_math_glyph_variant_t {
    pub glyph: hb_codepoint_t,
    pub advance: hb_position_t,
}
#[test]
fn bindgen_test_layout_hb_ot_math_glyph_variant_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_ot_math_glyph_variant_t>(),
        8usize,
        concat!("Size of: ", stringify!(hb_ot_math_glyph_variant_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_ot_math_glyph_variant_t>(),
        4usize,
        concat!("Alignment of ", stringify!(hb_ot_math_glyph_variant_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_ot_math_glyph_variant_t>())).glyph as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_math_glyph_variant_t),
            "::",
            stringify!(glyph)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_ot_math_glyph_variant_t>())).advance as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_math_glyph_variant_t),
            "::",
            stringify!(advance)
        )
    );
}
pub const HB_OT_MATH_GLYPH_PART_FLAG_EXTENDER: hb_ot_math_glyph_part_flags_t = 1;
/// hb_ot_math_glyph_part_flags_t:
///
/// Flags for math glyph parts.
///
/// Since: 1.3.3
pub type hb_ot_math_glyph_part_flags_t = u32;
/// hb_ot_math_glyph_part_t:
/// @glyph: The glyph index of the variant part
/// @start_connector_length: The length of the connector on the starting side of the variant part
/// @end_connector_length: The length of the connector on the ending side of the variant part
/// @full_advance: The total advance of the part
/// @flags: `hb_ot_math_glyph_part_flags_t` flags for the part
///
/// Data type to hold information for a "part" component of a math-variant glyph.
/// Large variants for stretchable math glyphs (such as parentheses) can be constructed
/// on the fly from parts.
///
/// Since: 1.3.3
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_math_glyph_part_t {
    pub glyph: hb_codepoint_t,
    pub start_connector_length: hb_position_t,
    pub end_connector_length: hb_position_t,
    pub full_advance: hb_position_t,
    pub flags: hb_ot_math_glyph_part_flags_t,
}
#[test]
fn bindgen_test_layout_hb_ot_math_glyph_part_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_ot_math_glyph_part_t>(),
        20usize,
        concat!("Size of: ", stringify!(hb_ot_math_glyph_part_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_ot_math_glyph_part_t>(),
        4usize,
        concat!("Alignment of ", stringify!(hb_ot_math_glyph_part_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_math_glyph_part_t>())).glyph as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_math_glyph_part_t),
            "::",
            stringify!(glyph)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_ot_math_glyph_part_t>())).start_connector_length as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_math_glyph_part_t),
            "::",
            stringify!(start_connector_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_ot_math_glyph_part_t>())).end_connector_length as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_math_glyph_part_t),
            "::",
            stringify!(end_connector_length)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_ot_math_glyph_part_t>())).full_advance as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_math_glyph_part_t),
            "::",
            stringify!(full_advance)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_math_glyph_part_t>())).flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_math_glyph_part_t),
            "::",
            stringify!(flags)
        )
    );
}
extern "C" {
    pub fn hb_ot_math_has_data(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_math_get_constant(
        font: *mut hb_font_t,
        constant: hb_ot_math_constant_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_italics_correction(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_top_accent_attachment(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_math_is_glyph_extended_shape(
        face: *mut hb_face_t,
        glyph: hb_codepoint_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_kerning(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        kern: hb_ot_math_kern_t,
        correction_height: hb_position_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_variants(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        start_offset: ::std::os::raw::c_uint,
        variants_count: *mut ::std::os::raw::c_uint,
        variants: *mut hb_ot_math_glyph_variant_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_math_get_min_connector_overlap(
        font: *mut hb_font_t,
        direction: hb_direction_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_math_get_glyph_assembly(
        font: *mut hb_font_t,
        glyph: hb_codepoint_t,
        direction: hb_direction_t,
        start_offset: ::std::os::raw::c_uint,
        parts_count: *mut ::std::os::raw::c_uint,
        parts: *mut hb_ot_math_glyph_part_t,
        italics_correction: *mut hb_position_t,
    ) -> ::std::os::raw::c_uint;
}
pub const HB_OT_META_TAG_DESIGN_LANGUAGES: hb_ot_meta_tag_t = 1684827751;
pub const HB_OT_META_TAG_SUPPORTED_LANGUAGES: hb_ot_meta_tag_t = 1936485991;
pub const _HB_OT_META_TAG_MAX_VALUE: hb_ot_meta_tag_t = 2147483647;
/// hb_ot_meta_tag_t:
/// @HB_OT_META_TAG_DESIGN_LANGUAGES: Design languages. Text, using only
/// Basic Latin (ASCII) characters. Indicates languages and/or scripts
/// for the user audiences that the font was primarily designed for.
/// @HB_OT_META_TAG_SUPPORTED_LANGUAGES: Supported languages. Text, using
/// only Basic Latin (ASCII) characters. Indicates languages and/or scripts
/// that the font is declared to be capable of supporting.
///
/// Known metadata tags from https://docs.microsoft.com/en-us/typography/opentype/spec/meta
///
/// Since: 2.6.0
pub type hb_ot_meta_tag_t = u32;
extern "C" {
    pub fn hb_ot_meta_get_entry_tags(
        face: *mut hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        entries_count: *mut ::std::os::raw::c_uint,
        entries: *mut hb_ot_meta_tag_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_meta_reference_entry(
        face: *mut hb_face_t,
        meta_tag: hb_ot_meta_tag_t,
    ) -> *mut hb_blob_t;
}
pub const HB_OT_METRICS_TAG_HORIZONTAL_ASCENDER: hb_ot_metrics_tag_t = 1751216995;
pub const HB_OT_METRICS_TAG_HORIZONTAL_DESCENDER: hb_ot_metrics_tag_t = 1751413603;
pub const HB_OT_METRICS_TAG_HORIZONTAL_LINE_GAP: hb_ot_metrics_tag_t = 1751934832;
pub const HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_ASCENT: hb_ot_metrics_tag_t = 1751346273;
pub const HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_DESCENT: hb_ot_metrics_tag_t = 1751346276;
pub const HB_OT_METRICS_TAG_VERTICAL_ASCENDER: hb_ot_metrics_tag_t = 1986098019;
pub const HB_OT_METRICS_TAG_VERTICAL_DESCENDER: hb_ot_metrics_tag_t = 1986294627;
pub const HB_OT_METRICS_TAG_VERTICAL_LINE_GAP: hb_ot_metrics_tag_t = 1986815856;
pub const HB_OT_METRICS_TAG_HORIZONTAL_CARET_RISE: hb_ot_metrics_tag_t = 1751347827;
pub const HB_OT_METRICS_TAG_HORIZONTAL_CARET_RUN: hb_ot_metrics_tag_t = 1751347822;
pub const HB_OT_METRICS_TAG_HORIZONTAL_CARET_OFFSET: hb_ot_metrics_tag_t = 1751347046;
pub const HB_OT_METRICS_TAG_VERTICAL_CARET_RISE: hb_ot_metrics_tag_t = 1986228851;
pub const HB_OT_METRICS_TAG_VERTICAL_CARET_RUN: hb_ot_metrics_tag_t = 1986228846;
pub const HB_OT_METRICS_TAG_VERTICAL_CARET_OFFSET: hb_ot_metrics_tag_t = 1986228070;
pub const HB_OT_METRICS_TAG_X_HEIGHT: hb_ot_metrics_tag_t = 2020108148;
pub const HB_OT_METRICS_TAG_CAP_HEIGHT: hb_ot_metrics_tag_t = 1668311156;
pub const HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_SIZE: hb_ot_metrics_tag_t = 1935833203;
pub const HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_SIZE: hb_ot_metrics_tag_t = 1935833459;
pub const HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_OFFSET: hb_ot_metrics_tag_t = 1935833199;
pub const HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_OFFSET: hb_ot_metrics_tag_t = 1935833455;
pub const HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_SIZE: hb_ot_metrics_tag_t = 1936750707;
pub const HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_SIZE: hb_ot_metrics_tag_t = 1936750963;
pub const HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_OFFSET: hb_ot_metrics_tag_t = 1936750703;
pub const HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_OFFSET: hb_ot_metrics_tag_t = 1936750959;
pub const HB_OT_METRICS_TAG_STRIKEOUT_SIZE: hb_ot_metrics_tag_t = 1937011315;
pub const HB_OT_METRICS_TAG_STRIKEOUT_OFFSET: hb_ot_metrics_tag_t = 1937011311;
pub const HB_OT_METRICS_TAG_UNDERLINE_SIZE: hb_ot_metrics_tag_t = 1970168947;
pub const HB_OT_METRICS_TAG_UNDERLINE_OFFSET: hb_ot_metrics_tag_t = 1970168943;
pub const _HB_OT_METRICS_TAG_MAX_VALUE: hb_ot_metrics_tag_t = 2147483647;
/// hb_ot_metrics_tag_t:
/// @HB_OT_METRICS_TAG_HORIZONTAL_ASCENDER: horizontal ascender.
/// @HB_OT_METRICS_TAG_HORIZONTAL_DESCENDER: horizontal descender.
/// @HB_OT_METRICS_TAG_HORIZONTAL_LINE_GAP: horizontal line gap.
/// @HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_ASCENT: horizontal clipping ascent.
/// @HB_OT_METRICS_TAG_HORIZONTAL_CLIPPING_DESCENT: horizontal clipping descent.
/// @HB_OT_METRICS_TAG_VERTICAL_ASCENDER: vertical ascender.
/// @HB_OT_METRICS_TAG_VERTICAL_DESCENDER: vertical descender.
/// @HB_OT_METRICS_TAG_VERTICAL_LINE_GAP: vertical line gap.
/// @HB_OT_METRICS_TAG_HORIZONTAL_CARET_RISE: horizontal caret rise.
/// @HB_OT_METRICS_TAG_HORIZONTAL_CARET_RUN: horizontal caret run.
/// @HB_OT_METRICS_TAG_HORIZONTAL_CARET_OFFSET: horizontal caret offset.
/// @HB_OT_METRICS_TAG_VERTICAL_CARET_RISE: vertical caret rise.
/// @HB_OT_METRICS_TAG_VERTICAL_CARET_RUN: vertical caret run.
/// @HB_OT_METRICS_TAG_VERTICAL_CARET_OFFSET: vertical caret offset.
/// @HB_OT_METRICS_TAG_X_HEIGHT: x height.
/// @HB_OT_METRICS_TAG_CAP_HEIGHT: cap height.
/// @HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_SIZE: subscript em x size.
/// @HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_SIZE: subscript em y size.
/// @HB_OT_METRICS_TAG_SUBSCRIPT_EM_X_OFFSET: subscript em x offset.
/// @HB_OT_METRICS_TAG_SUBSCRIPT_EM_Y_OFFSET: subscript em y offset.
/// @HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_SIZE: superscript em x size.
/// @HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_SIZE: superscript em y size.
/// @HB_OT_METRICS_TAG_SUPERSCRIPT_EM_X_OFFSET: superscript em x offset.
/// @HB_OT_METRICS_TAG_SUPERSCRIPT_EM_Y_OFFSET: superscript em y offset.
/// @HB_OT_METRICS_TAG_STRIKEOUT_SIZE: strikeout size.
/// @HB_OT_METRICS_TAG_STRIKEOUT_OFFSET: strikeout offset.
/// @HB_OT_METRICS_TAG_UNDERLINE_SIZE: underline size.
/// @HB_OT_METRICS_TAG_UNDERLINE_OFFSET: underline offset.
///
/// From https://docs.microsoft.com/en-us/typography/opentype/spec/mvar#value-tags
///
/// Since: 2.6.0
pub type hb_ot_metrics_tag_t = u32;
extern "C" {
    pub fn hb_ot_metrics_get_position(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
        position: *mut hb_position_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_metrics_get_variation(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
    ) -> ::std::os::raw::c_float;
}
extern "C" {
    pub fn hb_ot_metrics_get_x_variation(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_metrics_get_y_variation(
        font: *mut hb_font_t,
        metrics_tag: hb_ot_metrics_tag_t,
    ) -> hb_position_t;
}
extern "C" {
    pub fn hb_ot_shape_glyphs_closure(
        font: *mut hb_font_t,
        buffer: *mut hb_buffer_t,
        features: *const hb_feature_t,
        num_features: ::std::os::raw::c_uint,
        glyphs: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_shape_plan_collect_lookups(
        shape_plan: *mut hb_shape_plan_t,
        table_tag: hb_tag_t,
        lookup_indexes: *mut hb_set_t,
    );
}
extern "C" {
    pub fn hb_ot_var_has_data(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_var_get_axis_count(face: *mut hb_face_t) -> ::std::os::raw::c_uint;
}
pub const HB_OT_VAR_AXIS_FLAG_HIDDEN: hb_ot_var_axis_flags_t = 1;
pub const _HB_OT_VAR_AXIS_FLAG_MAX_VALUE: hb_ot_var_axis_flags_t = 2147483647;
/// hb_ot_var_axis_flags_t:
/// @HB_OT_VAR_AXIS_FLAG_HIDDEN: The axis should not be exposed directly in user interfaces.
///
/// Since: 2.2.0
pub type hb_ot_var_axis_flags_t = u32;
/// hb_ot_var_axis_info_t:
///
/// Since: 2.2.0
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_ot_var_axis_info_t {
    pub axis_index: ::std::os::raw::c_uint,
    pub tag: hb_tag_t,
    pub name_id: hb_ot_name_id_t,
    pub flags: hb_ot_var_axis_flags_t,
    pub min_value: ::std::os::raw::c_float,
    pub default_value: ::std::os::raw::c_float,
    pub max_value: ::std::os::raw::c_float,
    pub reserved: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_hb_ot_var_axis_info_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_ot_var_axis_info_t>(),
        32usize,
        concat!("Size of: ", stringify!(hb_ot_var_axis_info_t))
    );
    assert_eq!(
        ::std::mem::align_of::<hb_ot_var_axis_info_t>(),
        4usize,
        concat!("Alignment of ", stringify!(hb_ot_var_axis_info_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_ot_var_axis_info_t>())).axis_index as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_var_axis_info_t),
            "::",
            stringify!(axis_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_var_axis_info_t>())).tag as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_var_axis_info_t),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_var_axis_info_t>())).name_id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_var_axis_info_t),
            "::",
            stringify!(name_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_var_axis_info_t>())).flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_var_axis_info_t),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_var_axis_info_t>())).min_value as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_var_axis_info_t),
            "::",
            stringify!(min_value)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_ot_var_axis_info_t>())).default_value as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_var_axis_info_t),
            "::",
            stringify!(default_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_var_axis_info_t>())).max_value as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_var_axis_info_t),
            "::",
            stringify!(max_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<hb_ot_var_axis_info_t>())).reserved as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_ot_var_axis_info_t),
            "::",
            stringify!(reserved)
        )
    );
}
extern "C" {
    pub fn hb_ot_var_get_axis_infos(
        face: *mut hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        axes_count: *mut ::std::os::raw::c_uint,
        axes_array: *mut hb_ot_var_axis_info_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_var_find_axis_info(
        face: *mut hb_face_t,
        axis_tag: hb_tag_t,
        axis_info: *mut hb_ot_var_axis_info_t,
    ) -> hb_bool_t;
}
extern "C" {
    pub fn hb_ot_var_get_named_instance_count(face: *mut hb_face_t) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_var_named_instance_get_subfamily_name_id(
        face: *mut hb_face_t,
        instance_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
extern "C" {
    pub fn hb_ot_var_named_instance_get_postscript_name_id(
        face: *mut hb_face_t,
        instance_index: ::std::os::raw::c_uint,
    ) -> hb_ot_name_id_t;
}
extern "C" {
    pub fn hb_ot_var_named_instance_get_design_coords(
        face: *mut hb_face_t,
        instance_index: ::std::os::raw::c_uint,
        coords_length: *mut ::std::os::raw::c_uint,
        coords: *mut ::std::os::raw::c_float,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_ot_var_normalize_variations(
        face: *mut hb_face_t,
        variations: *const hb_variation_t,
        variations_length: ::std::os::raw::c_uint,
        coords: *mut ::std::os::raw::c_int,
        coords_length: ::std::os::raw::c_uint,
    );
}
extern "C" {
    pub fn hb_ot_var_normalize_coords(
        face: *mut hb_face_t,
        coords_length: ::std::os::raw::c_uint,
        design_coords: *const ::std::os::raw::c_float,
        normalized_coords: *mut ::std::os::raw::c_int,
    );
}
pub const HB_AAT_LAYOUT_FEATURE_TYPE_INVALID: hb_aat_layout_feature_type_t = 65535;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_ALL_TYPOGRAPHIC: hb_aat_layout_feature_type_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_LIGATURES: hb_aat_layout_feature_type_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CURISVE_CONNECTION: hb_aat_layout_feature_type_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_LETTER_CASE: hb_aat_layout_feature_type_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_SUBSTITUTION: hb_aat_layout_feature_type_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_LINGUISTIC_REARRANGEMENT: hb_aat_layout_feature_type_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_SPACING: hb_aat_layout_feature_type_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_SMART_SWASH_TYPE: hb_aat_layout_feature_type_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_DIACRITICS_TYPE: hb_aat_layout_feature_type_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_VERTICAL_POSITION: hb_aat_layout_feature_type_t = 10;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_FRACTIONS: hb_aat_layout_feature_type_t = 11;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_OVERLAPPING_CHARACTERS_TYPE: hb_aat_layout_feature_type_t = 13;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_TYPOGRAPHIC_EXTRAS: hb_aat_layout_feature_type_t = 14;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_MATHEMATICAL_EXTRAS: hb_aat_layout_feature_type_t = 15;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_ORNAMENT_SETS_TYPE: hb_aat_layout_feature_type_t = 16;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_ALTERNATIVES: hb_aat_layout_feature_type_t = 17;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_DESIGN_COMPLEXITY_TYPE: hb_aat_layout_feature_type_t = 18;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_STYLE_OPTIONS: hb_aat_layout_feature_type_t = 19;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CHARACTER_SHAPE: hb_aat_layout_feature_type_t = 20;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_NUMBER_CASE: hb_aat_layout_feature_type_t = 21;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_TEXT_SPACING: hb_aat_layout_feature_type_t = 22;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_TRANSLITERATION: hb_aat_layout_feature_type_t = 23;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_ANNOTATION_TYPE: hb_aat_layout_feature_type_t = 24;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_KANA_SPACING_TYPE: hb_aat_layout_feature_type_t = 25;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_SPACING_TYPE: hb_aat_layout_feature_type_t = 26;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_UNICODE_DECOMPOSITION_TYPE: hb_aat_layout_feature_type_t = 27;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_RUBY_KANA: hb_aat_layout_feature_type_t = 28;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CJK_SYMBOL_ALTERNATIVES_TYPE: hb_aat_layout_feature_type_t =
    29;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_IDEOGRAPHIC_ALTERNATIVES_TYPE: hb_aat_layout_feature_type_t =
    30;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CJK_VERTICAL_ROMAN_PLACEMENT_TYPE:
    hb_aat_layout_feature_type_t = 31;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_ITALIC_CJK_ROMAN: hb_aat_layout_feature_type_t = 32;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CASE_SENSITIVE_LAYOUT: hb_aat_layout_feature_type_t = 33;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_ALTERNATE_KANA: hb_aat_layout_feature_type_t = 34;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_STYLISTIC_ALTERNATIVES: hb_aat_layout_feature_type_t = 35;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CONTEXTUAL_ALTERNATIVES: hb_aat_layout_feature_type_t = 36;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_LOWER_CASE: hb_aat_layout_feature_type_t = 37;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_UPPER_CASE: hb_aat_layout_feature_type_t = 38;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_LANGUAGE_TAG_TYPE: hb_aat_layout_feature_type_t = 39;
pub const HB_AAT_LAYOUT_FEATURE_TYPE_CJK_ROMAN_SPACING_TYPE: hb_aat_layout_feature_type_t = 103;
pub const _HB_AAT_LAYOUT_FEATURE_TYPE_MAX_VALUE: hb_aat_layout_feature_type_t = 2147483647;
/// hb_aat_layout_feature_type_t:
///
///
/// Since: 2.2.0
pub type hb_aat_layout_feature_type_t = u32;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INVALID: hb_aat_layout_feature_selector_t = 65535;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_ON: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_TYPE_FEATURES_OFF: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_REQUIRED_LIGATURES_OFF: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_COMMON_LIGATURES_OFF: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_ON: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_RARE_LIGATURES_OFF: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LOGOS_ON: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LOGOS_OFF: hb_aat_layout_feature_selector_t = 7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_ON: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_REBUS_PICTURES_OFF: hb_aat_layout_feature_selector_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DIPHTHONG_LIGATURES_OFF: hb_aat_layout_feature_selector_t =
    11;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    12;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SQUARED_LIGATURES_OFF: hb_aat_layout_feature_selector_t =
    13;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_ON:
    hb_aat_layout_feature_selector_t = 14;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ABBREV_SQUARED_LIGATURES_OFF:
    hb_aat_layout_feature_selector_t = 15;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_ON: hb_aat_layout_feature_selector_t = 16;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SYMBOL_LIGATURES_OFF: hb_aat_layout_feature_selector_t =
    17;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    18;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_LIGATURES_OFF:
    hb_aat_layout_feature_selector_t = 19;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    20;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HISTORICAL_LIGATURES_OFF:
    hb_aat_layout_feature_selector_t = 21;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_UNCONNECTED: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PARTIALLY_CONNECTED: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CURSIVE: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_AND_LOWER_CASE: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_CAPS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALL_LOWER_CASE: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SMALL_CAPS: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INITIAL_CAPS_AND_SMALL_CAPS:
    hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_ON:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SUBSTITUTE_VERTICAL_FORMS_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_ON:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINGUISTIC_REARRANGEMENT_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_NUMBERS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_NUMBERS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_NUMBERS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_NUMBERS: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_ON: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_INITIAL_SWASHES_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_ON: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_WORD_FINAL_SWASHES_OFF: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_ON: hb_aat_layout_feature_selector_t =
    4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_INITIAL_SWASHES_OFF:
    hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_ON: hb_aat_layout_feature_selector_t =
    6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LINE_FINAL_SWASHES_OFF: hb_aat_layout_feature_selector_t =
    7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_ON: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NON_FINAL_SWASHES_OFF: hb_aat_layout_feature_selector_t =
    9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SHOW_DIACRITICS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HIDE_DIACRITICS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DECOMPOSE_DIACRITICS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NORMAL_POSITION: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SUPERIORS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INFERIORS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ORDINALS: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SCIENTIFIC_INFERIORS: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_FRACTIONS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_VERTICAL_FRACTIONS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DIAGONAL_FRACTIONS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_ON: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PREVENT_OVERLAP_OFF: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_ON: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHENS_TO_EM_DASH_OFF: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_EN_DASH_OFF: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_ON: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASHED_ZERO_OFF: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_ON: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FORM_INTERROBANG_OFF: hb_aat_layout_feature_selector_t = 7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_ON: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SMART_QUOTES_OFF: hb_aat_layout_feature_selector_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_ON: hb_aat_layout_feature_selector_t =
    10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIODS_TO_ELLIPSIS_OFF: hb_aat_layout_feature_selector_t =
    11;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_ON: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HYPHEN_TO_MINUS_OFF: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_ON: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ASTERISK_TO_MULTIPLY_OFF:
    hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_ON: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SLASH_TO_DIVIDE_OFF: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_ON: hb_aat_layout_feature_selector_t =
    6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INEQUALITY_LIGATURES_OFF:
    hb_aat_layout_feature_selector_t = 7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_ON: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPONENTS_OFF: hb_aat_layout_feature_selector_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_ON: hb_aat_layout_feature_selector_t =
    10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_MATHEMATICAL_GREEK_OFF: hb_aat_layout_feature_selector_t =
    11;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ORNAMENTS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DINGBATS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PI_CHARACTERS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FLEURONS: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DECORATIVE_BORDERS: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INTERNATIONAL_SYMBOLS: hb_aat_layout_feature_selector_t =
    5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_MATH_SYMBOLS: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ALTERNATES: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL1: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL2: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL3: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL4: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DESIGN_LEVEL5: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_STYLE_OPTIONS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DISPLAY_TEXT: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ENGRAVED_TEXT: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ILLUMINATED_CAPS: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TITLING_CAPS: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TALL_CAPS: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_CHARACTERS: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SIMPLIFIED_CHARACTERS: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1978_CHARACTERS: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1983_CHARACTERS: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS1990_CHARACTERS: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_ONE: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_TWO: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_THREE: hb_aat_layout_feature_selector_t =
    7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FOUR: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_ALT_FIVE: hb_aat_layout_feature_selector_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_EXPERT_CHARACTERS: hb_aat_layout_feature_selector_t = 10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_JIS2004_CHARACTERS: hb_aat_layout_feature_selector_t = 11;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HOJO_CHARACTERS: hb_aat_layout_feature_selector_t = 12;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NLCCHARACTERS: hb_aat_layout_feature_selector_t = 13;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRADITIONAL_NAMES_CHARACTERS:
    hb_aat_layout_feature_selector_t = 14;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_NUMBERS: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_NUMBERS: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_TEXT: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_MONOSPACED_TEXT: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_TEXT: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_THIRD_WIDTH_TEXT: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_QUARTER_WIDTH_TEXT: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALT_PROPORTIONAL_TEXT: hb_aat_layout_feature_selector_t =
    5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALT_HALF_WIDTH_TEXT: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_TRANSLITERATION: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HIRAGANA_TO_KATAKANA: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_KATAKANA_TO_HIRAGANA: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_KANA_TO_ROMANIZATION: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_HIRAGANA:
    hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMANIZATION_TO_KATAKANA:
    hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_ONE: hb_aat_layout_feature_selector_t =
    7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_TWO: hb_aat_layout_feature_selector_t =
    8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HANJA_TO_HANGUL_ALT_THREE:
    hb_aat_layout_feature_selector_t = 9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_ANNOTATION: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_BOX_ANNOTATION: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ROUNDED_BOX_ANNOTATION: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CIRCLE_ANNOTATION: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_CIRCLE_ANNOTATION:
    hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PARENTHESIS_ANNOTATION: hb_aat_layout_feature_selector_t =
    5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PERIOD_ANNOTATION: hb_aat_layout_feature_selector_t = 6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ROMAN_NUMERAL_ANNOTATION:
    hb_aat_layout_feature_selector_t = 7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DIAMOND_ANNOTATION: hb_aat_layout_feature_selector_t = 8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_BOX_ANNOTATION: hb_aat_layout_feature_selector_t =
    9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_INVERTED_ROUNDED_BOX_ANNOTATION:
    hb_aat_layout_feature_selector_t = 10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_KANA: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_KANA: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_IDEOGRAPHS: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_IDEOGRAPHS: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_IDEOGRAPHS: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_ON:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CANONICAL_COMPOSITION_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_ON:
    hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_COMPATIBILITY_COMPOSITION_OFF:
    hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_ON:
    hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_TRANSCODING_COMPOSITION_OFF:
    hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_RUBY_KANA: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_RUBY_KANA_OFF: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_CJK_SYMBOL_ALTERNATIVES:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_ONE: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_TWO: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_THREE: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FOUR: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_SYMBOL_ALT_FIVE: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_IDEOGRAPHIC_ALTERNATIVES:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_ONE: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_TWO: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_THREE: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FOUR: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_IDEOGRAPHIC_ALT_FIVE: hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_CENTERED:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_VERTICAL_ROMAN_HBASELINE:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_CJK_ITALIC_ROMAN: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN: hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CJK_ITALIC_ROMAN_OFF: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_ON:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_LAYOUT_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_ON:
    hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CASE_SENSITIVE_SPACING_OFF:
    hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_ON: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_HORIZ_KANA_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_ON: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_ALTERNATE_VERT_KANA_OFF: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_NO_STYLISTIC_ALTERNATES: hb_aat_layout_feature_selector_t =
    0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ONE_OFF: hb_aat_layout_feature_selector_t =
    3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_ON: hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWO_OFF: hb_aat_layout_feature_selector_t =
    5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_ON: hb_aat_layout_feature_selector_t =
    6;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THREE_OFF: hb_aat_layout_feature_selector_t =
    7;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_ON: hb_aat_layout_feature_selector_t =
    8;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOUR_OFF: hb_aat_layout_feature_selector_t =
    9;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_ON: hb_aat_layout_feature_selector_t =
    10;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIVE_OFF: hb_aat_layout_feature_selector_t =
    11;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_ON: hb_aat_layout_feature_selector_t =
    12;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIX_OFF: hb_aat_layout_feature_selector_t =
    13;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_ON: hb_aat_layout_feature_selector_t =
    14;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVEN_OFF: hb_aat_layout_feature_selector_t =
    15;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_ON: hb_aat_layout_feature_selector_t =
    16;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHT_OFF: hb_aat_layout_feature_selector_t =
    17;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_ON: hb_aat_layout_feature_selector_t =
    18;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINE_OFF: hb_aat_layout_feature_selector_t =
    19;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_ON: hb_aat_layout_feature_selector_t =
    20;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TEN_OFF: hb_aat_layout_feature_selector_t =
    21;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_ON: hb_aat_layout_feature_selector_t =
    22;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_ELEVEN_OFF:
    hb_aat_layout_feature_selector_t = 23;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_ON: hb_aat_layout_feature_selector_t =
    24;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWELVE_OFF:
    hb_aat_layout_feature_selector_t = 25;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_ON:
    hb_aat_layout_feature_selector_t = 26;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_THIRTEEN_OFF:
    hb_aat_layout_feature_selector_t = 27;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_ON:
    hb_aat_layout_feature_selector_t = 28;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FOURTEEN_OFF:
    hb_aat_layout_feature_selector_t = 29;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_ON:
    hb_aat_layout_feature_selector_t = 30;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_FIFTEEN_OFF:
    hb_aat_layout_feature_selector_t = 31;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_ON:
    hb_aat_layout_feature_selector_t = 32;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SIXTEEN_OFF:
    hb_aat_layout_feature_selector_t = 33;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_ON:
    hb_aat_layout_feature_selector_t = 34;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_SEVENTEEN_OFF:
    hb_aat_layout_feature_selector_t = 35;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_ON:
    hb_aat_layout_feature_selector_t = 36;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_EIGHTEEN_OFF:
    hb_aat_layout_feature_selector_t = 37;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_ON:
    hb_aat_layout_feature_selector_t = 38;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_NINETEEN_OFF:
    hb_aat_layout_feature_selector_t = 39;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_ON: hb_aat_layout_feature_selector_t =
    40;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_STYLISTIC_ALT_TWENTY_OFF:
    hb_aat_layout_feature_selector_t = 41;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_ON:
    hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_ALTERNATES_OFF:
    hb_aat_layout_feature_selector_t = 1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_ON: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_SWASH_ALTERNATES_OFF: hb_aat_layout_feature_selector_t = 3;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_ON:
    hb_aat_layout_feature_selector_t = 4;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_CONTEXTUAL_SWASH_ALTERNATES_OFF:
    hb_aat_layout_feature_selector_t = 5;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_LOWER_CASE: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_SMALL_CAPS: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_LOWER_CASE_PETITE_CAPS: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_UPPER_CASE: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_SMALL_CAPS: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_UPPER_CASE_PETITE_CAPS: hb_aat_layout_feature_selector_t =
    2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_HALF_WIDTH_CJK_ROMAN: hb_aat_layout_feature_selector_t = 0;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_PROPORTIONAL_CJK_ROMAN: hb_aat_layout_feature_selector_t =
    1;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_DEFAULT_CJK_ROMAN: hb_aat_layout_feature_selector_t = 2;
pub const HB_AAT_LAYOUT_FEATURE_SELECTOR_FULL_WIDTH_CJK_ROMAN: hb_aat_layout_feature_selector_t = 3;
pub const _HB_AAT_LAYOUT_FEATURE_SELECTOR_MAX_VALUE: hb_aat_layout_feature_selector_t = 2147483647;
/// hb_aat_layout_feature_selector_t:
///
///
/// Since: 2.2.0
pub type hb_aat_layout_feature_selector_t = u32;
extern "C" {
    pub fn hb_aat_layout_get_feature_types(
        face: *mut hb_face_t,
        start_offset: ::std::os::raw::c_uint,
        feature_count: *mut ::std::os::raw::c_uint,
        features: *mut hb_aat_layout_feature_type_t,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_aat_layout_feature_type_get_name_id(
        face: *mut hb_face_t,
        feature_type: hb_aat_layout_feature_type_t,
    ) -> hb_ot_name_id_t;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hb_aat_layout_feature_selector_info_t {
    pub name_id: hb_ot_name_id_t,
    pub enable: hb_aat_layout_feature_selector_t,
    pub disable: hb_aat_layout_feature_selector_t,
    pub reserved: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_hb_aat_layout_feature_selector_info_t() {
    assert_eq!(
        ::std::mem::size_of::<hb_aat_layout_feature_selector_info_t>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(hb_aat_layout_feature_selector_info_t)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<hb_aat_layout_feature_selector_info_t>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(hb_aat_layout_feature_selector_info_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_aat_layout_feature_selector_info_t>())).name_id as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_aat_layout_feature_selector_info_t),
            "::",
            stringify!(name_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_aat_layout_feature_selector_info_t>())).enable as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_aat_layout_feature_selector_info_t),
            "::",
            stringify!(enable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_aat_layout_feature_selector_info_t>())).disable as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_aat_layout_feature_selector_info_t),
            "::",
            stringify!(disable)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<hb_aat_layout_feature_selector_info_t>())).reserved as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(hb_aat_layout_feature_selector_info_t),
            "::",
            stringify!(reserved)
        )
    );
}
extern "C" {
    pub fn hb_aat_layout_feature_type_get_selector_infos(
        face: *mut hb_face_t,
        feature_type: hb_aat_layout_feature_type_t,
        start_offset: ::std::os::raw::c_uint,
        selector_count: *mut ::std::os::raw::c_uint,
        selectors: *mut hb_aat_layout_feature_selector_info_t,
        default_index: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn hb_aat_layout_has_substitution(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_aat_layout_has_positioning(face: *mut hb_face_t) -> hb_bool_t;
}
extern "C" {
    pub fn hb_aat_layout_has_tracking(face: *mut hb_face_t) -> hb_bool_t;
}
