#ifndef _RE2C_RE_RULE_
#define _RE2C_RE_RULE_

#include <stddef.h>
#include <stdint.h>
#include <limits>
#include <set>
#include <string>

#include "src/msg/location.h"

namespace re2c {

// semantic action (user-defined code for rule)
struct SemAct {
    loc_t loc;
    const char* text; // the actual text of the action
    const char* cond; // condition where to jump after executing this action
    bool autogen;     // if this is an autogenerated jump to another condition (using `:=>`)

    // used for reachability analysis of <*> rules
    mutable bool is_star; // if this action comes from <*> condition
    mutable bool is_used; // if this action is reachable in some condition
};

struct Rule {
    static constexpr size_t NONE = std::numeric_limits<size_t>::max();

    const SemAct* semact;
    std::set<const Rule*> shadow;
    size_t ltag; // first tag
    size_t htag; // next to last tag
    size_t ttag; // trailing context
    size_t ncap; // number of POSIX captures
    bool is_oldstyle_eof; // standalone end-of-input rule `$ { ... }`

    Rule();
    ~Rule() {}
    Rule(const Rule& r) = default;
    Rule& operator=(const Rule& r) = default;
    Rule(Rule&& r) = default;
    Rule& operator=(Rule&& r) = default;
};

inline Rule::Rule()
    : semact(nullptr)
    , shadow()
    , ltag(0)
    , htag(0)
    , ttag(0)
    , ncap(0)
    , is_oldstyle_eof(false)
{}

} // namespace re2c

#endif // _RE2C_RE_RULE_
