% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{bidirection}
\alias{bidirection}
\alias{has_flipped_aes}
\alias{flip_data}
\alias{flipped_names}
\title{Utilities for working with bidirectional layers}
\usage{
has_flipped_aes(
  data,
  params = list(),
  main_is_orthogonal = NA,
  range_is_orthogonal = NA,
  group_has_equal = FALSE,
  ambiguous = FALSE,
  main_is_continuous = FALSE,
  main_is_optional = FALSE
)

flip_data(data, flip = NULL)

flipped_names(flip = FALSE)
}
\arguments{
\item{data}{The layer data}

\item{params}{The parameters of the \code{Stat}/\code{Geom}. Only the \code{orientation}
parameter will be used.}

\item{main_is_orthogonal}{If only \code{x} or \code{y} are present do they correspond
to the main orientation or the reverse. E.g. If \code{TRUE} and \code{y} is present
it is not flipped. If \code{NA} this check will be ignored.}

\item{range_is_orthogonal}{If \code{xmin}/\code{xmax} or \code{ymin}/\code{ymax} is present do
they correspond to the main orientation or reverse. If \code{NA} this check will
be ignored.}

\item{group_has_equal}{Is it expected that grouped data has either a single
\code{x} or \code{y} value that will correspond to the orientation.}

\item{ambiguous}{Is the layer ambiguous in its mapping by nature. If so, it
will only be flipped if \code{params$orientation == "y"}}

\item{main_is_continuous}{If there is a discrete and continuous axis, does
the continuous one correspond to the main orientation?}

\item{main_is_optional}{Is the main axis aesthetic optional and, if not
given, set to \code{0}}

\item{flip}{Logical. Is the layer flipped.}
}
\value{
\code{has_flipped_aes()} returns \code{TRUE} if it detects a layer in the other
orientation and \code{FALSE} otherwise. \code{flip_data()} will return the input
unchanged if \code{flip = FALSE} and the data with flipped aesthetic names if
\code{flip = TRUE}. \code{flipped_names()} returns a named list of strings. If
\code{flip = FALSE} the name of the element will correspond to the element, e.g.
\code{flipped_names(FALSE)$x == "x"} and if \code{flip = TRUE} it will correspond to
the flipped name, e.g. \code{flipped_names(FALSE)$x == "y"}
}
\description{
These functions are what underpins the ability of certain geoms to work
automatically in both directions. See the \emph{Extending ggplot2} vignette for
how they are used when implementing \code{Geom}, \code{Stat}, and \code{Position} classes.
}
\details{
\code{has_flipped_aes()} is used to sniff out the orientation of the layer from
the data. It has a range of arguments that can be used to finetune the
sniffing based on what the data should look like. \code{flip_data()} will switch
the column names of the data so that it looks like x-oriented data.
\code{flipped_names()} provides a named list of aesthetic names that corresponds
to the orientation of the layer.
}
\section{Controlling the sniffing}{

How the layer data should be interpreted depends on its specific features.
\code{has_flipped_aes()} contains a range of flags for defining what certain
features in the data correspond to:
\itemize{
\item \code{main_is_orthogonal}: This argument controls how the existence of only a \code{x}
or \code{y} aesthetic is understood. If \code{TRUE} then the existing aesthetic
would be then secondary axis. This behaviour is present in \code{\link[=stat_ydensity]{stat_ydensity()}}
and \code{\link[=stat_boxplot]{stat_boxplot()}}. If \code{FALSE} then the existing aesthetic is the main
axis as seen in e.g. \code{\link[=stat_bin]{stat_bin()}}, \code{\link[=geom_count]{geom_count()}}, and \code{\link[=stat_density]{stat_density()}}.
\item \code{range_is_orthogonal}: This argument controls whether the existence of
range-like aesthetics (e.g. \code{xmin} and \code{xmax}) represents the main or
secondary axis. If \code{TRUE} then the range is given for the secondary axis as
seen in e.g. \code{\link[=geom_ribbon]{geom_ribbon()}} and \code{\link[=geom_linerange]{geom_linerange()}}.
\item \code{group_has_equal}: This argument controls whether to test for equality of
all \code{x} and \code{y} values inside each group and set the main axis to the one
where all is equal. This test is only performed if \code{TRUE}, and only after
less computationally heavy tests has come up empty handed. Examples are
\code{\link[=stat_boxplot]{stat_boxplot()}} and \link{stat_ydensity}
\item \code{ambiguous}: This argument tells the function that the layer, while
bidirectional, doesn't treat each axis differently. It will circumvent any
data based guessing and only take hint from the \code{orientation} element in
\code{params}. If this is not present it will fall back to \code{FALSE}. Examples are
\code{\link[=geom_line]{geom_line()}} and \code{\link[=geom_area]{geom_area()}}
\item \code{main_is_continuous}: This argument controls how the test for discreteness
in the scales should be interpreted. If \code{TRUE} then the main axis will be
the one which is not discrete-like. Conversely, if \code{FALSE} the main axis
will be the discrete-like one. Examples of \code{TRUE} is \code{\link[=stat_density]{stat_density()}} and
\code{\link[=stat_bin]{stat_bin()}}, while examples of \code{FALSE} is \code{\link[=stat_ydensity]{stat_ydensity()}} and
\code{\link[=stat_boxplot]{stat_boxplot()}}
\item \code{main_is_optional}: This argument controls the rare case of layers were the
main direction is an optional aesthetic. This is only seen in
\code{\link[=stat_boxplot]{stat_boxplot()}} where \code{x} is set to \code{0} if not given. If \code{TRUE} there will
be a check for whether all \code{x} or all \code{y} are equal to \code{0}
}
}

\keyword{internal}
