# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class AdditionalCacheNodeProperties(_Model):
    """Model representing cache node for connected cache resource.

    :ivar cache_node_properties_details_issues_list: issues list to return the issues as part of
     the additional cache node properties.
    :vartype cache_node_properties_details_issues_list: list[str]
    :ivar issues_list: current cache node issue list.
    :vartype issues_list: list[str]
    :ivar issues_count: Number of cache node issues.
    :vartype issues_count: int
    :ivar current_tls_certificate: cache node current tls certificate.
    :vartype current_tls_certificate: ~azure.mgmt.connectedcache.models.MccCacheNodeTlsCertificate
    :ivar last_auto_update_info: cache node last auto update information.
    :vartype last_auto_update_info: ~azure.mgmt.connectedcache.models.MccCacheNodeAutoUpdateInfo
    :ivar aggregated_status_details: Cache node resource aggregated status details.
    :vartype aggregated_status_details: str
    :ivar aggregated_status_text: Cache node resource aggregated status text.
    :vartype aggregated_status_text: str
    :ivar aggregated_status_code: Cache node resource aggregated status code.
    :vartype aggregated_status_code: int
    :ivar product_version: Cache node resource Mcc product version.
    :vartype product_version: str
    :ivar is_provisioned: Cache node resource flag indicating if cache node has been physically
     installed or provisioned on their physical lab.
    :vartype is_provisioned: bool
    :ivar cache_node_state_detailed_text: Cache node resource detailed state text.
    :vartype cache_node_state_detailed_text: str
    :ivar cache_node_state_short_text: Cache node resource short state text.
    :vartype cache_node_state_short_text: str
    :ivar cache_node_state: Cache node resource state as integer.
    :vartype cache_node_state: int
    :ivar drive_configuration: Cache node resource drive configurations.
    :vartype drive_configuration:
     list[~azure.mgmt.connectedcache.models.CacheNodeDriveConfiguration]
    :ivar bgp_configuration: Cache node resource Bgp configuration.
    :vartype bgp_configuration: ~azure.mgmt.connectedcache.models.BgpConfiguration
    :ivar proxy_url_configuration: proxyUrl configuration of the cache node.
    :vartype proxy_url_configuration: ~azure.mgmt.connectedcache.models.ProxyUrlConfiguration
    :ivar is_proxy_required: Cache node resource requires a proxy. Known values are: "None" and
     "Required".
    :vartype is_proxy_required: str or ~azure.mgmt.connectedcache.models.ProxyRequired
    :ivar os_type: Operating system of the cache node. Known values are: "Windows", "Linux", and
     "Eflow".
    :vartype os_type: str or ~azure.mgmt.connectedcache.models.OsType
    :ivar auto_update_version: Auto update or fast update version.
    :vartype auto_update_version: str
    :ivar update_info_details: Update related information details.
    :vartype update_info_details: str
    :ivar update_requested_date_time: customer requested date time for mcc install of update cycle.
    :vartype update_requested_date_time: ~datetime.datetime
    :ivar auto_update_next_available_version: Auto update version that is the Next available
     version to update on mcc cache node.
    :vartype auto_update_next_available_version: str
    :ivar auto_update_next_available_date_time: Auto update last applied date time of mcc install.
    :vartype auto_update_next_available_date_time: ~datetime.datetime
    :ivar auto_update_applied_version: Auto update version that is the applied to update on mcc
     cache node.
    :vartype auto_update_applied_version: str
    :ivar auto_update_last_applied_details: Auto Update status details from the backend after
     applying the new version details.
    :vartype auto_update_last_applied_details: str
    :ivar auto_update_last_applied_state: Last applied auto update state for mcc install of auto
     update cycle.
    :vartype auto_update_last_applied_state: str
    :ivar auto_update_last_applied_date_time: Auto update last applied date time of mcc install.
    :vartype auto_update_last_applied_date_time: ~datetime.datetime
    :ivar auto_update_last_triggered_date_time: Auto update last triggered date time of mcc
     install.
    :vartype auto_update_last_triggered_date_time: ~datetime.datetime
    :ivar creation_method: Resource creation method of mcc cache node resource, cli or portal.
    :vartype creation_method: int
    :ivar tls_status: Cache node tls certificate status.
    :vartype tls_status: str
    :ivar optional_property1: Optional property #1 of Mcc response object.
    :vartype optional_property1: str
    :ivar optional_property2: Optional property #2 of Mcc response object.
    :vartype optional_property2: str
    :ivar optional_property3: Optional property #3 of Mcc response object.
    :vartype optional_property3: str
    :ivar optional_property4: Optional property #4 of Mcc response object.
    :vartype optional_property4: str
    :ivar optional_property5: Optional property #5 of Mcc response object.
    :vartype optional_property5: str
    """

    cache_node_properties_details_issues_list: Optional[list[str]] = rest_field(
        name="cacheNodePropertiesDetailsIssuesList", visibility=["read", "create", "update", "delete", "query"]
    )
    """issues list to return the issues as part of the additional cache node properties."""
    issues_list: Optional[list[str]] = rest_field(name="issuesList", visibility=["read"])
    """current cache node issue list."""
    issues_count: Optional[int] = rest_field(name="issuesCount", visibility=["read"])
    """Number of cache node issues."""
    current_tls_certificate: Optional["_models.MccCacheNodeTlsCertificate"] = rest_field(
        name="currentTlsCertificate", visibility=["read"]
    )
    """cache node current tls certificate."""
    last_auto_update_info: Optional["_models.MccCacheNodeAutoUpdateInfo"] = rest_field(
        name="lastAutoUpdateInfo", visibility=["read"]
    )
    """cache node last auto update information."""
    aggregated_status_details: Optional[str] = rest_field(name="aggregatedStatusDetails", visibility=["read"])
    """Cache node resource aggregated status details."""
    aggregated_status_text: Optional[str] = rest_field(name="aggregatedStatusText", visibility=["read"])
    """Cache node resource aggregated status text."""
    aggregated_status_code: Optional[int] = rest_field(name="aggregatedStatusCode", visibility=["read"])
    """Cache node resource aggregated status code."""
    product_version: Optional[str] = rest_field(name="productVersion", visibility=["read"])
    """Cache node resource Mcc product version."""
    is_provisioned: Optional[bool] = rest_field(name="isProvisioned", visibility=["read"])
    """Cache node resource flag indicating if cache node has been physically installed or provisioned
     on their physical lab."""
    cache_node_state_detailed_text: Optional[str] = rest_field(name="cacheNodeStateDetailedText", visibility=["read"])
    """Cache node resource detailed state text."""
    cache_node_state_short_text: Optional[str] = rest_field(name="cacheNodeStateShortText", visibility=["read"])
    """Cache node resource short state text."""
    cache_node_state: Optional[int] = rest_field(name="cacheNodeState", visibility=["read"])
    """Cache node resource state as integer."""
    drive_configuration: Optional[list["_models.CacheNodeDriveConfiguration"]] = rest_field(
        name="driveConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource drive configurations."""
    bgp_configuration: Optional["_models.BgpConfiguration"] = rest_field(
        name="bgpConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource Bgp configuration."""
    proxy_url_configuration: Optional["_models.ProxyUrlConfiguration"] = rest_field(
        name="proxyUrlConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """proxyUrl configuration of the cache node."""
    is_proxy_required: Optional[Union[str, "_models.ProxyRequired"]] = rest_field(
        name="isProxyRequired", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource requires a proxy. Known values are: \"None\" and \"Required\"."""
    os_type: Optional[Union[str, "_models.OsType"]] = rest_field(
        name="osType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Operating system of the cache node. Known values are: \"Windows\", \"Linux\", and \"Eflow\"."""
    auto_update_version: Optional[str] = rest_field(
        name="autoUpdateVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Auto update or fast update version."""
    update_info_details: Optional[str] = rest_field(
        name="updateInfoDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Update related information details."""
    update_requested_date_time: Optional[datetime.datetime] = rest_field(
        name="updateRequestedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """customer requested date time for mcc install of update cycle."""
    auto_update_next_available_version: Optional[str] = rest_field(
        name="autoUpdateNextAvailableVersion", visibility=["read"]
    )
    """Auto update version that is the Next available version to update on mcc cache node."""
    auto_update_next_available_date_time: Optional[datetime.datetime] = rest_field(
        name="autoUpdateNextAvailableDateTime", visibility=["read"], format="rfc3339"
    )
    """Auto update last applied date time of mcc install."""
    auto_update_applied_version: Optional[str] = rest_field(name="autoUpdateAppliedVersion", visibility=["read"])
    """Auto update version that is the applied to update on mcc cache node."""
    auto_update_last_applied_details: Optional[str] = rest_field(
        name="autoUpdateLastAppliedDetails", visibility=["read"]
    )
    """Auto Update status details from the backend after applying the new version details."""
    auto_update_last_applied_state: Optional[str] = rest_field(name="autoUpdateLastAppliedState", visibility=["read"])
    """Last applied auto update state for mcc install of auto update cycle."""
    auto_update_last_applied_date_time: Optional[datetime.datetime] = rest_field(
        name="autoUpdateLastAppliedDateTime", visibility=["read"], format="rfc3339"
    )
    """Auto update last applied date time of mcc install."""
    auto_update_last_triggered_date_time: Optional[datetime.datetime] = rest_field(
        name="autoUpdateLastTriggeredDateTime", visibility=["read"], format="rfc3339"
    )
    """Auto update last triggered date time of mcc install."""
    creation_method: Optional[int] = rest_field(
        name="creationMethod", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource creation method of mcc cache node resource, cli or portal."""
    tls_status: Optional[str] = rest_field(name="tlsStatus", visibility=["read"])
    """Cache node tls certificate status."""
    optional_property1: Optional[str] = rest_field(
        name="optionalProperty1", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property #1 of Mcc response object."""
    optional_property2: Optional[str] = rest_field(
        name="optionalProperty2", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property #2 of Mcc response object."""
    optional_property3: Optional[str] = rest_field(
        name="optionalProperty3", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property #3 of Mcc response object."""
    optional_property4: Optional[str] = rest_field(
        name="optionalProperty4", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property #4 of Mcc response object."""
    optional_property5: Optional[str] = rest_field(
        name="optionalProperty5", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property #5 of Mcc response object."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        cache_node_properties_details_issues_list: Optional[list[str]] = None,
        drive_configuration: Optional[list["_models.CacheNodeDriveConfiguration"]] = None,
        bgp_configuration: Optional["_models.BgpConfiguration"] = None,
        proxy_url_configuration: Optional["_models.ProxyUrlConfiguration"] = None,
        is_proxy_required: Optional[Union[str, "_models.ProxyRequired"]] = None,
        os_type: Optional[Union[str, "_models.OsType"]] = None,
        auto_update_version: Optional[str] = None,
        update_info_details: Optional[str] = None,
        update_requested_date_time: Optional[datetime.datetime] = None,
        creation_method: Optional[int] = None,
        optional_property1: Optional[str] = None,
        optional_property2: Optional[str] = None,
        optional_property3: Optional[str] = None,
        optional_property4: Optional[str] = None,
        optional_property5: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AdditionalCustomerProperties(_Model):
    """Model representing customer for connected cache resource.

    :ivar customer_properties_overview_cache_efficiency: Customer resource cache efficiency.
    :vartype customer_properties_overview_cache_efficiency: float
    :ivar customer_properties_overview_average_egress_mbps: Customer resource average egress in
     Mbps.
    :vartype customer_properties_overview_average_egress_mbps: float
    :ivar customer_properties_overview_average_miss_mbps: Customer resource average cache miss
     throughput in Mbps.
    :vartype customer_properties_overview_average_miss_mbps: float
    :ivar customer_properties_overview_egress_mbps_max: Customer resource maximum egress in Mbps.
    :vartype customer_properties_overview_egress_mbps_max: float
    :ivar customer_properties_overview_egress_mbps_max_date_time: Customer resource peak egress
     timestamp.
    :vartype customer_properties_overview_egress_mbps_max_date_time: ~datetime.datetime
    :ivar customer_properties_overview_miss_mbps_max: Customer resource maximum cache miss
     throughput in Mbps.
    :vartype customer_properties_overview_miss_mbps_max: float
    :ivar customer_properties_overview_miss_mbps_max_date_time: Customer resource peak cache miss
     throughput timestamp.
    :vartype customer_properties_overview_miss_mbps_max_date_time: ~datetime.datetime
    :ivar customer_properties_overview_cache_nodes_healthy_count: Customer resource total healthy
     cache nodes.
    :vartype customer_properties_overview_cache_nodes_healthy_count: int
    :ivar customer_properties_overview_cache_nodes_unhealthy_count: Customer resource total
     unhealthy cache nodes.
    :vartype customer_properties_overview_cache_nodes_unhealthy_count: int
    :ivar signup_status: Customer resource signup status as boolean.
    :vartype signup_status: bool
    :ivar signup_status_code: Customer resource signup status as integer code.
    :vartype signup_status_code: int
    :ivar signup_status_text: Customer resource signup status as string text.
    :vartype signup_status_text: str
    :ivar signup_phase_status_code: Customer resource signup phase status code as integer.
    :vartype signup_phase_status_code: int
    :ivar signup_phase_status_text: Customer resource signup phase status as string text.
    :vartype signup_phase_status_text: str
    :ivar peering_db_last_update_date: Customer resource last PeeringDB update timestamp.
    :vartype peering_db_last_update_date: ~datetime.datetime
    :ivar customer_org_name: Customer resource owner organization name.
    :vartype customer_org_name: str
    :ivar customer_email: Customer resource contact email.
    :vartype customer_email: str
    :ivar customer_transit_asn: Customer resource transit Asn (autonomous system number).
    :vartype customer_transit_asn: str
    :ivar customer_transit_state: Customer resource transit state. Known values are: "NoTransit",
     "CombinedTransit", and "TransitOnly".
    :vartype customer_transit_state: str or ~azure.mgmt.connectedcache.models.CustomerTransitState
    :ivar customer_asn: Customer resource Asn (autonomous system number).
    :vartype customer_asn: str
    :ivar customer_asn_estimated_egress_peek_gbps: Customer resource estimated Asn peering peak in
     Gbps.
    :vartype customer_asn_estimated_egress_peek_gbps: float
    :ivar customer_entitlement_sku_id: Customer resource entitlement Sku Id.
    :vartype customer_entitlement_sku_id: str
    :ivar customer_entitlement_sku_guid: Customer resource entitlement Sku Guid.
    :vartype customer_entitlement_sku_guid: str
    :ivar customer_entitlement_sku_name: Customer resource entitlement Sku name.
    :vartype customer_entitlement_sku_name: str
    :ivar customer_entitlement_expiration: Customer resource entitlement expiration date string.
    :vartype customer_entitlement_expiration: ~datetime.datetime
    :ivar optional_property1: Optional property #1 of Mcc response object.
    :vartype optional_property1: str
    :ivar optional_property2: Optional property #2 of Mcc response object.
    :vartype optional_property2: str
    :ivar optional_property3: Optional property #3 of Mcc response object.
    :vartype optional_property3: str
    :ivar optional_property4: Optional property #4 of Mcc response object.
    :vartype optional_property4: str
    :ivar optional_property5: Optional property #5 of Mcc response object.
    :vartype optional_property5: str
    """

    customer_properties_overview_cache_efficiency: Optional[float] = rest_field(
        name="customerPropertiesOverviewCacheEfficiency", visibility=["read"]
    )
    """Customer resource cache efficiency."""
    customer_properties_overview_average_egress_mbps: Optional[float] = rest_field(
        name="customerPropertiesOverviewAverageEgressMbps", visibility=["read"]
    )
    """Customer resource average egress in Mbps."""
    customer_properties_overview_average_miss_mbps: Optional[float] = rest_field(
        name="customerPropertiesOverviewAverageMissMbps", visibility=["read"]
    )
    """Customer resource average cache miss throughput in Mbps."""
    customer_properties_overview_egress_mbps_max: Optional[float] = rest_field(
        name="customerPropertiesOverviewEgressMbpsMax", visibility=["read"]
    )
    """Customer resource maximum egress in Mbps."""
    customer_properties_overview_egress_mbps_max_date_time: Optional[datetime.datetime] = rest_field(
        name="customerPropertiesOverviewEgressMbpsMaxDateTime", visibility=["read"], format="rfc3339"
    )
    """Customer resource peak egress timestamp."""
    customer_properties_overview_miss_mbps_max: Optional[float] = rest_field(
        name="customerPropertiesOverviewMissMbpsMax", visibility=["read"]
    )
    """Customer resource maximum cache miss throughput in Mbps."""
    customer_properties_overview_miss_mbps_max_date_time: Optional[datetime.datetime] = rest_field(
        name="customerPropertiesOverviewMissMbpsMaxDateTime", visibility=["read"], format="rfc3339"
    )
    """Customer resource peak cache miss throughput timestamp."""
    customer_properties_overview_cache_nodes_healthy_count: Optional[int] = rest_field(
        name="customerPropertiesOverviewCacheNodesHealthyCount", visibility=["read"]
    )
    """Customer resource total healthy cache nodes."""
    customer_properties_overview_cache_nodes_unhealthy_count: Optional[int] = rest_field(
        name="customerPropertiesOverviewCacheNodesUnhealthyCount", visibility=["read"]
    )
    """Customer resource total unhealthy cache nodes."""
    signup_status: Optional[bool] = rest_field(name="signupStatus", visibility=["read"])
    """Customer resource signup status as boolean."""
    signup_status_code: Optional[int] = rest_field(name="signupStatusCode", visibility=["read"])
    """Customer resource signup status as integer code."""
    signup_status_text: Optional[str] = rest_field(name="signupStatusText", visibility=["read"])
    """Customer resource signup status as string text."""
    signup_phase_status_code: Optional[int] = rest_field(name="signupPhaseStatusCode", visibility=["read"])
    """Customer resource signup phase status code as integer."""
    signup_phase_status_text: Optional[str] = rest_field(name="signupPhaseStatusText", visibility=["read"])
    """Customer resource signup phase status as string text."""
    peering_db_last_update_date: Optional[datetime.datetime] = rest_field(
        name="peeringDbLastUpdateDate", visibility=["read"], format="rfc3339"
    )
    """Customer resource last PeeringDB update timestamp."""
    customer_org_name: Optional[str] = rest_field(name="customerOrgName", visibility=["read"])
    """Customer resource owner organization name."""
    customer_email: Optional[str] = rest_field(
        name="customerEmail", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource contact email."""
    customer_transit_asn: Optional[str] = rest_field(
        name="customerTransitAsn", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource transit Asn (autonomous system number)."""
    customer_transit_state: Optional[Union[str, "_models.CustomerTransitState"]] = rest_field(
        name="customerTransitState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource transit state. Known values are: \"NoTransit\", \"CombinedTransit\", and
     \"TransitOnly\"."""
    customer_asn: Optional[str] = rest_field(
        name="customerAsn", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource Asn (autonomous system number)."""
    customer_asn_estimated_egress_peek_gbps: Optional[float] = rest_field(
        name="customerAsnEstimatedEgressPeekGbps", visibility=["read"]
    )
    """Customer resource estimated Asn peering peak in Gbps."""
    customer_entitlement_sku_id: Optional[str] = rest_field(
        name="customerEntitlementSkuId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource entitlement Sku Id."""
    customer_entitlement_sku_guid: Optional[str] = rest_field(
        name="customerEntitlementSkuGuid", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource entitlement Sku Guid."""
    customer_entitlement_sku_name: Optional[str] = rest_field(
        name="customerEntitlementSkuName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource entitlement Sku name."""
    customer_entitlement_expiration: Optional[datetime.datetime] = rest_field(
        name="customerEntitlementExpiration",
        visibility=["read", "create", "update", "delete", "query"],
        format="rfc3339",
    )
    """Customer resource entitlement expiration date string."""
    optional_property1: Optional[str] = rest_field(
        name="optionalProperty1", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property #1 of Mcc response object."""
    optional_property2: Optional[str] = rest_field(
        name="optionalProperty2", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property #2 of Mcc response object."""
    optional_property3: Optional[str] = rest_field(
        name="optionalProperty3", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property #3 of Mcc response object."""
    optional_property4: Optional[str] = rest_field(
        name="optionalProperty4", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property #4 of Mcc response object."""
    optional_property5: Optional[str] = rest_field(
        name="optionalProperty5", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional property #5 of Mcc response object."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        customer_email: Optional[str] = None,
        customer_transit_asn: Optional[str] = None,
        customer_transit_state: Optional[Union[str, "_models.CustomerTransitState"]] = None,
        customer_asn: Optional[str] = None,
        customer_entitlement_sku_id: Optional[str] = None,
        customer_entitlement_sku_guid: Optional[str] = None,
        customer_entitlement_sku_name: Optional[str] = None,
        customer_entitlement_expiration: Optional[datetime.datetime] = None,
        optional_property1: Optional[str] = None,
        optional_property2: Optional[str] = None,
        optional_property3: Optional[str] = None,
        optional_property4: Optional[str] = None,
        optional_property5: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BgpCidrsConfiguration(_Model):
    """Mcc cache node Bgp Cidr details.

    :ivar bgp_cidrs: Mcc cache node Bgp Cidr details.
    :vartype bgp_cidrs: list[str]
    """

    bgp_cidrs: Optional[list[str]] = rest_field(name="bgpCidrs", visibility=["read"])
    """Mcc cache node Bgp Cidr details."""


class BgpConfiguration(_Model):
    """Bgp configuration of cache node.

    :ivar asn_to_ip_address_mapping: Asn to ip address mapping.
    :vartype asn_to_ip_address_mapping: str
    """

    asn_to_ip_address_mapping: Optional[str] = rest_field(
        name="asnToIpAddressMapping", visibility=["read", "create", "update", "delete", "query"]
    )
    """Asn to ip address mapping."""

    @overload
    def __init__(
        self,
        *,
        asn_to_ip_address_mapping: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CacheNodeDriveConfiguration(_Model):
    """Drive configuration for cache node.

    :ivar physical_path: physical path location of the folder used for caching content.
    :vartype physical_path: str
    :ivar size_in_gb: physical size of the drive used for caching content.
    :vartype size_in_gb: int
    :ivar cache_number: corresponding nginx cache number. Valid cache numbers are 1 - 20.
    :vartype cache_number: int
    :ivar nginx_mapping: full binding for corresponding nginx cache drive.
    :vartype nginx_mapping: str
    """

    physical_path: Optional[str] = rest_field(
        name="physicalPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """physical path location of the folder used for caching content."""
    size_in_gb: Optional[int] = rest_field(name="sizeInGb", visibility=["read", "create", "update", "delete", "query"])
    """physical size of the drive used for caching content."""
    cache_number: Optional[int] = rest_field(
        name="cacheNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """corresponding nginx cache number. Valid cache numbers are 1 - 20."""
    nginx_mapping: Optional[str] = rest_field(
        name="nginxMapping", visibility=["read", "create", "update", "delete", "query"]
    )
    """full binding for corresponding nginx cache drive."""

    @overload
    def __init__(
        self,
        *,
        physical_path: Optional[str] = None,
        size_in_gb: Optional[int] = None,
        cache_number: Optional[int] = None,
        nginx_mapping: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CacheNodeEntity(_Model):
    """Model representing Cache Node for ConnectedCache resource.

    :ivar fully_qualified_resource_id: Cache node resource Azure fully qualified resource Id.
    :vartype fully_qualified_resource_id: str
    :ivar customer_id: Cache node resource customer resource GUID Id.
    :vartype customer_id: str
    :ivar customer_name: Cache node resource customer resource name.
    :vartype customer_name: str
    :ivar ip_address: Cache node resource Ip address.
    :vartype ip_address: str
    :ivar customer_index: Cache node resource customer index as string.
    :vartype customer_index: str
    :ivar cache_node_id: Cache node resource identifier of the cache node.
    :vartype cache_node_id: str
    :ivar cache_node_name: Cache node resource name.
    :vartype cache_node_name: str
    :ivar customer_asn: Cache node resource customer resource Asn (autonomous system number).
    :vartype customer_asn: int
    :ivar is_enabled: Cache node resource flag for indicating if cache node is enabled.
    :vartype is_enabled: bool
    :ivar max_allowable_egress_in_mbps: Cache node resource maximum allowed egress in Mbps.
    :vartype max_allowable_egress_in_mbps: int
    :ivar max_allowable_probability: Cache node resource maximum allowed probability of egress.
    :vartype max_allowable_probability: float
    :ivar x_cid: Cache node resource Azure XCid.
    :vartype x_cid: str
    :ivar is_enterprise_managed: Cache node resource flag for determining if managed by enterprise
     as boolean.
    :vartype is_enterprise_managed: bool
    :ivar create_async_operation_id: Cache node resource create async operation Id.
    :vartype create_async_operation_id: str
    :ivar delete_async_operation_id: Cache node resource deletion async operation Id.
    :vartype delete_async_operation_id: str
    :ivar client_tenant_id: Cache node resource customer resource client tenant Id of subscription.
    :vartype client_tenant_id: str
    :ivar category: Cache node resource category.
    :vartype category: str
    :ivar release_version: Cache node resource release version.
    :vartype release_version: int
    :ivar last_sync_with_azure_timestamp: Cache node resource last sync timestamp.
    :vartype last_sync_with_azure_timestamp: ~datetime.datetime
    :ivar last_updated_timestamp: Cache node resource last backend updated timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    :ivar synch_with_azure_attempts_count: Cache node resource attempts to sync with Azure.
    :vartype synch_with_azure_attempts_count: int
    :ivar container_configurations: Cache node resource container configuration details.
    :vartype container_configurations: str
    :ivar cidr_csv: Cache node resource comma separated values of Cidrs.
    :vartype cidr_csv: list[str]
    :ivar cidr_csv_last_update_time: Cache node resource last Cidr Csv update timestamp.
    :vartype cidr_csv_last_update_time: ~datetime.datetime
    :ivar bgp_cidr_csv_last_update_time: Cache node resource last Bgp Cidr Csv update timestamp.
    :vartype bgp_cidr_csv_last_update_time: ~datetime.datetime
    :ivar bgp_last_reported_time: Cache node resource last Bgp report timestamp.
    :vartype bgp_last_reported_time: ~datetime.datetime
    :ivar bgp_review_state_text: Cache node resource Bgp review state string text in detail.
    :vartype bgp_review_state_text: str
    :ivar bgp_review_state: Cache node resource Bgp review state string text. Known values are:
     "NotConfigured", "InReview", "Approved", and "AttentionRequired".
    :vartype bgp_review_state: str or ~azure.mgmt.connectedcache.models.BgpReviewStateEnum
    :ivar bgp_review_feedback: Cache node resource Bgp review feedback text.
    :vartype bgp_review_feedback: str
    :ivar bgp_number_of_times_updated: Cache node resource Bgp update count.
    :vartype bgp_number_of_times_updated: int
    :ivar bgp_number_of_records: Cache node resource Bgp record count.
    :vartype bgp_number_of_records: int
    :ivar bgp_cidr_blocks_count: Cache node resource Bgp block count.
    :vartype bgp_cidr_blocks_count: int
    :ivar bgp_address_space: Cache node resource total addressable space defined by Bgp and Cidr
     Csv blocks.
    :vartype bgp_address_space: int
    :ivar should_migrate: Cache node resource flag for determining if customer will be migrated.
    :vartype should_migrate: bool
    :ivar bgp_file_bytes_truncated: Cache node resource bytes truncated from Bgp output file.
    :vartype bgp_file_bytes_truncated: int
    :ivar cidr_selection_type: Cache node resource current Cidr range precedence selection type.
    :vartype cidr_selection_type: int
    :ivar is_frozen: Cache node resource flag for indicating the cache node resource is frozen (not
     selectable, not editable in UI).
    :vartype is_frozen: bool
    :ivar review_state: Cache node resource review process state as integer.
    :vartype review_state: int
    :ivar review_state_text: Cache node resource review state text.
    :vartype review_state_text: str
    :ivar review_feedback: Cache node resource review feedback text.
    :vartype review_feedback: str
    :ivar configuration_state: Cache node resource configuration state. Known values are:
     "Configured" and "NotConfigured_Ip".
    :vartype configuration_state: str or ~azure.mgmt.connectedcache.models.ConfigurationState
    :ivar configuration_state_text: Cache node resource configuration state text.
    :vartype configuration_state_text: str
    :ivar address_space: Cache node resource total addressable space defined by the Cidr Csv block.
    :vartype address_space: int
    :ivar worker_connections: Cache node resource Mcc container deployment worker connection count.
    :vartype worker_connections: int
    :ivar worker_connections_last_updated_date_time: Cache node resource last updated Mcc container
     deployment worker connection count timestamp.
    :vartype worker_connections_last_updated_date_time: ~datetime.datetime
    :ivar container_resync_trigger: Cache node resource Mcc container configuration details re-sync
     trigger.
    :vartype container_resync_trigger: int
    :ivar image_uri: Cache node resource Mcc Container Id Uri.
    :vartype image_uri: str
    :ivar fully_qualified_domain_name: FQDN(fully qualified domain name) value of the mcc cache
     node.
    :vartype fully_qualified_domain_name: str
    :ivar auto_update_ring_type: Auto Update Ring Type which is slow or fast etc. Known values are:
     "Preview", "Slow", and "Fast".
    :vartype auto_update_ring_type: str or ~azure.mgmt.connectedcache.models.AutoUpdateRingType
    :ivar auto_update_requested_week: Customer requested week of month for mcc install of auto
     update cycle. 0 is default no selection. 1-5 are valid weeks of month, 1 is first week, 2 is
     second week, etc.
    :vartype auto_update_requested_week: int
    :ivar auto_update_requested_day: Customer requested day of week for mcc install of auto update
     cycle. 0 is default no selection. 1-7 are days of week, 1 is Sunday, 2 is Monday, etc.
    :vartype auto_update_requested_day: int
    :ivar auto_update_requested_time: Customer requested time of the day for mcc install of auto
     update cycle, should be hh:mm.
    :vartype auto_update_requested_time: str
    """

    fully_qualified_resource_id: Optional[str] = rest_field(
        name="fullyQualifiedResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource Azure fully qualified resource Id."""
    customer_id: Optional[str] = rest_field(name="customerId", visibility=["read"])
    """Cache node resource customer resource GUID Id."""
    customer_name: Optional[str] = rest_field(
        name="customerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource customer resource name."""
    ip_address: Optional[str] = rest_field(name="ipAddress", visibility=["read", "create", "update", "delete", "query"])
    """Cache node resource Ip address."""
    customer_index: Optional[str] = rest_field(
        name="customerIndex", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource customer index as string."""
    cache_node_id: Optional[str] = rest_field(
        name="cacheNodeId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource identifier of the cache node."""
    cache_node_name: Optional[str] = rest_field(
        name="cacheNodeName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource name."""
    customer_asn: Optional[int] = rest_field(
        name="customerAsn", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource customer resource Asn (autonomous system number)."""
    is_enabled: Optional[bool] = rest_field(
        name="isEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource flag for indicating if cache node is enabled."""
    max_allowable_egress_in_mbps: Optional[int] = rest_field(
        name="maxAllowableEgressInMbps", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource maximum allowed egress in Mbps."""
    max_allowable_probability: Optional[float] = rest_field(name="maxAllowableProbability", visibility=["read"])
    """Cache node resource maximum allowed probability of egress."""
    x_cid: Optional[str] = rest_field(name="xCid", visibility=["read"])
    """Cache node resource Azure XCid."""
    is_enterprise_managed: Optional[bool] = rest_field(
        name="isEnterpriseManaged", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource flag for determining if managed by enterprise as boolean."""
    create_async_operation_id: Optional[str] = rest_field(name="createAsyncOperationId", visibility=["read"])
    """Cache node resource create async operation Id."""
    delete_async_operation_id: Optional[str] = rest_field(name="deleteAsyncOperationId", visibility=["read"])
    """Cache node resource deletion async operation Id."""
    client_tenant_id: Optional[str] = rest_field(name="clientTenantId", visibility=["read"])
    """Cache node resource customer resource client tenant Id of subscription."""
    category: Optional[str] = rest_field(visibility=["read"])
    """Cache node resource category."""
    release_version: Optional[int] = rest_field(name="releaseVersion", visibility=["read"])
    """Cache node resource release version."""
    last_sync_with_azure_timestamp: Optional[datetime.datetime] = rest_field(
        name="lastSyncWithAzureTimestamp", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last sync timestamp."""
    last_updated_timestamp: Optional[datetime.datetime] = rest_field(
        name="lastUpdatedTimestamp", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last backend updated timestamp."""
    synch_with_azure_attempts_count: Optional[int] = rest_field(name="synchWithAzureAttemptsCount", visibility=["read"])
    """Cache node resource attempts to sync with Azure."""
    container_configurations: Optional[str] = rest_field(name="containerConfigurations", visibility=["read"])
    """Cache node resource container configuration details."""
    cidr_csv: Optional[list[str]] = rest_field(
        name="cidrCsv", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource comma separated values of Cidrs."""
    cidr_csv_last_update_time: Optional[datetime.datetime] = rest_field(
        name="cidrCsvLastUpdateTime", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last Cidr Csv update timestamp."""
    bgp_cidr_csv_last_update_time: Optional[datetime.datetime] = rest_field(
        name="bgpCidrCsvLastUpdateTime", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last Bgp Cidr Csv update timestamp."""
    bgp_last_reported_time: Optional[datetime.datetime] = rest_field(
        name="bgpLastReportedTime", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last Bgp report timestamp."""
    bgp_review_state_text: Optional[str] = rest_field(name="bgpReviewStateText", visibility=["read"])
    """Cache node resource Bgp review state string text in detail."""
    bgp_review_state: Optional[Union[str, "_models.BgpReviewStateEnum"]] = rest_field(
        name="bgpReviewState", visibility=["read"]
    )
    """Cache node resource Bgp review state string text. Known values are: \"NotConfigured\",
     \"InReview\", \"Approved\", and \"AttentionRequired\"."""
    bgp_review_feedback: Optional[str] = rest_field(name="bgpReviewFeedback", visibility=["read"])
    """Cache node resource Bgp review feedback text."""
    bgp_number_of_times_updated: Optional[int] = rest_field(name="bgpNumberOfTimesUpdated", visibility=["read"])
    """Cache node resource Bgp update count."""
    bgp_number_of_records: Optional[int] = rest_field(name="bgpNumberOfRecords", visibility=["read"])
    """Cache node resource Bgp record count."""
    bgp_cidr_blocks_count: Optional[int] = rest_field(name="bgpCidrBlocksCount", visibility=["read"])
    """Cache node resource Bgp block count."""
    bgp_address_space: Optional[int] = rest_field(name="bgpAddressSpace", visibility=["read"])
    """Cache node resource total addressable space defined by Bgp and Cidr Csv blocks."""
    should_migrate: Optional[bool] = rest_field(
        name="shouldMigrate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource flag for determining if customer will be migrated."""
    bgp_file_bytes_truncated: Optional[int] = rest_field(name="bgpFileBytesTruncated", visibility=["read"])
    """Cache node resource bytes truncated from Bgp output file."""
    cidr_selection_type: Optional[int] = rest_field(
        name="cidrSelectionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource current Cidr range precedence selection type."""
    is_frozen: Optional[bool] = rest_field(name="isFrozen", visibility=["read"])
    """Cache node resource flag for indicating the cache node resource is frozen (not selectable, not
     editable in UI)."""
    review_state: Optional[int] = rest_field(name="reviewState", visibility=["read"])
    """Cache node resource review process state as integer."""
    review_state_text: Optional[str] = rest_field(name="reviewStateText", visibility=["read"])
    """Cache node resource review state text."""
    review_feedback: Optional[str] = rest_field(name="reviewFeedback", visibility=["read"])
    """Cache node resource review feedback text."""
    configuration_state: Optional[Union[str, "_models.ConfigurationState"]] = rest_field(
        name="configurationState", visibility=["read"]
    )
    """Cache node resource configuration state. Known values are: \"Configured\" and
     \"NotConfigured_Ip\"."""
    configuration_state_text: Optional[str] = rest_field(name="configurationStateText", visibility=["read"])
    """Cache node resource configuration state text."""
    address_space: Optional[int] = rest_field(name="addressSpace", visibility=["read"])
    """Cache node resource total addressable space defined by the Cidr Csv block."""
    worker_connections: Optional[int] = rest_field(name="workerConnections", visibility=["read"])
    """Cache node resource Mcc container deployment worker connection count."""
    worker_connections_last_updated_date_time: Optional[datetime.datetime] = rest_field(
        name="workerConnectionsLastUpdatedDateTime", visibility=["read"], format="rfc3339"
    )
    """Cache node resource last updated Mcc container deployment worker connection count timestamp."""
    container_resync_trigger: Optional[int] = rest_field(name="containerResyncTrigger", visibility=["read"])
    """Cache node resource Mcc container configuration details re-sync trigger."""
    image_uri: Optional[str] = rest_field(name="imageUri", visibility=["read"])
    """Cache node resource Mcc Container Id Uri."""
    fully_qualified_domain_name: Optional[str] = rest_field(
        name="fullyQualifiedDomainName", visibility=["read", "create", "update", "delete", "query"]
    )
    """FQDN(fully qualified domain name) value of the mcc cache node."""
    auto_update_ring_type: Optional[Union[str, "_models.AutoUpdateRingType"]] = rest_field(
        name="autoUpdateRingType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Auto Update Ring Type which is slow or fast etc. Known values are: \"Preview\", \"Slow\", and
     \"Fast\"."""
    auto_update_requested_week: Optional[int] = rest_field(
        name="autoUpdateRequestedWeek", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer requested week of month for mcc install of auto update cycle. 0 is default no
     selection. 1-5 are valid weeks of month, 1 is first week, 2 is second week, etc."""
    auto_update_requested_day: Optional[int] = rest_field(
        name="autoUpdateRequestedDay", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer requested day of week for mcc install of auto update cycle. 0 is default no selection.
     1-7 are days of week, 1 is Sunday, 2 is Monday, etc."""
    auto_update_requested_time: Optional[str] = rest_field(
        name="autoUpdateRequestedTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer requested time of the day for mcc install of auto update cycle, should be hh:mm."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        fully_qualified_resource_id: Optional[str] = None,
        customer_name: Optional[str] = None,
        ip_address: Optional[str] = None,
        customer_index: Optional[str] = None,
        cache_node_id: Optional[str] = None,
        cache_node_name: Optional[str] = None,
        customer_asn: Optional[int] = None,
        is_enabled: Optional[bool] = None,
        max_allowable_egress_in_mbps: Optional[int] = None,
        is_enterprise_managed: Optional[bool] = None,
        cidr_csv: Optional[list[str]] = None,
        should_migrate: Optional[bool] = None,
        cidr_selection_type: Optional[int] = None,
        fully_qualified_domain_name: Optional[str] = None,
        auto_update_ring_type: Optional[Union[str, "_models.AutoUpdateRingType"]] = None,
        auto_update_requested_week: Optional[int] = None,
        auto_update_requested_day: Optional[int] = None,
        auto_update_requested_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CacheNodeInstallProperties(_Model):
    """Mcc cache node resource install script properties.

    :ivar customer_id: Mcc customer resource Id.
    :vartype customer_id: str
    :ivar cache_node_id: Mcc cache node resource Id.
    :vartype cache_node_id: str
    :ivar primary_account_key: Mcc primary account key. Internal to Mcc.
    :vartype primary_account_key: str
    :ivar secondary_account_key: Mcc secondary account key. Internal to Mcc.
    :vartype secondary_account_key: str
    :ivar registration_key: Mcc Iot Central temporary device registration key, used once.
    :vartype registration_key: str
    :ivar tls_certificate_provisioning_key: Mcc Tls certificate provisioning key.
    :vartype tls_certificate_provisioning_key: str
    :ivar drive_configuration: Cache node resource drive configurations.
    :vartype drive_configuration:
     list[~azure.mgmt.connectedcache.models.CacheNodeDriveConfiguration]
    :ivar proxy_url_configuration: proxyUrl configuration of the cache node.
    :vartype proxy_url_configuration: ~azure.mgmt.connectedcache.models.ProxyUrlConfiguration
    """

    customer_id: Optional[str] = rest_field(
        name="customerId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc customer resource Id."""
    cache_node_id: Optional[str] = rest_field(
        name="cacheNodeId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc cache node resource Id."""
    primary_account_key: Optional[str] = rest_field(name="primaryAccountKey", visibility=["read"])
    """Mcc primary account key. Internal to Mcc."""
    secondary_account_key: Optional[str] = rest_field(name="secondaryAccountKey", visibility=["read"])
    """Mcc secondary account key. Internal to Mcc."""
    registration_key: Optional[str] = rest_field(name="registrationKey", visibility=["read"])
    """Mcc Iot Central temporary device registration key, used once."""
    tls_certificate_provisioning_key: Optional[str] = rest_field(
        name="tlsCertificateProvisioningKey", visibility=["read"]
    )
    """Mcc Tls certificate provisioning key."""
    drive_configuration: Optional[list["_models.CacheNodeDriveConfiguration"]] = rest_field(
        name="driveConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource drive configurations."""
    proxy_url_configuration: Optional["_models.ProxyUrlConfiguration"] = rest_field(
        name="proxyUrlConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """proxyUrl configuration of the cache node."""

    @overload
    def __init__(
        self,
        *,
        customer_id: Optional[str] = None,
        cache_node_id: Optional[str] = None,
        drive_configuration: Optional[list["_models.CacheNodeDriveConfiguration"]] = None,
        proxy_url_configuration: Optional["_models.ProxyUrlConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CacheNodeProperty(_Model):
    """Model representing an Mcc cache node connectedCache resource.

    :ivar provisioning_state: The provisioned state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Unknown", "Accepted", "Upgrading", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.connectedcache.models.ProvisioningState
    :ivar cache_node: Mcc cache node resource (cache node entity).
    :vartype cache_node: ~azure.mgmt.connectedcache.models.CacheNodeEntity
    :ivar additional_cache_node_properties: Mcc cache node resource additional properties.
    :vartype additional_cache_node_properties:
     ~azure.mgmt.connectedcache.models.AdditionalCacheNodeProperties
    :ivar status_code: Mcc response status code.
    :vartype status_code: str
    :ivar status_text: Mcc response status text as string for retrieving status details.
    :vartype status_text: str
    :ivar status_details: Mcc response status details for retrieving response inner details.
    :vartype status_details: str
    :ivar status: HTTP error status code.
    :vartype status: str
    :ivar error: Mcc response error details.
    :vartype error: ~azure.mgmt.connectedcache.models.ErrorDetail
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioned state of the resource. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Unknown\", \"Accepted\", \"Upgrading\", and \"Deleting\"."""
    cache_node: Optional["_models.CacheNodeEntity"] = rest_field(
        name="cacheNode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc cache node resource (cache node entity)."""
    additional_cache_node_properties: Optional["_models.AdditionalCacheNodeProperties"] = rest_field(
        name="additionalCacheNodeProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc cache node resource additional properties."""
    status_code: Optional[str] = rest_field(
        name="statusCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc response status code."""
    status_text: Optional[str] = rest_field(
        name="statusText", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc response status text as string for retrieving status details."""
    status_details: Optional[str] = rest_field(
        name="statusDetails", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc response status details for retrieving response inner details."""
    status: Optional[str] = rest_field(visibility=["read"])
    """HTTP error status code."""
    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Mcc response error details."""

    @overload
    def __init__(
        self,
        *,
        cache_node: Optional["_models.CacheNodeEntity"] = None,
        additional_cache_node_properties: Optional["_models.AdditionalCacheNodeProperties"] = None,
        status_code: Optional[str] = None,
        status_text: Optional[str] = None,
        status_details: Optional[str] = None,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConnectedCachePatchResource(_Model):
    """Mcc PATCH operation properties.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "update"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomerEntity(_Model):
    """Model representing Customer resource for ConnectedCache resource.

    :ivar fully_qualified_resource_id: Customer resource Azure fully qualified resource Id.
    :vartype fully_qualified_resource_id: str
    :ivar customer_id: Customer resource Guid Id.
    :vartype customer_id: str
    :ivar customer_name: Customer resource name.
    :vartype customer_name: str
    :ivar contact_email: Customer resource contact email.
    :vartype contact_email: str
    :ivar contact_phone: Customer resource contact phone.
    :vartype contact_phone: str
    :ivar contact_name: Customer resource contact full name.
    :vartype contact_name: str
    :ivar is_entitled: Customer resource entitlement flag as boolean.
    :vartype is_entitled: bool
    :ivar release_version: Customer resource Mcc release version.
    :vartype release_version: int
    :ivar create_async_operation_id: Customer resource create async operation Id.
    :vartype create_async_operation_id: str
    :ivar delete_async_operation_id: Customer resource deletion async operation Id.
    :vartype delete_async_operation_id: str
    :ivar client_tenant_id: Customer resource client tenant Id of subscription.
    :vartype client_tenant_id: str
    :ivar synch_with_azure_attempts_count: Customer resource sync attempts.
    :vartype synch_with_azure_attempts_count: int
    :ivar last_sync_with_azure_timestamp: Customer resource last Azure sync timestamp.
    :vartype last_sync_with_azure_timestamp: ~datetime.datetime
    :ivar is_enterprise_managed: Customer resource flag for enterprise management as boolean.
    :vartype is_enterprise_managed: bool
    :ivar should_migrate: Customer resource flag for migration.
    :vartype should_migrate: bool
    :ivar resend_signup_code: Customer resource flag for resending signup code as boolean.
    :vartype resend_signup_code: bool
    :ivar verify_signup_code: Customer resource flag for requiring verification of signup code as
     boolean.
    :vartype verify_signup_code: bool
    :ivar verify_signup_phrase: Customer resource phrase for verifying signup.
    :vartype verify_signup_phrase: str
    """

    fully_qualified_resource_id: Optional[str] = rest_field(
        name="fullyQualifiedResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource Azure fully qualified resource Id."""
    customer_id: Optional[str] = rest_field(name="customerId", visibility=["read"])
    """Customer resource Guid Id."""
    customer_name: Optional[str] = rest_field(
        name="customerName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource name."""
    contact_email: Optional[str] = rest_field(
        name="contactEmail", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource contact email."""
    contact_phone: Optional[str] = rest_field(
        name="contactPhone", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource contact phone."""
    contact_name: Optional[str] = rest_field(
        name="contactName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource contact full name."""
    is_entitled: Optional[bool] = rest_field(
        name="isEntitled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource entitlement flag as boolean."""
    release_version: Optional[int] = rest_field(
        name="releaseVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource Mcc release version."""
    create_async_operation_id: Optional[str] = rest_field(name="createAsyncOperationId", visibility=["read"])
    """Customer resource create async operation Id."""
    delete_async_operation_id: Optional[str] = rest_field(name="deleteAsyncOperationId", visibility=["read"])
    """Customer resource deletion async operation Id."""
    client_tenant_id: Optional[str] = rest_field(
        name="clientTenantId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource client tenant Id of subscription."""
    synch_with_azure_attempts_count: Optional[int] = rest_field(name="synchWithAzureAttemptsCount", visibility=["read"])
    """Customer resource sync attempts."""
    last_sync_with_azure_timestamp: Optional[datetime.datetime] = rest_field(
        name="lastSyncWithAzureTimestamp", visibility=["read"], format="rfc3339"
    )
    """Customer resource last Azure sync timestamp."""
    is_enterprise_managed: Optional[bool] = rest_field(
        name="isEnterpriseManaged", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource flag for enterprise management as boolean."""
    should_migrate: Optional[bool] = rest_field(
        name="shouldMigrate", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource flag for migration."""
    resend_signup_code: Optional[bool] = rest_field(
        name="resendSignupCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource flag for resending signup code as boolean."""
    verify_signup_code: Optional[bool] = rest_field(
        name="verifySignupCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Customer resource flag for requiring verification of signup code as boolean."""
    verify_signup_phrase: Optional[str] = rest_field(name="verifySignupPhrase", visibility=["create", "update"])
    """Customer resource phrase for verifying signup."""

    @overload
    def __init__(
        self,
        *,
        fully_qualified_resource_id: Optional[str] = None,
        customer_name: Optional[str] = None,
        contact_email: Optional[str] = None,
        contact_phone: Optional[str] = None,
        contact_name: Optional[str] = None,
        is_entitled: Optional[bool] = None,
        release_version: Optional[int] = None,
        client_tenant_id: Optional[str] = None,
        is_enterprise_managed: Optional[bool] = None,
        should_migrate: Optional[bool] = None,
        resend_signup_code: Optional[bool] = None,
        verify_signup_code: Optional[bool] = None,
        verify_signup_phrase: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomerProperty(_Model):
    """Model representing customer for connectedCache resource.

    :ivar provisioning_state: The provisioned state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Unknown", "Accepted", "Upgrading", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.connectedcache.models.ProvisioningState
    :ivar customer: Mcc customer resource (customer entity).
    :vartype customer: ~azure.mgmt.connectedcache.models.CustomerEntity
    :ivar additional_customer_properties: Mcc customer resource additional properties.
    :vartype additional_customer_properties:
     ~azure.mgmt.connectedcache.models.AdditionalCustomerProperties
    :ivar status_code: Mcc response status code.
    :vartype status_code: str
    :ivar status_text: Mcc response status text as string for retrieving status details.
    :vartype status_text: str
    :ivar status_details: Mcc response status details for retrieving response inner details.
    :vartype status_details: str
    :ivar status: HTTP error status code.
    :vartype status: str
    :ivar error: Mcc response error details.
    :vartype error: ~azure.mgmt.connectedcache.models.ErrorDetail
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioned state of the resource. Known values are: \"Succeeded\", \"Failed\",
     \"Canceled\", \"Unknown\", \"Accepted\", \"Upgrading\", and \"Deleting\"."""
    customer: Optional["_models.CustomerEntity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc customer resource (customer entity)."""
    additional_customer_properties: Optional["_models.AdditionalCustomerProperties"] = rest_field(
        name="additionalCustomerProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc customer resource additional properties."""
    status_code: Optional[str] = rest_field(name="statusCode", visibility=["read"])
    """Mcc response status code."""
    status_text: Optional[str] = rest_field(name="statusText", visibility=["read"])
    """Mcc response status text as string for retrieving status details."""
    status_details: Optional[str] = rest_field(name="statusDetails", visibility=["read"])
    """Mcc response status details for retrieving response inner details."""
    status: Optional[str] = rest_field(visibility=["read"])
    """HTTP error status code."""
    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read"])
    """Mcc response error details."""

    @overload
    def __init__(
        self,
        *,
        customer: Optional["_models.CustomerEntity"] = None,
        additional_customer_properties: Optional["_models.AdditionalCustomerProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnterpriseMccCacheNodeResource(TrackedResource):
    """Represents the high level Nodes needed to provision cache node resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.connectedcache.models.CacheNodeProperty
    """

    properties: Optional["_models.CacheNodeProperty"] = rest_field(visibility=["read", "create", "update"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.CacheNodeProperty"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EnterpriseMccCustomerResource(TrackedResource):
    """Represents the high level Nodes needed to provision customer resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.connectedcache.models.CustomerProperty
    """

    properties: Optional["_models.CustomerProperty"] = rest_field(visibility=["read", "create", "update"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.CustomerProperty"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.connectedcache.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.connectedcache.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.connectedcache.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IspCacheNodeResource(TrackedResource):
    """Represents the high level Nodes needed to provision cache node resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.connectedcache.models.CacheNodeProperty
    """

    properties: Optional["_models.CacheNodeProperty"] = rest_field(visibility=["read", "create", "update"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.CacheNodeProperty"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IspCustomerResource(TrackedResource):
    """Represents the high level Nodes needed to provision isp customer resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.connectedcache.models.CustomerProperty
    """

    properties: Optional["_models.CustomerProperty"] = rest_field(visibility=["read", "create", "update"])
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.CustomerProperty"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccCacheNodeAutoUpdateHistory(TrackedResource):
    """Mcc cache node resource auto update history.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Mcc cache node resource auto update history properties.
    :vartype properties: ~azure.mgmt.connectedcache.models.MccCacheNodeAutoUpdateHistoryProperties
    """

    properties: Optional["_models.MccCacheNodeAutoUpdateHistoryProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc cache node resource auto update history properties."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.MccCacheNodeAutoUpdateHistoryProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccCacheNodeAutoUpdateHistoryProperties(_Model):
    """Mcc cache node resource auto update history properties.

    :ivar customer_id: Mcc customer resource Id.
    :vartype customer_id: str
    :ivar cache_node_id: Mcc cache node resource Id.
    :vartype cache_node_id: str
    :ivar auto_update_history: Cache node resource auto update history information.
    :vartype auto_update_history:
     list[~azure.mgmt.connectedcache.models.MccCacheNodeAutoUpdateInfo]
    """

    customer_id: Optional[str] = rest_field(name="customerId", visibility=["read"])
    """Mcc customer resource Id."""
    cache_node_id: Optional[str] = rest_field(name="cacheNodeId", visibility=["read"])
    """Mcc cache node resource Id."""
    auto_update_history: Optional[list["_models.MccCacheNodeAutoUpdateInfo"]] = rest_field(
        name="autoUpdateHistory", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource auto update history information."""

    @overload
    def __init__(
        self,
        *,
        auto_update_history: Optional[list["_models.MccCacheNodeAutoUpdateInfo"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccCacheNodeAutoUpdateInfo(_Model):
    """Mcc cache node resource auto update properties.

    :ivar image_uri_before_update: Auto update image uri before update.
    :vartype image_uri_before_update: str
    :ivar image_uri_targeted: Auto update image uri targetted to update.
    :vartype image_uri_targeted: str
    :ivar image_uri_terminal: Auto update image uri at Terminal.
    :vartype image_uri_terminal: str
    :ivar auto_update_ring_type: Auto update Ring Type.
    :vartype auto_update_ring_type: int
    :ivar moved_to_terminal_state_date_time: Auto update image uri after update.
    :vartype moved_to_terminal_state_date_time: ~datetime.datetime
    :ivar rule_requested_week: Auto update image uri before update.
    :vartype rule_requested_week: int
    :ivar rule_requested_day: Auto update image uri after update.
    :vartype rule_requested_day: int
    :ivar created_date_time_utc: Auto update entity created datetime.
    :vartype created_date_time_utc: ~datetime.datetime
    :ivar updated_registry_date_time_utc: Auto update entity last updated datetime.
    :vartype updated_registry_date_time_utc: ~datetime.datetime
    :ivar plan_change_log_text: This text describing the purpose of the plan of auto update.
    :vartype plan_change_log_text: str
    :ivar auto_update_last_applied_status: Auto update last applied status.
    :vartype auto_update_last_applied_status: int
    :ivar auto_update_last_applied_status_text: Auto update last applied status text.
    :vartype auto_update_last_applied_status_text: str
    :ivar auto_update_last_applied_status_detailed_text: Auto update last applied detailed status
     text.
    :vartype auto_update_last_applied_status_detailed_text: str
    :ivar plan_id: Auto update planId.
    :vartype plan_id: int
    :ivar time_to_go_live_date_time: Auto update time to go live date time.
    :vartype time_to_go_live_date_time: str
    :ivar rule_requested_minute: Auto update rule requested minute.
    :vartype rule_requested_minute: str
    :ivar rule_requested_hour: Auto update rule requested hour.
    :vartype rule_requested_hour: str
    """

    image_uri_before_update: Optional[str] = rest_field(name="imageUriBeforeUpdate", visibility=["read"])
    """Auto update image uri before update."""
    image_uri_targeted: Optional[str] = rest_field(name="imageUriTargeted", visibility=["read"])
    """Auto update image uri targetted to update."""
    image_uri_terminal: Optional[str] = rest_field(name="imageUriTerminal", visibility=["read"])
    """Auto update image uri at Terminal."""
    auto_update_ring_type: Optional[int] = rest_field(name="autoUpdateRingType", visibility=["read"])
    """Auto update Ring Type."""
    moved_to_terminal_state_date_time: Optional[datetime.datetime] = rest_field(
        name="movedToTerminalStateDateTime", visibility=["read"], format="rfc3339"
    )
    """Auto update image uri after update."""
    rule_requested_week: Optional[int] = rest_field(name="ruleRequestedWeek", visibility=["read"])
    """Auto update image uri before update."""
    rule_requested_day: Optional[int] = rest_field(name="ruleRequestedDay", visibility=["read"])
    """Auto update image uri after update."""
    created_date_time_utc: Optional[datetime.datetime] = rest_field(
        name="createdDateTimeUtc", visibility=["read"], format="rfc3339"
    )
    """Auto update entity created datetime."""
    updated_registry_date_time_utc: Optional[datetime.datetime] = rest_field(
        name="updatedRegistryDateTimeUtc", visibility=["read"], format="rfc3339"
    )
    """Auto update entity last updated datetime."""
    plan_change_log_text: Optional[str] = rest_field(name="planChangeLogText", visibility=["read"])
    """This text describing the purpose of the plan of auto update."""
    auto_update_last_applied_status: Optional[int] = rest_field(name="autoUpdateLastAppliedStatus", visibility=["read"])
    """Auto update last applied status."""
    auto_update_last_applied_status_text: Optional[str] = rest_field(
        name="autoUpdateLastAppliedStatusText", visibility=["read"]
    )
    """Auto update last applied status text."""
    auto_update_last_applied_status_detailed_text: Optional[str] = rest_field(
        name="autoUpdateLastAppliedStatusDetailedText", visibility=["read"]
    )
    """Auto update last applied detailed status text."""
    plan_id: Optional[int] = rest_field(name="planId", visibility=["read"])
    """Auto update planId."""
    time_to_go_live_date_time: Optional[str] = rest_field(name="timeToGoLiveDateTime", visibility=["read"])
    """Auto update time to go live date time."""
    rule_requested_minute: Optional[str] = rest_field(name="ruleRequestedMinute", visibility=["read"])
    """Auto update rule requested minute."""
    rule_requested_hour: Optional[str] = rest_field(name="ruleRequestedHour", visibility=["read"])
    """Auto update rule requested hour."""


class MccCacheNodeBgpCidrDetails(TrackedResource):
    """Represents all Cidr details of the Bgp request for a specific cache node resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Mcc cache node resource Bgp Cidr properties.
    :vartype properties: ~azure.mgmt.connectedcache.models.BgpCidrsConfiguration
    """

    properties: Optional["_models.BgpCidrsConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc cache node resource Bgp Cidr properties."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.BgpCidrsConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccCacheNodeInstallDetails(TrackedResource):
    """Mcc cache node resource all install details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Mcc cache node resource install script details.
    :vartype properties: ~azure.mgmt.connectedcache.models.CacheNodeInstallProperties
    """

    properties: Optional["_models.CacheNodeInstallProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc cache node resource install script details."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.CacheNodeInstallProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccCacheNodeIssueHistory(TrackedResource):
    """Mcc cache node resource issue history.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Mcc cache node resource issue history properties.
    :vartype properties: ~azure.mgmt.connectedcache.models.MccCacheNodeIssueHistoryProperties
    """

    properties: Optional["_models.MccCacheNodeIssueHistoryProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc cache node resource issue history properties."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.MccCacheNodeIssueHistoryProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccCacheNodeIssueHistoryProperties(_Model):
    """Mcc cache node resource issue history properties.

    :ivar customer_id: Mcc customer resource Id.
    :vartype customer_id: str
    :ivar cache_node_id: Mcc cache node resource Id.
    :vartype cache_node_id: str
    :ivar mcc_issue_history: Cache node resource issue details history.
    :vartype mcc_issue_history: list[~azure.mgmt.connectedcache.models.MccIssue]
    """

    customer_id: Optional[str] = rest_field(name="customerId", visibility=["read"])
    """Mcc customer resource Id."""
    cache_node_id: Optional[str] = rest_field(name="cacheNodeId", visibility=["read"])
    """Mcc cache node resource Id."""
    mcc_issue_history: Optional[list["_models.MccIssue"]] = rest_field(
        name="mccIssueHistory", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource issue details history."""

    @overload
    def __init__(
        self,
        *,
        mcc_issue_history: Optional[list["_models.MccIssue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccCacheNodeTlsCertificate(_Model):
    """Mcc cache node resource Tls certificate details.

    :ivar action_required: Mcc cache node Tls certificate status.
    :vartype action_required: str
    :ivar certificate_file_name: Mcc cache node Tls certificate file name.
    :vartype certificate_file_name: str
    :ivar thumbprint: Mcc cache node Tls certificate thumbprint.
    :vartype thumbprint: str
    :ivar expiry_date: Mcc cache node Tls certificate expiry date.
    :vartype expiry_date: ~datetime.datetime
    :ivar not_before_date: Mcc cache node Tls certificate not before date.
    :vartype not_before_date: ~datetime.datetime
    :ivar subject: Mcc cache node Tls certificate subject name.
    :vartype subject: str
    :ivar subject_alt_name: Mcc cache node Tls certificate subject alternate name.
    :vartype subject_alt_name: str
    """

    action_required: Optional[str] = rest_field(name="actionRequired", visibility=["read"])
    """Mcc cache node Tls certificate status."""
    certificate_file_name: Optional[str] = rest_field(name="certificateFileName", visibility=["read"])
    """Mcc cache node Tls certificate file name."""
    thumbprint: Optional[str] = rest_field(visibility=["read"])
    """Mcc cache node Tls certificate thumbprint."""
    expiry_date: Optional[datetime.datetime] = rest_field(name="expiryDate", visibility=["read"], format="rfc3339")
    """Mcc cache node Tls certificate expiry date."""
    not_before_date: Optional[datetime.datetime] = rest_field(
        name="notBeforeDate", visibility=["read"], format="rfc3339"
    )
    """Mcc cache node Tls certificate not before date."""
    subject: Optional[str] = rest_field(visibility=["read"])
    """Mcc cache node Tls certificate subject name."""
    subject_alt_name: Optional[str] = rest_field(name="subjectAltName", visibility=["read"])
    """Mcc cache node Tls certificate subject alternate name."""


class MccCacheNodeTlsCertificateHistory(TrackedResource):
    """Mcc cache node resource Tls certificate history details.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.connectedcache.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Mcc cache node resource Tls certificate details.
    :vartype properties: ~azure.mgmt.connectedcache.models.MccCacheNodeTlsCertificateProperties
    """

    properties: Optional["_models.MccCacheNodeTlsCertificateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Mcc cache node resource Tls certificate details."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.MccCacheNodeTlsCertificateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccCacheNodeTlsCertificateProperties(_Model):
    """Mcc cache node resource auto update properties.

    :ivar customer_id: Mcc customer resource Id.
    :vartype customer_id: str
    :ivar cache_node_id: Mcc cache node resource Id.
    :vartype cache_node_id: str
    :ivar tls_certificate_history: Cache node resource tls certificate history details.
    :vartype tls_certificate_history:
     list[~azure.mgmt.connectedcache.models.MccCacheNodeTlsCertificate]
    """

    customer_id: Optional[str] = rest_field(name="customerId", visibility=["read"])
    """Mcc customer resource Id."""
    cache_node_id: Optional[str] = rest_field(name="cacheNodeId", visibility=["read"])
    """Mcc cache node resource Id."""
    tls_certificate_history: Optional[list["_models.MccCacheNodeTlsCertificate"]] = rest_field(
        name="tlsCertificateHistory", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cache node resource tls certificate history details."""

    @overload
    def __init__(
        self,
        *,
        tls_certificate_history: Optional[list["_models.MccCacheNodeTlsCertificate"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MccIssue(_Model):
    """Mcc cache node resource issue properties.

    :ivar mcc_issue_type: Mcc cache node issue type.
    :vartype mcc_issue_type: str
    :ivar toast_string: Mcc cache node issues toastString.
    :vartype toast_string: str
    :ivar detail_string: Mcc cache node issue detail string.
    :vartype detail_string: str
    :ivar help_link: Mcc cache node issue related help link.
    :vartype help_link: str
    :ivar issue_start_date: Mcc cache node issue start date.
    :vartype issue_start_date: ~datetime.datetime
    :ivar issue_end_date: Mcc cache node issue end date.
    :vartype issue_end_date: ~datetime.datetime
    """

    mcc_issue_type: Optional[str] = rest_field(name="mccIssueType", visibility=["read"])
    """Mcc cache node issue type."""
    toast_string: Optional[str] = rest_field(name="toastString", visibility=["read"])
    """Mcc cache node issues toastString."""
    detail_string: Optional[str] = rest_field(name="detailString", visibility=["read"])
    """Mcc cache node issue detail string."""
    help_link: Optional[str] = rest_field(name="helpLink", visibility=["read"])
    """Mcc cache node issue related help link."""
    issue_start_date: Optional[datetime.datetime] = rest_field(
        name="issueStartDate", visibility=["read"], format="rfc3339"
    )
    """Mcc cache node issue start date."""
    issue_end_date: Optional[datetime.datetime] = rest_field(name="issueEndDate", visibility=["read"], format="rfc3339")
    """Mcc cache node issue end date."""


class Operation(_Model):
    """REST API Operation.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.connectedcache.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.connectedcache.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.connectedcache.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class ProxyUrlConfiguration(_Model):
    """ProxyUrl configuration of cache node.

    :ivar proxy_url: Host Proxy Address configuration along with port number. This can be a proxy
     or ip address. ex: xx.xx.xx.xxxx:80 or host name `http://exampleproxy.com:80
     <http://exampleproxy.com:80>`_.
    :vartype proxy_url: str
    """

    proxy_url: Optional[str] = rest_field(name="proxyUrl", visibility=["read", "create", "update", "delete", "query"])
    """Host Proxy Address configuration along with port number. This can be a proxy or ip address. ex:
     xx.xx.xx.xxxx:80 or host name `http://exampleproxy.com:80 <http://exampleproxy.com:80>`_."""

    @overload
    def __init__(
        self,
        *,
        proxy_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.connectedcache.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.connectedcache.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
