# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Iterable, Optional, Type, TypeVar, Union, overload
import urllib.parse

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_create_or_update_request(
    resource_group_name: str,
    dns_forwarding_ruleset_name: str,
    forwarding_rule_name: str,
    subscription_id: str,
    *,
    if_match: Optional[str] = None,
    if_none_match: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-07-01-preview"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules/{forwardingRuleName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "dnsForwardingRulesetName": _SERIALIZER.url("dns_forwarding_ruleset_name", dns_forwarding_ruleset_name, "str"),
        "forwardingRuleName": _SERIALIZER.url("forwarding_rule_name", forwarding_rule_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if if_none_match is not None:
        _headers["If-None-Match"] = _SERIALIZER.header("if_none_match", if_none_match, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_update_request(
    resource_group_name: str,
    dns_forwarding_ruleset_name: str,
    forwarding_rule_name: str,
    subscription_id: str,
    *,
    if_match: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-07-01-preview"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules/{forwardingRuleName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "dnsForwardingRulesetName": _SERIALIZER.url("dns_forwarding_ruleset_name", dns_forwarding_ruleset_name, "str"),
        "forwardingRuleName": _SERIALIZER.url("forwarding_rule_name", forwarding_rule_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(
    resource_group_name: str,
    dns_forwarding_ruleset_name: str,
    forwarding_rule_name: str,
    subscription_id: str,
    *,
    if_match: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-07-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules/{forwardingRuleName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "dnsForwardingRulesetName": _SERIALIZER.url("dns_forwarding_ruleset_name", dns_forwarding_ruleset_name, "str"),
        "forwardingRuleName": _SERIALIZER.url("forwarding_rule_name", forwarding_rule_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(
    resource_group_name: str,
    dns_forwarding_ruleset_name: str,
    forwarding_rule_name: str,
    subscription_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-07-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules/{forwardingRuleName}",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "dnsForwardingRulesetName": _SERIALIZER.url("dns_forwarding_ruleset_name", dns_forwarding_ruleset_name, "str"),
        "forwardingRuleName": _SERIALIZER.url("forwarding_rule_name", forwarding_rule_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_list_request(
    resource_group_name: str,
    dns_forwarding_ruleset_name: str,
    subscription_id: str,
    *,
    top: Optional[int] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-07-01-preview"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url",
        "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/forwardingRules",
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str"),
        "resourceGroupName": _SERIALIZER.url(
            "resource_group_name", resource_group_name, "str", max_length=90, min_length=1
        ),
        "dnsForwardingRulesetName": _SERIALIZER.url("dns_forwarding_ruleset_name", dns_forwarding_ruleset_name, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if top is not None:
        _params["$top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class ForwardingRulesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.dnsresolver.DnsResolverManagementClient`'s
        :attr:`forwarding_rules` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    def create_or_update(
        self,
        resource_group_name: str,
        dns_forwarding_ruleset_name: str,
        forwarding_rule_name: str,
        parameters: _models.ForwardingRule,
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ForwardingRule:
        """Creates or updates a forwarding rule in a DNS forwarding ruleset.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset. Required.
        :type dns_forwarding_ruleset_name: str
        :param forwarding_rule_name: The name of the forwarding rule. Required.
        :type forwarding_rule_name: str
        :param parameters: Parameters supplied to the CreateOrUpdate operation. Required.
        :type parameters: ~azure.mgmt.dnsresolver.models.ForwardingRule
        :param if_match: ETag of the resource. Omit this value to always overwrite the current
         resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent
         changes. Default value is None.
        :type if_match: str
        :param if_none_match: Set to '*' to allow a new resource to be created, but to prevent updating
         an existing resource. Other values will be ignored. Default value is None.
        :type if_none_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ForwardingRule or the result of cls(response)
        :rtype: ~azure.mgmt.dnsresolver.models.ForwardingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_or_update(
        self,
        resource_group_name: str,
        dns_forwarding_ruleset_name: str,
        forwarding_rule_name: str,
        parameters: IO[bytes],
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ForwardingRule:
        """Creates or updates a forwarding rule in a DNS forwarding ruleset.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset. Required.
        :type dns_forwarding_ruleset_name: str
        :param forwarding_rule_name: The name of the forwarding rule. Required.
        :type forwarding_rule_name: str
        :param parameters: Parameters supplied to the CreateOrUpdate operation. Required.
        :type parameters: IO[bytes]
        :param if_match: ETag of the resource. Omit this value to always overwrite the current
         resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent
         changes. Default value is None.
        :type if_match: str
        :param if_none_match: Set to '*' to allow a new resource to be created, but to prevent updating
         an existing resource. Other values will be ignored. Default value is None.
        :type if_none_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ForwardingRule or the result of cls(response)
        :rtype: ~azure.mgmt.dnsresolver.models.ForwardingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_or_update(
        self,
        resource_group_name: str,
        dns_forwarding_ruleset_name: str,
        forwarding_rule_name: str,
        parameters: Union[_models.ForwardingRule, IO[bytes]],
        if_match: Optional[str] = None,
        if_none_match: Optional[str] = None,
        **kwargs: Any
    ) -> _models.ForwardingRule:
        """Creates or updates a forwarding rule in a DNS forwarding ruleset.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset. Required.
        :type dns_forwarding_ruleset_name: str
        :param forwarding_rule_name: The name of the forwarding rule. Required.
        :type forwarding_rule_name: str
        :param parameters: Parameters supplied to the CreateOrUpdate operation. Is either a
         ForwardingRule type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.dnsresolver.models.ForwardingRule or IO[bytes]
        :param if_match: ETag of the resource. Omit this value to always overwrite the current
         resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent
         changes. Default value is None.
        :type if_match: str
        :param if_none_match: Set to '*' to allow a new resource to be created, but to prevent updating
         an existing resource. Other values will be ignored. Default value is None.
        :type if_none_match: str
        :return: ForwardingRule or the result of cls(response)
        :rtype: ~azure.mgmt.dnsresolver.models.ForwardingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ForwardingRule] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ForwardingRule")

        _request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            dns_forwarding_ruleset_name=dns_forwarding_ruleset_name,
            forwarding_rule_name=forwarding_rule_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            if_none_match=if_none_match,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ForwardingRule", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def update(
        self,
        resource_group_name: str,
        dns_forwarding_ruleset_name: str,
        forwarding_rule_name: str,
        parameters: _models.ForwardingRulePatch,
        if_match: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ForwardingRule:
        """Updates a forwarding rule in a DNS forwarding ruleset.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset. Required.
        :type dns_forwarding_ruleset_name: str
        :param forwarding_rule_name: The name of the forwarding rule. Required.
        :type forwarding_rule_name: str
        :param parameters: Parameters supplied to the Update operation. Required.
        :type parameters: ~azure.mgmt.dnsresolver.models.ForwardingRulePatch
        :param if_match: ETag of the resource. Omit this value to always overwrite the current
         resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent
         changes. Default value is None.
        :type if_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ForwardingRule or the result of cls(response)
        :rtype: ~azure.mgmt.dnsresolver.models.ForwardingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def update(
        self,
        resource_group_name: str,
        dns_forwarding_ruleset_name: str,
        forwarding_rule_name: str,
        parameters: IO[bytes],
        if_match: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.ForwardingRule:
        """Updates a forwarding rule in a DNS forwarding ruleset.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset. Required.
        :type dns_forwarding_ruleset_name: str
        :param forwarding_rule_name: The name of the forwarding rule. Required.
        :type forwarding_rule_name: str
        :param parameters: Parameters supplied to the Update operation. Required.
        :type parameters: IO[bytes]
        :param if_match: ETag of the resource. Omit this value to always overwrite the current
         resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent
         changes. Default value is None.
        :type if_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: ForwardingRule or the result of cls(response)
        :rtype: ~azure.mgmt.dnsresolver.models.ForwardingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def update(
        self,
        resource_group_name: str,
        dns_forwarding_ruleset_name: str,
        forwarding_rule_name: str,
        parameters: Union[_models.ForwardingRulePatch, IO[bytes]],
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> _models.ForwardingRule:
        """Updates a forwarding rule in a DNS forwarding ruleset.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset. Required.
        :type dns_forwarding_ruleset_name: str
        :param forwarding_rule_name: The name of the forwarding rule. Required.
        :type forwarding_rule_name: str
        :param parameters: Parameters supplied to the Update operation. Is either a ForwardingRulePatch
         type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.dnsresolver.models.ForwardingRulePatch or IO[bytes]
        :param if_match: ETag of the resource. Omit this value to always overwrite the current
         resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent
         changes. Default value is None.
        :type if_match: str
        :return: ForwardingRule or the result of cls(response)
        :rtype: ~azure.mgmt.dnsresolver.models.ForwardingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ForwardingRule] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "ForwardingRulePatch")

        _request = build_update_request(
            resource_group_name=resource_group_name,
            dns_forwarding_ruleset_name=dns_forwarding_ruleset_name,
            forwarding_rule_name=forwarding_rule_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ForwardingRule", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        dns_forwarding_ruleset_name: str,
        forwarding_rule_name: str,
        if_match: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Deletes a forwarding rule in a DNS forwarding ruleset. WARNING: This operation cannot be
        undone.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset. Required.
        :type dns_forwarding_ruleset_name: str
        :param forwarding_rule_name: The name of the forwarding rule. Required.
        :type forwarding_rule_name: str
        :param if_match: ETag of the resource. Omit this value to always overwrite the current
         resource. Specify the last-seen ETag value to prevent accidentally overwriting any concurrent
         changes. Default value is None.
        :type if_match: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            resource_group_name=resource_group_name,
            dns_forwarding_ruleset_name=dns_forwarding_ruleset_name,
            forwarding_rule_name=forwarding_rule_name,
            subscription_id=self._config.subscription_id,
            if_match=if_match,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def get(
        self, resource_group_name: str, dns_forwarding_ruleset_name: str, forwarding_rule_name: str, **kwargs: Any
    ) -> _models.ForwardingRule:
        """Gets properties of a forwarding rule in a DNS forwarding ruleset.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset. Required.
        :type dns_forwarding_ruleset_name: str
        :param forwarding_rule_name: The name of the forwarding rule. Required.
        :type forwarding_rule_name: str
        :return: ForwardingRule or the result of cls(response)
        :rtype: ~azure.mgmt.dnsresolver.models.ForwardingRule
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ForwardingRule] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            dns_forwarding_ruleset_name=dns_forwarding_ruleset_name,
            forwarding_rule_name=forwarding_rule_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ForwardingRule", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list(
        self, resource_group_name: str, dns_forwarding_ruleset_name: str, top: Optional[int] = None, **kwargs: Any
    ) -> Iterable["_models.ForwardingRule"]:
        """Lists forwarding rules in a DNS forwarding ruleset.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param dns_forwarding_ruleset_name: The name of the DNS forwarding ruleset. Required.
        :type dns_forwarding_ruleset_name: str
        :param top: The maximum number of results to return. If not specified, returns up to 100
         results. Default value is None.
        :type top: int
        :return: An iterator like instance of either ForwardingRule or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.dnsresolver.models.ForwardingRule]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ForwardingRuleListResult] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    resource_group_name=resource_group_name,
                    dns_forwarding_ruleset_name=dns_forwarding_ruleset_name,
                    subscription_id=self._config.subscription_id,
                    top=top,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("ForwardingRuleListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
