---
id: fast-colors
title: fast-colors 
hide_title: false
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->



## Classes

|  Class | Description |
|  --- | --- |
|  [ColorHSL](./fast-colors.colorhsl.md) | This uses Hue values in "degree" format. So expect a range of \[0,360\]. Some other implementations instead uses radians or a normalized Hue with range \[0,1\]. Be aware of this when checking values or using other libraries. |
|  [ColorHSV](./fast-colors.colorhsv.md) | This uses Hue values in "degree" format. So expect a range of \[0,360\]. Some other implementations instead uses radians or a normalized Hue with range \[0,1\]. Be aware of this when checking values or using other libraries. |
|  [ColorLAB](./fast-colors.colorlab.md) | [CIELAB color space](https://en.wikipedia.org/wiki/CIELAB_color_space) This implementation uses the D65 constants for 2 degrees. That determines the constants used for the pure white point of the XYZ space of 0.95047, 1.0, 1.08883. [https://en.wikipedia.org/wiki/Illuminant\_D65](https://en.wikipedia.org/wiki/Illuminant_D65) These constants determine how the XYZ, LCH and LAB colors convert to/from RGB. |
|  [ColorLCH](./fast-colors.colorlch.md) | [CIELCH color space](https://en.wikipedia.org/wiki/CIELAB_color_space)<!-- -->This is a cylindrical representation of the CIELAB space useful for saturation operations This uses Hue values in "degree" format. So expect a range of \[0,360\]. Some other implementations instead uses radians or a normalized Hue with range \[0,1\]. Be aware of this when checking values or using other libraries. This implementation uses the D65 constants for 2 degrees. That determines the constants used for the pure white point of the XYZ space of 0.95047, 1.0, 1.08883. [https://en.wikipedia.org/wiki/Illuminant\_D65](https://en.wikipedia.org/wiki/Illuminant_D65) These constants determine how the XYZ, LCH and LAB colors convert to/from RGB. |
|  [ColorPalette](./fast-colors.colorpalette.md) | Generates a color palette |
|  [ColorRGBA64](./fast-colors.colorrgba64.md) | A RGBA color with 64 bit channels. |
|  [ColorScale](./fast-colors.colorscale.md) | A color scale created from linear stops |
|  [ColorXYZ](./fast-colors.colorxyz.md) | [XYZ color space](https://en.wikipedia.org/wiki/CIE_1931_color_space)<!-- -->This implementation uses the D65 constants for 2 degrees. That determines the constants used for the pure white point of the XYZ space of 0.95047, 1.0, 1.08883. [https://en.wikipedia.org/wiki/Illuminant\_D65](https://en.wikipedia.org/wiki/Illuminant_D65) These constants determine how the XYZ, LCH and LAB colors convert to/from RGB. |
|  [ComponentStateColorPalette](./fast-colors.componentstatecolorpalette.md) | Creates a color palette for UI components |
|  [Histogram](./fast-colors.histogram.md) | For each possible color, this counts how many pixels in the source image match that color. If signifigantBits is less than 8, each channel (eg: red, green, blue) in each color is reduced to fit in significantBits. So for the default value of 5 significantBits colors are reduced from 8 bits per channel (0-255) to 5 (0-31). Colors that were previously distinct get combined together. If the image source has more than 2^32 pixels (eg: a square image 65536x65536 in size) of the same color this code will break. |
|  [ImageDataPixelBlob](./fast-colors.imagedatapixelblob.md) | A [PixelBlob](./fast-colors.pixelblob.md) implementation from an [ImageData](https://developer.mozilla.org/en-US/docs/Web/API/ImageData) object. |
|  [PixelBox](./fast-colors.pixelbox.md) | Represents a range of colors in RGB color space. |

## Enumerations

|  Enumeration | Description |
|  --- | --- |
|  [ColorBlendMode](./fast-colors.colorblendmode.md) | Color blend modes. |
|  [ColorInterpolationSpace](./fast-colors.colorinterpolationspace.md) | Color interpolation spaces |

## Functions

|  Function | Description |
|  --- | --- |
|  [blend(mode, bottom, top)](./fast-colors.blend.md) | Blend two colors. |
|  [blendBurn(bottom, top)](./fast-colors.blendburn.md) | Blends two colors with the burn mode |
|  [blendBurnChannel(bottom, top)](./fast-colors.blendburnchannel.md) |  |
|  [blendColor(bottom, top)](./fast-colors.blendcolor.md) | Blends two colors |
|  [blendDarken(bottom, top)](./fast-colors.blenddarken.md) | Blends two colors with the darken mode |
|  [blendDarkenChannel(bottom, top)](./fast-colors.blenddarkenchannel.md) |  |
|  [blendDodge(bottom, top)](./fast-colors.blenddodge.md) | Blends two colors with the dodge mode |
|  [blendDodgeChannel(bottom, top)](./fast-colors.blenddodgechannel.md) |  |
|  [blendLighten(bottom, top)](./fast-colors.blendlighten.md) | Blends two colors with the lighten mode |
|  [blendLightenChannel(bottom, top)](./fast-colors.blendlightenchannel.md) |  |
|  [blendMultiply(bottom, top)](./fast-colors.blendmultiply.md) | Blends two colors with the multiply mode |
|  [blendMultiplyChannel(bottom, top)](./fast-colors.blendmultiplychannel.md) |  |
|  [blendOverlay(bottom, top)](./fast-colors.blendoverlay.md) | Blends two colors with the overlay mode |
|  [blendOverlayChannel(bottom, top)](./fast-colors.blendoverlaychannel.md) |  |
|  [blendScreen(bottom, top)](./fast-colors.blendscreen.md) | Blends two colors with the screen mode |
|  [blendScreenChannel(bottom, top)](./fast-colors.blendscreenchannel.md) |  |
|  [calculateOverlayColor(rgbMatch, rgbBackground, rgbOverlay)](./fast-colors.calculateoverlaycolor.md) | Calculate an overlay color that uses rgba (rgb + alpha) that matches the appearance of a given solid color when placed on the same background |
|  [centeredRescale(input, config)](./fast-colors.centeredrescale.md) | Takes an input array of colors and extrapolates them to a larger palette. The mapping first takes the input array and extrapolates between each color so that they are separated by spacing-1 slots. Then it adds to either end enough new colors to make up the desired targetSize. All output color slots between the defined stops are interpolated. |
|  [clamp(i, min, max)](./fast-colors.clamp.md) | Ensures that an input number does not exceed a max value and is not less than a min value. |
|  [computeAlphaBlend(bottom, top)](./fast-colors.computealphablend.md) | Alpha channel of bottom is ignored The returned color always has an alpha channel of 1 Different programs (eg: paint.net, photoshop) will give different answers than this occasionally but within +/- 1/255 in each channel. Just depends on the details of how they round off decimals |
|  [contrastRatio(a, b)](./fast-colors.contrastratio.md) | Calculate the contrast ratio between two colors. Uses the formula described by [WCAG 2.0](https://www.w3.org/TR/WCAG20-TECHS/G17.html)<!-- -->. |
|  [darkenViaLAB(input, amount, darkenConstant)](./fast-colors.darkenvialab.md) | Darken a color using LAB color space |
|  [degreesToRadians(i)](./fast-colors.degreestoradians.md) | Converts degrees to radians. |
|  [denormalize(i, min, max)](./fast-colors.denormalize.md) | Scales a number between 0 and 1 |
|  [desaturateViaLCH(input, saturation, saturationConstant)](./fast-colors.desaturatevialch.md) | De-saturate a color using LCH color space |
|  [extractPalette(colors, config)](./fast-colors.extractpalette.md) | Extracts a palette. |
|  [generateOffCenterPalette(input, outputSteps, greyscaleConfig, colorConfig)](./fast-colors.generateoffcenterpalette.md) | Generates a greyscale palette using greyscaleConfig. The Lightness (in HSL) of the input color is then compared to the greyscale palette to determine how far off center the input color should be placed. The output palette is then generated with outputSteps number of steps using colorConfig. |
|  [generateScaledPalettes(input, shortPaletteLength, config)](./fast-colors.generatescaledpalettes.md) | Generates two palettes of length shortPaletteLength and longPaletteLength from a base color. The base color is compared to the default greyscale palette to determine where it should be placed. The short palette is then fed into centeredRescale to create the long palette. The colors in the short palette are always contained within the long. |
|  [getHexStringForByte(i)](./fast-colors.gethexstringforbyte.md) | Converts a number between 0 and 255 to a hex string. |
|  [hslToRGB(hsl, alpha)](./fast-colors.hsltorgb.md) | Converts a [ColorHSL](./fast-colors.colorhsl.md) to a [ColorRGBA64](./fast-colors.colorrgba64.md) |
|  [hsvToRGB(hsv, alpha)](./fast-colors.hsvtorgb.md) | Converts a [ColorHSV](./fast-colors.colorhsv.md) to a [ColorRGBA64](./fast-colors.colorrgba64.md) |
|  [insertIntoSortedList(list, newItem, sortPriority)](./fast-colors.insertintosortedlist.md) | Adds a newItem to an already sorted list without needing to do a full re-sort. Higher sort priority puts the newItem closer to the start (index 0) of the list. |
|  [interpolateByColorSpace(position, space, left, right)](./fast-colors.interpolatebycolorspace.md) | Interpolate by color space |
|  [interpolateHSL(position, left, right)](./fast-colors.interpolatehsl.md) | Interpolate by HSL color space |
|  [interpolateHSV(position, left, right)](./fast-colors.interpolatehsv.md) | Interpolate by HSV color space |
|  [interpolateLAB(position, left, right)](./fast-colors.interpolatelab.md) | Interpolate by LAB color space |
|  [interpolateLCH(position, left, right)](./fast-colors.interpolatelch.md) | Interpolate by LCH color space |
|  [interpolateRGB(position, left, right)](./fast-colors.interpolatergb.md) | Interpolate by RGB color space |
|  [interpolateXYZ(position, left, right)](./fast-colors.interpolatexyz.md) | Interpolate by XYZ color space |
|  [isColorNamed(raw)](./fast-colors.iscolornamed.md) | Tests whether a color is in [NamedColors](./fast-colors.namedcolors.md)<!-- -->. |
|  [isColorStringHexARGB(raw)](./fast-colors.iscolorstringhexargb.md) | Test if a color matches \#AARRGGBB or \#ARGB |
|  [isColorStringHexRGB(raw)](./fast-colors.iscolorstringhexrgb.md) | Test if a color matches \#RRGGBB or \#RGB |
|  [isColorStringHexRGBA(raw)](./fast-colors.iscolorstringhexrgba.md) | Test if a color matches \#RRGGBBAA or \#RGBA |
|  [isColorStringWebRGB(raw)](./fast-colors.iscolorstringwebrgb.md) | Test if a color matches rgb(rr, gg, bb) |
|  [isColorStringWebRGBA(raw)](./fast-colors.iscolorstringwebrgba.md) | Test if a color matches rgba(rr, gg, bb, aa) |
|  [labToLCH(lab)](./fast-colors.labtolch.md) | Converts a [ColorLAB](./fast-colors.colorlab.md) to a [ColorLCH](./fast-colors.colorlch.md) |
|  [labToRGB(lab, alpha)](./fast-colors.labtorgb.md) | Converts a [ColorLAB](./fast-colors.colorlab.md) to a [ColorRGBA64](./fast-colors.colorrgba64.md) |
|  [labToXYZ(lab)](./fast-colors.labtoxyz.md) | Converts a [ColorLAB](./fast-colors.colorlab.md) to a [ColorXYZ](./fast-colors.colorxyz.md) |
|  [lchToLAB(lch)](./fast-colors.lchtolab.md) | Converts a [ColorLCH](./fast-colors.colorlch.md) to a [ColorLAB](./fast-colors.colorlab.md) |
|  [lchToRGB(lch, alpha)](./fast-colors.lchtorgb.md) | Convert a [ColorLCH](./fast-colors.colorlch.md) to a [ColorRGBA64](./fast-colors.colorrgba64.md) |
|  [lerp(i, min, max)](./fast-colors.lerp.md) | Linearly interpolate |
|  [lerpAnglesInDegrees(i, min, max)](./fast-colors.lerpanglesindegrees.md) | Linearly interpolate angles in degrees |
|  [lerpAnglesInRadians(i, min, max)](./fast-colors.lerpanglesinradians.md) | Linearly interpolate angles in radians |
|  [lightenViaLAB(input, amount, darkenConstant)](./fast-colors.lightenvialab.md) | Lighten a color using LAB color space |
|  [loadImageData(source)](./fast-colors.loadimagedata.md) | Creates an HTMLImageElement and loads the source argument as its src. Then an HTMLCanvasElement is created and the image is copied into the canvas. The pixel data is then returned from the CanvasRenderingContext2D for that canvas. |
|  [matchLightnessIndex(input, reference)](./fast-colors.matchlightnessindex.md) | Takes the input color and compares it to each color in the reference array to find the index with the closest Lightness value in HSL color space |
|  [normalize(i, min, max)](./fast-colors.normalize.md) | Scales an input to a number between 0 and 1 |
|  [parseColor(raw)](./fast-colors.parsecolor.md) | Expects any of the following and attempts to determine which is being used \#RRGGBB, \#AARRGGBB, rgb(RR,GG,BB) rgba(RR,GG,BB,a), or any of the [CSS color names](https://www.w3schools.com/colors/colors_names.asp)<!-- -->. |
|  [parseColorHexARGB(raw)](./fast-colors.parsecolorhexargb.md) | Converts a hexadecimal color string to a [ColorRGBA64](./fast-colors.colorrgba64.md)<!-- -->. |
|  [parseColorHexRGB(raw)](./fast-colors.parsecolorhexrgb.md) | Converts a hexadecimal color string to a [ColorRGBA64](./fast-colors.colorrgba64.md)<!-- -->. |
|  [parseColorHexRGBA(raw)](./fast-colors.parsecolorhexrgba.md) | Converts a hexadecimal color string to a [ColorRGBA64](./fast-colors.colorrgba64.md)<!-- -->. |
|  [parseColorNamed(raw)](./fast-colors.parsecolornamed.md) | Converts a named color to a [ColorRGBA64](./fast-colors.colorrgba64.md)<!-- -->. |
|  [parseColorWebRGB(raw)](./fast-colors.parsecolorwebrgb.md) | Converts a rgb color string to a [ColorRGBA64](./fast-colors.colorrgba64.md)<!-- -->. |
|  [parseColorWebRGBA(raw)](./fast-colors.parsecolorwebrgba.md) | Converts a rgba color string to a [ColorRGBA64](./fast-colors.colorrgba64.md)<!-- -->. |
|  [quantize(source, config)](./fast-colors.quantize.md) | The image stored in the source PixelBlob is reduced down to a small set of colors. Based on the Modified Median Cut Quantization implementation from https://github.com/DanBloomberg/leptonica/blob/master/src/colorquant2.c |
|  [quantizeHistogram(histogram, config)](./fast-colors.quantizehistogram.md) | The data in the color histogram is reduced down to a small set of colors. It can be useful to create the Histogram manually in cases where one wants to remove or alter the colors in it or to re-use it in order to quantize multiple times with different config settings. Based on the Modified Median Cut Quantization implementation from https://github.com/DanBloomberg/leptonica/blob/master/src/colorquant2.c |
|  [radiansToDegrees(i)](./fast-colors.radianstodegrees.md) | Converts radians to degrees. |
|  [rescale(input, targetSize, preserveInputColors)](./fast-colors.rescale.md) | Take the input array of colors and extrapolates them to a larger palette of size targetSize. If preserveInputColors is false the input colors are evenly distributed into the output. Otherwise, the positions of the input colors are adjusted from a perfectly even distribution in order to ensure that the exact color values appearing in the input array also appear in the output array. The larger targetSize is compared to input.length the smaller those adjustments will be. |
|  [rgbToHSL(rgb)](./fast-colors.rgbtohsl.md) | Converts a [ColorRGBA64](./fast-colors.colorrgba64.md) to a [ColorHSL](./fast-colors.colorhsl.md) |
|  [rgbToHSV(rgb)](./fast-colors.rgbtohsv.md) | Converts a [ColorRGBA64](./fast-colors.colorrgba64.md) to a [ColorHSV](./fast-colors.colorhsv.md) |
|  [rgbToLAB(rgb)](./fast-colors.rgbtolab.md) | Converts a [ColorRGBA64](./fast-colors.colorrgba64.md) to a [ColorLAB](./fast-colors.colorlab.md) |
|  [rgbToLCH(rgb)](./fast-colors.rgbtolch.md) | Convert a [ColorRGBA64](./fast-colors.colorrgba64.md) to a [ColorLCH](./fast-colors.colorlch.md) |
|  [rgbToLinearLuminance(rgb)](./fast-colors.rgbtolinearluminance.md) | Get the luminance of a color in the linear RGB space. This is not the same as the relative luminance in the sRGB space for WCAG contrast calculations. Use rgbToRelativeLuminance instead. |
|  [rgbToRelativeLuminance(rgb)](./fast-colors.rgbtorelativeluminance.md) | Get the relative luminance of a color. Adjusts the color to sRGB space, which is necessary for the WCAG contrast spec. The alpha channel of the input is ignored. |
|  [rgbToTemperature(rgb)](./fast-colors.rgbtotemperature.md) | Convert a rgb color to a color temperature |
|  [rgbToXYZ(rgb)](./fast-colors.rgbtoxyz.md) | Converts a [ColorRGBA64](./fast-colors.colorrgba64.md) to a [ColorXYZ](./fast-colors.colorxyz.md) |
|  [roundToPrecisionSmall(i, precision)](./fast-colors.roundtoprecisionsmall.md) | Will return infinity if i\*10^(precision) overflows number note that floating point rounding rules come into play here so values that end up rounding on a .5 round to the nearest even not always up so 2.5 rounds to 2 |
|  [saturateViaLCH(input, saturation, saturationConstant)](./fast-colors.saturatevialch.md) | Saturate a color using LCH color space |
|  [temperatureToRGB(tempKelvin, alpha)](./fast-colors.temperaturetorgb.md) | Converts a color temperature to a [ColorRGBA64](./fast-colors.colorrgba64.md) |
|  [xyzToLAB(xyz)](./fast-colors.xyztolab.md) | Converts a [ColorXYZ](./fast-colors.colorxyz.md) to a [ColorLAB](./fast-colors.colorlab.md) |
|  [xyzToRGB(xyz, alpha)](./fast-colors.xyztorgb.md) | Converts a [ColorXYZ](./fast-colors.colorxyz.md) to a [ColorRGBA64](./fast-colors.colorrgba64.md) |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [CenteredRescaleConfig](./fast-colors.centeredrescaleconfig.md) |  |
|  [ColorPaletteConfig](./fast-colors.colorpaletteconfig.md) |  |
|  [ColorRGBA64Config](./fast-colors.colorrgba64config.md) | Configuration object for [ColorRGBA64](./fast-colors.colorrgba64.md) |
|  [ColorScaleStop](./fast-colors.colorscalestop.md) |  |
|  [ComponentStateColorPaletteConfig](./fast-colors.componentstatecolorpaletteconfig.md) | Configuration for [ComponentStateColorPalette](./fast-colors.componentstatecolorpalette.md) |
|  [PaletteEntry](./fast-colors.paletteentry.md) |  |
|  [PaletteEntryConstraint](./fast-colors.paletteentryconstraint.md) |  |
|  [PaletteExtractionConfig](./fast-colors.paletteextractionconfig.md) | Configuration structure for palette extraction. |
|  [PixelBlob](./fast-colors.pixelblob.md) | Represents a blob of pixel data. |
|  [QuantizeConfig](./fast-colors.quantizeconfig.md) | A quantize configuration object. |
|  [QuantizedColor](./fast-colors.quantizedcolor.md) | A quantized color |

## Variables

|  Variable | Description |
|  --- | --- |
|  [defaultCenteredRescaleConfig](./fast-colors.defaultcenteredrescaleconfig.md) |  |
|  [defaultPaletteExtractionConfig](./fast-colors.defaultpaletteextractionconfig.md) | The default configuration for palette extraction. |
|  [defaultQuantizeConfig](./fast-colors.defaultquantizeconfig.md) | The default quantize configuration. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [NamedColors](./fast-colors.namedcolors.md) | Browser [named colors](https://www.w3schools.com/colors/colors_names.asp)<!-- -->. |
