/*************************************************************************
* Copyright (C) 2018 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

/*
//     Intel(R) Cryptography Primitives Library
//     Operations over GF(p).
//
//     Context:
//        ippsGFpAdd()
//
*/
#include "owndefs.h"
#include "owncp.h"

#include "gfpec/pcpgfpstuff.h"
#include "gfpec/pcpgfpxstuff.h"
#include "pcptool.h"


/*F*
// Name: ippsGFpAdd
//
// Purpose: Sum of GF elements
//
// Returns:                   Reason:
//    ippStsNullPtrErr              NULL == pGFp
//                                  NULL == pA
//                                  NULL == pR
//                                  NULL == pB
//
//    ippStsContextMatchErr         invalid pGFp->idCtx
//                                  invalid pA->idCtx
//                                  invalid pR->idCtx
//                                  invalid pB->idCtx
//
//    ippStsOutOfRangeErr           GFPE_ROOM() != GFP_FELEN()
//
//    ippStsNoErr                   no error
//
// Parameters:
//    pA         Pointer to the context of the first finite field element.
//    pB         Pointer to the context of the second finite field element.
//    pR         Pointer to the context of the result finite field element.
//    pGFp       Pointer to the context of the finite field.
//
*F*/

/* clang-format off */
IPPFUN(IppStatus, ippsGFpAdd, (const IppsGFpElement* pA,
                               const IppsGFpElement* pB,
                               IppsGFpElement* pR,
                               IppsGFpState* pGFp))
/* clang-format on */
{
    IPP_BAD_PTR4_RET(pA, pB, pR, pGFp);
    IPP_BADARG_RET(!GFP_VALID_ID(pGFp), ippStsContextMatchErr);
    IPP_BADARG_RET(!GFPE_VALID_ID(pA), ippStsContextMatchErr);
    IPP_BADARG_RET(!GFPE_VALID_ID(pB), ippStsContextMatchErr);
    IPP_BADARG_RET(!GFPE_VALID_ID(pR), ippStsContextMatchErr);
    {
        gsModEngine* pGFE = GFP_PMA(pGFp);
        IPP_BADARG_RET((GFPE_ROOM(pA) != GFP_FELEN(pGFE)) || (GFPE_ROOM(pB) != GFP_FELEN(pGFE)) ||
                           (GFPE_ROOM(pR) != GFP_FELEN(pGFE)),
                       ippStsOutOfRangeErr);

        GFP_METHOD(pGFE)->add(GFPE_DATA(pR), GFPE_DATA(pA), GFPE_DATA(pB), pGFE);
        return ippStsNoErr;
    }
}
