//
// The Fontaine Font Analysis Project 
// 
// Copyright (c) 2009 by Edward H. Trager
// All Rights Reserved
// 
// Released under the GNU GPL version 2.0 or later.
//     


//
// HKSCS.h
//

#ifndef ORTHOGRAPHY_DATA
#include "../OrthographyData.h"
#endif

#ifndef HKSCS
#define HKSCS

namespace HongKongSupplementaryCharacterSet{

//
// Unicode values : For 1693 characters in the supplemental plane.
//                  Characters in HKSCS which are also in BMP are
//                  not included.
//                  
// Reference: http://www.ogcio.gov.hk/ccli/eng/hkscs/introduction.html
//                  
UINT32 values[]={
	0x27267,
	0x27CB1,
	0x27CC5,
	0x242BF,
	0x23617,
	0x27352,
	0x26E8B,
	0x270D2,
	0x2A351,
	0x27C6C,
	0x26B23,
	0x25A54,
	0x21A63,
	0x23E06,
	0x23F61,
	0x28BB9,
	0x27BEF,
	0x21D5E,
	0x29EB0,
	0x29945,
	0x2010C,
	0x200D1,
	0x200CD,
	0x200CB,
	0x21FE8,
	0x200CA,
	0x2010E,
	0x2A3A9,
	0x21145,
	0x27735,
	0x209E7,
	0x29DF6,
	0x2700E,
	0x2A133,
	0x2846C,
	0x21DCA,
	0x205D0,
	0x22AE6,
	0x27D84,
	0x20C42,
	0x20D15,
	0x2512B,
	0x22CC6,
	0x20341,
	0x24DB8,
	0x294E5,
	0x280BE,
	0x22C38,
	0x2815D,
	0x269F2,
	0x24DEA,
	0x20D7C,
	0x20FB4,
	0x20CD5,
	0x210F4,
	0x20E96,
	0x20C0B,
	0x20F64,
	0x22CA9,
	0x28256,
	0x244D3,
	0x20D46,
	0x29A4D,
	0x280E9,
	0x24EA7,
	0x22CC2,
	0x295F4,
	0x252C7,
	0x297D4,
	0x278C8,
	0x22D44,
	0x260A5,
	0x22D4C,
	0x22BCA,
	0x21077,
	0x2106F,
	0x266DA,
	0x26716,
	0x279A0,
	0x25052,
	0x20C43,
	0x221A1,
	0x28B4C,
	0x20731,
	0x201A9,
	0x22D8D,
	0x245C8,
	0x204FC,
	0x26097,
	0x20F4C,
	0x20D96,
	0x22A66,
	0x2109D,
	0x20D9C,
	0x22775,
	0x2A601,
	0x20E09,
	0x22ACF,
	0x22CC9,
	0x210C8,
	0x239C2,
	0x2829B,
	0x25E49,
	0x220C7,
	0x20F31,
	0x22CB2,
	0x29720,
	0x24E3B,
	0x27574,
	0x22E8B,
	0x22208,
	0x2A65B,
	0x28CCD,
	0x20E7A,
	0x20C34,
	0x2681C,
	0x210CF,
	0x22803,
	0x22939,
	0x251E3,
	0x20E8C,
	0x20F8D,
	0x20EAA,
	0x20F30,
	0x20D47,
	0x2114F,
	0x20E4C,
	0x20EAB,
	0x20BA9,
	0x20D48,
	0x210C0,
	0x2113D,
	0x22696,
	0x20FAD,
	0x233F4,
	0x27639,
	0x22BCE,
	0x20D7E,
	0x20D7F,
	0x22C51,
	0x22C55,
	0x20E98,
	0x210C7,
	0x20F2E,
	0x2A632,
	0x26B50,
	0x28CD2,
	0x28D99,
	0x28CCA,
	0x29EC3,
	0x2775E,
	0x22DEE,
	0x26572,
	0x280BD,
	0x20EFA,
	0x20E0F,
	0x20E77,
	0x20EFB,
	0x24DEB,
	0x20CD6,
	0x227B5,
	0x210C9,
	0x20E10,
	0x20E78,
	0x21078,
	0x21148,
	0x28207,
	0x21455,
	0x20E79,
	0x24E50,
	0x22DA4,
	0x2101D,
	0x2101E,
	0x210F5,
	0x210F6,
	0x20E11,
	0x27694,
	0x282CD,
	0x20FB5,
	0x20E7B,
	0x2517E,
	0x20FB6,
	0x21180,
	0x252D8,
	0x2A2BD,
	0x249DA,
	0x2183A,
	0x24177,
	0x2827C,
	0x2573D,
	0x25B74,
	0x2313D,
	0x21BC1,
	0x2F878,
	0x20086,
	0x248E9,
	0x2626A,
	0x2634B,
	0x26612,
	0x26951,
	0x278B2,
	0x28E0F,
	0x29810,
	0x20087,
	0x29C73,
	0x2414E,
	0x251CD,
	0x25D30,
	0x28A32,
	0x23281,
	0x2A107,
	0x21980,
	0x2870F,
	0x2A2BA,
	0x20A6F,
	0x29947,
	0x28AEA,
	0x2207E,
	0x289E3,
	0x21DB6,
	0x22712,
	0x233F9,
	0x23C63,
	0x24505,
	0x24A13,
	0x25CA4,
	0x25695,
	0x28DB9,
	0x2143F,
	0x2497B,
	0x2710D,
	0x26D74,
	0x26B15,
	0x26FBE,
	0x23256,
	0x22796,
	0x23B1A,
	0x23551,
	0x240EC,
	0x21E23,
	0x201A4,
	0x26C41,
	0x20239,
	0x298FA,
	0x20B9F,
	0x221C1,
	0x2896D,
	0x29079,
	0x2A1B5,
	0x26C46,
	0x286B2,
	0x273FF,
	0x2549A,
	0x24B0F,
	0x289C0,
	0x23F41,
	0x20325,
	0x20ED8,
	0x23ED7,
	0x26ED3,
	0x257E0,
	0x28BE9,
	0x258E1,
	0x294D9,
	0x259AC,
	0x2648D,
	0x25C01,
	0x2530E,
	0x25CFE,
	0x25BB4,
	0x26C7F,
	0x25D20,
	0x25C65,
	0x25CC1,
	0x24882,
	0x24578,
	0x26E44,
	0x26ED6,
	0x24057,
	0x26029,
	0x217F9,
	0x2836D,
	0x26121,
	0x2615A,
	0x262D0,
	0x26351,
	0x21661,
	0x20068,
	0x23766,
	0x2833A,
	0x26489,
	0x2A087,
	0x26CC3,
	0x22714,
	0x26626,
	0x23DE3,
	0x266E8,
	0x28A48,
	0x226F6,
	0x26498,
	0x24FB8,
	0x2148A,
	0x2185E,
	0x24A65,
	0x24A95,
	0x20B0D,
	0x26A52,
	0x23D7E,
	0x214FD,
	0x26B0A,
	0x249A7,
	0x23530,
	0x21773,
	0x23DF8,
	0x2F994,
	0x20E16,
	0x217B4,
	0x2317D,
	0x2355A,
	0x23E8B,
	0x26DA3,
	0x26B05,
	0x26B97,
	0x235CE,
	0x26DA5,
	0x26ED4,
	0x26E42,
	0x22EEF,
	0x25BE4,
	0x23CB5,
	0x26B96,
	0x26E77,
	0x26E43,
	0x25C91,
	0x25CC0,
	0x26E99,
	0x28625,
	0x2863B,
	0x27088,
	0x21582,
	0x270CD,
	0x2F9B2,
	0x218A2,
	0x2739A,
	0x2A0F8,
	0x22C27,
	0x275E0,
	0x23DB9,
	0x275E4,
	0x2770F,
	0x28A25,
	0x27924,
	0x27ABD,
	0x27A59,
	0x27B3A,
	0x23F8F,
	0x27B38,
	0x25430,
	0x25565,
	0x24A7A,
	0x216DF,
	0x27D54,
	0x27D8F,
	0x2F9D4,
	0x27D53,
	0x27D98,
	0x27DBD,
	0x21910,
	0x24CC9,
	0x28002,
	0x21014,
	0x2498A,
	0x281BC,
	0x2710C,
	0x28365,
	0x28412,
	0x2A29F,
	0x20A50,
	0x289DE,
	0x2853D,
	0x23DBB,
	0x23262,
	0x2A014,
	0x286BC,
	0x28501,
	0x22325,
	0x26ED7,
	0x2853C,
	0x27ABE,
	0x2856C,
	0x2860B,
	0x28713,
	0x286E6,
	0x28933,
	0x21E89,
	0x255B9,
	0x28AC6,
	0x23C9B,
	0x28B0C,
	0x255DB,
	0x20D31,
	0x28AE1,
	0x28BEB,
	0x28AE2,
	0x28AE5,
	0x28BEC,
	0x28C39,
	0x28BFF,
	0x2267A,
	0x286D8,
	0x2127C,
	0x23E2E,
	0x26ED5,
	0x28AE0,
	0x26CB8,
	0x20274,
	0x26410,
	0x290AF,
	0x290E5,
	0x24AD1,
	0x21915,
	0x2330A,
	0x24AE9,
	0x291D5,
	0x291EB,
	0x230B7,
	0x230BC,
	0x2546C,
	0x29433,
	0x2941D,
	0x2797A,
	0x27175,
	0x20630,
	0x2415C,
	0x25706,
	0x26D27,
	0x216D3,
	0x24A29,
	0x29857,
	0x29905,
	0x25725,
	0x290B1,
	0x29BD5,
	0x29B05,
	0x28600,
	0x269A8,
	0x2307D,
	0x29D3E,
	0x21863,
	0x2424B,
	0x29E68,
	0x29FB7,
	0x2A192,
	0x2A1AB,
	0x2A0E1,
	0x2A123,
	0x2A1DF,
	0x2A134,
	0x2215B,
	0x2A193,
	0x2A220,
	0x2193B,
	0x2A233,
	0x2A0B9,
	0x2A2B4,
	0x24364,
	0x28C2B,
	0x26DA2,
	0x2908B,
	0x24975,
	0x249BB,
	0x249F8,
	0x24348,
	0x24A51,
	0x28BDA,
	0x218FA,
	0x2897E,
	0x28E36,
	0x28A44,
	0x2896C,
	0x244B9,
	0x24473,
	0x243F8,
	0x217EF,
	0x218BE,
	0x23599,
	0x21885,
	0x2542F,
	0x217F8,
	0x216FB,
	0x21839,
	0x21774,
	0x218D1,
	0x25F4B,
	0x216C0,
	0x24A25,
	0x213FE,
	0x212A8,
	0x213C6,
	0x214B6,
	0x236A6,
	0x24994,
	0x27165,
	0x23E31,
	0x2555C,
	0x23EFB,
	0x27052,
	0x236EE,
	0x2999D,
	0x26F26,
	0x21922,
	0x2373F,
	0x240E1,
	0x2408B,
	0x2410F,
	0x26C21,
	0x266B1,
	0x20FDF,
	0x20BA8,
	0x20E0D,
	0x28B13,
	0x24436,
	0x20465,
	0x2037F,
	0x25651,
	0x201AB,
	0x203CB,
	0x2030A,
	0x20414,
	0x202C0,
	0x28EB3,
	0x20275,
	0x2020C,
	0x24A0E,
	0x23E8A,
	0x23595,
	0x23E39,
	0x23EBF,
	0x21884,
	0x23E89,
	0x205E0,
	0x204A3,
	0x20492,
	0x20491,
	0x28A9C,
	0x2070E,
	0x20873,
	0x2438C,
	0x20C20,
	0x249AC,
	0x210E4,
	0x20E1D,
	0x24ABC,
	0x2408D,
	0x240C9,
	0x20345,
	0x20BC6,
	0x28A46,
	0x216FA,
	0x2176F,
	0x21710,
	0x25946,
	0x219F3,
	0x21861,
	0x24295,
	0x25E83,
	0x28BD7,
	0x20413,
	0x21303,
	0x289FB,
	0x21996,
	0x2197C,
	0x23AEE,
	0x21903,
	0x21904,
	0x218A0,
	0x216FE,
	0x28A47,
	0x21DBA,
	0x23472,
	0x289A8,
	0x21927,
	0x217AB,
	0x2173B,
	0x275FD,
	0x22860,
	0x2262B,
	0x225AF,
	0x225BE,
	0x29088,
	0x26F73,
	0x2003E,
	0x20046,
	0x2261B,
	0x22C9B,
	0x22D07,
	0x246D4,
	0x2914D,
	0x24665,
	0x22B6A,
	0x22B22,
	0x23450,
	0x298EA,
	0x22E78,
	0x2A45B,
	0x249E3,
	0x22D67,
	0x22CA1,
	0x2308E,
	0x232AD,
	0x24989,
	0x232AB,
	0x232E0,
	0x218D9,
	0x2943F,
	0x23289,
	0x231B3,
	0x25584,
	0x28B22,
	0x2558F,
	0x216FC,
	0x2555B,
	0x25425,
	0x23103,
	0x2182A,
	0x23234,
	0x2320F,
	0x23182,
	0x242C9,
	0x26D24,
	0x27870,
	0x21DEB,
	0x232D2,
	0x232E1,
	0x25872,
	0x2383A,
	0x237BC,
	0x237A2,
	0x233FE,
	0x2462A,
	0x237D5,
	0x24487,
	0x21912,
	0x23FC0,
	0x23C9A,
	0x28BEA,
	0x28ACB,
	0x2801E,
	0x289DC,
	0x249EC,
	0x23F7F,
	0x2403C,
	0x2431A,
	0x24276,
	0x2478F,
	0x24725,
	0x24AA4,
	0x205EB,
	0x23EF8,
	0x2365F,
	0x24A4A,
	0x24917,
	0x25FE1,
	0x24ADF,
	0x28C23,
	0x23F35,
	0x26DEA,
	0x24CD9,
	0x24D06,
	0x2A5C6,
	0x28ACC,
	0x249AB,
	0x2498E,
	0x24A4E,
	0x249C5,
	0x248F3,
	0x28AE3,
	0x21864,
	0x25221,
	0x251E7,
	0x23232,
	0x24697,
	0x23781,
	0x248F0,
	0x24ABA,
	0x24AC7,
	0x24A96,
	0x261AE,
	0x25581,
	0x27741,
	0x256E3,
	0x23EFA,
	0x216E6,
	0x20D4C,
	0x2498C,
	0x20299,
	0x23DBA,
	0x2176E,
	0x201D4,
	0x20C0D,
	0x226F5,
	0x25AAF,
	0x25A9C,
	0x2025B,
	0x25BC6,
	0x25BB3,
	0x25EBC,
	0x25EA6,
	0x249F9,
	0x217B0,
	0x26261,
	0x2615C,
	0x27B48,
	0x25E82,
	0x26B75,
	0x20916,
	0x2004E,
	0x235CF,
	0x26412,
	0x263F8,
	0x24962,
	0x2082C,
	0x25AE9,
	0x25D43,
	0x25E0E,
	0x2343F,
	0x249F7,
	0x265AD,
	0x265A0,
	0x27127,
	0x26CD1,
	0x267B4,
	0x26A42,
	0x26A51,
	0x26DA7,
	0x2721B,
	0x21840,
	0x218A1,
	0x218D8,
	0x2F9BC,
	0x23D8F,
	0x27422,
	0x25683,
	0x27785,
	0x27784,
	0x28BF5,
	0x28BD9,
	0x28B9C,
	0x289F9,
	0x29448,
	0x24284,
	0x21845,
	0x27DDC,
	0x24C09,
	0x22321,
	0x217DA,
	0x2492F,
	0x28A4B,
	0x28AFC,
	0x28C1D,
	0x28C3B,
	0x28D34,
	0x248FF,
	0x24A42,
	0x243EA,
	0x23225,
	0x28EE7,
	0x28E66,
	0x28E65,
	0x249ED,
	0x24A78,
	0x23FEE,
	0x290B0,
	0x29093,
	0x257DF,
	0x28989,
	0x28C26,
	0x28B2F,
	0x263BE,
	0x2421B,
	0x20F26,
	0x28BC5,
	0x24AB2,
	0x294DA,
	0x295D7,
	0x28B50,
	0x24A67,
	0x28B64,
	0x28A45,
	0x27B06,
	0x28B65,
	0x258C8,
	0x298F1,
	0x29948,
	0x21302,
	0x249B8,
	0x214E8,
	0x2271F,
	0x23DB8,
	0x22781,
	0x2296B,
	0x29E2D,
	0x2A1F5,
	0x2A0FE,
	0x24104,
	0x2A1B4,
	0x2A0ED,
	0x2A0F3,
	0x2992F,
	0x26E12,
	0x26FDF,
	0x26B82,
	0x26DA4,
	0x26E84,
	0x26DF0,
	0x26E00,
	0x237D7,
	0x26064,
	0x2359C,
	0x23640,
	0x249DE,
	0x202BF,
	0x2555D,
	0x21757,
	0x231C9,
	0x24941,
	0x241B5,
	0x241AC,
	0x26C40,
	0x24F97,
	0x217B5,
	0x28A49,
	0x24488,
	0x289FC,
	0x218D6,
	0x20F1D,
	0x26CC0,
	0x21413,
	0x242FA,
	0x22C26,
	0x243C1,
	0x23DB7,
	0x26741,
	0x2615B,
	0x260A4,
	0x249B9,
	0x2498B,
	0x289FA,
	0x28B63,
	0x2189F,
	0x24AB3,
	0x24A3E,
	0x24A94,
	0x217D9,
	0x24A66,
	0x203A7,
	0x21424,
	0x249E5,
	0x24916,
	0x24976,
	0x204FE,
	0x28ACE,
	0x28A16,
	0x28BE7,
	0x255D5,
	0x28A82,
	0x24943,
	0x20CFF,
	0x2061A,
	0x20BEB,
	0x20CB8,
	0x217FA,
	0x216C2,
	0x24A50,
	0x21852,
	0x28AC0,
	0x249AD,
	0x218BF,
	0x21883,
	0x27484,
	0x23D5B,
	0x28A81,
	0x21862,
	0x20AB4,
	0x2139C,
	0x28218,
	0x290E4,
	0x27E4F,
	0x23FED,
	0x23E2D,
	0x203F5,
	0x28C1C,
	0x26BC0,
	0x21452,
	0x24362,
	0x24A71,
	0x22FE3,
	0x212B0,
	0x223BD,
	0x21398,
	0x234E5,
	0x27BF4,
	0x236DF,
	0x28A83,
	0x237D6,
	0x233FA,
	0x24C9F,
	0x236AD,
	0x26CB7,
	0x26D26,
	0x26D51,
	0x26C82,
	0x26FDE,
	0x27109,
	0x2173A,
	0x26C80,
	0x27053,
	0x217DB,
	0x217B3,
	0x21905,
	0x241FC,
	0x2173C,
	0x242A5,
	0x24293,
	0x23EF9,
	0x27736,
	0x2445B,
	0x242CA,
	0x24259,
	0x289E1,
	0x26D28,
	0x244CE,
	0x27E4D,
	0x243BD,
	0x24256,
	0x21304,
	0x243E9,
	0x2F825,
	0x24A4F,
	0x24A5D,
	0x217DF,
	0x23AFA,
	0x23300,
	0x20214,
	0x208D5,
	0x20619,
	0x21F9E,
	0x2A2B6,
	0x2915B,
	0x28A59,
	0x29420,
	0x27AF4,
	0x256F6,
	0x27B18,
	0x248F2,
	0x24F5C,
	0x25535,
	0x20CCF,
	0x27967,
	0x21BC2,
	0x20094,
	0x202B7,
	0x203A0,
	0x204D7,
	0x205D5,
	0x20615,
	0x20676,
	0x216BA,
	0x20AC2,
	0x20ACD,
	0x20BBF,
	0x2F83B,
	0x20BCB,
	0x20BFB,
	0x20C3B,
	0x20C53,
	0x20C65,
	0x20C7C,
	0x20C8D,
	0x20CB5,
	0x20CDD,
	0x20CED,
	0x20D6F,
	0x20DB2,
	0x20DC8,
	0x20E04,
	0x20E0E,
	0x20ED7,
	0x20F90,
	0x20F2D,
	0x20E73,
	0x20FBC,
	0x2105C,
	0x2104F,
	0x21076,
	0x2107B,
	0x21088,
	0x21096,
	0x210BF,
	0x210D3,
	0x2112F,
	0x2113B,
	0x212E3,
	0x21375,
	0x21336,
	0x21577,
	0x21619,
	0x217C3,
	0x217C7,
	0x2182D,
	0x2196A,
	0x21A2D,
	0x21A45,
	0x21C2A,
	0x21C70,
	0x21CAC,
	0x21EC8,
	0x21ED5,
	0x21F15,
	0x22045,
	0x2227C,
	0x223D7,
	0x223FA,
	0x2272A,
	0x22871,
	0x2294F,
	0x22967,
	0x22993,
	0x22AD5,
	0x22AE8,
	0x22B0E,
	0x22B3F,
	0x22C4C,
	0x22C88,
	0x22CB7,
	0x25BE8,
	0x22D08,
	0x22D12,
	0x22DB7,
	0x22D95,
	0x22E42,
	0x22F74,
	0x22FCC,
	0x23033,
	0x23066,
	0x2331F,
	0x233DE,
	0x27A79,
	0x23567,
	0x235F3,
	0x249BA,
	0x2361A,
	0x23716,
	0x20346,
	0x23AA7,
	0x27657,
	0x25FE2,
	0x23E11,
	0x23EB9,
	0x275FE,
	0x2209A,
	0x24119,
	0x28A9A,
	0x242EE,
	0x2430D,
	0x2403B,
	0x24334,
	0x24396,
	0x24A45,
	0x205CA,
	0x20611,
	0x21EA8,
	0x23CFF,
	0x24404,
	0x244D6,
	0x24674,
	0x2472F,
	0x285E8,
	0x299C9,
	0x221C3,
	0x28B4E,
	0x24812,
	0x248FB,
	0x24A15,
	0x24AC0,
	0x20C78,
	0x24EA5,
	0x24F86,
	0x20779,
	0x2502C,
	0x25299,
	0x25419,
	0x23F4A,
	0x24AA7,
	0x25446,
	0x2546E,
	0x26B52,
	0x2553F,
	0x27632,
	0x2555E,
	0x25562,
	0x25566,
	0x257C7,
	0x2493F,
	0x2585D,
	0x233CC,
	0x25903,
	0x28948,
	0x25AAE,
	0x25B89,
	0x25C06,
	0x21D90,
	0x26102,
	0x27C12,
	0x261B2,
	0x24F9A,
	0x26402,
	0x2644A,
	0x26BF7,
	0x26484,
	0x2191C,
	0x249F6,
	0x26488,
	0x23FEF,
	0x26512,
	0x265BF,
	0x266B5,
	0x2271B,
	0x257E1,
	0x2F8CD,
	0x24521,
	0x266FC,
	0x24934,
	0x26CBD,
	0x26799,
	0x2686E,
	0x26411,
	0x2685E,
	0x268C7,
	0x290C0,
	0x20A11,
	0x26926,
	0x26939,
	0x269FA,
	0x26A2D,
	0x26469,
	0x20021,
	0x26A34,
	0x26B5B,
	0x23519,
	0x26B9D,
	0x26CA4,
	0x26DAE,
	0x2258D,
	0x2704B,
	0x271CD,
	0x27280,
	0x27285,
	0x2217A,
	0x2728B,
	0x272E6,
	0x249D0,
	0x27450,
	0x20EF8,
	0x22926,
	0x28473,
	0x217B1,
	0x24A2A,
	0x21820,
	0x29CAD,
	0x298A4,
	0x277CC,
	0x27858,
	0x2160A,
	0x2372F,
	0x280E8,
	0x213C5,
	0x279DD,
	0x291A8,
	0x270AF,
	0x289AB,
	0x279FD,
	0x27A0A,
	0x27B0B,
	0x27D66,
	0x2417A,
	0x28009,
	0x2A2DF,
	0x28318,
	0x26E07,
	0x2816F,
	0x28023,
	0x269B5,
	0x213ED,
	0x2322F,
	0x28048,
	0x28C30,
	0x28083,
	0x28949,
	0x24988,
	0x24AA5,
	0x23F81,
	0x28090,
	0x280F4,
	0x2812E,
	0x21FA1,
	0x2814F,
	0x28189,
	0x281AF,
	0x2821A,
	0x28306,
	0x2832F,
	0x2838A,
	0x28468,
	0x286AA,
	0x28956,
	0x289B8,
	0x289E7,
	0x289E8,
	0x28B46,
	0x28BD4,
	0x28C09,
	0x28FC5,
	0x290EC,
	0x29110,
	0x2913C,
	0x2915E,
	0x24ACA,
	0x294E7,
	0x295E9,
	0x295B0,
	0x295B8,
	0x29732,
	0x298D1,
	0x29949,
	0x2996A,
	0x299C3,
	0x29A28,
	0x29B0E,
	0x29D5A,
	0x29D9B,
	0x29EF8,
	0x29F23,
	0x2A293,
	0x2A2FF,
	0x2A5CB,
	0x20C9C,
	0x224B0,
	0x24A93,
	0x28B2C,
	0x2789D,
	0x217F5,
	0x28024,
	0x28B6C,
	0x28B99,
	0x27A3E,
	0x266AF,
	0x27655,
	0x23CB7,
	0x25635,
	0x25956,
	0x25E81,
	0x26258,
	0x20E6D,
	0x23E88,
	0x24C9E,
	0x217F6,
	0x2187B,
	0x25C4A,
	0x25311,
	0x29D98,
	0x25ED8,
	0x23D40,
	0x20FEA,
	0x20D49,
	0x236BA,
	0x20E9D,
	0x282E2,
	0x20C41,
	0x20C96,
	0x25148,
	0x20E76,
	0x22C62,
	0x20EA2,
	0x21075,
	0x22B43,
	0x22EB3,
	0x20DA7,
	0x2688A,
	0x210C1,
	0x24706,
	0x26893,
	0x226F4,
	0x27D2F,
	0x241A3,
	0x27D73,
	0x26ED0,
	0x272B6,
	0x211D9,
	0x23CFC,
	0x2A6A9,
	0x20EAC,
	0x20EF9,
	0x21CA2,
	0x24FC2,
	0x27FF9,
	0x20FEB,
	0x22DA0,
	0x247E0,
	0x29D7C,
	0x20FEC,
	0x20E0A,
	0x275A3,
	0x20FED,
	0x26048,
	0x21187,
	0x24618,
	0x24B6E,
	0x25A95,
	0x20979,
	0x22465,
	0x29EAC,
	0x23CFE,
	0x29F30,
	0x24FA9,
	0x2959E,
	0x29FDE,
	0x23DB6,
	0x272B2,
	0x267B3,
	0x23720,
	0x23EF7,
	0x23E2C,
	0x2048E,
	0x20EB6,
	0x27F2E,
	0x2A434,
	0x230DA,
	0x243F2,
	0x212A9,
	0x24963,
	0x29E06,
	0x270AE,
	0x2176C,
	0x294D0,
	0x26335,
	0x27164,
	0x20D28,
	0x26D22,
	0x24AE2,
	0x20D71,
	0x21F0F,
	0x21DD1,
	0x2493E,
	0x2176D,
	0x28E97,
	0x26D23,
	0x203FC,
	0x25C21,
	0x23CFD,
	0x24919,
	0x20CD4,
	0x201F2,
	0x2A64A,
	0x2837D,
	0x24A77,
	0x28A5A,
	0x2A2B2,
	0x2F840,
	0x24ABB,
	0x2183B,
	0x26E05,
	0x2251B,
	0x26159,
	0x233F5,
	0x28BC2,
	0x28E39,
	0x21D46,
	0x20F3B,
	0x25F1A,
	0x27486,
	0x267CC,
	0x26ED1,
	0x24011,
	0x28B2D,
	0x23CC7,
	0x25ED7,
	0x27656,
	0x25531,
	0x21944,
	0x212FE,
	0x29903,
	0x26DDC,
	0x270AD,
	0x261AD,
	0x28A0F,
	0x23677,
	0x200EE,
	0x26846,
	0x24F0E,
	0x2634C,
	0x2626B,
	0x200CC,
	0x2008A,
	0x27607,
	0x20547,
	0x205DF,
	0x23FC5,
	0x24942,
	0x289E4,
	0x219DB,
	0x23CC8,
	0x24933,
	0x289AA,
	0x202A0,
	0x26BB3,
	0x21305,
	0x224ED,
	0x26D29,
	0x27A84,
	0x23600,
	0x24AB1,
	0x22513,
	0x2037E,
	0x20380,
	0x20347,
	0x2041F,
	0x249A4,
	0x20487,
	0x233B4,
	0x20BFF,
	0x220FC,
	0x202E5,
	0x22530,
	0x2058E,
	0x23233,
	0x21983,
	0x205B3,
	0x23C99,
	0x24AA6,
	0x2372D,
	0x26B13,
	0x28ADE,
	0x23F80,
	0x20954,
	0x23FEC,
	0x20BE2,
	0x21726,
	0x216E8,
	0x286AB,
	0x21596,
	0x21613,
	0x28A9B,
	0x25772,
	0x20B8F,
	0x23FEB,
	0x22DA3,
	0x20C77,
	0x26B53,
	0x20D74,
	0x2170D,
	0x20EDD,
	0x20D4D,
	0x289BC,
	0x22698,
	0x218D7,
	0x2403A,
	0x24435,
	0x210B4,
	0x2328A,
	0x28B66,
	0x2124F,
	0x241A5,
	0x26C7E,
	0x21416,
	0x21454,
	0x24363,
	0x24BF5,
	0x2123C,
	0x2A150,
	0x24278,
	0x2163E,
	0x21692,
	0x20D4E,
	0x26C81,
	0x26D2A,
	0x217DC,
	0x217FB,
	0x217B2,
	0x26DA6,
	0x21828,
	0x216D5,
	0x26E45,
	0x249A9,
	0x26FA1,
	0x22554,
	0x21911,
	0x216B8,
	0x27A0E,
	0x20204,
	0x21A34,
	0x259CC,
	0x205A5,
	0x21B44,
	0x21CA5,
	0x26B28,
	0x21DF9,
	0x21E37,
	0x21EA4,
	0x24901,
	0x22049,
	0x22173,
	0x244BC,
	0x20CD3,
	0x21771,
	0x28482,
	0x201C1,
	0x2F894,
	0x2133A,
	0x26888,
	0x223D0,
	0x22471,
	0x26E6E,
	0x28A36,
	0x25250,
	0x21F6A,
	0x270F8,
	0x22668,
	0x2029E,
	0x28A29,
	0x21877,
	0x227B4,
	0x24982,
	0x2498F,
	0x27A53,
	0x2F8A6,
	0x26ED2,
	0x20656,
	0x23FB7,
	0x2285F,
	0x28B9D,
	0x2995D,
	0x22980,
	0x228C1,
	0x20118,
	0x21770,
	0x22E0D,
	0x249DF,
	0x2138E,
	0x217FC,
	0x22E36,
	0x2408C,
	0x2571D,
	0x24A28,
	0x24A23,
	0x2307E,
	0x24940,
	0x21829,
	0x23400,
	0x231F7,
	0x231F8,
	0x231A4,
	0x231A5,
	0x20E75,
	0x251E6,
	0x21E3D,
	0x23231,
	0x285F4,
	0x231C8,
	0x25313,
	0x228F7,
	0x2439C,
	0x24A21,
	0x237C2,
	0x241CD,
	0x290ED,
	0x233E6,
	0x26DA0,
	0x2346F,
	0x28ADF,
	0x235CD,
	0x2363C,
	0x28A4A,
	0x203C9,
	0x23659,
	0x2212A,
	0x23703,
	0x2919C,
	0x20923,
	0x227CD,
	0x23ADB,
	0x203B5,
	0x21958,
	0x23B5A,
	0x23EFC,
	0x2248B,
	0x248F1,
	0x26B51,
	0x23DBC,
	0x23DBD,
	0x241A4,
	0x2490C,
	0x24900,
	0x23CC9,
	0x20D32,
	0x231F9,
	0x22491,
	0x26D25,
	0x26DA1,
	0x26DEB,
	0x2497F,
	0x24085,
	0x26E72,
	0x26F74,
	0x28B21,
	0x23E2F,
	0x23F82,
	0x2304B,
	0x23E30,
	0x21497,
	0x2403D,
	0x29170,
	0x24144,
	0x24091,
	0x24155,
	0x24039,
	0x23FF0,
	0x23FB4,
	0x2413F,
	0x24156,
	0x24157,
	0x24140,
	0x261DD,
	0x24277,
	0x24365,
	0x242C1,
	0x2445A,
	0x24A27,
	0x24A22,
	0x28BE8,
	0x25605,
	0x24974,
	0x23044,
	0x24823,
	0x2882B,
	0x28804,
	0x20C3A,
	0x26A2E,
	0x241E2,
	0x216E7,
	0x24A24,
	0x249B7,
	0x2498D,
	0x249FB,
	0x24A26,
	0x205C3,
	0x228AD,
	0x28EB2,
	0x24A8C,
	0x2415F,
	0x24A79,
	0x28B8F,
	0x28C03,
	0x2189E,
	0x21988,
	0x28ED9,
	0x21A4B,
	0x28EAC,
	0x24F82,
	0x24D13,
	0x263F5,
	0x26911,
	0x2690E,
	0x26F9F,
	0x2509D,
	0x2517D,
	0x21E1C,
	0x25220,
	0x232AC,
	0x28964,
	0x28968,
	0x216C1,
	0x21376,
	0x24A12,
	0x255E0,
	0x2760C,
	0x28B2B,
	0x26083,
	0x2261C,
	0x25857,
	0x27B39,
	0x27126,
	0x2910D,
	END_OF_DATA
};

//
// Sample sentences
// 
const char *sentences[]={
	"",
	END_OF_DATA
};


//
// 
//
OrthographyData data={
	"Hong Kong Supplementary Character Set",
	"香港增補字符集",
	0x27267, // 
	values,
	"",
	sentences
};

const OrthographyData *pData = &data;

}; // end of namespace

#endif
