modulation_dict = {'_atom_site_Fourier_wave_vector_description': '<pre><h2>_atom_site_Fourier_wave_vector_description</h2> '
                                               'A description of the linear combination involved '
                                               'in a given\n'
                                               ' Fourier wave vector used to describe the atomic '
                                               'modulation\n'
                                               ' functions.\n'
                                               '\n'
                                               '<h3>Example:</h3>\n'
                                               'q(4)=q(1)+q(2)</pre>',
 '_atom_site_Fourier_wave_vector_seq_id': '<pre><h2>_atom_site_Fourier_wave_vector_seq_id</h2> A '
                                          'numeric code identifying the wave vectors defined in\n'
                                          ' _atom_site_Fourier_wave_vector_.</pre>',
 '_atom_site_Fourier_wave_vector_x': '<pre><h2>_atom_site_Fourier_wave_vector_x</h2> Wave vectors '
                                     'of the Fourier terms used in the structural model\n'
                                     ' to describe the atomic modulation functions, expressed '
                                     'with\n'
                                     ' respect to the three-dimensional reciprocal basis that '
                                     'spans\n'
                                     ' the lattice of main reflections. They are linear '
                                     'combinations\n'
                                     ' with integer coefficients of the independent wave vectors '
                                     'given\n'
                                     ' in the _cell_wave_vector_ list. Therefore, a generic '
                                     'Fourier wave\n'
                                     ' vector is expressed as k=n(1)q(1)+...+n(p)q(p), where p is '
                                     'given\n'
                                     ' by _cell_modulation_dimension. In the case of composites\n'
                                     ' described in a single data block, these wave vectors are\n'
                                     ' expressed with respect to the three-dimensional reciprocal\n'
                                     ' basis of each subsystem (see '
                                     '_cell_subsystem_matrix_W_).</pre>',
 '_atom_site_Fourier_wave_vector_y': '<pre><h2>_atom_site_Fourier_wave_vector_y</h2> Wave vectors '
                                     'of the Fourier terms used in the structural model\n'
                                     ' to describe the atomic modulation functions, expressed '
                                     'with\n'
                                     ' respect to the three-dimensional reciprocal basis that '
                                     'spans\n'
                                     ' the lattice of main reflections. They are linear '
                                     'combinations\n'
                                     ' with integer coefficients of the independent wave vectors '
                                     'given\n'
                                     ' in the _cell_wave_vector_ list. Therefore, a generic '
                                     'Fourier wave\n'
                                     ' vector is expressed as k=n(1)q(1)+...+n(p)q(p), where p is '
                                     'given\n'
                                     ' by _cell_modulation_dimension. In the case of composites\n'
                                     ' described in a single data block, these wave vectors are\n'
                                     ' expressed with respect to the three-dimensional reciprocal\n'
                                     ' basis of each subsystem (see '
                                     '_cell_subsystem_matrix_W_).</pre>',
 '_atom_site_Fourier_wave_vector_z': '<pre><h2>_atom_site_Fourier_wave_vector_z</h2> Wave vectors '
                                     'of the Fourier terms used in the structural model\n'
                                     ' to describe the atomic modulation functions, expressed '
                                     'with\n'
                                     ' respect to the three-dimensional reciprocal basis that '
                                     'spans\n'
                                     ' the lattice of main reflections. They are linear '
                                     'combinations\n'
                                     ' with integer coefficients of the independent wave vectors '
                                     'given\n'
                                     ' in the _cell_wave_vector_ list. Therefore, a generic '
                                     'Fourier wave\n'
                                     ' vector is expressed as k=n(1)q(1)+...+n(p)q(p), where p is '
                                     'given\n'
                                     ' by _cell_modulation_dimension. In the case of composites\n'
                                     ' described in a single data block, these wave vectors are\n'
                                     ' expressed with respect to the three-dimensional reciprocal\n'
                                     ' basis of each subsystem (see '
                                     '_cell_subsystem_matrix_W_).</pre>',
 '_atom_site_U_Fourier_atom_site_label': '<pre><h2>_atom_site_U_Fourier_atom_site_label</h2> '
                                         'Modulation parameters are usually looped in separate '
                                         'lists.\n'
                                         ' Modulated parameters are the atom positions '
                                         '(displacive\n'
                                         ' modulation), the atomic occupation (occupational '
                                         'modulation)\n'
                                         ' and/or the atomic anisotropic (or isotropic) '
                                         'displacement\n'
                                         ' parameters (referred to as modulation of thermal '
                                         'parameters,\n'
                                         " since the term 'displacement parameters' is ambiguous "
                                         'in this\n'
                                         ' context). _atom_site_U_Fourier_atom_site_label is the '
                                         'code that\n'
                                         ' identifies an atom in a loop in which the Fourier '
                                         'components of\n'
                                         ' its thermal-parameters modulation are listed.  This '
                                         'code must\n'
                                         ' match the _atom_site_label of the associated coordinate '
                                         'list\n'
                                         ' and conform to the rules described in '
                                         '_atom_site_label.</pre>',
 '_atom_site_U_Fourier_id': '<pre><h2>_atom_site_U_Fourier_id</h2> A code identifying each Fourier '
                            'component used to describe the\n'
                            ' modulation of the atomic thermal parameters.</pre>',
 '_atom_site_U_Fourier_param_cos': '<pre><h2>_atom_site_U_Fourier_param_cos</h2> The modulation of '
                                   'the atomic thermal parameters is usually\n'
                                   ' parameterized by Fourier series. Each term of the series\n'
                                   ' commonly adopts two different representations: the '
                                   'sine-cosine\n'
                                   ' form,\n'
                                   '          U(ij)c cos(2\\p k r)+U(ij)s sin(2\\p k r),\n'
                                   ' and the modulus-argument form,\n'
                                   '          |U(ij)| cos(2\\p k r+\\c),\n'
                                   ' where k is the wave vector of the term and r is the atomic\n'
                                   ' average position. _atom_site_U_Fourier_param_cos is the '
                                   'cosine\n'
                                   ' coefficient [U(ij)c], in angstroms squared, corresponding to\n'
                                   ' the Fourier term defined by\n'
                                   ' _atom_site_U_Fourier_atom_site_label,\n'
                                   ' _atom_site_U_Fourier_tens_elem and\n'
                                   ' _atom_site_U_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_U_Fourier_param_id': '<pre><h2>_atom_site_U_Fourier_param_id</h2> A code identifying '
                                  'the (in general complex) coefficient of each\n'
                                  ' term present in the Fourier series describing the modulation '
                                  'of\n'
                                  ' the atomic thermal parameters. This code must match\n'
                                  ' _atom_site_U_Fourier_id.</pre>',
 '_atom_site_U_Fourier_param_modulus': '<pre><h2>_atom_site_U_Fourier_param_modulus</h2> The '
                                       'modulation of the atomic thermal parameters is usually\n'
                                       ' parameterized by Fourier series. Each term of the series\n'
                                       ' commonly adopts two different representations: the '
                                       'sine-cosine\n'
                                       ' form,\n'
                                       '          U(ij)c cos(2\\p k r)+U(ij)s sin(2\\p k r),\n'
                                       ' and the modulus-argument form,\n'
                                       '          |U(ij)| cos(2\\p k r+\\c),\n'
                                       ' where k is the wave vector of the term and r is the '
                                       'atomic\n'
                                       ' average position. _atom_site_U_Fourier_param_modulus is '
                                       'the\n'
                                       ' modulus [|U(ij)|], in angstroms squared, of the complex\n'
                                       ' amplitudes corresponding to the Fourier term defined by\n'
                                       ' _atom_site_U_Fourier_atom_site_label,\n'
                                       ' _atom_site_U_Fourier_tens_elem and\n'
                                       ' _atom_site_U_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_U_Fourier_param_phase': '<pre><h2>_atom_site_U_Fourier_param_phase</h2> The '
                                     'modulation of the atomic thermal parameters is usually\n'
                                     ' parameterized by Fourier series. Each term of the series\n'
                                     ' commonly adopts two different representations: the '
                                     'sine-cosine\n'
                                     ' form,\n'
                                     '          U(ij)c cos(2\\p k r)+U(ij)s sin(2\\p k r),\n'
                                     ' and the modulus-argument form,\n'
                                     '          |U(ij)| cos(2\\p k r+\\c),\n'
                                     ' where k is the wave vector of the term and r is the atomic\n'
                                     ' average position. _atom_site_U_Fourier_param_phase is the '
                                     'phase\n'
                                     ' (\\c/2\\p), in cycles, of the complex amplitude '
                                     'corresponding to\n'
                                     ' the Fourier term defined by '
                                     '_atom_site_U_Fourier_atom_site_label,\n'
                                     ' _atom_site_U_Fourier_tens_elem and\n'
                                     ' _atom_site_U_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_U_Fourier_param_sin': '<pre><h2>_atom_site_U_Fourier_param_sin</h2> The modulation of '
                                   'the atomic thermal parameters is usually\n'
                                   ' parameterized by Fourier series. Each term of the series\n'
                                   ' commonly adopts two different representations: the '
                                   'sine-cosine\n'
                                   ' form,\n'
                                   '          U(ij)c cos(2\\p k r)+U(ij)s sin(2\\p k r),\n'
                                   ' and the modulus-argument form,\n'
                                   '          |U(ij)| cos(2\\p k r+\\c),\n'
                                   ' where k is the wave vector of the term and r is the atomic\n'
                                   ' average position. _atom_site_U_Fourier_param_sin is the sine\n'
                                   ' coefficient [U(ij)s], in angstroms squared, corresponding to\n'
                                   ' the Fourier term defined by\n'
                                   ' _atom_site_U_Fourier_atom_site_label,\n'
                                   ' _atom_site_U_Fourier_tens_elem\n'
                                   ' and _atom_site_U_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_U_Fourier_tens_elem': '<pre><h2>_atom_site_U_Fourier_tens_elem</h2> A label '
                                   'identifying the temperature tensor element U(ij) of a\n'
                                   ' given atom or rigid group whose modulation is being '
                                   'parameterized\n'
                                   ' by Fourier series.\n'
                                   '\n'
                                   '<h3>Example:</h3>\n'
                                   'U11\n'
                                   '\tmodulation of U11\n'
                                   '\n'
                                   'U12\n'
                                   '\tmodulation of U12\n'
                                   '\n'
                                   'U13\n'
                                   '\tmodulation of U13\n'
                                   '\n'
                                   'U22\n'
                                   '\tmodulation of U22\n'
                                   '\n'
                                   'U23\n'
                                   '\tmodulation of U23\n'
                                   '\n'
                                   'U33\n'
                                   '\tmodulation of U33\n'
                                   '\n'
                                   'Uiso\n'
                                   '\tmodulation of U~isotropic~\n'
                                   '</pre>',
 '_atom_site_U_Fourier_wave_vector_seq_id': '<pre><h2>_atom_site_U_Fourier_wave_vector_seq_id</h2> '
                                            'A numeric code identifying the wave vectors of the '
                                            'Fourier terms\n'
                                            ' used to describe the modulation functions '
                                            'corresponding to the\n'
                                            ' temperature factors of an atom or rigid group. This '
                                            'code must\n'
                                            ' match _atom_site_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_U_modulation_flag': '<pre><h2>_atom_site_U_modulation_flag</h2> A code that signals '
                                 'whether the structural model includes the\n'
                                 ' modulation of the thermal parameters of a given atom\n'
                                 ' site.\n'
                                 '\n'
                                 '<h3>Example:</h3>\n'
                                 'yes\n'
                                 '\tmodulation of thermal parameters\n'
                                 '\n'
                                 'y\n'
                                 '\tabbreviation for "yes"\n'
                                 '\n'
                                 'no\n'
                                 '\tno modulation of thermal parameters\n'
                                 '\n'
                                 'n\n'
                                 '\tabbreviation for "no"\n'
                                 '</pre>',
 '_atom_site_[ms]': '<pre><h2>_atom_site_[ms]</h2> Data items in the ATOM_SITE category record '
                    'details about\n'
                    ' the atom sites in a crystal structure, such as the positional\n'
                    ' coordinates, atomic displacement parameters, and magnetic moments\n'
                    ' and directions. This category exists in the core CIF dictionary\n'
                    ' but is extended in this dictionary by the addition of some items\n'
                    ' that may appear in the main looped list of atom-site information.</pre>',
 '_atom_site_displace_Fourier_atom_site_label': '<pre><h2>_atom_site_displace_Fourier_atom_site_label</h2> '
                                                'Modulation parameters are usually looped in '
                                                'separate lists.\n'
                                                ' Modulated parameters are the atom positions '
                                                '(displacive\n'
                                                ' modulation), the atomic occupation (occupational '
                                                'modulation)\n'
                                                ' and/or the atomic anisotropic (or isotropic) '
                                                'displacement\n'
                                                ' parameters (referred to as modulation of thermal '
                                                'parameters,\n'
                                                " since the term 'displacement parameters' is "
                                                'ambiguous in this\n'
                                                ' context).  '
                                                '_atom_site_displace_Fourier_atom_site_label is '
                                                'the\n'
                                                ' code that identifies an atom or rigid group in a '
                                                'loop in which\n'
                                                ' the Fourier components of its displacive '
                                                'modulation are listed.\n'
                                                ' In the case of a rigid group, this list would '
                                                'only include the\n'
                                                ' translational part of its displacive modulation. '
                                                'The rotational\n'
                                                ' part (if any) would appear in a separate list '
                                                '(see\n'
                                                ' _atom_site_rot_Fourier_atom_site_label). This '
                                                'code must match\n'
                                                ' the _atom_site_label of the associated '
                                                'coordinate list and\n'
                                                ' conform to the rules described in '
                                                '_atom_site_label.</pre>',
 '_atom_site_displace_Fourier_axis': '<pre><h2>_atom_site_displace_Fourier_axis</h2> A label '
                                     'identifying the displacement component of a given atom\n'
                                     ' or rigid group that is being parameterized by Fourier '
                                     'series. a,\n'
                                     ' b and c are the basic lattice vectors of the reference '
                                     'structure.\n'
                                     ' For composites they refer to the reference structure of '
                                     'each\n'
                                     ' subsystem. a1, a2 and a3 are defined by\n'
                                     ' _atom_sites_displace_Fourier_axes_description.\n'
                                     '\n'
                                     '<h3>Example:</h3>\n'
                                     'x\n'
                                     '\tdisplacement along the a axis\n'
                                     '\n'
                                     'y\n'
                                     '\tdisplacement along the b axis\n'
                                     '\n'
                                     'z\n'
                                     '\tdisplacement along the c axis\n'
                                     '\n'
                                     'a1\n'
                                     '\tdisplacement along an arbitrary a1 axis\n'
                                     '\n'
                                     'a2\n'
                                     '\tdisplacement along an arbitrary a2 axis\n'
                                     '\n'
                                     'a3\n'
                                     '\tdisplacement along an arbitrary a3 axis\n'
                                     '</pre>',
 '_atom_site_displace_Fourier_id': '<pre><h2>_atom_site_displace_Fourier_id</h2> A code '
                                   'identifying each component of the displacive modulation of\n'
                                   ' a given atom or rigid group when the modulation is expressed '
                                   'in\n'
                                   ' terms of Fourier series. In the case of a rigid group, it\n'
                                   ' applies only to the translational part of the '
                                   'distortion.</pre>',
 '_atom_site_displace_Fourier_param_cos': '<pre><h2>_atom_site_displace_Fourier_param_cos</h2> The '
                                          'displacive distortion of a given atom or rigid group '
                                          '(see\n'
                                          ' also _atom_site_rot_Fourier_param_cos) is usually '
                                          'parameterized\n'
                                          ' by Fourier series. Each term of the series commonly '
                                          'adopts two\n'
                                          ' different representations: the sine-cosine form,\n'
                                          '          Ac cos(2\\p k r)+As sin(2\\p k r),\n'
                                          ' and the modulus-argument form,\n'
                                          '          |A| cos(2\\p k r+\\f),\n'
                                          ' where k is the wave vector of the term and r is the '
                                          'atomic\n'
                                          ' average position. '
                                          '_atom_site_displace_Fourier_param_cos is the\n'
                                          ' cosine coefficient (Ac) corresponding to the Fourier '
                                          'term defined\n'
                                          ' by _atom_site_displace_Fourier_atom_site_label,\n'
                                          ' _atom_site_displace_Fourier_axis and\n'
                                          ' _atom_site_displace_Fourier_wave_vector_seq_id. Atomic '
                                          'or rigid-\n'
                                          ' group displacements must be expressed as fractions of '
                                          'the unit\n'
                                          ' cell or in angstroms if the modulations are referred '
                                          'to some\n'
                                          ' special axes defined by\n'
                                          ' _atom_sites_displace_Fourier_axes_description.</pre>',
 '_atom_site_displace_Fourier_param_id': '<pre><h2>_atom_site_displace_Fourier_param_id</h2> A '
                                         'code identifying the (in general complex) coefficient of '
                                         'each\n'
                                         ' term present in the Fourier series describing the '
                                         'displacive\n'
                                         ' modulation of a given atom or rigid group. In the case '
                                         'of a rigid\n'
                                         ' group, it applies only to the translational part of '
                                         'the\n'
                                         ' distortion. This code must match '
                                         '_atom_site_displace_Fourier_id.</pre>',
 '_atom_site_displace_Fourier_param_modulus': '<pre><h2>_atom_site_displace_Fourier_param_modulus</h2> '
                                              'The displacive distortion of a given atom or rigid '
                                              'group (see\n'
                                              ' also _atom_site_rot_Fourier_param_modulus) is '
                                              'usually\n'
                                              ' parameterized by Fourier series. Each term of the '
                                              'series commonly\n'
                                              ' adopts two different representations: the '
                                              'sine-cosine form,\n'
                                              '          Ac cos(2\\p k r)+As sin(2\\p k r),\n'
                                              ' and the modulus-argument form,\n'
                                              '          |A| cos(2\\p k r+\\f),\n'
                                              ' where k is the wave vector of the term and r is '
                                              'the atomic\n'
                                              ' average position. '
                                              '_atom_site_displace_Fourier_param_modulus is\n'
                                              ' the modulus (|A|) of the complex amplitude '
                                              'corresponding to the\n'
                                              ' Fourier term defined by\n'
                                              ' _atom_site_displace_Fourier_atom_site_label,\n'
                                              ' _atom_site_displace_Fourier_axis and\n'
                                              ' _atom_site_displace_Fourier_wave_vector_seq_id. '
                                              'Atomic or rigid-\n'
                                              ' group displacements must be expressed as fractions '
                                              'of the unit\n'
                                              ' cell or in angstroms if the modulations are '
                                              'referred to some\n'
                                              ' special axes defined by\n'
                                              ' '
                                              '_atom_sites_displace_Fourier_axes_description.</pre>',
 '_atom_site_displace_Fourier_param_phase': '<pre><h2>_atom_site_displace_Fourier_param_phase</h2> '
                                            'The displacive distortion of a given atom or rigid '
                                            'group (see\n'
                                            ' also _atom_site_rot_Fourier_param_phase) is usually '
                                            'parameterized\n'
                                            ' by Fourier series. Each term of the series commonly '
                                            'adopts two\n'
                                            ' different representations: the sine-cosine form,\n'
                                            '          Ac cos(2\\p k r)+As sin(2\\p k r),\n'
                                            ' and the modulus-argument form,\n'
                                            '          |A| cos(2\\p k r+\\f),\n'
                                            ' where k is the wave vector of the term and r is the '
                                            'atomic\n'
                                            ' average position. '
                                            '_atom_site_displace_Fourier_param_phase is the\n'
                                            ' phase (\\f/2\\p) in cycles of the complex amplitude '
                                            'corresponding\n'
                                            ' to the Fourier term defined by\n'
                                            ' _atom_site_displace_Fourier_atom_site_label,\n'
                                            ' _atom_site_displace_Fourier_axis and\n'
                                            ' '
                                            '_atom_site_displace_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_displace_Fourier_param_sin': '<pre><h2>_atom_site_displace_Fourier_param_sin</h2> The '
                                          'displacive distortion of a given atom or rigid group '
                                          '(see\n'
                                          ' also _atom_site_rot_Fourier_param_sin) is usually '
                                          'parameterized\n'
                                          ' by Fourier series. Each term of the series commonly '
                                          'adopts two\n'
                                          ' different representations: the sine-cosine form,\n'
                                          '          Ac cos(2\\p k r)+As sin(2\\p k r),\n'
                                          ' and the modulus-argument form,\n'
                                          '          |A| cos(2\\p k r+\\f),\n'
                                          ' where k is the wave vector of the term and r is the '
                                          'atomic\n'
                                          ' average position. '
                                          '_atom_site_displace_Fourier_param_sin is the\n'
                                          ' sine coefficient (As) corresponding to the Fourier '
                                          'term defined\n'
                                          ' by _atom_site_displace_Fourier_atom_site_label,\n'
                                          ' _atom_site_displace_Fourier_axis, and\n'
                                          ' _atom_site_displace_Fourier_wave_vector_seq_id. Atomic '
                                          'or rigid-\n'
                                          ' group displacements must be expressed as fractions of '
                                          'the unit\n'
                                          ' cell or in angstroms if the modulations are referred '
                                          'to some\n'
                                          ' special axes defined by\n'
                                          ' _atom_sites_displace_Fourier_axes_description.</pre>',
 '_atom_site_displace_Fourier_wave_vector_seq_id': '<pre><h2>_atom_site_displace_Fourier_wave_vector_seq_id</h2> '
                                                   'A numeric code identifying the wave vectors of '
                                                   'the Fourier terms\n'
                                                   ' used in the structural model to describe the '
                                                   'displacive\n'
                                                   ' modulation of an atom or rigid group. In the '
                                                   'case of a rigid\n'
                                                   ' group, it applies only to the translational '
                                                   'part of the\n'
                                                   ' distortion. This code must match\n'
                                                   ' _atom_site_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_displace_modulation_flag': '<pre><h2>_atom_site_displace_modulation_flag</h2> A code '
                                        'that signals whether the structural model includes the\n'
                                        ' modulation of the positional coordinates of a given '
                                        'atom\n'
                                        ' site.\n'
                                        '\n'
                                        '<h3>Example:</h3>\n'
                                        'yes\n'
                                        '\tdisplacive modulation\n'
                                        '\n'
                                        'y\n'
                                        '\tabbreviation for "yes"\n'
                                        '\n'
                                        'no\n'
                                        '\tno displacive modulation\n'
                                        '\n'
                                        'n\n'
                                        '\tabbreviation for "no"\n'
                                        '</pre>',
 '_atom_site_displace_special_func_atom_site_label': '<pre><h2>_atom_site_displace_special_func_atom_site_label</h2> '
                                                     'The code that identifies an atom in a loop '
                                                     'in which the special\n'
                                                     ' function that describes its displacive '
                                                     'modulation is being\n'
                                                     ' defined. This code must match the '
                                                     '_atom_site_label of the\n'
                                                     ' associated coordinate list and conform to '
                                                     'the rules described in\n'
                                                     ' _atom_site_label.</pre>',
 '_atom_site_displace_special_func_sawtooth_ax': '<pre><h2>_atom_site_displace_special_func_sawtooth_ax</h2>  '
                                                 '_atom_site_displace_special_func_sawtooth_ items '
                                                 'are the\n'
                                                 '  adjustable parameters of a sawtooth function.\n'
                                                 '\n'
                                                 '  A displacive sawtooth function along the '
                                                 'internal space is\n'
                                                 '  defined as follows:\n'
                                                 '\n'
                                                 '                    ux=2*ax[(x4-c)/w]\n'
                                                 '                    uy=2*ay[(x4-c)/w]\n'
                                                 '                    uz=2*az[(x4-c)/w]\n'
                                                 '\n'
                                                 '  for x4 belonging to the interval [c-(w/2), '
                                                 'c+(w/2)], where ax,\n'
                                                 '  ay and az are the amplitudes (maximum '
                                                 'displacements)\n'
                                                 '  along each crystallographic axis, w is its '
                                                 'width, x4 is the\n'
                                                 '  internal coordinate and c is the centre of the '
                                                 'function in\n'
                                                 '  internal space. ux, uy and uz must be '
                                                 'expressed in relative\n'
                                                 '  units. The use of this function is restricted '
                                                 'to\n'
                                                 '  one-dimensional modulated structures. For more '
                                                 'details, see\n'
                                                 '  the manual for JANA2000 (Petricek &amp; Dusek, '
                                                 '2000).\n'
                                                 '\n'
                                                 '  Reference: Petricek, V. &amp; Dusek, M. '
                                                 '(2000). JANA2000. The\n'
                                                 '  crystallographic computing system. Institute '
                                                 'of Physics, Prague,\n'
                                                 '  Czech Republic.\n'
                                                 '</pre>',
 '_atom_site_displace_special_func_sawtooth_ay': '<pre><h2>_atom_site_displace_special_func_sawtooth_ay</h2>  '
                                                 '_atom_site_displace_special_func_sawtooth_ items '
                                                 'are the\n'
                                                 '  adjustable parameters of a sawtooth function.\n'
                                                 '\n'
                                                 '  A displacive sawtooth function along the '
                                                 'internal space is\n'
                                                 '  defined as follows:\n'
                                                 '\n'
                                                 '                    ux=2*ax[(x4-c)/w]\n'
                                                 '                    uy=2*ay[(x4-c)/w]\n'
                                                 '                    uz=2*az[(x4-c)/w]\n'
                                                 '\n'
                                                 '  for x4 belonging to the interval [c-(w/2), '
                                                 'c+(w/2)], where ax,\n'
                                                 '  ay and az are the amplitudes (maximum '
                                                 'displacements)\n'
                                                 '  along each crystallographic axis, w is its '
                                                 'width, x4 is the\n'
                                                 '  internal coordinate and c is the centre of the '
                                                 'function in\n'
                                                 '  internal space. ux, uy and uz must be '
                                                 'expressed in relative\n'
                                                 '  units. The use of this function is restricted '
                                                 'to\n'
                                                 '  one-dimensional modulated structures. For more '
                                                 'details, see\n'
                                                 '  the manual for JANA2000 (Petricek &amp; Dusek, '
                                                 '2000).\n'
                                                 '\n'
                                                 '  Reference: Petricek, V. &amp; Dusek, M. '
                                                 '(2000). JANA2000. The\n'
                                                 '  crystallographic computing system. Institute '
                                                 'of Physics, Prague,\n'
                                                 '  Czech Republic.\n'
                                                 '</pre>',
 '_atom_site_displace_special_func_sawtooth_az': '<pre><h2>_atom_site_displace_special_func_sawtooth_az</h2>  '
                                                 '_atom_site_displace_special_func_sawtooth_ items '
                                                 'are the\n'
                                                 '  adjustable parameters of a sawtooth function.\n'
                                                 '\n'
                                                 '  A displacive sawtooth function along the '
                                                 'internal space is\n'
                                                 '  defined as follows:\n'
                                                 '\n'
                                                 '                    ux=2*ax[(x4-c)/w]\n'
                                                 '                    uy=2*ay[(x4-c)/w]\n'
                                                 '                    uz=2*az[(x4-c)/w]\n'
                                                 '\n'
                                                 '  for x4 belonging to the interval [c-(w/2), '
                                                 'c+(w/2)], where ax,\n'
                                                 '  ay and az are the amplitudes (maximum '
                                                 'displacements)\n'
                                                 '  along each crystallographic axis, w is its '
                                                 'width, x4 is the\n'
                                                 '  internal coordinate and c is the centre of the '
                                                 'function in\n'
                                                 '  internal space. ux, uy and uz must be '
                                                 'expressed in relative\n'
                                                 '  units. The use of this function is restricted '
                                                 'to\n'
                                                 '  one-dimensional modulated structures. For more '
                                                 'details, see\n'
                                                 '  the manual for JANA2000 (Petricek &amp; Dusek, '
                                                 '2000).\n'
                                                 '\n'
                                                 '  Reference: Petricek, V. &amp; Dusek, M. '
                                                 '(2000). JANA2000. The\n'
                                                 '  crystallographic computing system. Institute '
                                                 'of Physics, Prague,\n'
                                                 '  Czech Republic.\n'
                                                 '</pre>',
 '_atom_site_displace_special_func_sawtooth_c': '<pre><h2>_atom_site_displace_special_func_sawtooth_c</h2>  '
                                                '_atom_site_displace_special_func_sawtooth_ items '
                                                'are the\n'
                                                '  adjustable parameters of a sawtooth function.\n'
                                                '\n'
                                                '  A displacive sawtooth function along the '
                                                'internal space is\n'
                                                '  defined as follows:\n'
                                                '\n'
                                                '                    ux=2*ax[(x4-c)/w]\n'
                                                '                    uy=2*ay[(x4-c)/w]\n'
                                                '                    uz=2*az[(x4-c)/w]\n'
                                                '\n'
                                                '  for x4 belonging to the interval [c-(w/2), '
                                                'c+(w/2)], where ax,\n'
                                                '  ay and az are the amplitudes (maximum '
                                                'displacements)\n'
                                                '  along each crystallographic axis, w is its '
                                                'width, x4 is the\n'
                                                '  internal coordinate and c is the centre of the '
                                                'function in\n'
                                                '  internal space. ux, uy and uz must be expressed '
                                                'in relative\n'
                                                '  units. The use of this function is restricted '
                                                'to\n'
                                                '  one-dimensional modulated structures. For more '
                                                'details, see\n'
                                                '  the manual for JANA2000 (Petricek &amp; Dusek, '
                                                '2000).\n'
                                                '\n'
                                                '  Reference: Petricek, V. &amp; Dusek, M. (2000). '
                                                'JANA2000. The\n'
                                                '  crystallographic computing system. Institute of '
                                                'Physics, Prague,\n'
                                                '  Czech Republic.\n'
                                                '</pre>',
 '_atom_site_displace_special_func_sawtooth_w': '<pre><h2>_atom_site_displace_special_func_sawtooth_w</h2>  '
                                                '_atom_site_displace_special_func_sawtooth_ items '
                                                'are the\n'
                                                '  adjustable parameters of a sawtooth function.\n'
                                                '\n'
                                                '  A displacive sawtooth function along the '
                                                'internal space is\n'
                                                '  defined as follows:\n'
                                                '\n'
                                                '                    ux=2*ax[(x4-c)/w]\n'
                                                '                    uy=2*ay[(x4-c)/w]\n'
                                                '                    uz=2*az[(x4-c)/w]\n'
                                                '\n'
                                                '  for x4 belonging to the interval [c-(w/2), '
                                                'c+(w/2)], where ax,\n'
                                                '  ay and az are the amplitudes (maximum '
                                                'displacements)\n'
                                                '  along each crystallographic axis, w is its '
                                                'width, x4 is the\n'
                                                '  internal coordinate and c is the centre of the '
                                                'function in\n'
                                                '  internal space. ux, uy and uz must be expressed '
                                                'in relative\n'
                                                '  units. The use of this function is restricted '
                                                'to\n'
                                                '  one-dimensional modulated structures. For more '
                                                'details, see\n'
                                                '  the manual for JANA2000 (Petricek &amp; Dusek, '
                                                '2000).\n'
                                                '\n'
                                                '  Reference: Petricek, V. &amp; Dusek, M. (2000). '
                                                'JANA2000. The\n'
                                                '  crystallographic computing system. Institute of '
                                                'Physics, Prague,\n'
                                                '  Czech Republic.\n'
                                                '</pre>',
 '_atom_site_occ_Fourier_atom_site_label': '<pre><h2>_atom_site_occ_Fourier_atom_site_label</h2> '
                                           'Modulation parameters are usually looped in separate '
                                           'lists.\n'
                                           ' Modulated parameters are the atom positions '
                                           '(displacive\n'
                                           ' modulation), the atomic occupation (occupational '
                                           'modulation)\n'
                                           ' and/or the atomic anisotropic (or isotropic) '
                                           'displacement\n'
                                           ' parameters (referred to as modulation of thermal '
                                           'parameters,\n'
                                           " since the term 'displacement parameters' is ambiguous "
                                           'in this\n'
                                           ' context). _atom_site_occ_Fourier_atom_site_label is '
                                           'the code that\n'
                                           ' identifies an atom in a loop in which the Fourier '
                                           'components of\n'
                                           ' its occupational modulation are listed. This code '
                                           'must\n'
                                           ' match the _atom_site_label of the associated '
                                           'coordinate list and\n'
                                           ' conform to the rules described in '
                                           '_atom_site_label.</pre>',
 '_atom_site_occ_Fourier_id': '<pre><h2>_atom_site_occ_Fourier_id</h2> A code identifying each '
                              'component of the occupational modulation\n'
                              ' of a given atom or rigid group when the modulation is\n'
                              ' expressed in terms of Fourier series.</pre>',
 '_atom_site_occ_Fourier_param_cos': '<pre><h2>_atom_site_occ_Fourier_param_cos</h2> The '
                                     'occupational distortion of a given atom or rigid group is\n'
                                     ' usually parameterized by Fourier series. Each term of the '
                                     'series\n'
                                     ' commonly adopts two different representations: the '
                                     'sine-cosine\n'
                                     ' form,\n'
                                     '          Pc cos(2\\p k r)+Ps sin(2\\p k r),\n'
                                     ' and the modulus-argument form,\n'
                                     '          |P| cos(2\\p k r+\\d),\n'
                                     ' where k is the wave vector of the term and r is the atomic\n'
                                     ' average position. _atom_site_occ_Fourier_param_cos is the '
                                     'cosine\n'
                                     ' coefficient (Pc) corresponding to the Fourier term defined '
                                     'by\n'
                                     ' _atom_site_occ_Fourier_atom_site_label and\n'
                                     ' _atom_site_occ_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_occ_Fourier_param_id': '<pre><h2>_atom_site_occ_Fourier_param_id</h2> A code '
                                    'identifying the (in general complex) coefficient of each\n'
                                    ' term present in the Fourier series describing the '
                                    'occupational\n'
                                    ' modulation of a given atom or rigid group. This code must '
                                    'match\n'
                                    ' _atom_site_occ_Fourier_id.</pre>',
 '_atom_site_occ_Fourier_param_modulus': '<pre><h2>_atom_site_occ_Fourier_param_modulus</h2> The '
                                         'occupational distortion of a given atom or rigid group '
                                         'is\n'
                                         ' usually parameterized by Fourier series. Each term of '
                                         'the series\n'
                                         ' commonly adopts two different representations: the '
                                         'sine-cosine\n'
                                         ' form,\n'
                                         '          Pc cos(2\\p k r)+Ps sin(2\\p k r),\n'
                                         ' and the modulus-argument form,\n'
                                         '          |P| cos(2\\p k r+\\d),\n'
                                         ' where k is the wave vector of the term and r is the '
                                         'atomic\n'
                                         ' average position. _atom_site_occ_Fourier_param_modulus '
                                         'is the\n'
                                         ' modulus (|P|) of the complex amplitude corresponding to '
                                         'the\n'
                                         ' Fourier term defined by '
                                         '_atom_site_occ_Fourier_atom_site_label\n'
                                         ' and _atom_site_occ_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_occ_Fourier_param_phase': '<pre><h2>_atom_site_occ_Fourier_param_phase</h2> The '
                                       'occupational distortion of a given atom or rigid group is\n'
                                       ' usually parameterized by Fourier series. Each term of the '
                                       'series\n'
                                       ' commonly adopts two different representations: the '
                                       'sine-cosine\n'
                                       ' form,\n'
                                       '          Pc cos(2\\p k r)+Ps sin(2\\p k r),\n'
                                       ' and the modulus-argument form,\n'
                                       '          |P| cos(2\\p k r+\\d),\n'
                                       ' where k is the wave vector of the term and r is the '
                                       'atomic\n'
                                       ' average position. _atom_site_occ_Fourier_param_phase is '
                                       'the phase\n'
                                       ' (\\d/2\\p) in cycles corresponding to the Fourier term '
                                       'defined by\n'
                                       ' _atom_site_occ_Fourier_atom_site_label and\n'
                                       ' _atom_site_occ_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_occ_Fourier_param_sin': '<pre><h2>_atom_site_occ_Fourier_param_sin</h2> The '
                                     'occupational distortion of a given atom or rigid group is\n'
                                     ' usually parameterized by Fourier series. Each term of the '
                                     'series\n'
                                     ' commonly adopts two different representations: the '
                                     'sine-cosine\n'
                                     ' form,\n'
                                     '          Pc cos(2\\p k r)+Ps sin(2\\p k r),\n'
                                     ' and the modulus-argument form,\n'
                                     '          |P| cos(2\\p k r+\\d),\n'
                                     ' where k is the wave vector of the term and r is the atomic\n'
                                     ' average position. _atom_site_occ_Fourier_param_sin is the '
                                     'sine\n'
                                     ' coefficient (Ps) corresponding to the Fourier term defined '
                                     'by\n'
                                     ' _atom_site_occ_Fourier_atom_site_label and\n'
                                     ' _atom_site_occ_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_occ_Fourier_wave_vector_seq_id': '<pre><h2>_atom_site_occ_Fourier_wave_vector_seq_id</h2> '
                                              'A numeric code identifying the wave vectors of the '
                                              'Fourier terms\n'
                                              ' used in the structural model to describe the '
                                              'modulation functions\n'
                                              ' corresponding to the occupational part of the '
                                              'distortion. This\n'
                                              ' code must match '
                                              '_atom_site_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_occ_modulation_flag': '<pre><h2>_atom_site_occ_modulation_flag</h2> A code that '
                                   'signals whether the structural model includes the\n'
                                   ' modulation of the occupation of a given atom site.\n'
                                   '\n'
                                   '<h3>Example:</h3>\n'
                                   'yes\n'
                                   '\toccupational modulation\n'
                                   '\n'
                                   'y\n'
                                   '\tabbreviation for "yes"\n'
                                   '\n'
                                   'no\n'
                                   '\tno occupational modulation\n'
                                   '\n'
                                   'n\n'
                                   '\tabbreviation for "no"\n'
                                   '</pre>',
 '_atom_site_occ_special_func_atom_site_label': '<pre><h2>_atom_site_occ_special_func_atom_site_label</h2> '
                                                'The code that identifies an atom or rigid group '
                                                'in a loop in\n'
                                                ' which the parameters of the special function '
                                                'that describes its\n'
                                                ' occupational modulation are listed. This code '
                                                'must match\n'
                                                ' the _atom_site_label of the associated '
                                                'coordinate list and\n'
                                                ' conform to the rules described in '
                                                '_atom_site_label.</pre>',
 '_atom_site_occ_special_func_crenel_c': '<pre><h2>_atom_site_occ_special_func_crenel_c</h2>  '
                                         '_atom_site_occ_special_func_crenel_ items are the '
                                         'adjustable\n'
                                         '  parameters of a crenel function.\n'
                                         '\n'
                                         '  An occupational crenel function along the internal '
                                         'space is\n'
                                         '  defined as follows:\n'
                                         '\n'
                                         '           p(x4)=1   if x4 belongs to the interval '
                                         '[c-w/2,c+w/2]\n'
                                         '           p(x4)=0   if x4 is outside the interval '
                                         '[c-w/2,c+w/2],\n'
                                         '\n'
                                         '  where x4 is the internal coordinate, c is the centre '
                                         'of the\n'
                                         '  function in internal space and w is its width. The use '
                                         'of this\n'
                                         '  function is restricted to one-dimensional modulated '
                                         'structures.\n'
                                         '  For more details, see the manual for JANA2000\n'
                                         '  (Petricek &amp; Dusek, 2000).\n'
                                         '\n'
                                         '  Reference: Petricek, V. &amp; Dusek, M. (2000). '
                                         'JANA2000. The\n'
                                         '  crystallographic computing system. Institute of '
                                         'Physics, Prague,\n'
                                         '  Czech Republic.</pre>',
 '_atom_site_occ_special_func_crenel_w': '<pre><h2>_atom_site_occ_special_func_crenel_w</h2>  '
                                         '_atom_site_occ_special_func_crenel_ items are the '
                                         'adjustable\n'
                                         '  parameters of a crenel function.\n'
                                         '\n'
                                         '  An occupational crenel function along the internal '
                                         'space is\n'
                                         '  defined as follows:\n'
                                         '\n'
                                         '           p(x4)=1   if x4 belongs to the interval '
                                         '[c-w/2,c+w/2]\n'
                                         '           p(x4)=0   if x4 is outside the interval '
                                         '[c-w/2,c+w/2],\n'
                                         '\n'
                                         '  where x4 is the internal coordinate, c is the centre '
                                         'of the\n'
                                         '  function in internal space and w is its width. The use '
                                         'of this\n'
                                         '  function is restricted to one-dimensional modulated '
                                         'structures.\n'
                                         '  For more details, see the manual for JANA2000\n'
                                         '  (Petricek &amp; Dusek, 2000).\n'
                                         '\n'
                                         '  Reference: Petricek, V. &amp; Dusek, M. (2000). '
                                         'JANA2000. The\n'
                                         '  crystallographic computing system. Institute of '
                                         'Physics, Prague,\n'
                                         '  Czech Republic.</pre>',
 '_atom_site_phason_atom_site_label': '<pre><h2>_atom_site_phason_atom_site_label</h2> The code '
                                      'that identifies an atom or rigid group in a loop in\n'
                                      ' which the phason coefficients are listed. Although this '
                                      'kind of\n'
                                      ' correction is intended to be overall, some refinement '
                                      'programs\n'
                                      ' (for example, JANA2000) allow an independent phason '
                                      'correction\n'
                                      ' for each atom or rigid group. In this case,\n'
                                      ' _atom_site_phason_formula and _atom_site_phason_coeff '
                                      'should be\n'
                                      ' used (see also _refine_ls_mod_overall_phason_). This code '
                                      'must\n'
                                      ' match the _atom_site_label of the associated coordinate '
                                      'list and\n'
                                      ' conform to the rules described in _atom_site_label.</pre>',
 '_atom_site_phason_coeff': '<pre><h2>_atom_site_phason_coeff</h2> The phason coefficient used to '
                            'calculate (with the appropriate\n'
                            ' expression given in _atom_site_phason_formula) the atomic phason\n'
                            ' correction. Although this kind of correction is intended to be\n'
                            ' overall, some refinement programs (for example, JANA2000) allow\n'
                            ' an independent phason correction for each atom or rigid group. In\n'
                            ' this case, _atom_site_phason_formula and _atom_site_phason_coeff\n'
                            ' should be used (see also _refine_ls_mod_overall_phason_).</pre>',
 '_atom_site_phason_formula': '<pre><h2>_atom_site_phason_formula</h2> The formula used for the '
                              'phason correction. Although both kinds\n'
                              ' of corrections are intended to be overall, some refinement\n'
                              ' programs (for example, JANA2000) allow an independent phason\n'
                              ' correction for each atom or rigid group. In this case,\n'
                              ' _atom_site_phason_formula and _atom_site_phason_coeff should\n'
                              ' be used (see also _refine_ls_mod_overall_phason_).\n'
                              '\n'
                              '<h3>Example:</h3>\n'
                              'Axe\n'
                              '\tAxe, J. D. (1980). Phys. Rev. B, 21, 4181-4190.\n'
                              '\n'
                              'Ovr\n'
                              '\tOverhauser, A. W. (1971). Phys. Rev. B, 3, 3173-3182.\n'
                              '</pre>',
 '_atom_site_rot_Fourier_atom_site_label': '<pre><h2>_atom_site_rot_Fourier_atom_site_label</h2> '
                                           'Modulation parameters are usually looped in separate '
                                           'lists.\n'
                                           ' Modulated parameters are the atom positions '
                                           '(displacive\n'
                                           ' modulation), the atomic occupation (occupational '
                                           'modulation)\n'
                                           ' and/or the atomic anisotropic (or isotropic) '
                                           'displacement\n'
                                           ' parameters (referred to as modulation of thermal '
                                           'parameters,\n'
                                           " since the term 'displacement parameters' is ambiguous "
                                           'in this\n'
                                           ' context). _atom_site_rot_Fourier_atom_site_label is '
                                           'the code that\n'
                                           ' identifies a rigid group in a loop in which the '
                                           'Fourier\n'
                                           ' components of the rotational part of its displacive '
                                           'modulation\n'
                                           ' are listed. The translational part (if any) would '
                                           'appear in a\n'
                                           ' separate list (see '
                                           '_atom_site_displace_Fourier_atom_site_label).\n'
                                           ' This code must match the _atom_site_label of the '
                                           'associated\n'
                                           ' coordinate list and conform to the rules described '
                                           'in\n'
                                           ' _atom_site_label.</pre>',
 '_atom_site_rot_Fourier_axis': '<pre><h2>_atom_site_rot_Fourier_axis</h2> A label identifying the '
                                'rotation component around a fixed point\n'
                                ' of a given rigid group whose modulation is being parameterized '
                                'by\n'
                                ' Fourier series. a, b and c are the basic lattice vectors of the\n'
                                ' reference structure. For composites they refer to the reference\n'
                                ' structure of each subsystem. a~1~, a~2~ and a~3~ are defined by\n'
                                ' _atom_sites_rot_Fourier_axes_description.\n'
                                '\n'
                                '<h3>Example:</h3>\n'
                                'x\n'
                                '\trotation around the a axis\n'
                                '\n'
                                'y\n'
                                '\trotation around the b axis\n'
                                '\n'
                                'z\n'
                                '\trotation around the c axis\n'
                                '\n'
                                'a1\n'
                                '\trotation around an arbitrary a1 axis\n'
                                '\n'
                                'a2\n'
                                '\trotation around an arbitrary a2 axis\n'
                                '\n'
                                'a3\n'
                                '\trotation around an arbitrary a3 axis\n'
                                '</pre>',
 '_atom_site_rot_Fourier_id': '<pre><h2>_atom_site_rot_Fourier_id</h2> A code identifying each '
                              'component of the rotational modulation of\n'
                              ' a given rigid group when the modulation is expressed in terms of\n'
                              ' Fourier series.</pre>',
 '_atom_site_rot_Fourier_param_cos': '<pre><h2>_atom_site_rot_Fourier_param_cos</h2> The '
                                     'displacive distortion of a given rigid group is not\n'
                                     ' completely described by _atom_site_displace_Fourier_. The '
                                     'rigid\n'
                                     ' rotation of the group around a given axis passing through a '
                                     'fixed\n'
                                     ' point (for example, the centre of mass of the group) is '
                                     'usually\n'
                                     ' parameterized by Fourier series. Each term of the series\n'
                                     ' commonly adopts two different representations: the '
                                     'sine-cosine\n'
                                     ' form,\n'
                                     '          Rc cos(2\\p k r)+Rs sin(2\\p k r),\n'
                                     ' and the modulus-argument form,\n'
                                     '          |R| cos(2\\p k r+\\y),\n'
                                     ' where k is the wave vector of the term and r is the atomic\n'
                                     ' average position. _atom_site_rot_Fourier_param_cos is the '
                                     'cosine\n'
                                     ' coefficient (Rc) in degrees corresponding to the Fourier '
                                     'term\n'
                                     ' defined by _atom_site_rot_Fourier_atom_site_label,\n'
                                     ' _atom_site_rot_Fourier_axis and\n'
                                     ' _atom_site_rot_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_rot_Fourier_param_id': '<pre><h2>_atom_site_rot_Fourier_param_id</h2> A code '
                                    'identifying the (in general complex) coefficient of each\n'
                                    ' term present in the Fourier series describing the rotational '
                                    'part\n'
                                    ' of the displacive modulation of a given rigid group. This '
                                    'code\n'
                                    ' must match _atom_site_rot_Fourier_id.</pre>',
 '_atom_site_rot_Fourier_param_modulus': '<pre><h2>_atom_site_rot_Fourier_param_modulus</h2> The '
                                         'displacive distortion of a given rigid group is not\n'
                                         ' completely described by _atom_site_displace_Fourier_. '
                                         'The rigid\n'
                                         ' rotation of the group around a given axis passing '
                                         'through a fixed\n'
                                         ' point (for example, the centre of mass of the group) is '
                                         'usually\n'
                                         ' parameterized by Fourier series. Each term of the '
                                         'series\n'
                                         ' commonly adopts two different representations: the '
                                         'sine-cosine\n'
                                         ' form,\n'
                                         '          Rc cos(2\\p k r)+Rs sin(2\\p k r),\n'
                                         ' and the modulus-argument form,\n'
                                         '          |R| cos(2\\p k r+\\y),\n'
                                         ' where k is the wave vector of the term and r is the '
                                         'atomic\n'
                                         ' average position. _atom_site_rot_Fourier_param_modulus '
                                         'is the\n'
                                         ' modulus (|R|) in degrees of the complex amplitude '
                                         'corresponding\n'
                                         ' to the Fourier term defined by\n'
                                         ' _atom_site_rot_Fourier_atom_site_label,\n'
                                         ' _atom_site_rot_Fourier_axis and\n'
                                         ' _atom_site_rot_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_rot_Fourier_param_phase': '<pre><h2>_atom_site_rot_Fourier_param_phase</h2> The '
                                       'displacive distortion of a given rigid group is not\n'
                                       ' completely described by _atom_site_displace_Fourier_. The '
                                       'rigid\n'
                                       ' rotation of the group around a given axis passing through '
                                       'a fixed\n'
                                       ' point (for example, the centre of mass of the group) is '
                                       'usually\n'
                                       ' parameterized by Fourier series. Each term of the series\n'
                                       ' commonly adopts two different representations: the '
                                       'sine-cosine\n'
                                       ' form,\n'
                                       '          Rc cos(2\\p k r)+Rs sin(2\\p k r),\n'
                                       ' and the modulus-argument form,\n'
                                       '          |R| cos(2\\p k r+\\y),\n'
                                       ' where k is the wave vector of the term and r is the '
                                       'atomic\n'
                                       ' average position. _atom_site_rot_Fourier_param_phase is '
                                       'the phase\n'
                                       ' (\\y/2\\p) in cycles of the complex amplitude '
                                       'corresponding to the\n'
                                       ' Fourier term defined by '
                                       '_atom_site_rot_Fourier_atom_site_label,\n'
                                       ' _atom_site_rot_Fourier_axis and\n'
                                       ' _atom_site_rot_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_rot_Fourier_param_sin': '<pre><h2>_atom_site_rot_Fourier_param_sin</h2> The '
                                     'displacive distortion of a given rigid group is not\n'
                                     ' completely described by _atom_site_displace_Fourier_. The '
                                     'rigid\n'
                                     ' rotation of the group around a given axis passing through a '
                                     'fixed\n'
                                     ' point (for example, the centre of mass of the group) is '
                                     'usually\n'
                                     ' parameterized by Fourier series. Each term of the series\n'
                                     ' commonly adopts two different representations: the '
                                     'sine-cosine\n'
                                     ' form,\n'
                                     '          Rc cos(2\\p k r)+Rs sin(2\\p k r),\n'
                                     ' and the modulus-argument form,\n'
                                     '          |R| cos(2\\p k r+\\y),\n'
                                     ' where k is the wave vector of the term and r is the atomic\n'
                                     ' average position. _atom_site_rot_Fourier_param_sin is the '
                                     'sine\n'
                                     ' coefficient (Rs) in degrees corresponding to the Fourier '
                                     'term\n'
                                     ' defined by _atom_site_rot_Fourier_atom_site_label,\n'
                                     ' _atom_site_rot_Fourier_axis and\n'
                                     ' _atom_site_rot_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_rot_Fourier_wave_vector_seq_id': '<pre><h2>_atom_site_rot_Fourier_wave_vector_seq_id</h2> '
                                              'A numeric code identifying the wave vectors of the '
                                              'Fourier terms\n'
                                              ' used in the structural model to describe the '
                                              'modulation functions\n'
                                              ' corresponding to the rotational distortion of a '
                                              'rigid group. This\n'
                                              ' code must match '
                                              '_atom_site_Fourier_wave_vector_seq_id.</pre>',
 '_atom_site_subsystem_code': '<pre><h2>_atom_site_subsystem_code</h2> A code that links a given '
                              'atom or rigid-group site to one of the\n'
                              ' subsystems present in a composite. This code provides an\n'
                              ' alternative description for composites which is less explicit\n'
                              ' than that based on linked data blocks (see the description in\n'
                              ' this dictionary of _audit_link_[ms]). It must match one of\n'
                              ' the labels specified for _cell_subsystem_code.</pre>',
 '_atom_sites_displace_Fourier_axes_description': '<pre><h2>_atom_sites_displace_Fourier_axes_description</h2> '
                                                  'The definition of the axes used for describing '
                                                  'the displacive\n'
                                                  ' modulation, parameterized by Fourier series, '
                                                  'when they are other\n'
                                                  ' than the crystallographic axes.\n'
                                                  '\n'
                                                  '<h3>Example:</h3>\n'
                                                  ' a1 and a2 are respectively the long molecular '
                                                  'axis\n'
                                                  ' and the axis normal to the mean molecular '
                                                  'plane.</pre>',
 '_atom_sites_modulation_global_phase_t_1': '<pre><h2>_atom_sites_modulation_global_phase_t_1</h2> '
                                            'The initial phases, in cycles, of the modulation '
                                            'waves. For\n'
                                            ' incommensurate structures they are irrelevant. '
                                            'However, they are\n'
                                            ' essential for the description of commensurate '
                                            'structures within\n'
                                            ' the superspace formalism, since they determine the '
                                            'space group\n'
                                            ' of the commensurate superstructure [see Perez-Mato,\n'
                                            ' Madariaga, Zu\\~niga &amp; Garcia Arribas (1987) or '
                                            'van\n'
                                            ' Smaalen (1995)]. Note that for composites described\n'
                                            ' using a single data block, the initial phases for '
                                            'each subsystem\n'
                                            ' are derived using the W matrices (see '
                                            '_cell_subsystem_matrix_W_)\n'
                                            ' from a unique set of global phases whose values are '
                                            'assigned to\n'
                                            ' _atom_sites_modulation_global_phase_t_. Detailed '
                                            'information can\n'
                                            ' be found in van Smaalen (1995).\n'
                                            '\n'
                                            ' Ref: Perez-Mato, J. M., Madariaga, G., Zu\\~niga, F. '
                                            'J. &amp; Garcia\n'
                                            ' Arribas, A. (1987). Acta Cryst. A43, 216-226. '
                                            'Smaalen, S. van\n'
                                            ' (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_atom_sites_modulation_global_phase_t_2': '<pre><h2>_atom_sites_modulation_global_phase_t_2</h2> '
                                            'The initial phases, in cycles, of the modulation '
                                            'waves. For\n'
                                            ' incommensurate structures they are irrelevant. '
                                            'However, they are\n'
                                            ' essential for the description of commensurate '
                                            'structures within\n'
                                            ' the superspace formalism, since they determine the '
                                            'space group\n'
                                            ' of the commensurate superstructure [see Perez-Mato,\n'
                                            ' Madariaga, Zu\\~niga &amp; Garcia Arribas (1987) or '
                                            'van\n'
                                            ' Smaalen (1995)]. Note that for composites described\n'
                                            ' using a single data block, the initial phases for '
                                            'each subsystem\n'
                                            ' are derived using the W matrices (see '
                                            '_cell_subsystem_matrix_W_)\n'
                                            ' from a unique set of global phases whose values are '
                                            'assigned to\n'
                                            ' _atom_sites_modulation_global_phase_t_. Detailed '
                                            'information can\n'
                                            ' be found in van Smaalen (1995).\n'
                                            '\n'
                                            ' Ref: Perez-Mato, J. M., Madariaga, G., Zu\\~niga, F. '
                                            'J. &amp; Garcia\n'
                                            ' Arribas, A. (1987). Acta Cryst. A43, 216-226. '
                                            'Smaalen, S. van\n'
                                            ' (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_atom_sites_modulation_global_phase_t_3': '<pre><h2>_atom_sites_modulation_global_phase_t_3</h2> '
                                            'The initial phases, in cycles, of the modulation '
                                            'waves. For\n'
                                            ' incommensurate structures they are irrelevant. '
                                            'However, they are\n'
                                            ' essential for the description of commensurate '
                                            'structures within\n'
                                            ' the superspace formalism, since they determine the '
                                            'space group\n'
                                            ' of the commensurate superstructure [see Perez-Mato,\n'
                                            ' Madariaga, Zu\\~niga &amp; Garcia Arribas (1987) or '
                                            'van\n'
                                            ' Smaalen (1995)]. Note that for composites described\n'
                                            ' using a single data block, the initial phases for '
                                            'each subsystem\n'
                                            ' are derived using the W matrices (see '
                                            '_cell_subsystem_matrix_W_)\n'
                                            ' from a unique set of global phases whose values are '
                                            'assigned to\n'
                                            ' _atom_sites_modulation_global_phase_t_. Detailed '
                                            'information can\n'
                                            ' be found in van Smaalen (1995).\n'
                                            '\n'
                                            ' Ref: Perez-Mato, J. M., Madariaga, G., Zu\\~niga, F. '
                                            'J. &amp; Garcia\n'
                                            ' Arribas, A. (1987). Acta Cryst. A43, 216-226. '
                                            'Smaalen, S. van\n'
                                            ' (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_atom_sites_modulation_global_phase_t_4': '<pre><h2>_atom_sites_modulation_global_phase_t_4</h2> '
                                            'The initial phases, in cycles, of the modulation '
                                            'waves. For\n'
                                            ' incommensurate structures they are irrelevant. '
                                            'However, they are\n'
                                            ' essential for the description of commensurate '
                                            'structures within\n'
                                            ' the superspace formalism, since they determine the '
                                            'space group\n'
                                            ' of the commensurate superstructure [see Perez-Mato,\n'
                                            ' Madariaga, Zu\\~niga &amp; Garcia Arribas (1987) or '
                                            'van\n'
                                            ' Smaalen (1995)]. Note that for composites described\n'
                                            ' using a single data block, the initial phases for '
                                            'each subsystem\n'
                                            ' are derived using the W matrices (see '
                                            '_cell_subsystem_matrix_W_)\n'
                                            ' from a unique set of global phases whose values are '
                                            'assigned to\n'
                                            ' _atom_sites_modulation_global_phase_t_. Detailed '
                                            'information can\n'
                                            ' be found in van Smaalen (1995).\n'
                                            '\n'
                                            ' Ref: Perez-Mato, J. M., Madariaga, G., Zu\\~niga, F. '
                                            'J. &amp; Garcia\n'
                                            ' Arribas, A. (1987). Acta Cryst. A43, 216-226. '
                                            'Smaalen, S. van\n'
                                            ' (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_atom_sites_modulation_global_phase_t_5': '<pre><h2>_atom_sites_modulation_global_phase_t_5</h2> '
                                            'The initial phases, in cycles, of the modulation '
                                            'waves. For\n'
                                            ' incommensurate structures they are irrelevant. '
                                            'However, they are\n'
                                            ' essential for the description of commensurate '
                                            'structures within\n'
                                            ' the superspace formalism, since they determine the '
                                            'space group\n'
                                            ' of the commensurate superstructure [see Perez-Mato,\n'
                                            ' Madariaga, Zu\\~niga &amp; Garcia Arribas (1987) or '
                                            'van\n'
                                            ' Smaalen (1995)]. Note that for composites described\n'
                                            ' using a single data block, the initial phases for '
                                            'each subsystem\n'
                                            ' are derived using the W matrices (see '
                                            '_cell_subsystem_matrix_W_)\n'
                                            ' from a unique set of global phases whose values are '
                                            'assigned to\n'
                                            ' _atom_sites_modulation_global_phase_t_. Detailed '
                                            'information can\n'
                                            ' be found in van Smaalen (1995).\n'
                                            '\n'
                                            ' Ref: Perez-Mato, J. M., Madariaga, G., Zu\\~niga, F. '
                                            'J. &amp; Garcia\n'
                                            ' Arribas, A. (1987). Acta Cryst. A43, 216-226. '
                                            'Smaalen, S. van\n'
                                            ' (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_atom_sites_modulation_global_phase_t_6': '<pre><h2>_atom_sites_modulation_global_phase_t_6</h2> '
                                            'The initial phases, in cycles, of the modulation '
                                            'waves. For\n'
                                            ' incommensurate structures they are irrelevant. '
                                            'However, they are\n'
                                            ' essential for the description of commensurate '
                                            'structures within\n'
                                            ' the superspace formalism, since they determine the '
                                            'space group\n'
                                            ' of the commensurate superstructure [see Perez-Mato,\n'
                                            ' Madariaga, Zu\\~niga &amp; Garcia Arribas (1987) or '
                                            'van\n'
                                            ' Smaalen (1995)]. Note that for composites described\n'
                                            ' using a single data block, the initial phases for '
                                            'each subsystem\n'
                                            ' are derived using the W matrices (see '
                                            '_cell_subsystem_matrix_W_)\n'
                                            ' from a unique set of global phases whose values are '
                                            'assigned to\n'
                                            ' _atom_sites_modulation_global_phase_t_. Detailed '
                                            'information can\n'
                                            ' be found in van Smaalen (1995).\n'
                                            '\n'
                                            ' Ref: Perez-Mato, J. M., Madariaga, G., Zu\\~niga, F. '
                                            'J. &amp; Garcia\n'
                                            ' Arribas, A. (1987). Acta Cryst. A43, 216-226. '
                                            'Smaalen, S. van\n'
                                            ' (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_atom_sites_modulation_global_phase_t_7': '<pre><h2>_atom_sites_modulation_global_phase_t_7</h2> '
                                            'The initial phases, in cycles, of the modulation '
                                            'waves. For\n'
                                            ' incommensurate structures they are irrelevant. '
                                            'However, they are\n'
                                            ' essential for the description of commensurate '
                                            'structures within\n'
                                            ' the superspace formalism, since they determine the '
                                            'space group\n'
                                            ' of the commensurate superstructure [see Perez-Mato,\n'
                                            ' Madariaga, Zu\\~niga &amp; Garcia Arribas (1987) or '
                                            'van\n'
                                            ' Smaalen (1995)]. Note that for composites described\n'
                                            ' using a single data block, the initial phases for '
                                            'each subsystem\n'
                                            ' are derived using the W matrices (see '
                                            '_cell_subsystem_matrix_W_)\n'
                                            ' from a unique set of global phases whose values are '
                                            'assigned to\n'
                                            ' _atom_sites_modulation_global_phase_t_. Detailed '
                                            'information can\n'
                                            ' be found in van Smaalen (1995).\n'
                                            '\n'
                                            ' Ref: Perez-Mato, J. M., Madariaga, G., Zu\\~niga, F. '
                                            'J. &amp; Garcia\n'
                                            ' Arribas, A. (1987). Acta Cryst. A43, 216-226. '
                                            'Smaalen, S. van\n'
                                            ' (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_atom_sites_modulation_global_phase_t_8': '<pre><h2>_atom_sites_modulation_global_phase_t_8</h2> '
                                            'The initial phases, in cycles, of the modulation '
                                            'waves. For\n'
                                            ' incommensurate structures they are irrelevant. '
                                            'However, they are\n'
                                            ' essential for the description of commensurate '
                                            'structures within\n'
                                            ' the superspace formalism, since they determine the '
                                            'space group\n'
                                            ' of the commensurate superstructure [see Perez-Mato,\n'
                                            ' Madariaga, Zu\\~niga &amp; Garcia Arribas (1987) or '
                                            'van\n'
                                            ' Smaalen (1995)]. Note that for composites described\n'
                                            ' using a single data block, the initial phases for '
                                            'each subsystem\n'
                                            ' are derived using the W matrices (see '
                                            '_cell_subsystem_matrix_W_)\n'
                                            ' from a unique set of global phases whose values are '
                                            'assigned to\n'
                                            ' _atom_sites_modulation_global_phase_t_. Detailed '
                                            'information can\n'
                                            ' be found in van Smaalen (1995).\n'
                                            '\n'
                                            ' Ref: Perez-Mato, J. M., Madariaga, G., Zu\\~niga, F. '
                                            'J. &amp; Garcia\n'
                                            ' Arribas, A. (1987). Acta Cryst. A43, 216-226. '
                                            'Smaalen, S. van\n'
                                            ' (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_atom_sites_rot_Fourier_axes_description': '<pre><h2>_atom_sites_rot_Fourier_axes_description</h2> '
                                             'The definition of the axes used for describing the '
                                             'rotational\n'
                                             ' part of the displacive modulation of a given rigid '
                                             'group,\n'
                                             ' parameterized by Fourier series, when they are '
                                             'other than the\n'
                                             ' crystallographic axes.\n'
                                             '\n'
                                             '<h3>Example:</h3>\n'
                                             ' a1 and a2 are respectively the long molecular axis\n'
                                             ' and the axis normal to the mean molecular '
                                             'plane.</pre>',
 '_audit_link_[ms]': '<pre><h2>_audit_link_[ms]</h2> This category description does NOT introduce '
                     'a new category;\n'
                     ' instead, it describes the recommended practice for using\n'
                     ' block codes as described in the core AUDIT_LINK category for\n'
                     ' descriptions of modulated structures.\n'
                     '\n'
                     ' The value of _audit_block_code may be associated with a data\n'
                     ' block in the same file or in a different file related to the\n'
                     ' current data block. The value of _audit_block_code should be\n'
                     ' unique.\n'
                     '\n'
                     ' It is recommended that data blocks are named as follows:\n'
                     '\n'
                     '           &lt;string&gt;      The name of the data block containing those '
                     'items that,\n'
                     '              for a particular material, are independent of the\n'
                     '              specific structure (modulated, reference etc.).\n'
                     '              For example, the experimental set-up or\n'
                     '              publication details would be described here.\n'
                     '\n'
                     '           &lt;string&gt;_REFRNCE        The name of the data block that '
                     'contains\n'
                     '             specific details of the reference (unmodulated)\n'
                     '              structure if it was refined separately using only\n'
                     '              main reflections. In the case of composites, this\n'
                     '              data block may contain those items that are common\n'
                     '              to the reference structures of all subsystems.\n'
                     '\n'
                     '           &lt;string&gt;_MOD     The name of the data block in which '
                     'specific\n'
                     '              details of the modulated structure are given. In the\n'
                     '              case of composites, this data block may include\n'
                     '              either those items that are common to the modulated\n'
                     '              structures of all subsystems or the whole modulated\n'
                     '              structure if it is described implicitly through the\n'
                     '              *_subsystem_code pointers.\n'
                     '\n'
                     ' A trailing code following the reserved words MOD or REFRNCE\n'
                     ' indicates that the corresponding data block includes\n'
                     ' structural information corresponding to the modulated or\n'
                     ' reference structures of the subsystem labelled by\n'
                     ' _cell_subsystem_code. A recommended format for &lt;string&gt;\n'
                     ' is given in the definitions of _pd_block_[pd] and\n'
                     ' _pd_block_id in the dictionary extension cif_pd.dic\n'
                     ' (http://www.iucr.org/cif/pd/index.html).\n'
                     '\n'
                     '<h3>Example:</h3>\n'
                     '\n'
                     '    loop_\n'
                     '    _audit_link_block_code\n'
                     '    _audit_link_block_description\n'
                     "       .               'publication details'\n"
                     "       K2SEO4_COM      'experimental data common to ref./mod. structures'\n"
                     "       K2SEO4_REFRNCE  'reference structure'\n"
                     "       K2SEO4_MOD      'modulated structure'\n"
                     '\n'
                     "    _audit_link_block_code      'PbSVS2_MOD_VS2'</pre>",
 '_cell_[ms]': '<pre><h2>_cell_[ms]</h2> Data items in the CELL category record details about\n'
               ' the crystallographic cell parameters and their measurement.\n'
               ' This category is already defined in the core CIF dictionary\n'
               ' but is extended in this dictionary by the addition of some items\n'
               ' that are specific for modulated and composite structures.</pre>',
 '_cell_modulation_dimension': '<pre><h2>_cell_modulation_dimension</h2> Number of additional '
                               'reciprocal vectors needed to index the\n'
                               ' whole diffraction pattern using integer Miller indices.</pre>',
 '_cell_reciprocal_basis_description': '<pre><h2>_cell_reciprocal_basis_description</h2> '
                                       'Definition of the higher-dimensional basis with respect to '
                                       'which\n'
                                       ' the Miller indices are defined. The three-dimensional '
                                       'basis used\n'
                                       ' to index the additional wave vectors should be clearly '
                                       'indicated.\n'
                                       '\n'
                                       '<h3>Example:</h3>\n'
                                       ' a*,b*,c* (reciprocal basis spanning the lattice of main\n'
                                       ' reflections) and q (incommensurate with respect to '
                                       'a*,b*,c*)\n'
                                       'The diffraction pattern can be indexed with four integers '
                                       'based\n'
                                       ' on the reciprocal vectors a*~1~=a*~11~, a*~2~=a*~12~,\n'
                                       ' a*~3~=a*~13~, a*~4~=a*~21~. a*~1j~ (j=1,2,3) index the\n'
                                       ' main reflections of the 1st subsystem. a*~21~ is '
                                       'incommensurate\n'
                                       ' with a*~11~.</pre>',
 '_cell_subsystem_[ms]': '<pre><h2>_cell_subsystem_[ms]</h2> Data items in the CELL_SUBSYSTEM '
                         'category record details about\n'
                         ' the crystallographic cell parameters of each subsystem present in\n'
                         ' a composite.\n'
                         '\n'
                         '<h3>Example:</h3>\n'
                         '\n'
                         '     _cell_subsystems_number                  2\n'
                         '     loop_\n'
                         '         _cell_subsystem_code\n'
                         '         _cell_subsystem_description\n'
                         '         _cell_subsystem_matrix_W_1_1\n'
                         '         _cell_subsystem_matrix_W_1_4\n'
                         '         _cell_subsystem_matrix_W_2_2\n'
                         '         _cell_subsystem_matrix_W_3_3\n'
                         '         _cell_subsystem_matrix_W_4_1\n'
                         '         _cell_subsystem_matrix_W_4_4\n'
                         "   NbS2            '1st subsystem'  1 0 1 1 0 1\n"
                         "   LaS             '2nd subsystem'  0 1 1 1 1 0</pre>",
 '_cell_subsystem_code': '<pre><h2>_cell_subsystem_code</h2> The code identifying uniquely a '
                         'certain composite subsystem.\n'
                         ' This code is used to identify the data blocks that contain\n'
                         ' the structural information associated with the subsystem.\n'
                         '\n'
                         '<h3>Example:</h3>\n'
                         'NbS2</pre>',
 '_cell_subsystem_description': '<pre><h2>_cell_subsystem_description</h2> Description of each '
                                'subsystem defining a composite structurally.\n'
                                ' The number of definitions must match the number given in\n'
                                ' _cell_subsystems_number.\n'
                                '\n'
                                '<h3>Example:</h3>\n'
                                'NbS2 part of the layer compound (LaS)~1.14~NbS~2~</pre>',
 '_cell_subsystem_matrix_W_10_1': '<pre><h2>_cell_subsystem_matrix_W_10_1</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_10_10': '<pre><h2>_cell_subsystem_matrix_W_10_10</h2> In the case of '
                                   'composites, for each subsystem the matrix W as\n'
                                   ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                   ' Its dimension must match\n'
                                   ' '
                                   '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                   '\n'
                                   ' Intergrowth compounds are composed of several periodic\n'
                                   ' substructures in which the reciprocal lattices of two '
                                   'different\n'
                                   ' subsystems are incommensurate in at least one direction. The\n'
                                   ' indexing of the whole diffraction diagram with integer '
                                   'indices\n'
                                   ' requires more than three reciprocal basic vectors. However, '
                                   'the\n'
                                   ' distinction between main reflections and satellites is not '
                                   'as\n'
                                   ' obvious as in normal incommensurate structures. Indeed, true\n'
                                   ' satellites are normally difficult to locate for composites '
                                   'and\n'
                                   ' the modulation wave vectors are reciprocal vectors of the\n'
                                   ' other subsystem(s) referred to the reciprocal basis of one\n'
                                   ' of them. The choice of the enlarged reciprocal basis\n'
                                   ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                   ' the reciprocal basis of each subsystem is always known '
                                   'through\n'
                                   ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                   'for\n'
                                   ' each subsystem, can be blocked as follows:\n'
                                   '\n'
                                   '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                   '            W^\\n^= (                    )\n'
                                   '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                   '\n'
                                   ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                   '(dxd)\n'
                                   ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                   'respectively. For\n'
                                   ' example, Z^\\n^ expresses the reciprocal basis of each '
                                   'subsystem\n'
                                   ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                   ' W^\\n^ also gives the irrational components of the modulation '
                                   'wave\n'
                                   ' vectors of each subsystem in its own three-dimensional '
                                   'reciprocal\n'
                                   ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group '
                                   'of\n'
                                   ' a given subsystem from the unique superspace group of the\n'
                                   ' composite.\n'
                                   '\n'
                                   ' The structure of these materials is always described by a set '
                                   'of\n'
                                   ' incommensurate structures, one for each subsystem. The '
                                   'atomic\n'
                                   ' coordinates, modulation parameters and wave vectors used for\n'
                                   ' describing the modulation(s) are always referred to the '
                                   '(direct\n'
                                   ' or reciprocal) basis of each particular subsystem. Although\n'
                                   ' expressing the structural results in the chosen common basis '
                                   'is\n'
                                   ' possible (using the matrices W), it is less confusing to use\n'
                                   ' this alternative description. Atomic coordinates are only\n'
                                   ' referred to a common basis when interatomic distances are\n'
                                   ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                   ' span the lattice of main reflections of one of the subsystems '
                                   'and\n'
                                   ' therefore its W matrix is the unit matrix.\n'
                                   '\n'
                                   ' For composites described in a single data block using\n'
                                   ' *_subsystem_code pointers, the cell parameters, the '
                                   'superspace\n'
                                   ' group and the measured modulation wave vectors (see\n'
                                   ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                   ' described in _cell_reciprocal_basis_description and coincide\n'
                                   ' with the reciprocal basis of the specific subsystem (if any)\n'
                                   ' whose W matrix is the unit matrix. The cell parameters and '
                                   'the\n'
                                   ' symmetry of the remaining subsystems can be derived using '
                                   'the\n'
                                   ' appropriate W matrices. In any case (single or multiblock '
                                   'CIF),\n'
                                   ' the values assigned to the items describing the atomic '
                                   'parameters\n'
                                   ' (including the wave vectors used to describe the '
                                   'modulations)\n'
                                   ' are always the same and are referred to the basis of each\n'
                                   ' particular subsystem. Such a basis will be explicitly given '
                                   'in a\n'
                                   ' multiblock CIF or should be calculated (with the appropriate '
                                   'W\n'
                                   ' matrix) in the case of a single block description of the\n'
                                   ' composite.\n'
                                   '\n'
                                   ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                   ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_10_11': '<pre><h2>_cell_subsystem_matrix_W_10_11</h2> In the case of '
                                   'composites, for each subsystem the matrix W as\n'
                                   ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                   ' Its dimension must match\n'
                                   ' '
                                   '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                   '\n'
                                   ' Intergrowth compounds are composed of several periodic\n'
                                   ' substructures in which the reciprocal lattices of two '
                                   'different\n'
                                   ' subsystems are incommensurate in at least one direction. The\n'
                                   ' indexing of the whole diffraction diagram with integer '
                                   'indices\n'
                                   ' requires more than three reciprocal basic vectors. However, '
                                   'the\n'
                                   ' distinction between main reflections and satellites is not '
                                   'as\n'
                                   ' obvious as in normal incommensurate structures. Indeed, true\n'
                                   ' satellites are normally difficult to locate for composites '
                                   'and\n'
                                   ' the modulation wave vectors are reciprocal vectors of the\n'
                                   ' other subsystem(s) referred to the reciprocal basis of one\n'
                                   ' of them. The choice of the enlarged reciprocal basis\n'
                                   ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                   ' the reciprocal basis of each subsystem is always known '
                                   'through\n'
                                   ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                   'for\n'
                                   ' each subsystem, can be blocked as follows:\n'
                                   '\n'
                                   '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                   '            W^\\n^= (                    )\n'
                                   '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                   '\n'
                                   ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                   '(dxd)\n'
                                   ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                   'respectively. For\n'
                                   ' example, Z^\\n^ expresses the reciprocal basis of each '
                                   'subsystem\n'
                                   ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                   ' W^\\n^ also gives the irrational components of the modulation '
                                   'wave\n'
                                   ' vectors of each subsystem in its own three-dimensional '
                                   'reciprocal\n'
                                   ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group '
                                   'of\n'
                                   ' a given subsystem from the unique superspace group of the\n'
                                   ' composite.\n'
                                   '\n'
                                   ' The structure of these materials is always described by a set '
                                   'of\n'
                                   ' incommensurate structures, one for each subsystem. The '
                                   'atomic\n'
                                   ' coordinates, modulation parameters and wave vectors used for\n'
                                   ' describing the modulation(s) are always referred to the '
                                   '(direct\n'
                                   ' or reciprocal) basis of each particular subsystem. Although\n'
                                   ' expressing the structural results in the chosen common basis '
                                   'is\n'
                                   ' possible (using the matrices W), it is less confusing to use\n'
                                   ' this alternative description. Atomic coordinates are only\n'
                                   ' referred to a common basis when interatomic distances are\n'
                                   ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                   ' span the lattice of main reflections of one of the subsystems '
                                   'and\n'
                                   ' therefore its W matrix is the unit matrix.\n'
                                   '\n'
                                   ' For composites described in a single data block using\n'
                                   ' *_subsystem_code pointers, the cell parameters, the '
                                   'superspace\n'
                                   ' group and the measured modulation wave vectors (see\n'
                                   ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                   ' described in _cell_reciprocal_basis_description and coincide\n'
                                   ' with the reciprocal basis of the specific subsystem (if any)\n'
                                   ' whose W matrix is the unit matrix. The cell parameters and '
                                   'the\n'
                                   ' symmetry of the remaining subsystems can be derived using '
                                   'the\n'
                                   ' appropriate W matrices. In any case (single or multiblock '
                                   'CIF),\n'
                                   ' the values assigned to the items describing the atomic '
                                   'parameters\n'
                                   ' (including the wave vectors used to describe the '
                                   'modulations)\n'
                                   ' are always the same and are referred to the basis of each\n'
                                   ' particular subsystem. Such a basis will be explicitly given '
                                   'in a\n'
                                   ' multiblock CIF or should be calculated (with the appropriate '
                                   'W\n'
                                   ' matrix) in the case of a single block description of the\n'
                                   ' composite.\n'
                                   '\n'
                                   ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                   ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_10_2': '<pre><h2>_cell_subsystem_matrix_W_10_2</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_10_3': '<pre><h2>_cell_subsystem_matrix_W_10_3</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_10_4': '<pre><h2>_cell_subsystem_matrix_W_10_4</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_10_5': '<pre><h2>_cell_subsystem_matrix_W_10_5</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_10_6': '<pre><h2>_cell_subsystem_matrix_W_10_6</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_10_7': '<pre><h2>_cell_subsystem_matrix_W_10_7</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_10_8': '<pre><h2>_cell_subsystem_matrix_W_10_8</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_10_9': '<pre><h2>_cell_subsystem_matrix_W_10_9</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_1': '<pre><h2>_cell_subsystem_matrix_W_11_1</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_10': '<pre><h2>_cell_subsystem_matrix_W_11_10</h2> In the case of '
                                   'composites, for each subsystem the matrix W as\n'
                                   ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                   ' Its dimension must match\n'
                                   ' '
                                   '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                   '\n'
                                   ' Intergrowth compounds are composed of several periodic\n'
                                   ' substructures in which the reciprocal lattices of two '
                                   'different\n'
                                   ' subsystems are incommensurate in at least one direction. The\n'
                                   ' indexing of the whole diffraction diagram with integer '
                                   'indices\n'
                                   ' requires more than three reciprocal basic vectors. However, '
                                   'the\n'
                                   ' distinction between main reflections and satellites is not '
                                   'as\n'
                                   ' obvious as in normal incommensurate structures. Indeed, true\n'
                                   ' satellites are normally difficult to locate for composites '
                                   'and\n'
                                   ' the modulation wave vectors are reciprocal vectors of the\n'
                                   ' other subsystem(s) referred to the reciprocal basis of one\n'
                                   ' of them. The choice of the enlarged reciprocal basis\n'
                                   ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                   ' the reciprocal basis of each subsystem is always known '
                                   'through\n'
                                   ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                   'for\n'
                                   ' each subsystem, can be blocked as follows:\n'
                                   '\n'
                                   '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                   '            W^\\n^= (                    )\n'
                                   '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                   '\n'
                                   ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                   '(dxd)\n'
                                   ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                   'respectively. For\n'
                                   ' example, Z^\\n^ expresses the reciprocal basis of each '
                                   'subsystem\n'
                                   ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                   ' W^\\n^ also gives the irrational components of the modulation '
                                   'wave\n'
                                   ' vectors of each subsystem in its own three-dimensional '
                                   'reciprocal\n'
                                   ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group '
                                   'of\n'
                                   ' a given subsystem from the unique superspace group of the\n'
                                   ' composite.\n'
                                   '\n'
                                   ' The structure of these materials is always described by a set '
                                   'of\n'
                                   ' incommensurate structures, one for each subsystem. The '
                                   'atomic\n'
                                   ' coordinates, modulation parameters and wave vectors used for\n'
                                   ' describing the modulation(s) are always referred to the '
                                   '(direct\n'
                                   ' or reciprocal) basis of each particular subsystem. Although\n'
                                   ' expressing the structural results in the chosen common basis '
                                   'is\n'
                                   ' possible (using the matrices W), it is less confusing to use\n'
                                   ' this alternative description. Atomic coordinates are only\n'
                                   ' referred to a common basis when interatomic distances are\n'
                                   ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                   ' span the lattice of main reflections of one of the subsystems '
                                   'and\n'
                                   ' therefore its W matrix is the unit matrix.\n'
                                   '\n'
                                   ' For composites described in a single data block using\n'
                                   ' *_subsystem_code pointers, the cell parameters, the '
                                   'superspace\n'
                                   ' group and the measured modulation wave vectors (see\n'
                                   ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                   ' described in _cell_reciprocal_basis_description and coincide\n'
                                   ' with the reciprocal basis of the specific subsystem (if any)\n'
                                   ' whose W matrix is the unit matrix. The cell parameters and '
                                   'the\n'
                                   ' symmetry of the remaining subsystems can be derived using '
                                   'the\n'
                                   ' appropriate W matrices. In any case (single or multiblock '
                                   'CIF),\n'
                                   ' the values assigned to the items describing the atomic '
                                   'parameters\n'
                                   ' (including the wave vectors used to describe the '
                                   'modulations)\n'
                                   ' are always the same and are referred to the basis of each\n'
                                   ' particular subsystem. Such a basis will be explicitly given '
                                   'in a\n'
                                   ' multiblock CIF or should be calculated (with the appropriate '
                                   'W\n'
                                   ' matrix) in the case of a single block description of the\n'
                                   ' composite.\n'
                                   '\n'
                                   ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                   ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_11': '<pre><h2>_cell_subsystem_matrix_W_11_11</h2> In the case of '
                                   'composites, for each subsystem the matrix W as\n'
                                   ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                   ' Its dimension must match\n'
                                   ' '
                                   '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                   '\n'
                                   ' Intergrowth compounds are composed of several periodic\n'
                                   ' substructures in which the reciprocal lattices of two '
                                   'different\n'
                                   ' subsystems are incommensurate in at least one direction. The\n'
                                   ' indexing of the whole diffraction diagram with integer '
                                   'indices\n'
                                   ' requires more than three reciprocal basic vectors. However, '
                                   'the\n'
                                   ' distinction between main reflections and satellites is not '
                                   'as\n'
                                   ' obvious as in normal incommensurate structures. Indeed, true\n'
                                   ' satellites are normally difficult to locate for composites '
                                   'and\n'
                                   ' the modulation wave vectors are reciprocal vectors of the\n'
                                   ' other subsystem(s) referred to the reciprocal basis of one\n'
                                   ' of them. The choice of the enlarged reciprocal basis\n'
                                   ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                   ' the reciprocal basis of each subsystem is always known '
                                   'through\n'
                                   ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                   'for\n'
                                   ' each subsystem, can be blocked as follows:\n'
                                   '\n'
                                   '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                   '            W^\\n^= (                    )\n'
                                   '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                   '\n'
                                   ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                   '(dxd)\n'
                                   ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                   'respectively. For\n'
                                   ' example, Z^\\n^ expresses the reciprocal basis of each '
                                   'subsystem\n'
                                   ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                   ' W^\\n^ also gives the irrational components of the modulation '
                                   'wave\n'
                                   ' vectors of each subsystem in its own three-dimensional '
                                   'reciprocal\n'
                                   ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group '
                                   'of\n'
                                   ' a given subsystem from the unique superspace group of the\n'
                                   ' composite.\n'
                                   '\n'
                                   ' The structure of these materials is always described by a set '
                                   'of\n'
                                   ' incommensurate structures, one for each subsystem. The '
                                   'atomic\n'
                                   ' coordinates, modulation parameters and wave vectors used for\n'
                                   ' describing the modulation(s) are always referred to the '
                                   '(direct\n'
                                   ' or reciprocal) basis of each particular subsystem. Although\n'
                                   ' expressing the structural results in the chosen common basis '
                                   'is\n'
                                   ' possible (using the matrices W), it is less confusing to use\n'
                                   ' this alternative description. Atomic coordinates are only\n'
                                   ' referred to a common basis when interatomic distances are\n'
                                   ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                   ' span the lattice of main reflections of one of the subsystems '
                                   'and\n'
                                   ' therefore its W matrix is the unit matrix.\n'
                                   '\n'
                                   ' For composites described in a single data block using\n'
                                   ' *_subsystem_code pointers, the cell parameters, the '
                                   'superspace\n'
                                   ' group and the measured modulation wave vectors (see\n'
                                   ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                   ' described in _cell_reciprocal_basis_description and coincide\n'
                                   ' with the reciprocal basis of the specific subsystem (if any)\n'
                                   ' whose W matrix is the unit matrix. The cell parameters and '
                                   'the\n'
                                   ' symmetry of the remaining subsystems can be derived using '
                                   'the\n'
                                   ' appropriate W matrices. In any case (single or multiblock '
                                   'CIF),\n'
                                   ' the values assigned to the items describing the atomic '
                                   'parameters\n'
                                   ' (including the wave vectors used to describe the '
                                   'modulations)\n'
                                   ' are always the same and are referred to the basis of each\n'
                                   ' particular subsystem. Such a basis will be explicitly given '
                                   'in a\n'
                                   ' multiblock CIF or should be calculated (with the appropriate '
                                   'W\n'
                                   ' matrix) in the case of a single block description of the\n'
                                   ' composite.\n'
                                   '\n'
                                   ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                   ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_2': '<pre><h2>_cell_subsystem_matrix_W_11_2</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_3': '<pre><h2>_cell_subsystem_matrix_W_11_3</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_4': '<pre><h2>_cell_subsystem_matrix_W_11_4</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_5': '<pre><h2>_cell_subsystem_matrix_W_11_5</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_6': '<pre><h2>_cell_subsystem_matrix_W_11_6</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_7': '<pre><h2>_cell_subsystem_matrix_W_11_7</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_8': '<pre><h2>_cell_subsystem_matrix_W_11_8</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_11_9': '<pre><h2>_cell_subsystem_matrix_W_11_9</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_1': '<pre><h2>_cell_subsystem_matrix_W_1_1</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_10': '<pre><h2>_cell_subsystem_matrix_W_1_10</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_11': '<pre><h2>_cell_subsystem_matrix_W_1_11</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_2': '<pre><h2>_cell_subsystem_matrix_W_1_2</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_3': '<pre><h2>_cell_subsystem_matrix_W_1_3</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_4': '<pre><h2>_cell_subsystem_matrix_W_1_4</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_5': '<pre><h2>_cell_subsystem_matrix_W_1_5</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_6': '<pre><h2>_cell_subsystem_matrix_W_1_6</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_7': '<pre><h2>_cell_subsystem_matrix_W_1_7</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_8': '<pre><h2>_cell_subsystem_matrix_W_1_8</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_1_9': '<pre><h2>_cell_subsystem_matrix_W_1_9</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_1': '<pre><h2>_cell_subsystem_matrix_W_2_1</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_10': '<pre><h2>_cell_subsystem_matrix_W_2_10</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_11': '<pre><h2>_cell_subsystem_matrix_W_2_11</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_2': '<pre><h2>_cell_subsystem_matrix_W_2_2</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_3': '<pre><h2>_cell_subsystem_matrix_W_2_3</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_4': '<pre><h2>_cell_subsystem_matrix_W_2_4</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_5': '<pre><h2>_cell_subsystem_matrix_W_2_5</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_6': '<pre><h2>_cell_subsystem_matrix_W_2_6</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_7': '<pre><h2>_cell_subsystem_matrix_W_2_7</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_8': '<pre><h2>_cell_subsystem_matrix_W_2_8</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_2_9': '<pre><h2>_cell_subsystem_matrix_W_2_9</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_1': '<pre><h2>_cell_subsystem_matrix_W_3_1</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_10': '<pre><h2>_cell_subsystem_matrix_W_3_10</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_11': '<pre><h2>_cell_subsystem_matrix_W_3_11</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_2': '<pre><h2>_cell_subsystem_matrix_W_3_2</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_3': '<pre><h2>_cell_subsystem_matrix_W_3_3</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_4': '<pre><h2>_cell_subsystem_matrix_W_3_4</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_5': '<pre><h2>_cell_subsystem_matrix_W_3_5</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_6': '<pre><h2>_cell_subsystem_matrix_W_3_6</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_7': '<pre><h2>_cell_subsystem_matrix_W_3_7</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_8': '<pre><h2>_cell_subsystem_matrix_W_3_8</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_3_9': '<pre><h2>_cell_subsystem_matrix_W_3_9</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_1': '<pre><h2>_cell_subsystem_matrix_W_4_1</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_10': '<pre><h2>_cell_subsystem_matrix_W_4_10</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_11': '<pre><h2>_cell_subsystem_matrix_W_4_11</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_2': '<pre><h2>_cell_subsystem_matrix_W_4_2</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_3': '<pre><h2>_cell_subsystem_matrix_W_4_3</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_4': '<pre><h2>_cell_subsystem_matrix_W_4_4</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_5': '<pre><h2>_cell_subsystem_matrix_W_4_5</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_6': '<pre><h2>_cell_subsystem_matrix_W_4_6</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_7': '<pre><h2>_cell_subsystem_matrix_W_4_7</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_8': '<pre><h2>_cell_subsystem_matrix_W_4_8</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_4_9': '<pre><h2>_cell_subsystem_matrix_W_4_9</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_1': '<pre><h2>_cell_subsystem_matrix_W_5_1</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_10': '<pre><h2>_cell_subsystem_matrix_W_5_10</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_11': '<pre><h2>_cell_subsystem_matrix_W_5_11</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_2': '<pre><h2>_cell_subsystem_matrix_W_5_2</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_3': '<pre><h2>_cell_subsystem_matrix_W_5_3</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_4': '<pre><h2>_cell_subsystem_matrix_W_5_4</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_5': '<pre><h2>_cell_subsystem_matrix_W_5_5</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_6': '<pre><h2>_cell_subsystem_matrix_W_5_6</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_7': '<pre><h2>_cell_subsystem_matrix_W_5_7</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_8': '<pre><h2>_cell_subsystem_matrix_W_5_8</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_5_9': '<pre><h2>_cell_subsystem_matrix_W_5_9</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_1': '<pre><h2>_cell_subsystem_matrix_W_6_1</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_10': '<pre><h2>_cell_subsystem_matrix_W_6_10</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_11': '<pre><h2>_cell_subsystem_matrix_W_6_11</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_2': '<pre><h2>_cell_subsystem_matrix_W_6_2</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_3': '<pre><h2>_cell_subsystem_matrix_W_6_3</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_4': '<pre><h2>_cell_subsystem_matrix_W_6_4</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_5': '<pre><h2>_cell_subsystem_matrix_W_6_5</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_6': '<pre><h2>_cell_subsystem_matrix_W_6_6</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_7': '<pre><h2>_cell_subsystem_matrix_W_6_7</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_8': '<pre><h2>_cell_subsystem_matrix_W_6_8</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_6_9': '<pre><h2>_cell_subsystem_matrix_W_6_9</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_1': '<pre><h2>_cell_subsystem_matrix_W_7_1</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_10': '<pre><h2>_cell_subsystem_matrix_W_7_10</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_11': '<pre><h2>_cell_subsystem_matrix_W_7_11</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_2': '<pre><h2>_cell_subsystem_matrix_W_7_2</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_3': '<pre><h2>_cell_subsystem_matrix_W_7_3</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_4': '<pre><h2>_cell_subsystem_matrix_W_7_4</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_5': '<pre><h2>_cell_subsystem_matrix_W_7_5</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_6': '<pre><h2>_cell_subsystem_matrix_W_7_6</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_7': '<pre><h2>_cell_subsystem_matrix_W_7_7</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_8': '<pre><h2>_cell_subsystem_matrix_W_7_8</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_7_9': '<pre><h2>_cell_subsystem_matrix_W_7_9</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_1': '<pre><h2>_cell_subsystem_matrix_W_8_1</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_10': '<pre><h2>_cell_subsystem_matrix_W_8_10</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_11': '<pre><h2>_cell_subsystem_matrix_W_8_11</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_2': '<pre><h2>_cell_subsystem_matrix_W_8_2</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_3': '<pre><h2>_cell_subsystem_matrix_W_8_3</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_4': '<pre><h2>_cell_subsystem_matrix_W_8_4</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_5': '<pre><h2>_cell_subsystem_matrix_W_8_5</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_6': '<pre><h2>_cell_subsystem_matrix_W_8_6</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_7': '<pre><h2>_cell_subsystem_matrix_W_8_7</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_8': '<pre><h2>_cell_subsystem_matrix_W_8_8</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_8_9': '<pre><h2>_cell_subsystem_matrix_W_8_9</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_1': '<pre><h2>_cell_subsystem_matrix_W_9_1</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_10': '<pre><h2>_cell_subsystem_matrix_W_9_10</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_11': '<pre><h2>_cell_subsystem_matrix_W_9_11</h2> In the case of '
                                  'composites, for each subsystem the matrix W as\n'
                                  ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                  ' Its dimension must match\n'
                                  ' '
                                  '(_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                  '\n'
                                  ' Intergrowth compounds are composed of several periodic\n'
                                  ' substructures in which the reciprocal lattices of two '
                                  'different\n'
                                  ' subsystems are incommensurate in at least one direction. The\n'
                                  ' indexing of the whole diffraction diagram with integer '
                                  'indices\n'
                                  ' requires more than three reciprocal basic vectors. However, '
                                  'the\n'
                                  ' distinction between main reflections and satellites is not as\n'
                                  ' obvious as in normal incommensurate structures. Indeed, true\n'
                                  ' satellites are normally difficult to locate for composites '
                                  'and\n'
                                  ' the modulation wave vectors are reciprocal vectors of the\n'
                                  ' other subsystem(s) referred to the reciprocal basis of one\n'
                                  ' of them. The choice of the enlarged reciprocal basis\n'
                                  ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                  ' the reciprocal basis of each subsystem is always known '
                                  'through\n'
                                  ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                  'for\n'
                                  ' each subsystem, can be blocked as follows:\n'
                                  '\n'
                                  '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                  '            W^\\n^= (                    )\n'
                                  '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                  '\n'
                                  ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                  '(dxd)\n'
                                  ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                  'respectively. For\n'
                                  ' example, Z^\\n^ expresses the reciprocal basis of each '
                                  'subsystem\n'
                                  ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                  ' W^\\n^ also gives the irrational components of the modulation '
                                  'wave\n'
                                  ' vectors of each subsystem in its own three-dimensional '
                                  'reciprocal\n'
                                  ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                  ' a given subsystem from the unique superspace group of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' The structure of these materials is always described by a set '
                                  'of\n'
                                  ' incommensurate structures, one for each subsystem. The atomic\n'
                                  ' coordinates, modulation parameters and wave vectors used for\n'
                                  ' describing the modulation(s) are always referred to the '
                                  '(direct\n'
                                  ' or reciprocal) basis of each particular subsystem. Although\n'
                                  ' expressing the structural results in the chosen common basis '
                                  'is\n'
                                  ' possible (using the matrices W), it is less confusing to use\n'
                                  ' this alternative description. Atomic coordinates are only\n'
                                  ' referred to a common basis when interatomic distances are\n'
                                  ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                  ' span the lattice of main reflections of one of the subsystems '
                                  'and\n'
                                  ' therefore its W matrix is the unit matrix.\n'
                                  '\n'
                                  ' For composites described in a single data block using\n'
                                  ' *_subsystem_code pointers, the cell parameters, the '
                                  'superspace\n'
                                  ' group and the measured modulation wave vectors (see\n'
                                  ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                  ' described in _cell_reciprocal_basis_description and coincide\n'
                                  ' with the reciprocal basis of the specific subsystem (if any)\n'
                                  ' whose W matrix is the unit matrix. The cell parameters and '
                                  'the\n'
                                  ' symmetry of the remaining subsystems can be derived using the\n'
                                  ' appropriate W matrices. In any case (single or multiblock '
                                  'CIF),\n'
                                  ' the values assigned to the items describing the atomic '
                                  'parameters\n'
                                  ' (including the wave vectors used to describe the modulations)\n'
                                  ' are always the same and are referred to the basis of each\n'
                                  ' particular subsystem. Such a basis will be explicitly given in '
                                  'a\n'
                                  ' multiblock CIF or should be calculated (with the appropriate '
                                  'W\n'
                                  ' matrix) in the case of a single block description of the\n'
                                  ' composite.\n'
                                  '\n'
                                  ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                  ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_2': '<pre><h2>_cell_subsystem_matrix_W_9_2</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_3': '<pre><h2>_cell_subsystem_matrix_W_9_3</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_4': '<pre><h2>_cell_subsystem_matrix_W_9_4</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_5': '<pre><h2>_cell_subsystem_matrix_W_9_5</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_6': '<pre><h2>_cell_subsystem_matrix_W_9_6</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_7': '<pre><h2>_cell_subsystem_matrix_W_9_7</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_8': '<pre><h2>_cell_subsystem_matrix_W_9_8</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystem_matrix_W_9_9': '<pre><h2>_cell_subsystem_matrix_W_9_9</h2> In the case of '
                                 'composites, for each subsystem the matrix W as\n'
                                 ' defined in van Smaalen (1991); see also van Smaalen (1995).\n'
                                 ' Its dimension must match\n'
                                 ' (_cell_modulation_dimension+3)*(_cell_modulation_dimension+3).\n'
                                 '\n'
                                 ' Intergrowth compounds are composed of several periodic\n'
                                 ' substructures in which the reciprocal lattices of two '
                                 'different\n'
                                 ' subsystems are incommensurate in at least one direction. The\n'
                                 ' indexing of the whole diffraction diagram with integer indices\n'
                                 ' requires more than three reciprocal basic vectors. However, '
                                 'the\n'
                                 ' distinction between main reflections and satellites is not as\n'
                                 ' obvious as in normal incommensurate structures. Indeed, true\n'
                                 ' satellites are normally difficult to locate for composites and\n'
                                 ' the modulation wave vectors are reciprocal vectors of the\n'
                                 ' other subsystem(s) referred to the reciprocal basis of one\n'
                                 ' of them. The choice of the enlarged reciprocal basis\n'
                                 ' {a*, b*, c*, q~1~,..., q~d~} is completely arbitrary, but\n'
                                 ' the reciprocal basis of each subsystem is always known through\n'
                                 ' the W matrices. These matrices [(3+d)x(3+d)-dimensional], one '
                                 'for\n'
                                 ' each subsystem, can be blocked as follows:\n'
                                 '\n'
                                 '                   (Z^\\n^~3~    Z^\\n^~d~)\n'
                                 '            W^\\n^= (                    )\n'
                                 '                   (V^\\n^~3~    V^\\n^~d~),\n'
                                 '\n'
                                 ' the dimension of each block being (3x3), (3xd), (dx3) and '
                                 '(dxd)\n'
                                 ' for Z^\\n^~3~, Z^\\n^~d~, V^\\n^~3~ and V^\\n^~d~, '
                                 'respectively. For\n'
                                 ' example, Z^\\n^ expresses the reciprocal basis of each '
                                 'subsystem\n'
                                 ' in terms of the basis {a*, b*, c*, q~1~ ,..., q~d~}.\n'
                                 ' W^\\n^ also gives the irrational components of the modulation '
                                 'wave\n'
                                 ' vectors of each subsystem in its own three-dimensional '
                                 'reciprocal\n'
                                 ' basis {a~\\n~*, b~\\n~*, c~\\n~*} and the superspace group of\n'
                                 ' a given subsystem from the unique superspace group of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' The structure of these materials is always described by a set '
                                 'of\n'
                                 ' incommensurate structures, one for each subsystem. The atomic\n'
                                 ' coordinates, modulation parameters and wave vectors used for\n'
                                 ' describing the modulation(s) are always referred to the '
                                 '(direct\n'
                                 ' or reciprocal) basis of each particular subsystem. Although\n'
                                 ' expressing the structural results in the chosen common basis '
                                 'is\n'
                                 ' possible (using the matrices W), it is less confusing to use\n'
                                 ' this alternative description. Atomic coordinates are only\n'
                                 ' referred to a common basis when interatomic distances are\n'
                                 ' calculated. Usually, the reciprocal vectors {a*, b* and c*}\n'
                                 ' span the lattice of main reflections of one of the subsystems '
                                 'and\n'
                                 ' therefore its W matrix is the unit matrix.\n'
                                 '\n'
                                 ' For composites described in a single data block using\n'
                                 ' *_subsystem_code pointers, the cell parameters, the superspace\n'
                                 ' group and the measured modulation wave vectors (see\n'
                                 ' CELL_WAVE_VECTOR below) correspond to the reciprocal basis\n'
                                 ' described in _cell_reciprocal_basis_description and coincide\n'
                                 ' with the reciprocal basis of the specific subsystem (if any)\n'
                                 ' whose W matrix is the unit matrix. The cell parameters and the\n'
                                 ' symmetry of the remaining subsystems can be derived using the\n'
                                 ' appropriate W matrices. In any case (single or multiblock '
                                 'CIF),\n'
                                 ' the values assigned to the items describing the atomic '
                                 'parameters\n'
                                 ' (including the wave vectors used to describe the modulations)\n'
                                 ' are always the same and are referred to the basis of each\n'
                                 ' particular subsystem. Such a basis will be explicitly given in '
                                 'a\n'
                                 ' multiblock CIF or should be calculated (with the appropriate W\n'
                                 ' matrix) in the case of a single block description of the\n'
                                 ' composite.\n'
                                 '\n'
                                 ' Ref: Smaalen, S. van (1991). Phys. Rev. B, 43, 11330-11341.\n'
                                 ' Smaalen, S. van (1995). Crystallogr. Rev. 4, 79-202.</pre>',
 '_cell_subsystems_[ms]': '<pre><h2>_cell_subsystems_[ms]</h2> Data items in the CELL_SUBSYSTEMS '
                          'category describe the gross\n'
                          ' structure of the subsystems present in a composite.\n'
                          '\n'
                          '<h3>Example:</h3>\n'
                          '\n'
                          '     _cell_subsystems_number                  2</pre>',
 '_cell_subsystems_number': '<pre><h2>_cell_subsystems_number</h2> The number of subsystems used '
                            'to define the structural model of\n'
                            ' a composite structure.</pre>',
 '_cell_wave_vector_[ms]': '<pre><h2>_cell_wave_vector_[ms]</h2> Data items in the '
                           'CELL_WAVE_VECTOR category list the\n'
                           ' independent modulation wave vectors q~i~. The diffraction\n'
                           ' vectors are indexed in the form\n'
                           ' ha*+kb*+lc*+sum~i~ (m~i~q~i~). sum~i~ is taken\n'
                           ' over all wave vectors. In this version of the dictionary, the\n'
                           ' index i has been restricted to be less than 9.\n'
                           '\n'
                           '<h3>Example:</h3>\n'
                           '\n'
                           '     loop_\n'
                           '         _cell_wave_vector_seq_id\n'
                           '         _cell_wave_vector_x\n'
                           '  1       0.318(5)</pre>',
 '_cell_wave_vector_seq_id': '<pre><h2>_cell_wave_vector_seq_id</h2> A numeric code to identify '
                             'each independent wave vector. These\n'
                             ' codes define uniquely the reciprocal basis and, therefore,\n'
                             ' force the order of the Miller indices assigned to\n'
                             ' intensities, crystal faces etc.</pre>',
 '_cell_wave_vector_x': '<pre><h2>_cell_wave_vector_x</h2> Independent modulation wave vector(s) '
                        'with which the whole\n'
                        ' diffraction pattern is indexed, expressed as fractions of the\n'
                        ' three reciprocal basis vectors of the reference structure. In\n'
                        ' the case of composites, the modulation wave vectors of each\n'
                        ' subsystem are expressed in terms of the reciprocal basis of its\n'
                        ' corresponding reference structure. Their number must match\n'
                        ' _cell_modulation_dimension. In the case of composites described\n'
                        ' in a single data block, the wave\n'
                        ' vectors are expressed in the three-dimensional basis chosen as\n'
                        ' reference in _cell_reciprocal_basis_description, which would\n'
                        ' correspond to the subsystem (if any) whose W matrix is the\n'
                        ' {(_cell_modulation_dimension + 3)*\n'
                        ' (_cell_modulation_dimension + 3)} unit matrix. In this case,\n'
                        ' the wave vectors used to describe the modulation of each\n'
                        ' subsystem are referred to their own reciprocal basis via the W\n'
                        ' matrices (for details see _cell_subsystem_matrix_W_ and\n'
                        ' _atom_site_Fourier_wave_vector_).</pre>',
 '_cell_wave_vector_y': '<pre><h2>_cell_wave_vector_y</h2> Independent modulation wave vector(s) '
                        'with which the whole\n'
                        ' diffraction pattern is indexed, expressed as fractions of the\n'
                        ' three reciprocal basis vectors of the reference structure. In\n'
                        ' the case of composites, the modulation wave vectors of each\n'
                        ' subsystem are expressed in terms of the reciprocal basis of its\n'
                        ' corresponding reference structure. Their number must match\n'
                        ' _cell_modulation_dimension. In the case of composites described\n'
                        ' in a single data block, the wave\n'
                        ' vectors are expressed in the three-dimensional basis chosen as\n'
                        ' reference in _cell_reciprocal_basis_description, which would\n'
                        ' correspond to the subsystem (if any) whose W matrix is the\n'
                        ' {(_cell_modulation_dimension + 3)*\n'
                        ' (_cell_modulation_dimension + 3)} unit matrix. In this case,\n'
                        ' the wave vectors used to describe the modulation of each\n'
                        ' subsystem are referred to their own reciprocal basis via the W\n'
                        ' matrices (for details see _cell_subsystem_matrix_W_ and\n'
                        ' _atom_site_Fourier_wave_vector_).</pre>',
 '_cell_wave_vector_z': '<pre><h2>_cell_wave_vector_z</h2> Independent modulation wave vector(s) '
                        'with which the whole\n'
                        ' diffraction pattern is indexed, expressed as fractions of the\n'
                        ' three reciprocal basis vectors of the reference structure. In\n'
                        ' the case of composites, the modulation wave vectors of each\n'
                        ' subsystem are expressed in terms of the reciprocal basis of its\n'
                        ' corresponding reference structure. Their number must match\n'
                        ' _cell_modulation_dimension. In the case of composites described\n'
                        ' in a single data block, the wave\n'
                        ' vectors are expressed in the three-dimensional basis chosen as\n'
                        ' reference in _cell_reciprocal_basis_description, which would\n'
                        ' correspond to the subsystem (if any) whose W matrix is the\n'
                        ' {(_cell_modulation_dimension + 3)*\n'
                        ' (_cell_modulation_dimension + 3)} unit matrix. In this case,\n'
                        ' the wave vectors used to describe the modulation of each\n'
                        ' subsystem are referred to their own reciprocal basis via the W\n'
                        ' matrices (for details see _cell_subsystem_matrix_W_ and\n'
                        ' _atom_site_Fourier_wave_vector_).</pre>',
 '_cell_wave_vectors_[ms]': '<pre><h2>_cell_wave_vectors_[ms]</h2> Data items in the '
                            'CELL_WAVE_VECTORS category record details\n'
                            ' about the set of independent modulation wave vectors q~i~ and\n'
                            ' their measurement. The diffraction vectors are indexed in\n'
                            ' the form ha*+kb*+lc*+sum~i~ (m~i~q~i~). sum~i~ is taken\n'
                            ' over all wave vectors. In this version of the dictionary, the\n'
                            ' index i has been restricted to be less than 9.\n'
                            '\n'
                            '<h3>Example:</h3>\n'
                            '\n'
                            "     _cell_wave_vectors_meas_details          'Determined from "
                            "profiles along q'</pre>",
 '_cell_wave_vectors_meas_details': '<pre><h2>_cell_wave_vectors_meas_details</h2> Details about '
                                    'the method used to determine the independent\n'
                                    ' modulation wave vector(s).</pre>',
 '_cell_wave_vectors_pressure_max': '<pre><h2>_cell_wave_vectors_pressure_max</h2> The maximum and '
                                    'minimum values of the pressure in kilopascals\n'
                                    ' defining the interval within which the modulation wave '
                                    'vector(s)\n'
                                    ' were measured.</pre>',
 '_cell_wave_vectors_pressure_min': '<pre><h2>_cell_wave_vectors_pressure_min</h2> The maximum and '
                                    'minimum values of the pressure in kilopascals\n'
                                    ' defining the interval within which the modulation wave '
                                    'vector(s)\n'
                                    ' were measured.</pre>',
 '_cell_wave_vectors_temp_max': '<pre><h2>_cell_wave_vectors_temp_max</h2> The maximum and minimum '
                                'values of the temperature in kelvins\n'
                                ' defining the interval within which the modulation wave '
                                'vector(s)\n'
                                ' were measured.</pre>',
 '_cell_wave_vectors_temp_min': '<pre><h2>_cell_wave_vectors_temp_min</h2> The maximum and minimum '
                                'values of the temperature in kelvins\n'
                                ' defining the interval within which the modulation wave '
                                'vector(s)\n'
                                ' were measured.</pre>',
 '_cell_wave_vectors_variation': '<pre><h2>_cell_wave_vectors_variation</h2> Details concerning '
                                 'the behaviour (and its experimental\n'
                                 ' detection) of the wave vector(s) with temperature and/or\n'
                                 ' pressure within the ranges specified by\n'
                                 ' _cell_wave_vectors_pressure_max, '
                                 '_cell_wave_vectors_pressure_min,\n'
                                 ' _cell_wave_vectors_temp_max and '
                                 '_cell_wave_vectors_temp_min.</pre>',
 '_diffrn_refln_[ms]': '<pre><h2>_diffrn_refln_[ms]</h2> Data items in the DIFFRN_REFLN category '
                       'record details about\n'
                       ' the intensities measured in the diffraction experiment. The\n'
                       ' DIFFRN_REFLN data items refer to individual intensity\n'
                       ' measurements and must be included in looped lists. (The\n'
                       ' DIFFRN_REFLNS data items specify the parameters that apply\n'
                       ' to all intensity measurements. The DIFFRN_REFLNS data items\n'
                       ' are not looped.) Data items in this category are extensions\n'
                       ' of the core CIF dictionary definitions to the indexing of\n'
                       ' diffraction intensities by higher-dimensional components.</pre>',
 '_diffrn_refln_index_m_1': '<pre><h2>_diffrn_refln_index_m_1</h2> Additional Miller indices '
                            'needed to write the reciprocal vector\n'
                            ' of a certain reflection in the basis described in\n'
                            ' _cell_reciprocal_basis_description. Following the usual\n'
                            ' convention, such a vector would be expressed as\n'
                            '          H=h*a*+k*b*+l*c*+m1*q(1)+...+m8*q(8),\n'
                            ' where h,k,l are the usual _diffrn_refln_index_, and q(1)...q(8)\n'
                            ' represent the independent wave vectors given by\n'
                            ' _cell_wave_vector_ and identified by _cell_wave_vector_seq_id.\n'
                            ' Therefore, the total number of indices of a given reflection must\n'
                            ' match (_cell_modulation_dimension + 3) and the order of the\n'
                            ' additional indices must be consistent with the codes given in\n'
                            ' _cell_wave_vector_seq_id. These indices need not match\n'
                            ' _refln_index_m_ values if a transformation of the original\n'
                            ' measured cell has occurred.</pre>',
 '_diffrn_refln_index_m_2': '<pre><h2>_diffrn_refln_index_m_2</h2> Additional Miller indices '
                            'needed to write the reciprocal vector\n'
                            ' of a certain reflection in the basis described in\n'
                            ' _cell_reciprocal_basis_description. Following the usual\n'
                            ' convention, such a vector would be expressed as\n'
                            '          H=h*a*+k*b*+l*c*+m1*q(1)+...+m8*q(8),\n'
                            ' where h,k,l are the usual _diffrn_refln_index_, and q(1)...q(8)\n'
                            ' represent the independent wave vectors given by\n'
                            ' _cell_wave_vector_ and identified by _cell_wave_vector_seq_id.\n'
                            ' Therefore, the total number of indices of a given reflection must\n'
                            ' match (_cell_modulation_dimension + 3) and the order of the\n'
                            ' additional indices must be consistent with the codes given in\n'
                            ' _cell_wave_vector_seq_id. These indices need not match\n'
                            ' _refln_index_m_ values if a transformation of the original\n'
                            ' measured cell has occurred.</pre>',
 '_diffrn_refln_index_m_3': '<pre><h2>_diffrn_refln_index_m_3</h2> Additional Miller indices '
                            'needed to write the reciprocal vector\n'
                            ' of a certain reflection in the basis described in\n'
                            ' _cell_reciprocal_basis_description. Following the usual\n'
                            ' convention, such a vector would be expressed as\n'
                            '          H=h*a*+k*b*+l*c*+m1*q(1)+...+m8*q(8),\n'
                            ' where h,k,l are the usual _diffrn_refln_index_, and q(1)...q(8)\n'
                            ' represent the independent wave vectors given by\n'
                            ' _cell_wave_vector_ and identified by _cell_wave_vector_seq_id.\n'
                            ' Therefore, the total number of indices of a given reflection must\n'
                            ' match (_cell_modulation_dimension + 3) and the order of the\n'
                            ' additional indices must be consistent with the codes given in\n'
                            ' _cell_wave_vector_seq_id. These indices need not match\n'
                            ' _refln_index_m_ values if a transformation of the original\n'
                            ' measured cell has occurred.</pre>',
 '_diffrn_refln_index_m_4': '<pre><h2>_diffrn_refln_index_m_4</h2> Additional Miller indices '
                            'needed to write the reciprocal vector\n'
                            ' of a certain reflection in the basis described in\n'
                            ' _cell_reciprocal_basis_description. Following the usual\n'
                            ' convention, such a vector would be expressed as\n'
                            '          H=h*a*+k*b*+l*c*+m1*q(1)+...+m8*q(8),\n'
                            ' where h,k,l are the usual _diffrn_refln_index_, and q(1)...q(8)\n'
                            ' represent the independent wave vectors given by\n'
                            ' _cell_wave_vector_ and identified by _cell_wave_vector_seq_id.\n'
                            ' Therefore, the total number of indices of a given reflection must\n'
                            ' match (_cell_modulation_dimension + 3) and the order of the\n'
                            ' additional indices must be consistent with the codes given in\n'
                            ' _cell_wave_vector_seq_id. These indices need not match\n'
                            ' _refln_index_m_ values if a transformation of the original\n'
                            ' measured cell has occurred.</pre>',
 '_diffrn_refln_index_m_5': '<pre><h2>_diffrn_refln_index_m_5</h2> Additional Miller indices '
                            'needed to write the reciprocal vector\n'
                            ' of a certain reflection in the basis described in\n'
                            ' _cell_reciprocal_basis_description. Following the usual\n'
                            ' convention, such a vector would be expressed as\n'
                            '          H=h*a*+k*b*+l*c*+m1*q(1)+...+m8*q(8),\n'
                            ' where h,k,l are the usual _diffrn_refln_index_, and q(1)...q(8)\n'
                            ' represent the independent wave vectors given by\n'
                            ' _cell_wave_vector_ and identified by _cell_wave_vector_seq_id.\n'
                            ' Therefore, the total number of indices of a given reflection must\n'
                            ' match (_cell_modulation_dimension + 3) and the order of the\n'
                            ' additional indices must be consistent with the codes given in\n'
                            ' _cell_wave_vector_seq_id. These indices need not match\n'
                            ' _refln_index_m_ values if a transformation of the original\n'
                            ' measured cell has occurred.</pre>',
 '_diffrn_refln_index_m_6': '<pre><h2>_diffrn_refln_index_m_6</h2> Additional Miller indices '
                            'needed to write the reciprocal vector\n'
                            ' of a certain reflection in the basis described in\n'
                            ' _cell_reciprocal_basis_description. Following the usual\n'
                            ' convention, such a vector would be expressed as\n'
                            '          H=h*a*+k*b*+l*c*+m1*q(1)+...+m8*q(8),\n'
                            ' where h,k,l are the usual _diffrn_refln_index_, and q(1)...q(8)\n'
                            ' represent the independent wave vectors given by\n'
                            ' _cell_wave_vector_ and identified by _cell_wave_vector_seq_id.\n'
                            ' Therefore, the total number of indices of a given reflection must\n'
                            ' match (_cell_modulation_dimension + 3) and the order of the\n'
                            ' additional indices must be consistent with the codes given in\n'
                            ' _cell_wave_vector_seq_id. These indices need not match\n'
                            ' _refln_index_m_ values if a transformation of the original\n'
                            ' measured cell has occurred.</pre>',
 '_diffrn_refln_index_m_7': '<pre><h2>_diffrn_refln_index_m_7</h2> Additional Miller indices '
                            'needed to write the reciprocal vector\n'
                            ' of a certain reflection in the basis described in\n'
                            ' _cell_reciprocal_basis_description. Following the usual\n'
                            ' convention, such a vector would be expressed as\n'
                            '          H=h*a*+k*b*+l*c*+m1*q(1)+...+m8*q(8),\n'
                            ' where h,k,l are the usual _diffrn_refln_index_, and q(1)...q(8)\n'
                            ' represent the independent wave vectors given by\n'
                            ' _cell_wave_vector_ and identified by _cell_wave_vector_seq_id.\n'
                            ' Therefore, the total number of indices of a given reflection must\n'
                            ' match (_cell_modulation_dimension + 3) and the order of the\n'
                            ' additional indices must be consistent with the codes given in\n'
                            ' _cell_wave_vector_seq_id. These indices need not match\n'
                            ' _refln_index_m_ values if a transformation of the original\n'
                            ' measured cell has occurred.</pre>',
 '_diffrn_refln_index_m_8': '<pre><h2>_diffrn_refln_index_m_8</h2> Additional Miller indices '
                            'needed to write the reciprocal vector\n'
                            ' of a certain reflection in the basis described in\n'
                            ' _cell_reciprocal_basis_description. Following the usual\n'
                            ' convention, such a vector would be expressed as\n'
                            '          H=h*a*+k*b*+l*c*+m1*q(1)+...+m8*q(8),\n'
                            ' where h,k,l are the usual _diffrn_refln_index_, and q(1)...q(8)\n'
                            ' represent the independent wave vectors given by\n'
                            ' _cell_wave_vector_ and identified by _cell_wave_vector_seq_id.\n'
                            ' Therefore, the total number of indices of a given reflection must\n'
                            ' match (_cell_modulation_dimension + 3) and the order of the\n'
                            ' additional indices must be consistent with the codes given in\n'
                            ' _cell_wave_vector_seq_id. These indices need not match\n'
                            ' _refln_index_m_ values if a transformation of the original\n'
                            ' measured cell has occurred.</pre>',
 '_diffrn_reflns_[ms]': '<pre><h2>_diffrn_reflns_[ms]</h2> Data items in the DIFFRN_REFLNS '
                        'category record details about\n'
                        ' the set of intensities measured in the diffraction experiment.\n'
                        ' The DIFFRN_REFLNS data items specify the parameters that apply to\n'
                        ' all intensity measurements. The DIFFRN_REFLNS data items are\n'
                        ' not looped. (The DIFFRN_REFLN data items refer to individual\n'
                        ' intensity measurements and must be included in looped lists.)\n'
                        ' Data items in this category extend the core CIF dictionary\n'
                        ' definitions providing independent checks on the range of values\n'
                        ' recorded for each of the additional Miller indices given in\n'
                        ' the DIFFRN_REFLN category.</pre>',
 '_diffrn_reflns_limit_index_m_1_max': '<pre><h2>_diffrn_reflns_limit_index_m_1_max</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_1_min': '<pre><h2>_diffrn_reflns_limit_index_m_1_min</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_2_max': '<pre><h2>_diffrn_reflns_limit_index_m_2_max</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_2_min': '<pre><h2>_diffrn_reflns_limit_index_m_2_min</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_3_max': '<pre><h2>_diffrn_reflns_limit_index_m_3_max</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_3_min': '<pre><h2>_diffrn_reflns_limit_index_m_3_min</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_4_max': '<pre><h2>_diffrn_reflns_limit_index_m_4_max</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_4_min': '<pre><h2>_diffrn_reflns_limit_index_m_4_min</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_5_max': '<pre><h2>_diffrn_reflns_limit_index_m_5_max</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_5_min': '<pre><h2>_diffrn_reflns_limit_index_m_5_min</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_6_max': '<pre><h2>_diffrn_reflns_limit_index_m_6_max</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_6_min': '<pre><h2>_diffrn_reflns_limit_index_m_6_min</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_7_max': '<pre><h2>_diffrn_reflns_limit_index_m_7_max</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_7_min': '<pre><h2>_diffrn_reflns_limit_index_m_7_min</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_8_max': '<pre><h2>_diffrn_reflns_limit_index_m_8_max</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_limit_index_m_8_min': '<pre><h2>_diffrn_reflns_limit_index_m_8_min</h2> Maximum '
                                       'and minimum values of the additional Miller indices\n'
                                       ' appearing in _diffrn_refln_index_m_. The number of ranges '
                                       'must\n'
                                       ' match _cell_modulation_dimension. The order of the '
                                       'additional\n'
                                       ' indices must be consistent with the codes given in\n'
                                       ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_reflns_satellite_order_max': '<pre><h2>_diffrn_reflns_satellite_order_max</h2> Maximum '
                                       'order of observed satellites.</pre>',
 '_diffrn_standard_refln_[ms]': '<pre><h2>_diffrn_standard_refln_[ms]</h2> Data items in the '
                                'DIFFRN_STANDARD_REFLN category record\n'
                                ' details about the reflections treated as standards during the\n'
                                ' measurement of diffraction intensities. Note that these are the\n'
                                ' individual standard reflections, not the results of the '
                                'analysis\n'
                                ' of the standard reflections. Data items in this category are\n'
                                ' extensions of  the core CIF dictionary definitions\n'
                                ' to the indexing of standard reflections by\n'
                                ' higher-dimensional components.</pre>',
 '_diffrn_standard_refln_index_m_1': '<pre><h2>_diffrn_standard_refln_index_m_1</h2> Additional '
                                     'Miller indices needed to write the reciprocal vectors\n'
                                     ' of the standard intensities used in the diffraction '
                                     'measurement\n'
                                     ' process, in the basis described in\n'
                                     ' _cell_reciprocal_basis_description. The total number of '
                                     'indices\n'
                                     ' of a given standard reflection must match\n'
                                     ' (_cell_modulation_dimension + 3) and the order of the\n'
                                     ' additional indices must be consistent with the codes given '
                                     'in\n'
                                     ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_standard_refln_index_m_2': '<pre><h2>_diffrn_standard_refln_index_m_2</h2> Additional '
                                     'Miller indices needed to write the reciprocal vectors\n'
                                     ' of the standard intensities used in the diffraction '
                                     'measurement\n'
                                     ' process, in the basis described in\n'
                                     ' _cell_reciprocal_basis_description. The total number of '
                                     'indices\n'
                                     ' of a given standard reflection must match\n'
                                     ' (_cell_modulation_dimension + 3) and the order of the\n'
                                     ' additional indices must be consistent with the codes given '
                                     'in\n'
                                     ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_standard_refln_index_m_3': '<pre><h2>_diffrn_standard_refln_index_m_3</h2> Additional '
                                     'Miller indices needed to write the reciprocal vectors\n'
                                     ' of the standard intensities used in the diffraction '
                                     'measurement\n'
                                     ' process, in the basis described in\n'
                                     ' _cell_reciprocal_basis_description. The total number of '
                                     'indices\n'
                                     ' of a given standard reflection must match\n'
                                     ' (_cell_modulation_dimension + 3) and the order of the\n'
                                     ' additional indices must be consistent with the codes given '
                                     'in\n'
                                     ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_standard_refln_index_m_4': '<pre><h2>_diffrn_standard_refln_index_m_4</h2> Additional '
                                     'Miller indices needed to write the reciprocal vectors\n'
                                     ' of the standard intensities used in the diffraction '
                                     'measurement\n'
                                     ' process, in the basis described in\n'
                                     ' _cell_reciprocal_basis_description. The total number of '
                                     'indices\n'
                                     ' of a given standard reflection must match\n'
                                     ' (_cell_modulation_dimension + 3) and the order of the\n'
                                     ' additional indices must be consistent with the codes given '
                                     'in\n'
                                     ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_standard_refln_index_m_5': '<pre><h2>_diffrn_standard_refln_index_m_5</h2> Additional '
                                     'Miller indices needed to write the reciprocal vectors\n'
                                     ' of the standard intensities used in the diffraction '
                                     'measurement\n'
                                     ' process, in the basis described in\n'
                                     ' _cell_reciprocal_basis_description. The total number of '
                                     'indices\n'
                                     ' of a given standard reflection must match\n'
                                     ' (_cell_modulation_dimension + 3) and the order of the\n'
                                     ' additional indices must be consistent with the codes given '
                                     'in\n'
                                     ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_standard_refln_index_m_6': '<pre><h2>_diffrn_standard_refln_index_m_6</h2> Additional '
                                     'Miller indices needed to write the reciprocal vectors\n'
                                     ' of the standard intensities used in the diffraction '
                                     'measurement\n'
                                     ' process, in the basis described in\n'
                                     ' _cell_reciprocal_basis_description. The total number of '
                                     'indices\n'
                                     ' of a given standard reflection must match\n'
                                     ' (_cell_modulation_dimension + 3) and the order of the\n'
                                     ' additional indices must be consistent with the codes given '
                                     'in\n'
                                     ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_standard_refln_index_m_7': '<pre><h2>_diffrn_standard_refln_index_m_7</h2> Additional '
                                     'Miller indices needed to write the reciprocal vectors\n'
                                     ' of the standard intensities used in the diffraction '
                                     'measurement\n'
                                     ' process, in the basis described in\n'
                                     ' _cell_reciprocal_basis_description. The total number of '
                                     'indices\n'
                                     ' of a given standard reflection must match\n'
                                     ' (_cell_modulation_dimension + 3) and the order of the\n'
                                     ' additional indices must be consistent with the codes given '
                                     'in\n'
                                     ' _cell_wave_vector_seq_id.</pre>',
 '_diffrn_standard_refln_index_m_8': '<pre><h2>_diffrn_standard_refln_index_m_8</h2> Additional '
                                     'Miller indices needed to write the reciprocal vectors\n'
                                     ' of the standard intensities used in the diffraction '
                                     'measurement\n'
                                     ' process, in the basis described in\n'
                                     ' _cell_reciprocal_basis_description. The total number of '
                                     'indices\n'
                                     ' of a given standard reflection must match\n'
                                     ' (_cell_modulation_dimension + 3) and the order of the\n'
                                     ' additional indices must be consistent with the codes given '
                                     'in\n'
                                     ' _cell_wave_vector_seq_id.</pre>',
 '_exptl_crystal_[ms]': '<pre><h2>_exptl_crystal_[ms]</h2> Data items in the EXPTL_CRYSTAL '
                        'category record\n'
                        ' details about experimental measurements on the crystal or\n'
                        ' crystals used, such as shape, size and density. The new\n'
                        ' data item added to this category specifies whether the structure\n'
                        ' is crystalline, modulated or composite.</pre>',
 '_exptl_crystal_face_[ms]': '<pre><h2>_exptl_crystal_face_[ms]</h2> Data items in the '
                             'EXPTL_CRYSTAL_FACE category record\n'
                             ' details of the crystal faces. Data items in this category are\n'
                             ' extensions of the core CIF dictionary definitions to the\n'
                             ' indexing of crystal faces by higher-dimensional components.</pre>',
 '_exptl_crystal_face_index_m_1': '<pre><h2>_exptl_crystal_face_index_m_1</h2> Additional Miller '
                                  'indices of the crystal face associated with the\n'
                                  ' value _exptl_crystal_face_perp_dist when the face is indexed\n'
                                  ' using a multidimensional scheme. The total number of indices '
                                  'must\n'
                                  ' match (_cell_modulation_dimension + 3). The order of the '
                                  'indices\n'
                                  ' must be consistent with the codes given in\n'
                                  ' _cell_wave_vector_seq_id.</pre>',
 '_exptl_crystal_face_index_m_2': '<pre><h2>_exptl_crystal_face_index_m_2</h2> Additional Miller '
                                  'indices of the crystal face associated with the\n'
                                  ' value _exptl_crystal_face_perp_dist when the face is indexed\n'
                                  ' using a multidimensional scheme. The total number of indices '
                                  'must\n'
                                  ' match (_cell_modulation_dimension + 3). The order of the '
                                  'indices\n'
                                  ' must be consistent with the codes given in\n'
                                  ' _cell_wave_vector_seq_id.</pre>',
 '_exptl_crystal_face_index_m_3': '<pre><h2>_exptl_crystal_face_index_m_3</h2> Additional Miller '
                                  'indices of the crystal face associated with the\n'
                                  ' value _exptl_crystal_face_perp_dist when the face is indexed\n'
                                  ' using a multidimensional scheme. The total number of indices '
                                  'must\n'
                                  ' match (_cell_modulation_dimension + 3). The order of the '
                                  'indices\n'
                                  ' must be consistent with the codes given in\n'
                                  ' _cell_wave_vector_seq_id.</pre>',
 '_exptl_crystal_face_index_m_4': '<pre><h2>_exptl_crystal_face_index_m_4</h2> Additional Miller '
                                  'indices of the crystal face associated with the\n'
                                  ' value _exptl_crystal_face_perp_dist when the face is indexed\n'
                                  ' using a multidimensional scheme. The total number of indices '
                                  'must\n'
                                  ' match (_cell_modulation_dimension + 3). The order of the '
                                  'indices\n'
                                  ' must be consistent with the codes given in\n'
                                  ' _cell_wave_vector_seq_id.</pre>',
 '_exptl_crystal_face_index_m_5': '<pre><h2>_exptl_crystal_face_index_m_5</h2> Additional Miller '
                                  'indices of the crystal face associated with the\n'
                                  ' value _exptl_crystal_face_perp_dist when the face is indexed\n'
                                  ' using a multidimensional scheme. The total number of indices '
                                  'must\n'
                                  ' match (_cell_modulation_dimension + 3). The order of the '
                                  'indices\n'
                                  ' must be consistent with the codes given in\n'
                                  ' _cell_wave_vector_seq_id.</pre>',
 '_exptl_crystal_face_index_m_6': '<pre><h2>_exptl_crystal_face_index_m_6</h2> Additional Miller '
                                  'indices of the crystal face associated with the\n'
                                  ' value _exptl_crystal_face_perp_dist when the face is indexed\n'
                                  ' using a multidimensional scheme. The total number of indices '
                                  'must\n'
                                  ' match (_cell_modulation_dimension + 3). The order of the '
                                  'indices\n'
                                  ' must be consistent with the codes given in\n'
                                  ' _cell_wave_vector_seq_id.</pre>',
 '_exptl_crystal_face_index_m_7': '<pre><h2>_exptl_crystal_face_index_m_7</h2> Additional Miller '
                                  'indices of the crystal face associated with the\n'
                                  ' value _exptl_crystal_face_perp_dist when the face is indexed\n'
                                  ' using a multidimensional scheme. The total number of indices '
                                  'must\n'
                                  ' match (_cell_modulation_dimension + 3). The order of the '
                                  'indices\n'
                                  ' must be consistent with the codes given in\n'
                                  ' _cell_wave_vector_seq_id.</pre>',
 '_exptl_crystal_face_index_m_8': '<pre><h2>_exptl_crystal_face_index_m_8</h2> Additional Miller '
                                  'indices of the crystal face associated with the\n'
                                  ' value _exptl_crystal_face_perp_dist when the face is indexed\n'
                                  ' using a multidimensional scheme. The total number of indices '
                                  'must\n'
                                  ' match (_cell_modulation_dimension + 3). The order of the '
                                  'indices\n'
                                  ' must be consistent with the codes given in\n'
                                  ' _cell_wave_vector_seq_id.</pre>',
 '_exptl_crystal_type_of_structure': '<pre><h2>_exptl_crystal_type_of_structure</h2>       The '
                                     'type of structure. This is used to check the consistency of '
                                     'a\n'
                                     '        CIF: the data blocks that are expected and/or '
                                     'certain characteristic\n'
                                     '        parameters depend on whether the material is '
                                     'classified as crystalline\n'
                                     '        (periodic in three dimensions), modulated or '
                                     'composite.\n'
                                     '\n'
                                     '<h3>Example:</h3>\n'
                                     'cryst\n'
                                     '\tcrystalline structure\n'
                                     '\n'
                                     'mod\n'
                                     '\tmodulated structure\n'
                                     '\n'
                                     'comp\n'
                                     '\tcomposite (misfit) structure\n'
                                     '</pre>',
 '_geom_angle_[ms]': '<pre><h2>_geom_angle_[ms]</h2> Data items in the GEOM_ANGLE category record\n'
                     ' details about the bond angles, as calculated from the\n'
                     ' ATOM, CELL and SYMMETRY data. These extensions\n'
                     ' to the core CIF dictionary definitions record the maximum,\n'
                     ' minimum and average values of angles and extend the\n'
                     ' symmetry-operation code used in angle listings to the\n'
                     ' higher-dimensional superspace form.</pre>',
 '_geom_angle_av': '<pre><h2>_geom_angle_av</h2> Maximum, minimum and average angles in degrees '
                   'bounded by\n'
                   ' _geom_angle_atom_site_label_1, *_2, and *_3. The site at *_2\n'
                   ' is at the apex of the angle.</pre>',
 '_geom_angle_max': '<pre><h2>_geom_angle_max</h2> Maximum, minimum and average angles in degrees '
                    'bounded by\n'
                    ' _geom_angle_atom_site_label_1, *_2, and *_3. The site at *_2\n'
                    ' is at the apex of the angle.</pre>',
 '_geom_angle_min': '<pre><h2>_geom_angle_min</h2> Maximum, minimum and average angles in degrees '
                    'bounded by\n'
                    ' _geom_angle_atom_site_label_1, *_2, and *_3. The site at *_2\n'
                    ' is at the apex of the angle.</pre>',
 '_geom_angle_site_ssg_symmetry_1': '<pre><h2>_geom_angle_site_ssg_symmetry_1</h2> The symmetry '
                                    'code of each atom site as the symmetry operation\n'
                                    " number 'n' and the higher-dimensional translation "
                                    "'m1...mp'.\n"
                                    " These numbers are combined to form the code 'n m1...mp' or\n"
                                    ' n_m1...mp. The character string n_m1...mp is composed as '
                                    'follows:\n'
                                    " 'n' refers to the symmetry operation that is applied to the\n"
                                    ' superspace coordinates. It must match a number given in\n'
                                    " _space_group_symop_ssg_id. 'm1...mp' refer to the "
                                    'translations\n'
                                    ' that are subsequently applied to the symmetry-transformed\n'
                                    ' coordinates to generate the atom used in calculating the '
                                    'angle.\n'
                                    ' These translations (t1,...tp) are related to (m1...mp) by '
                                    'the\n'
                                    ' relations m1=5+t1, ..., mp=5+tp. By adding 5 to the '
                                    'translations,\n'
                                    " the use of negative numbers is avoided. The number 'p' must "
                                    'agree\n'
                                    ' with (_cell_modulation_dimension + 3). If there are no cell\n'
                                    ' translations, the translation number may be omitted. If no\n'
                                    ' symmetry operations or translations are applicable, then a '
                                    'single\n'
                                    " full stop '.' is used.\n"
                                    '\n'
                                    '<h3>Example:</h3>\n'
                                    'None\n'
                                    '4\n'
                                    '7_6455</pre>',
 '_geom_angle_site_ssg_symmetry_2': '<pre><h2>_geom_angle_site_ssg_symmetry_2</h2> The symmetry '
                                    'code of each atom site as the symmetry operation\n'
                                    " number 'n' and the higher-dimensional translation "
                                    "'m1...mp'.\n"
                                    " These numbers are combined to form the code 'n m1...mp' or\n"
                                    ' n_m1...mp. The character string n_m1...mp is composed as '
                                    'follows:\n'
                                    " 'n' refers to the symmetry operation that is applied to the\n"
                                    ' superspace coordinates. It must match a number given in\n'
                                    " _space_group_symop_ssg_id. 'm1...mp' refer to the "
                                    'translations\n'
                                    ' that are subsequently applied to the symmetry-transformed\n'
                                    ' coordinates to generate the atom used in calculating the '
                                    'angle.\n'
                                    ' These translations (t1,...tp) are related to (m1...mp) by '
                                    'the\n'
                                    ' relations m1=5+t1, ..., mp=5+tp. By adding 5 to the '
                                    'translations,\n'
                                    " the use of negative numbers is avoided. The number 'p' must "
                                    'agree\n'
                                    ' with (_cell_modulation_dimension + 3). If there are no cell\n'
                                    ' translations, the translation number may be omitted. If no\n'
                                    ' symmetry operations or translations are applicable, then a '
                                    'single\n'
                                    " full stop '.' is used.\n"
                                    '\n'
                                    '<h3>Example:</h3>\n'
                                    'None\n'
                                    '4\n'
                                    '7_6455</pre>',
 '_geom_angle_site_ssg_symmetry_3': '<pre><h2>_geom_angle_site_ssg_symmetry_3</h2> The symmetry '
                                    'code of each atom site as the symmetry operation\n'
                                    " number 'n' and the higher-dimensional translation "
                                    "'m1...mp'.\n"
                                    " These numbers are combined to form the code 'n m1...mp' or\n"
                                    ' n_m1...mp. The character string n_m1...mp is composed as '
                                    'follows:\n'
                                    " 'n' refers to the symmetry operation that is applied to the\n"
                                    ' superspace coordinates. It must match a number given in\n'
                                    " _space_group_symop_ssg_id. 'm1...mp' refer to the "
                                    'translations\n'
                                    ' that are subsequently applied to the symmetry-transformed\n'
                                    ' coordinates to generate the atom used in calculating the '
                                    'angle.\n'
                                    ' These translations (t1,...tp) are related to (m1...mp) by '
                                    'the\n'
                                    ' relations m1=5+t1, ..., mp=5+tp. By adding 5 to the '
                                    'translations,\n'
                                    " the use of negative numbers is avoided. The number 'p' must "
                                    'agree\n'
                                    ' with (_cell_modulation_dimension + 3). If there are no cell\n'
                                    ' translations, the translation number may be omitted. If no\n'
                                    ' symmetry operations or translations are applicable, then a '
                                    'single\n'
                                    " full stop '.' is used.\n"
                                    '\n'
                                    '<h3>Example:</h3>\n'
                                    'None\n'
                                    '4\n'
                                    '7_6455</pre>',
 '_geom_bond_[ms]': '<pre><h2>_geom_bond_[ms]</h2> Data items in the GEOM_BOND category record\n'
                    ' details about bonds, as calculated from the\n'
                    ' ATOM, CELL and SYMMETRY data. These extensions\n'
                    ' to the core CIF dictionary definitions record the maximum,\n'
                    ' minimum and average lengths of bonds and extend the\n'
                    ' symmetry-operation code used in bond listings to the\n'
                    ' higher-dimensional superspace form.</pre>',
 '_geom_bond_distance_av': '<pre><h2>_geom_bond_distance_av</h2> Maximum, minimum and average '
                           'values of the intramolecular bond\n'
                           ' distance in angstroms.</pre>',
 '_geom_bond_distance_max': '<pre><h2>_geom_bond_distance_max</h2> Maximum, minimum and average '
                            'values of the intramolecular bond\n'
                            ' distance in angstroms.</pre>',
 '_geom_bond_distance_min': '<pre><h2>_geom_bond_distance_min</h2> Maximum, minimum and average '
                            'values of the intramolecular bond\n'
                            ' distance in angstroms.</pre>',
 '_geom_bond_site_ssg_symmetry_1': '<pre><h2>_geom_bond_site_ssg_symmetry_1</h2> The symmetry code '
                                   'of each atom site as the symmetry operation\n'
                                   " number 'n' and the higher-dimensional translation 'm1...mp'.\n"
                                   " These numbers are combined to form the code 'n m1...mp' or\n"
                                   ' n_m1...mp. The character string n_m1...mp is composed as '
                                   'follows:\n'
                                   " 'n' refers to the symmetry operation that is applied to the\n"
                                   ' superspace coordinates. It must match a number given in\n'
                                   " _space_group_symop_ssg_id. 'm1...mp' refer to the "
                                   'translations\n'
                                   ' that are subsequently applied to the symmetry-transformed\n'
                                   ' coordinates to generate the atom used in calculating the '
                                   'bond.\n'
                                   ' These translations (t1,...tp) are related to (m1...mp) by '
                                   'the\n'
                                   ' relations m1=5+t1, ..., mp=5+tp. By adding 5 to the '
                                   'translations,\n'
                                   " the use of negative numbers is avoided. The number 'p' must "
                                   'agree\n'
                                   ' with (_cell_modulation_dimension + 3). If there are no cell\n'
                                   ' translations, the translation number may be omitted. If no\n'
                                   ' symmetry operations or translations are applicable then a '
                                   'single\n'
                                   " full stop '.' is used.\n"
                                   '\n'
                                   '<h3>Example:</h3>\n'
                                   'None\n'
                                   '4\n'
                                   '7_6455</pre>',
 '_geom_bond_site_ssg_symmetry_2': '<pre><h2>_geom_bond_site_ssg_symmetry_2</h2> The symmetry code '
                                   'of each atom site as the symmetry operation\n'
                                   " number 'n' and the higher-dimensional translation 'm1...mp'.\n"
                                   " These numbers are combined to form the code 'n m1...mp' or\n"
                                   ' n_m1...mp. The character string n_m1...mp is composed as '
                                   'follows:\n'
                                   " 'n' refers to the symmetry operation that is applied to the\n"
                                   ' superspace coordinates. It must match a number given in\n'
                                   " _space_group_symop_ssg_id. 'm1...mp' refer to the "
                                   'translations\n'
                                   ' that are subsequently applied to the symmetry-transformed\n'
                                   ' coordinates to generate the atom used in calculating the '
                                   'bond.\n'
                                   ' These translations (t1,...tp) are related to (m1...mp) by '
                                   'the\n'
                                   ' relations m1=5+t1, ..., mp=5+tp. By adding 5 to the '
                                   'translations,\n'
                                   " the use of negative numbers is avoided. The number 'p' must "
                                   'agree\n'
                                   ' with (_cell_modulation_dimension + 3). If there are no cell\n'
                                   ' translations, the translation number may be omitted. If no\n'
                                   ' symmetry operations or translations are applicable then a '
                                   'single\n'
                                   " full stop '.' is used.\n"
                                   '\n'
                                   '<h3>Example:</h3>\n'
                                   'None\n'
                                   '4\n'
                                   '7_6455</pre>',
 '_geom_contact_[ms]': '<pre><h2>_geom_contact_[ms]</h2> Data items in the GEOM_CONTACT category '
                       'record\n'
                       ' details about interatomic contacts, as calculated from the\n'
                       ' ATOM, CELL and SYMMETRY data. These extensions\n'
                       ' to the core CIF dictionary definitions record the maximum,\n'
                       ' minimum and average values of contact distances and extend the\n'
                       ' symmetry-operation code used in contact-distance listings to the\n'
                       ' higher-dimensional superspace form.</pre>',
 '_geom_contact_distance_av': '<pre><h2>_geom_contact_distance_av</h2> Maximum, minimum and '
                              'average values of the interatomic contact\n'
                              ' distance in angstroms.</pre>',
 '_geom_contact_distance_max': '<pre><h2>_geom_contact_distance_max</h2> Maximum, minimum and '
                               'average values of the interatomic contact\n'
                               ' distance in angstroms.</pre>',
 '_geom_contact_distance_min': '<pre><h2>_geom_contact_distance_min</h2> Maximum, minimum and '
                               'average values of the interatomic contact\n'
                               ' distance in angstroms.</pre>',
 '_geom_contact_site_ssg_symmetry_1': '<pre><h2>_geom_contact_site_ssg_symmetry_1</h2> The '
                                      'symmetry code of each atom site as the symmetry operation\n'
                                      " number 'n' and the higher-dimensional translation "
                                      "'m1...mp'.\n"
                                      " These numbers are combined to form the code 'n m1...mp' "
                                      'or\n'
                                      ' n_m1...mp. The character string n_m1...mp is composed as '
                                      'follows:\n'
                                      " 'n' refers to the symmetry operation that is applied to "
                                      'the\n'
                                      ' superspace coordinates. It must match a number given in\n'
                                      " _space_group_symop_ssg_id. 'm1...mp' refer to the "
                                      'translations\n'
                                      ' that are subsequently applied to the symmetry-transformed\n'
                                      ' coordinates to generate the atom used in calculating the '
                                      'contact.\n'
                                      ' These translations (t1,...tp) are related to (m1...mp) by '
                                      'the\n'
                                      ' relations m1=5+t1, ..., mp=5+tp. By adding 5 to the '
                                      'translations,\n'
                                      " the use of negative numbers is avoided. The number 'p' "
                                      'must agree\n'
                                      ' with (_cell_modulation_dimension + 3). If there are no '
                                      'cell\n'
                                      ' translations, the translation number may be omitted. If '
                                      'no\n'
                                      ' symmetry operations or translations are applicable, then a '
                                      'single\n'
                                      " full stop '.' is used.\n"
                                      '\n'
                                      '<h3>Example:</h3>\n'
                                      'None\n'
                                      '4\n'
                                      '7_6455</pre>',
 '_geom_contact_site_ssg_symmetry_2': '<pre><h2>_geom_contact_site_ssg_symmetry_2</h2> The '
                                      'symmetry code of each atom site as the symmetry operation\n'
                                      " number 'n' and the higher-dimensional translation "
                                      "'m1...mp'.\n"
                                      " These numbers are combined to form the code 'n m1...mp' "
                                      'or\n'
                                      ' n_m1...mp. The character string n_m1...mp is composed as '
                                      'follows:\n'
                                      " 'n' refers to the symmetry operation that is applied to "
                                      'the\n'
                                      ' superspace coordinates. It must match a number given in\n'
                                      " _space_group_symop_ssg_id. 'm1...mp' refer to the "
                                      'translations\n'
                                      ' that are subsequently applied to the symmetry-transformed\n'
                                      ' coordinates to generate the atom used in calculating the '
                                      'contact.\n'
                                      ' These translations (t1,...tp) are related to (m1...mp) by '
                                      'the\n'
                                      ' relations m1=5+t1, ..., mp=5+tp. By adding 5 to the '
                                      'translations,\n'
       