/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __tcl
#define __tcl

#include <tcl.h>
#include <string>
#include <sstream>

struct tcl_interp { // tcl interpreter

  Tcl_Interp *interp;

  void setup (Tcl_Interp* pi);

  tcl_interp ();
  ~tcl_interp ();

  std::string result;

  tcl_interp& operator() (const std::string& cmd);

};

typedef int (*tclcmd)(ClientData cd, Tcl_Interp* ti, int objc, Tcl_Obj* CONST objv[]);
int tcl_run (ClientData cd, Tcl_Interp* ti, int objc, Tcl_Obj* CONST objv[]);

#endif
