# Contributing to the debputy-lsp project

The [debputy][debputy-repo] and `debputy-lsp`
project welcome contributing. Generally, you can help by:

 1. Providing editor configuration
 2. Provide patches, new features or bug fixes

[debputy-repo]: https://salsa.debian.org/debian/debputy/

## Provide editor configuration

Ideally, the editor should bring its own editor configuration for
language servers. This project will host editor configuration where
this currenlty not the case or where upstreaming is non-trivial.

However, please only provide copyrightable editor glue configuration
where:

 1. You provide it the `EXPAT` or `MIT` license terms. As stated,
    `debputy-lsp` is ideally a temporary host and not a permanent host
    for such files and a very permissive license enables us to
    outsource editor configuration.

 2. It is generally applicable and can reasonable be upstremable.
    That is usually the minimal LSP glue needed with some comments or
    suggestions. Providing non-controversial defaults for certain
    features is acceptable.

If the editor already has glue out of the box, you are welcome to
submit a link / reference to their documentation, such that the
`debputy lsp editor-config` command can provide the details.

Note: Changes to `debputy lsp editor-config` should generally be
done against [debputy][debputy-repo] project.

## Provide patches, new features or bug fixes

These are generally welcome as well. At the time of writing, those
should be done via the [debputy][debputy-repo] project. Note that the
`debputy` repo uses a different license than the ones used for the
editor glue provided by `debputy-lsp`.

For new features, it might be a good idea to check whether it is in
scope for `debputy lsp` before doing it. The `debputy lsp` part has a
narrower scope than `lintian` and some other QA tools. That implies
that many `lintian` checks will never be provided by `debputy`.
