; This sample project.clj file is suitable as a starting point for building
; libraries using cljx.  Some things it does:
;
; * Clojure and ClojureScript resources generated by cljx are put under
; `target/*`; this means they'll be removed by `lein clean`.
; * Non-test resources are put into `target/classes`; by default, that
; directory's contents will be included in the .jar file produced by Leiningen
; * Generated Clojure testing resources are dropped into `target/test-classes`,
; where `lein test` will pick them up.
; * `.cljx` files are excluded from any generated jar files
; * ClojureScript is a dependency in the `:dev` profile, so it will not be
; transitively passed on to this project's dependents.
;
; Using cljx in an "application" setting (where you're producing artifacts for
; deployment, as opposed to for consumption by other Clojure/ClojureScript
; projects) would use largely the same cljx configuration, though likely a
; different lein-cljsbuild configuration (so that the generated JavaScript is
; placed appropriately for inclusion in .war, ubarjar, or other resource bundles
; destined for deployment).

(defproject org.you/yourproject "1.0.0"
  :jar-exclusions [#"\.cljx|\.swp|\.swo|\.DS_Store"]
  :source-paths ["src/cljx"]
  :test-paths ["target/test-classes"]
  :dependencies [[org.clojure/clojure "1.6.0-alpha1"]]
  ;; needs disabling for Cljx. See
  ;; https://github.com/technomancy/leiningen/blob/master/sample.project.clj#L389-392.
  :auto-clean false
  :cljx {:builds [{:source-paths ["src/cljx"]
                   :output-path "target/classes"
                   :rules :clj}

                  {:source-paths ["src/cljx"]
                   :output-path "target/classes"
                   :rules :cljs}

                  {:source-paths ["test/cljx"]
                   :output-path "target/test-classes"
                   :rules :clj}

                  {:source-paths ["test/cljx"]
                   :output-path "target/test-classes"
                   :rules :cljs}]}

  :cljsbuild {:test-commands {"node" ["node" :node-runner "target/testable.js"]}
              :builds [{:source-paths ["target/classes" "target/test-classes"]
                        :compiler {:output-to "target/testable.js"
                                   :optimizations :advanced
                                   :pretty-print true}}]}

  :profiles {:dev {:plugins [[org.clojure/clojurescript "0.0-2156"]
                             [com.keminglabs/cljx "CLJX-VERSION-HERE"]
                             [lein-cljsbuild "1.0.1"]]
                   :aliases {"cleantest" ["do" "clean," "cljx" "once," "test,"
                                          "cljsbuild" "test"]
                             "deploy" ["do" "clean," "cljx" "once," "deploy" "clojars"]}}})

