/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.StringHolder;
import IceGrid.ServerDescriptor;
import IceGrid.ServerState;
import IceGridGUI.Coordinator;
import IceGridGUI.LiveActions;
import IceGridGUI.LiveDeployment.CommunicatorEditor;
import IceGridGUI.LiveDeployment.Node;
import IceGridGUI.LiveDeployment.Server;
import IceGridGUI.LiveDeployment.TableField;
import IceGridGUI.Utils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

class ServerEditor
extends CommunicatorEditor {
    private Coordinator _coordinator;
    private Server _target;
    private JTextField _currentState = new JTextField(20);
    private JTextField _currentPid = new JTextField(20);
    private JCheckBox _enabled = new JCheckBox("Enabled");
    private JTextField _application = new JTextField(20);
    private JButton _gotoApplication;
    private JTextField _exe = new JTextField(20);
    private JTextField _pwd = new JTextField(20);
    private JTextField _user = new JTextField(20);
    private JTextField _activation = new JTextField(20);
    private JTextField _activationTimeout = new JTextField(20);
    private JTextField _deactivationTimeout = new JTextField(20);
    private JCheckBox _allocatable = new JCheckBox("Allocatable");
    private TableField _envs = new TableField("Name", "Value");
    private JTextField _options = new JTextField(20);
    private JCheckBox _applicationDistrib = new JCheckBox("Depends on the application distribution");
    private JTextField _icepatch = new JTextField(20);
    private JTextField _directories = new JTextField(20);
    private JToolBar _toolBar;

    public JToolBar getToolBar() {
        if (this._toolBar == null) {
            this._toolBar = new ToolBar();
        }
        return this._toolBar;
    }

    ServerEditor(Coordinator c) {
        this._coordinator = c;
        this._currentState.setEditable(false);
        this._currentPid.setEditable(false);
        this._enabled.setEnabled(false);
        this._application.setEditable(false);
        this._exe.setEditable(false);
        this._pwd.setEditable(false);
        this._activation.setEditable(false);
        this._activationTimeout.setEditable(false);
        this._deactivationTimeout.setEditable(false);
        this._options.setEditable(false);
        this._user.setEditable(false);
        this._allocatable.setEnabled(false);
        this._applicationDistrib.setEnabled(false);
        this._icepatch.setEditable(false);
        this._directories.setEditable(false);
        AbstractAction gotoApplication = new AbstractAction("", Utils.getIcon("/icons/16x16/goto.png")){

            public void actionPerformed(ActionEvent e) {
                ServerEditor.this._coordinator.openLiveApplication(ServerEditor.this._application.getText()).getRoot().selectServer(((Node)ServerEditor.this._target.getParent()).getId(), ServerEditor.this._target.getId());
            }
        };
        gotoApplication.putValue("ShortDescription", "View/Edit this application");
        this._gotoApplication = new JButton(gotoApplication);
    }

    void show(Server server) {
        this._target = server;
        ServerState state = server.getState();
        if (state == null) {
            this._currentState.setText("Unknown");
            this._currentPid.setText("");
            this._enabled.setSelected(false);
        } else {
            this._currentState.setText(state.toString());
            int pid = server.getPid();
            if (pid == 0) {
                this._currentPid.setText("");
            } else {
                this._currentPid.setText(Integer.toString(pid));
            }
            this._enabled.setSelected(server.isEnabled());
        }
        ServerDescriptor descriptor = server.getServerDescriptor();
        final Utils.Resolver resolver = server.getResolver();
        this._application.setText(resolver.find("application"));
        super.show(descriptor, server.getProperties(), resolver);
        this._exe.setText(resolver.substitute(descriptor.exe));
        this._pwd.setText(resolver.substitute(descriptor.pwd));
        StringHolder toolTipHolder = new StringHolder();
        Utils.Stringifier stringifier = new Utils.Stringifier(){

            public String toString(Object obj) {
                return resolver.substitute((String)obj);
            }
        };
        this._options.setText(Utils.stringify(descriptor.options, stringifier, " ", toolTipHolder));
        this._options.setToolTipText(toolTipHolder.value);
        this._envs.setEnvs(descriptor.envs, resolver);
        this._user.setText(resolver.substitute(descriptor.user));
        this._activation.setText(resolver.substitute(descriptor.activation));
        this._activationTimeout.setText(resolver.substitute(descriptor.activationTimeout));
        this._deactivationTimeout.setText(resolver.substitute(descriptor.deactivationTimeout));
        this._allocatable.setSelected(descriptor.allocatable);
        this._applicationDistrib.setSelected(descriptor.applicationDistrib);
        this._icepatch.setText(resolver.substitute(resolver.substitute(descriptor.distrib.icepatch)));
        toolTipHolder = new StringHolder();
        this._directories.setText(Utils.stringify(descriptor.distrib.directories, stringifier, ", ", toolTipHolder));
        String toolTip = "<html>Include only these directories";
        if (toolTipHolder.value != null) {
            toolTip = toolTip + ":<br>" + toolTipHolder.value;
        }
        toolTip = toolTip + "</html>";
        this._directories.setToolTipText(toolTip);
    }

    protected void appendProperties(DefaultFormBuilder builder) {
        builder.appendSeparator("Runtime Status");
        builder.append("State");
        builder.append((Component)this._currentState, 3);
        builder.nextLine();
        builder.append("Process ID");
        builder.append((Component)this._currentPid, 3);
        builder.nextLine();
        builder.append("", (Component)this._enabled);
        builder.nextLine();
        builder.appendSeparator("Configuration");
        builder.append("Application");
        builder.append(this._application);
        builder.append(this._gotoApplication);
        builder.nextLine();
        super.appendProperties(builder);
        builder.appendSeparator("Activation");
        builder.append("Path to Executable");
        builder.append((Component)this._exe, 3);
        builder.nextLine();
        builder.append("Working Directory");
        builder.append((Component)this._pwd, 3);
        builder.nextLine();
        builder.append("Command Arguments");
        builder.append((Component)this._options, 3);
        builder.nextLine();
        builder.append("Run as");
        builder.append((Component)this._user, 3);
        builder.nextLine();
        builder.append("Environment Variables");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._envs);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Activation Mode");
        builder.append((Component)this._activation, 3);
        builder.nextLine();
        builder.append("Activation Timeout");
        builder.append((Component)this._activationTimeout, 3);
        builder.nextLine();
        builder.append("Deactivation Timeout");
        builder.append((Component)this._deactivationTimeout, 3);
        builder.nextLine();
        builder.append("", (Component)this._allocatable);
        builder.nextLine();
        JComponent c = builder.appendSeparator("Distribution");
        c.setToolTipText("Files specific to this server");
        builder.append("", (Component)this._applicationDistrib);
        builder.nextLine();
        builder.append("IcePatch2 Proxy");
        builder.append((Component)this._icepatch, 3);
        builder.nextLine();
        builder.append("Directories");
        builder.append((Component)this._directories, 3);
        builder.nextLine();
    }

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Server Properties");
    }

    private class ToolBar
    extends JToolBar {
        private ToolBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            this.setFloatable(false);
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            LiveActions la = ServerEditor.this._coordinator.getLiveActionsForMenu();
            this.add(la.get(0));
            this.add(la.get(1));
            this.addSeparator();
            this.add(la.get(2));
            this.add(la.get(3));
        }
    }
}

