/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGridGUI.Application.Editor;
import IceGridGUI.Utils;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class MapField
extends JTable {
    private DefaultTableModel _model;
    private Vector _columnNames;
    private boolean _editable = false;
    private boolean _substituteKey;
    private Editor _editor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MapField(Editor editor, String headKey, String headValue, boolean substituteKey) {
        this._substituteKey = substituteKey;
        this._columnNames = new Vector(2);
        this._columnNames.add(headKey);
        this._columnNames.add(headValue);
        this._editor = editor;
        AbstractAction deleteRow = new AbstractAction("Delete selected row(s)"){

            public void actionPerformed(ActionEvent e) {
                if (MapField.this._editable) {
                    int selectedRow;
                    if (MapField.this.isEditing()) {
                        MapField.this.getCellEditor().stopCellEditing();
                    }
                    while ((selectedRow = MapField.this.getSelectedRow()) != -1) {
                        MapField.this._model.removeRow(selectedRow);
                    }
                }
            }
        };
        this.getActionMap().put("delete", deleteRow);
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
    }

    public void set(Map map, Utils.Resolver resolver, boolean editable) {
        this._editable = editable;
        Vector vector = new Vector(map.size());
        Iterator p = map.entrySet().iterator();
        while (p.hasNext()) {
            Vector<String> row = new Vector<String>(2);
            Map.Entry entry = p.next();
            if (this._substituteKey) {
                row.add(Utils.substitute((String)entry.getKey(), resolver));
            } else {
                row.add((String)entry.getKey());
            }
            row.add(Utils.substitute((String)entry.getValue(), resolver));
            vector.add(row);
        }
        if (this._editable) {
            Vector<String> newRow = new Vector<String>(2);
            newRow.add("");
            newRow.add("");
            vector.add(newRow);
        }
        this._model = new DefaultTableModel(vector, this._columnNames){

            public boolean isCellEditable(int row, int column) {
                return MapField.this._editable;
            }
        };
        this._model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (MapField.this._editable) {
                    Object lastKey = MapField.this._model.getValueAt(MapField.this._model.getRowCount() - 1, 0);
                    if (lastKey != null && !lastKey.equals("")) {
                        MapField.this._model.addRow(new Object[]{"", ""});
                    }
                    MapField.this._editor.updated();
                }
            }
        });
        this.setModel(this._model);
        this.setCellSelectionEnabled(this._editable);
        this.setOpaque(this._editable);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(this._editable);
    }

    public TreeMap get() {
        if (!$assertionsDisabled && !this._editable) {
            throw new AssertionError();
        }
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        Vector<Vector> vector = this._model.getDataVector();
        TreeMap<String, String> result = new TreeMap<String, String>();
        Iterator<Vector> p = vector.iterator();
        while (p.hasNext()) {
            Vector row = p.next();
            String key = (String)row.elementAt(0);
            if (key == null || (key = key.trim()).equals("")) continue;
            String val = (String)row.elementAt(1);
            if (val == null) {
                val = "";
            }
            result.put(key, val);
        }
        return result;
    }

    static {
        $assertionsDisabled = !MapField.class.desiredAssertionStatus();
    }
}

