/*-
# X-BASED MASTERBALL(tm)
#
#  MballP.h
#
###
#
#  Copyright (c) 1994 - 2001	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Mball */

#ifndef _MballP_h
#define _MballP_h

#include "Mball.h"

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#define MAXRAND (2147483648.0)
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srand48
#define LRAND lrand48
#define MAXRAND (2147483648.0)
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand48
#define LRAND lrand48
#ifdef AIXV3
#define MAXRAND (2147483648.0)
#else
#define MAXRAND (32768.0)
#endif
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */

#ifndef SRAND
extern void SetRNG(long int s);

#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);

#define LRAND() LongRNG()
#endif
#ifndef MAXRAND
#define MAXRAND (2147483648.0)
#endif

#define NRAND(X) ((int)(LRAND()%(X)))

#define SYMBOL ':'

#define TOP 0
#define TTR 1
#define TR 2
#define RIGHT 3
#define BR 4
#define BBR 5
#define BOTTOM 6
#define BBL 7
#define BL 8
#define LEFT 9
#define TL 10
#define TTL 11
#define COORD 12
#define CW 13
#define CCW 23
#define CUTS (COORD / 2)

/* The following are in xmball.c also */
#define MINWEDGES 2
#define MAXWEDGES 12
#define MINRINGS 1

#define DEFAULTWEDGES 8
#define DEFAULTRINGS 4
#define SAME 0
#define OPPOSITE 1
#define DOWN 0
#define UP 1
#define MAXVIEWS 2

#define NUM_DEGREES 360
#define ST_ANG  (NUM_DEGREES/2)
#define RT_ANG  (NUM_DEGREES/4)
#define DEGREES(x) ((x)/M_PI*(double)ST_ANG)
#define RADIANS(x) (M_PI*(x)/(double)ST_ANG)
#define MULT 64
#define CIRCLE (NUM_DEGREES*MULT)
#define CIRCLE_2  (CIRCLE/2)
#define CIRCLE_4  (CIRCLE/4)

#define ABS(a) (((a)<0)?(-a):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

typedef struct _MballLoc {
	int         wedge, direction;
} MballLoc;

typedef struct _MballPart {
	Pixel       foreground;
	Pixel       borderColor;
	Pixel       wedgeColor[MAXWEDGES];
	MballLoc   *mballLoc[MAXWEDGES];
	int         currentWedge, currentRing;
	Boolean     started, practice, orient, vertical, mono, reverse;
	int         depth;
	int         base;
	int         wedges, rings;
	Position    delta, dr;
	Position    mballLength;
	Position    wedgeLength;
	Position    viewLength, viewMiddle;
	XPoint      puzzleSize;
	XPoint      puzzleOffset, letterOffset;
	GC          puzzleGC;
	GC          borderGC;
	GC          wedgeGC[MAXWEDGES];
	GC          inverseGC;
	String      wedgeName[MAXWEDGES];
	char       *username;
	XtCallbackList select;
} MballPart;

typedef struct _MballRec {
	CorePart    core;
	MballPart   mball;
} MballRec;

/* This gets around C's inability to do inheritance */
typedef struct _MballClassPart {
	int         ignore;
} MballClassPart;

typedef struct _MballClassRec {
	CoreClassPart core_class;
	MballClassPart mball_class;
} MballClassRec;

extern MballClassRec mballClassRec;
extern MballLoc *startLoc[MAXWEDGES];

extern void MoveMball(MballWidget w, int wedge, int ring, int direction, int control);

#if 0
/* For future auto-solver */
extern void SolveWedges(MballWidget w);

#endif
extern void DrawAllWedges(MballWidget w);
extern Boolean CheckSolved(MballWidget w);
extern void InitMoves(void);
extern void PutMove(int wedge, int ring, int direction, int control);
extern void GetMove(int *wedge, int *ring, int *direction, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(MballWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, MballWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, MballWidget w);
extern void PrintStartPosition(FILE * fp, MballWidget w);
extern void SetStartPosition(MballWidget w);

#endif /* _MballP_h */
