/* $Id: pkt_exams.c,v 1.6 2001/10/20 15:23:55 fygrave Exp $ */
/*
** Copyright (C) 2001 Fyodor Yarochkin <fygrave@tigerteam.net>,
**                    Ofir Arkin       <ofir@sys-security.com>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** All material for nonprofit, educational use only.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#include "xprobe.h"

/* XXX: finish checksum verification */

int udp_checksum_ver(rpack_t *udp_res) {
    struct udphdr *udp, *orig_udp;
    struct ip *ip;


    /* find udp header in unreach datagram */
    ip = (struct ip *) ((VOIDPTR_T)udp_res->pkt + (VOIDPTR_T)(udp_res->ip->ip_hl<<2) + 8);
    udp = (struct udphdr *)((VOIDPTR_T)udp_res->pkt +
          (VOIDPTR_T)(udp_res->ip->ip_hl<<2) + 8 + (ip->ip_hl<<2));

    if ((void *)udp > (void *)((VOIDPTR_T)udp_res->pkt + (VOIDPTR_T)udp_res->packsize)) {
        fprintf(stderr, "UDP header is not within received datagram\n");
            return UDP_CKSUM_BADDGRAM;
    }
    if (udp->uh_sum == 0) return UDP_CKSUM_ZERO;
    orig_udp = (struct udphdr *)((VOIDPTR_T)udp_res->orig_pkt + (VOIDPTR_T)sizeof(struct ip));
    
    if (udp->uh_sum == (orig_udp->uh_sum)) return UDP_CKSUM_GOOD; 
    return UDP_CKSUM_BAD; 
}
    
int icmp_unreach_lencheck(rpack_t *rpack) {
    struct ip *ip;

    /* find ip header in unreach datagram */
    ip = (struct ip *) ((VOIDPTR_T)rpack->pkt + (VOIDPTR_T)(rpack->ip->ip_hl<<2) + 8);

    if (ntohs(ip->ip_len) == UDP_LEN_ALL) return ICMPUNREACH_LEN_OK;
    if (ntohs(ip->ip_len) < UDP_LEN_ALL) return ICMPUNREACH_LEN_LS;

return ICMPUNREACH_LEN_GT;
}


int frag_bits_flipped(rpack_t *rpack) {
    struct ip *ip;

    /* find ip header in unreach datagram */
    ip = (struct ip *) ((VOIDPTR_T)rpack->pkt + (VOIDPTR_T)(rpack->ip->ip_hl<<2) + 8);

    if(ip->ip_off & htons(IP_DF)) return 0;
    if (ip->ip_off) return 1; /* bits are ok */ 
    return 2; /* bit are 0 */
}


/* XXX: finish checksum verification */
int ip_checksum_ok(rpack_t *rpack) {
    struct ip *ip;

    /* find ip header in unreach datagram */
    ip = (struct ip *) ((VOIDPTR_T)rpack->pkt + (VOIDPTR_T)(rpack->ip->ip_hl<<2) + 8);
    return(ip->ip_sum);
}

