/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/vrrp_xif.cc,v 1.2 2009/01/05 18:31:13 jtc Exp $"

#include "vrrp_xif.hh"

bool
XrlVrrpV0p1Client::send_add_vrid(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const AddVridCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/add_vrid");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(vrid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, vrid);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_add_vrid, cb));
}


/* Unmarshall add_vrid */
void
XrlVrrpV0p1Client::unmarshall_add_vrid(
	const XrlError&	e,
	XrlArgs*	a,
	AddVridCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlVrrpV0p1Client::send_delete_vrid(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const DeleteVridCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/delete_vrid");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(vrid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, vrid);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_delete_vrid, cb));
}


/* Unmarshall delete_vrid */
void
XrlVrrpV0p1Client::unmarshall_delete_vrid(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteVridCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlVrrpV0p1Client::send_set_priority(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const uint32_t&	priority,
	const SetPriorityCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/set_priority");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(vrid));
        x->args().add(XrlAtom(priority));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, vrid);
    x->args().set_arg(3, priority);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_set_priority, cb));
}


/* Unmarshall set_priority */
void
XrlVrrpV0p1Client::unmarshall_set_priority(
	const XrlError&	e,
	XrlArgs*	a,
	SetPriorityCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlVrrpV0p1Client::send_set_interval(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const uint32_t&	interval,
	const SetIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/set_interval");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(vrid));
        x->args().add(XrlAtom(interval));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, vrid);
    x->args().set_arg(3, interval);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_set_interval, cb));
}


/* Unmarshall set_interval */
void
XrlVrrpV0p1Client::unmarshall_set_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlVrrpV0p1Client::send_set_preempt(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const bool&	preempt,
	const SetPreemptCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/set_preempt");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(vrid));
        x->args().add(XrlAtom(preempt));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, vrid);
    x->args().set_arg(3, preempt);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_set_preempt, cb));
}


/* Unmarshall set_preempt */
void
XrlVrrpV0p1Client::unmarshall_set_preempt(
	const XrlError&	e,
	XrlArgs*	a,
	SetPreemptCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlVrrpV0p1Client::send_set_disable(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const bool&	disable,
	const SetDisableCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/set_disable");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(vrid));
        x->args().add(XrlAtom(disable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, vrid);
    x->args().set_arg(3, disable);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_set_disable, cb));
}


/* Unmarshall set_disable */
void
XrlVrrpV0p1Client::unmarshall_set_disable(
	const XrlError&	e,
	XrlArgs*	a,
	SetDisableCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlVrrpV0p1Client::send_add_ip(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const IPv4&	ip,
	const AddIpCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/add_ip");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(vrid));
        x->args().add(XrlAtom(ip));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, vrid);
    x->args().set_arg(3, ip);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_add_ip, cb));
}


/* Unmarshall add_ip */
void
XrlVrrpV0p1Client::unmarshall_add_ip(
	const XrlError&	e,
	XrlArgs*	a,
	AddIpCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlVrrpV0p1Client::send_delete_ip(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const IPv4&	ip,
	const DeleteIpCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/delete_ip");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(vrid));
        x->args().add(XrlAtom(ip));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, vrid);
    x->args().set_arg(3, ip);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_delete_ip, cb));
}


/* Unmarshall delete_ip */
void
XrlVrrpV0p1Client::unmarshall_delete_ip(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteIpCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlVrrpV0p1Client::send_get_ifs(
	const char*	dst_xrl_target_name,
	const GetIfsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/get_ifs");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_get_ifs, cb));
}


/* Unmarshall get_ifs */
void
XrlVrrpV0p1Client::unmarshall_get_ifs(
	const XrlError&	e,
	XrlArgs*	a,
	GetIfsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList ifs;
    try {
	a->get("ifs", ifs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &ifs);
}

bool
XrlVrrpV0p1Client::send_get_vifs(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const GetVifsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/get_vifs");
        x->args().add(XrlAtom(ifname));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_get_vifs, cb));
}


/* Unmarshall get_vifs */
void
XrlVrrpV0p1Client::unmarshall_get_vifs(
	const XrlError&	e,
	XrlArgs*	a,
	GetVifsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList vifs;
    try {
	a->get("vifs", vifs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &vifs);
}

bool
XrlVrrpV0p1Client::send_get_vrids(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const GetVridsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/get_vrids");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_get_vrids, cb));
}


/* Unmarshall get_vrids */
void
XrlVrrpV0p1Client::unmarshall_get_vrids(
	const XrlError&	e,
	XrlArgs*	a,
	GetVridsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList vrids;
    try {
	a->get("vrids", vrids);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &vrids);
}

bool
XrlVrrpV0p1Client::send_get_vrid_info(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const uint32_t&	vrid,
	const GetVridInfoCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "vrrp/0.1/get_vrid_info");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(vrid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, vrid);

    return _sender->send(*x, callback(this, &XrlVrrpV0p1Client::unmarshall_get_vrid_info, cb));
}


/* Unmarshall get_vrid_info */
void
XrlVrrpV0p1Client::unmarshall_get_vrid_info(
	const XrlError&	e,
	XrlArgs*	a,
	GetVridInfoCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0);
	return;
    } else if (a && a->size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(2));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    string state;
    IPv4 master;
    try {
	a->get("state", state);
	a->get("master", master);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    cb->dispatch(e, &state, &master);
}
