/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/rip_xif.cc,v 1.25 2009/01/05 18:31:13 jtc Exp $"

#include "rip_xif.hh"

bool
XrlRipV0p1Client::send_add_rip_address(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const AddRipAddressCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/add_rip_address");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_add_rip_address, cb));
}


/* Unmarshall add_rip_address */
void
XrlRipV0p1Client::unmarshall_add_rip_address(
	const XrlError&	e,
	XrlArgs*	a,
	AddRipAddressCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_remove_rip_address(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const RemoveRipAddressCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/remove_rip_address");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_remove_rip_address, cb));
}


/* Unmarshall remove_rip_address */
void
XrlRipV0p1Client::unmarshall_remove_rip_address(
	const XrlError&	e,
	XrlArgs*	a,
	RemoveRipAddressCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_set_rip_address_enabled(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const bool&	enabled,
	const SetRipAddressEnabledCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_rip_address_enabled");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(enabled));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, enabled);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_rip_address_enabled, cb));
}


/* Unmarshall set_rip_address_enabled */
void
XrlRipV0p1Client::unmarshall_set_rip_address_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	SetRipAddressEnabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_rip_address_enabled(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const RipAddressEnabledCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/rip_address_enabled");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_rip_address_enabled, cb));
}


/* Unmarshall rip_address_enabled */
void
XrlRipV0p1Client::unmarshall_rip_address_enabled(
	const XrlError&	e,
	XrlArgs*	a,
	RipAddressEnabledCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool enabled;
    try {
	a->get("enabled", enabled);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &enabled);
}

bool
XrlRipV0p1Client::send_set_cost(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	cost,
	const SetCostCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_cost");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(cost));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, cost);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_cost, cb));
}


/* Unmarshall set_cost */
void
XrlRipV0p1Client::unmarshall_set_cost(
	const XrlError&	e,
	XrlArgs*	a,
	SetCostCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_cost(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const CostCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/cost");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_cost, cb));
}


/* Unmarshall cost */
void
XrlRipV0p1Client::unmarshall_cost(
	const XrlError&	e,
	XrlArgs*	a,
	CostCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t cost;
    try {
	a->get("cost", cost);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &cost);
}

bool
XrlRipV0p1Client::send_set_horizon(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const string&	horizon,
	const SetHorizonCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_horizon");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(horizon));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, horizon);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_horizon, cb));
}


/* Unmarshall set_horizon */
void
XrlRipV0p1Client::unmarshall_set_horizon(
	const XrlError&	e,
	XrlArgs*	a,
	SetHorizonCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_horizon(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const HorizonCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/horizon");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_horizon, cb));
}


/* Unmarshall horizon */
void
XrlRipV0p1Client::unmarshall_horizon(
	const XrlError&	e,
	XrlArgs*	a,
	HorizonCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    string horizon;
    try {
	a->get("horizon", horizon);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &horizon);
}

bool
XrlRipV0p1Client::send_set_passive(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const bool&	passive,
	const SetPassiveCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_passive");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(passive));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, passive);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_passive, cb));
}


/* Unmarshall set_passive */
void
XrlRipV0p1Client::unmarshall_set_passive(
	const XrlError&	e,
	XrlArgs*	a,
	SetPassiveCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_passive(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const PassiveCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/passive");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_passive, cb));
}


/* Unmarshall passive */
void
XrlRipV0p1Client::unmarshall_passive(
	const XrlError&	e,
	XrlArgs*	a,
	PassiveCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool passive;
    try {
	a->get("passive", passive);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &passive);
}

bool
XrlRipV0p1Client::send_set_accept_non_rip_requests(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const bool&	accept,
	const SetAcceptNonRipRequestsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_accept_non_rip_requests");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(accept));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, accept);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_accept_non_rip_requests, cb));
}


/* Unmarshall set_accept_non_rip_requests */
void
XrlRipV0p1Client::unmarshall_set_accept_non_rip_requests(
	const XrlError&	e,
	XrlArgs*	a,
	SetAcceptNonRipRequestsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_accept_non_rip_requests(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const AcceptNonRipRequestsCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/accept_non_rip_requests");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_accept_non_rip_requests, cb));
}


/* Unmarshall accept_non_rip_requests */
void
XrlRipV0p1Client::unmarshall_accept_non_rip_requests(
	const XrlError&	e,
	XrlArgs*	a,
	AcceptNonRipRequestsCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool accept;
    try {
	a->get("accept", accept);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &accept);
}

bool
XrlRipV0p1Client::send_set_accept_default_route(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const bool&	accept,
	const SetAcceptDefaultRouteCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_accept_default_route");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(accept));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, accept);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_accept_default_route, cb));
}


/* Unmarshall set_accept_default_route */
void
XrlRipV0p1Client::unmarshall_set_accept_default_route(
	const XrlError&	e,
	XrlArgs*	a,
	SetAcceptDefaultRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_accept_default_route(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const AcceptDefaultRouteCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/accept_default_route");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_accept_default_route, cb));
}


/* Unmarshall accept_default_route */
void
XrlRipV0p1Client::unmarshall_accept_default_route(
	const XrlError&	e,
	XrlArgs*	a,
	AcceptDefaultRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool accept;
    try {
	a->get("accept", accept);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &accept);
}

bool
XrlRipV0p1Client::send_set_advertise_default_route(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const bool&	advertise,
	const SetAdvertiseDefaultRouteCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_advertise_default_route");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(advertise));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, advertise);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_advertise_default_route, cb));
}


/* Unmarshall set_advertise_default_route */
void
XrlRipV0p1Client::unmarshall_set_advertise_default_route(
	const XrlError&	e,
	XrlArgs*	a,
	SetAdvertiseDefaultRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_advertise_default_route(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const AdvertiseDefaultRouteCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/advertise_default_route");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_advertise_default_route, cb));
}


/* Unmarshall advertise_default_route */
void
XrlRipV0p1Client::unmarshall_advertise_default_route(
	const XrlError&	e,
	XrlArgs*	a,
	AdvertiseDefaultRouteCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    bool advertise;
    try {
	a->get("advertise", advertise);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &advertise);
}

bool
XrlRipV0p1Client::send_set_route_timeout(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	t_secs,
	const SetRouteTimeoutCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_route_timeout");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(t_secs));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, t_secs);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_route_timeout, cb));
}


/* Unmarshall set_route_timeout */
void
XrlRipV0p1Client::unmarshall_set_route_timeout(
	const XrlError&	e,
	XrlArgs*	a,
	SetRouteTimeoutCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_route_timeout(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const RouteTimeoutCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/route_timeout");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_route_timeout, cb));
}


/* Unmarshall route_timeout */
void
XrlRipV0p1Client::unmarshall_route_timeout(
	const XrlError&	e,
	XrlArgs*	a,
	RouteTimeoutCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t t_secs;
    try {
	a->get("t_secs", t_secs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &t_secs);
}

bool
XrlRipV0p1Client::send_set_deletion_delay(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	t_secs,
	const SetDeletionDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_deletion_delay");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(t_secs));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, t_secs);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_deletion_delay, cb));
}


/* Unmarshall set_deletion_delay */
void
XrlRipV0p1Client::unmarshall_set_deletion_delay(
	const XrlError&	e,
	XrlArgs*	a,
	SetDeletionDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_deletion_delay(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const DeletionDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/deletion_delay");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_deletion_delay, cb));
}


/* Unmarshall deletion_delay */
void
XrlRipV0p1Client::unmarshall_deletion_delay(
	const XrlError&	e,
	XrlArgs*	a,
	DeletionDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t t_secs;
    try {
	a->get("t_secs", t_secs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &t_secs);
}

bool
XrlRipV0p1Client::send_set_request_interval(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	t_secs,
	const SetRequestIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_request_interval");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(t_secs));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, t_secs);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_request_interval, cb));
}


/* Unmarshall set_request_interval */
void
XrlRipV0p1Client::unmarshall_set_request_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetRequestIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_request_interval(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const RequestIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/request_interval");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_request_interval, cb));
}


/* Unmarshall request_interval */
void
XrlRipV0p1Client::unmarshall_request_interval(
	const XrlError&	e,
	XrlArgs*	a,
	RequestIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t t_secs;
    try {
	a->get("t_secs", t_secs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &t_secs);
}

bool
XrlRipV0p1Client::send_set_update_interval(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	t_secs,
	const SetUpdateIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_update_interval");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(t_secs));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, t_secs);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_update_interval, cb));
}


/* Unmarshall set_update_interval */
void
XrlRipV0p1Client::unmarshall_set_update_interval(
	const XrlError&	e,
	XrlArgs*	a,
	SetUpdateIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_update_interval(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const UpdateIntervalCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/update_interval");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_update_interval, cb));
}


/* Unmarshall update_interval */
void
XrlRipV0p1Client::unmarshall_update_interval(
	const XrlError&	e,
	XrlArgs*	a,
	UpdateIntervalCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t t_secs;
    try {
	a->get("t_secs", t_secs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &t_secs);
}

bool
XrlRipV0p1Client::send_set_update_jitter(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	t_jitter,
	const SetUpdateJitterCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_update_jitter");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(t_jitter));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, t_jitter);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_update_jitter, cb));
}


/* Unmarshall set_update_jitter */
void
XrlRipV0p1Client::unmarshall_set_update_jitter(
	const XrlError&	e,
	XrlArgs*	a,
	SetUpdateJitterCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_update_jitter(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const UpdateJitterCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/update_jitter");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_update_jitter, cb));
}


/* Unmarshall update_jitter */
void
XrlRipV0p1Client::unmarshall_update_jitter(
	const XrlError&	e,
	XrlArgs*	a,
	UpdateJitterCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t t_jitter;
    try {
	a->get("t_jitter", t_jitter);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &t_jitter);
}

bool
XrlRipV0p1Client::send_set_triggered_update_delay(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	t_secs,
	const SetTriggeredUpdateDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_triggered_update_delay");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(t_secs));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, t_secs);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_triggered_update_delay, cb));
}


/* Unmarshall set_triggered_update_delay */
void
XrlRipV0p1Client::unmarshall_set_triggered_update_delay(
	const XrlError&	e,
	XrlArgs*	a,
	SetTriggeredUpdateDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_triggered_update_delay(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const TriggeredUpdateDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/triggered_update_delay");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_triggered_update_delay, cb));
}


/* Unmarshall triggered_update_delay */
void
XrlRipV0p1Client::unmarshall_triggered_update_delay(
	const XrlError&	e,
	XrlArgs*	a,
	TriggeredUpdateDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t t_secs;
    try {
	a->get("t_secs", t_secs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &t_secs);
}

bool
XrlRipV0p1Client::send_set_triggered_update_jitter(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	t_jitter,
	const SetTriggeredUpdateJitterCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_triggered_update_jitter");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(t_jitter));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, t_jitter);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_triggered_update_jitter, cb));
}


/* Unmarshall set_triggered_update_jitter */
void
XrlRipV0p1Client::unmarshall_set_triggered_update_jitter(
	const XrlError&	e,
	XrlArgs*	a,
	SetTriggeredUpdateJitterCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_triggered_update_jitter(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const TriggeredUpdateJitterCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/triggered_update_jitter");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_triggered_update_jitter, cb));
}


/* Unmarshall triggered_update_jitter */
void
XrlRipV0p1Client::unmarshall_triggered_update_jitter(
	const XrlError&	e,
	XrlArgs*	a,
	TriggeredUpdateJitterCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t t_jitter;
    try {
	a->get("t_jitter", t_jitter);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &t_jitter);
}

bool
XrlRipV0p1Client::send_set_interpacket_delay(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	t_msecs,
	const SetInterpacketDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_interpacket_delay");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(t_msecs));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, t_msecs);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_interpacket_delay, cb));
}


/* Unmarshall set_interpacket_delay */
void
XrlRipV0p1Client::unmarshall_set_interpacket_delay(
	const XrlError&	e,
	XrlArgs*	a,
	SetInterpacketDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_interpacket_delay(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const InterpacketDelayCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/interpacket_delay");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_interpacket_delay, cb));
}


/* Unmarshall interpacket_delay */
void
XrlRipV0p1Client::unmarshall_interpacket_delay(
	const XrlError&	e,
	XrlArgs*	a,
	InterpacketDelayCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    uint32_t t_msecs;
    try {
	a->get("t_msecs", t_msecs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &t_msecs);
}

bool
XrlRipV0p1Client::send_set_simple_authentication_key(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const string&	password,
	const SetSimpleAuthenticationKeyCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_simple_authentication_key");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(password));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, password);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_simple_authentication_key, cb));
}


/* Unmarshall set_simple_authentication_key */
void
XrlRipV0p1Client::unmarshall_set_simple_authentication_key(
	const XrlError&	e,
	XrlArgs*	a,
	SetSimpleAuthenticationKeyCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_delete_simple_authentication_key(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const DeleteSimpleAuthenticationKeyCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/delete_simple_authentication_key");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_delete_simple_authentication_key, cb));
}


/* Unmarshall delete_simple_authentication_key */
void
XrlRipV0p1Client::unmarshall_delete_simple_authentication_key(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteSimpleAuthenticationKeyCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_set_md5_authentication_key(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	key_id,
	const string&	password,
	const string&	start_time,
	const string&	end_time,
	const SetMd5AuthenticationKeyCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/set_md5_authentication_key");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(key_id));
        x->args().add(XrlAtom(password));
        x->args().add(XrlAtom(start_time));
        x->args().add(XrlAtom(end_time));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, key_id);
    x->args().set_arg(4, password);
    x->args().set_arg(5, start_time);
    x->args().set_arg(6, end_time);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_set_md5_authentication_key, cb));
}


/* Unmarshall set_md5_authentication_key */
void
XrlRipV0p1Client::unmarshall_set_md5_authentication_key(
	const XrlError&	e,
	XrlArgs*	a,
	SetMd5AuthenticationKeyCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_delete_md5_authentication_key(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const uint32_t&	key_id,
	const DeleteMd5AuthenticationKeyCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/delete_md5_authentication_key");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(key_id));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, key_id);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_delete_md5_authentication_key, cb));
}


/* Unmarshall delete_md5_authentication_key */
void
XrlRipV0p1Client::unmarshall_delete_md5_authentication_key(
	const XrlError&	e,
	XrlArgs*	a,
	DeleteMd5AuthenticationKeyCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlRipV0p1Client::send_rip_address_status(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const RipAddressStatusCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/rip_address_status");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_rip_address_status, cb));
}


/* Unmarshall rip_address_status */
void
XrlRipV0p1Client::unmarshall_rip_address_status(
	const XrlError&	e,
	XrlArgs*	a,
	RipAddressStatusCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    string status;
    try {
	a->get("status", status);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &status);
}

bool
XrlRipV0p1Client::send_get_all_addresses(
	const char*	dst_xrl_target_name,
	const GetAllAddressesCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/get_all_addresses");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_get_all_addresses, cb));
}


/* Unmarshall get_all_addresses */
void
XrlRipV0p1Client::unmarshall_get_all_addresses(
	const XrlError&	e,
	XrlArgs*	a,
	GetAllAddressesCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0);
	return;
    } else if (a && a->size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(3));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0);
	return;
    }
    XrlAtomList ifnames;
    XrlAtomList vifnames;
    XrlAtomList addrs;
    try {
	a->get("ifnames", ifnames);
	a->get("vifnames", vifnames);
	a->get("addrs", addrs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0);
	return;
    }
    cb->dispatch(e, &ifnames, &vifnames, &addrs);
}

bool
XrlRipV0p1Client::send_get_counters(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const GetCountersCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/get_counters");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_get_counters, cb));
}


/* Unmarshall get_counters */
void
XrlRipV0p1Client::unmarshall_get_counters(
	const XrlError&	e,
	XrlArgs*	a,
	GetCountersCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0);
	return;
    } else if (a && a->size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(2));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    XrlAtomList counter_descriptions;
    XrlAtomList counter_values;
    try {
	a->get("counter_descriptions", counter_descriptions);
	a->get("counter_values", counter_values);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0);
	return;
    }
    cb->dispatch(e, &counter_descriptions, &counter_values);
}

bool
XrlRipV0p1Client::send_get_peers(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const GetPeersCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/get_peers");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_get_peers, cb));
}


/* Unmarshall get_peers */
void
XrlRipV0p1Client::unmarshall_get_peers(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeersCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0);
	return;
    } else if (a && a->size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(1));
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    XrlAtomList peers;
    try {
	a->get("peers", peers);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0);
	return;
    }
    cb->dispatch(e, &peers);
}

bool
XrlRipV0p1Client::send_get_all_peers(
	const char*	dst_xrl_target_name,
	const GetAllPeersCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/get_all_peers");
    }

    x->set_target(dst_xrl_target_name);


    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_get_all_peers, cb));
}


/* Unmarshall get_all_peers */
void
XrlRipV0p1Client::unmarshall_get_all_peers(
	const XrlError&	e,
	XrlArgs*	a,
	GetAllPeersCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0, 0);
	return;
    } else if (a && a->size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(4));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    XrlAtomList peers;
    XrlAtomList ifnames;
    XrlAtomList vifnames;
    XrlAtomList addrs;
    try {
	a->get("peers", peers);
	a->get("ifnames", ifnames);
	a->get("vifnames", vifnames);
	a->get("addrs", addrs);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0, 0);
	return;
    }
    cb->dispatch(e, &peers, &ifnames, &vifnames, &addrs);
}

bool
XrlRipV0p1Client::send_get_peer_counters(
	const char*	dst_xrl_target_name,
	const string&	ifname,
	const string&	vifname,
	const IPv4&	addr,
	const IPv4&	peer,
	const GetPeerCountersCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/get_peer_counters");
        x->args().add(XrlAtom(ifname));
        x->args().add(XrlAtom(vifname));
        x->args().add(XrlAtom(addr));
        x->args().add(XrlAtom(peer));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, ifname);
    x->args().set_arg(1, vifname);
    x->args().set_arg(2, addr);
    x->args().set_arg(3, peer);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_get_peer_counters, cb));
}


/* Unmarshall get_peer_counters */
void
XrlRipV0p1Client::unmarshall_get_peer_counters(
	const XrlError&	e,
	XrlArgs*	a,
	GetPeerCountersCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e, 0, 0, 0);
	return;
    } else if (a && a->size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(3));
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0);
	return;
    }
    XrlAtomList counter_descriptions;
    XrlAtomList counter_values;
    uint32_t peer_last_active;
    try {
	a->get("counter_descriptions", counter_descriptions);
	a->get("counter_values", counter_values);
	a->get("peer_last_active", peer_last_active);
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	cb->dispatch(XrlError::BAD_ARGS(), 0, 0, 0);
	return;
    }
    cb->dispatch(e, &counter_descriptions, &counter_values, &peer_last_active);
}

bool
XrlRipV0p1Client::send_trace(
	const char*	dst_xrl_target_name,
	const string&	tvar,
	const bool&	enable,
	const TraceCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "rip/0.1/trace");
        x->args().add(XrlAtom(tvar));
        x->args().add(XrlAtom(enable));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, tvar);
    x->args().set_arg(1, enable);

    return _sender->send(*x, callback(this, &XrlRipV0p1Client::unmarshall_trace, cb));
}


/* Unmarshall trace */
void
XrlRipV0p1Client::unmarshall_trace(
	const XrlError&	e,
	XrlArgs*	a,
	TraceCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}
