/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 *
 * $XORP: xorp/xrl/interfaces/fea_rawlink_xif.hh,v 1.10 2009/01/05 18:31:12 jtc Exp $
 */

#ifndef __XRL_INTERFACES_FEA_RAWLINK_XIF_HH__
#define __XRL_INTERFACES_FEA_RAWLINK_XIF_HH__

#undef XORP_LIBRARY_NAME
#define XORP_LIBRARY_NAME "XifFeaRawlink"

#include "libxorp/xlog.h"
#include "libxorp/callback.hh"

#include "libxipc/xrl.hh"
#include "libxipc/xrl_error.hh"
#include "libxipc/xrl_sender.hh"


class XrlRawLinkV0p1Client {
public:
    XrlRawLinkV0p1Client(XrlSender* s) : _sender(s) {}
    virtual ~XrlRawLinkV0p1Client() {}

    typedef XorpCallback1<void, const XrlError&>::RefPtr SendCB;
    /**
     *  Send Xrl intended to:
     *
     *  Send a raw link-level packet on an interface.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param if_name the interface to send the packet on.
     *
     *  @param vif_name the vif to send the packet on.
     *
     *  @param src_address the MAC source address.
     *
     *  @param dst_address the MAC destination address.
     *
     *  @param ether_type the EtherType protocol type or the Destination SAP.
     *  It must be between 1536 and 65535 to specify the EtherType, or between
     *  1 and 255 to specify the Destination SAP IEEE 802.2 LLC frames.
     *
     *  @param payload the payload, everything after the MAC header.
     */
    bool send_send(
	const char*	dst_xrl_target_name,
	const string&	if_name,
	const string&	vif_name,
	const Mac&	src_address,
	const Mac&	dst_address,
	const uint32_t&	ether_type,
	const vector<uint8_t>&	payload,
	const SendCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr RegisterReceiverCB;
    /**
     *  Send Xrl intended to:
     *
     *  Register to receive raw link-level packets. The receiver is expected to
     *  support raw_link_client/0.1 interface.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param xrl_target_instance_name the receiver's XRL target instance
     *  name.
     *
     *  @param if_name the interface through which packets should be accepted.
     *
     *  @param vif_name the vif through which packets should be accepted.
     *
     *  @param ether_type the EtherType protocol number or the Destination SAP
     *  that the receiver is interested in. It must be between 1536 and 65535
     *  to specify the EtherType, or between 1 and 255 to specify the
     *  Destination SAP for IEEE 802.2 LLC frames. A protocol number of 0 is
     *  used to specify all protocols.
     *
     *  @param filter_program the optional filter program to be applied on the
     *  received packets. The program uses tcpdump(1) style expression.
     *
     *  @param enable_multicast_loopback if true then enable delivering of
     *  multicast datagrams back to this host (assuming the host is a member of
     *  the same multicast group).
     */
    bool send_register_receiver(
	const char*	dst_xrl_target_name,
	const string&	xrl_target_instance_name,
	const string&	if_name,
	const string&	vif_name,
	const uint32_t&	ether_type,
	const string&	filter_program,
	const bool&	enable_multicast_loopback,
	const RegisterReceiverCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr UnregisterReceiverCB;
    /**
     *  Send Xrl intended to:
     *
     *  Unregister to receive raw link-level packets.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param xrl_target_instance_name the receiver's XRL target instance
     *  name.
     *
     *  @param if_name the interface through which packets should not be
     *  accepted.
     *
     *  @param vif_name the vif through which packets should not be accepted.
     *
     *  @param ether_type the EtherType protocol number or the Destination SAP
     *  that the receiver is not interested in anymore. It must be between 1536
     *  and 65535 to specify the EtherType, or between 1 and 255 to specify the
     *  Destination SAP for IEEE 802.2 LLC frames. A protocol number of 0 is
     *  used to specify all protocols.
     *
     *  @param filter_program the filter program that was applied on the
     *  received packets. The program uses tcpdump(1) style expression.
     */
    bool send_unregister_receiver(
	const char*	dst_xrl_target_name,
	const string&	xrl_target_instance_name,
	const string&	if_name,
	const string&	vif_name,
	const uint32_t&	ether_type,
	const string&	filter_program,
	const UnregisterReceiverCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr JoinMulticastGroupCB;
    /**
     *  Send Xrl intended to:
     *
     *  Join a MAC multicast group.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param xrl_target_instance_name the receiver's XRL target instance
     *  name.
     *
     *  @param if_name the interface through which packets should be accepted.
     *
     *  @param vif_name the vif through which packets should be accepted.
     *
     *  @param ether_type the EtherType protocol number or the Destination SAP
     *  that the receiver is interested in. It must be between 1536 and 65535
     *  to specify the EtherType, or between 1 and 255 to specify the
     *  Destination SAP for IEEE 802.2 LLC frames. A protocol number of 0 is
     *  used to specify all protocols.
     *
     *  @param filter_program the optional filter program to be applied on the
     *  received packets. The program uses tcpdump(1) style expression.
     *
     *  @param group_address the multicast group address to join.
     */
    bool send_join_multicast_group(
	const char*	dst_xrl_target_name,
	const string&	xrl_target_instance_name,
	const string&	if_name,
	const string&	vif_name,
	const uint32_t&	ether_type,
	const string&	filter_program,
	const Mac&	group_address,
	const JoinMulticastGroupCB&	cb
    );

    typedef XorpCallback1<void, const XrlError&>::RefPtr LeaveMulticastGroupCB;
    /**
     *  Send Xrl intended to:
     *
     *  Leave a MAC multicast group.
     *
     *  @param dst_xrl_target_name the Xrl target name of the destination.
     *
     *  @param xrl_target_instance_name the receiver's XRL target instance
     *  name.
     *
     *  @param if_name the interface through which packets should not be
     *  accepted.
     *
     *  @param vif_name the vif through which packets should not be accepted.
     *
     *  @param ether_type the EtherType protocol number or the Destination SAP
     *  that the receiver is not interested in anymore. It must be between 1536
     *  and 65535 to specify the EtherType, or between 1 and 255 to specify the
     *  Destination SAP for IEEE 802.2 LLC frames. A protocol number of 0 is
     *  used to specify all protocols.
     *
     *  @param filter_program the filter program that was applied on the
     *  received packets. The program uses tcpdump(1) style expression.
     *
     *  @param group_address the multicast group address to leave.
     */
    bool send_leave_multicast_group(
	const char*	dst_xrl_target_name,
	const string&	xrl_target_instance_name,
	const string&	if_name,
	const string&	vif_name,
	const uint32_t&	ether_type,
	const string&	filter_program,
	const Mac&	group_address,
	const LeaveMulticastGroupCB&	cb
    );

protected:
    XrlSender* _sender;

private:
    void unmarshall_send(
	const XrlError&	e,
	XrlArgs*	a,
	SendCB		cb
    );

    void unmarshall_register_receiver(
	const XrlError&	e,
	XrlArgs*	a,
	RegisterReceiverCB		cb
    );

    void unmarshall_unregister_receiver(
	const XrlError&	e,
	XrlArgs*	a,
	UnregisterReceiverCB		cb
    );

    void unmarshall_join_multicast_group(
	const XrlError&	e,
	XrlArgs*	a,
	JoinMulticastGroupCB		cb
    );

    void unmarshall_leave_multicast_group(
	const XrlError&	e,
	XrlArgs*	a,
	LeaveMulticastGroupCB		cb
    );

};

#endif /* __XRL_INTERFACES_FEA_RAWLINK_XIF_HH__ */
