#ifndef PROPERTIES_H
#define PROPERTIES_H

class PropertiesBox;

class PermFrame : public FXVerticalFrame
{
    FXDECLARE(PermFrame)
    friend class PropertiesBox;
private:
    PermFrame()
    {}
    FXCheckButton*	ur;
    FXCheckButton*	uw;
    FXCheckButton*	ux;
    FXCheckButton*	gr;
    FXCheckButton*	gw;
    FXCheckButton*	gx;
    FXCheckButton*	or_;
    FXCheckButton*	ow;
    FXCheckButton*	ox;
	FXDataTarget	radiotarget;
	FXRadioButton*	set;
	FXRadioButton*	clear;
	FXRadioButton*	add;
	FXint			cmd;		  
    FXCheckButton*	rec;
    FXCheckButton*	own;
    FXCheckButton*	dironly;
    FXComboBox*		user;
    FXComboBox*		userbis;
    FXComboBox*		grp;
public:
    PermFrame(FXComposite *parent,FXObject *target);
};

class PropertiesBox : public FXDialogBox
{
    FXDECLARE(PropertiesBox)

private:
    PropertiesBox()
    {}
    FXLabel		*fileSize;
    FXString 	*files;
    FXString 	source;
	FXString	parentdir;
    FXString 	oldusr;
    FXString 	oldgrp;
    int num;
    FXCheckButton*    ur;
    FXCheckButton*    uw;
    FXCheckButton*    ux;
    FXCheckButton*    gr;
    FXCheckButton*    gw;
    FXCheckButton*    gx;
    FXCheckButton*    or_;
    FXCheckButton*    ow;
    FXCheckButton*    ox;
    FXTextField		*input;
    FXTextField		*username;
    FXTextField		*grpname;
    FXTextField		*open;
    FXTextField		*view;
    FXTextField		*edit;
    FXTextField		*ext;
    FXTextField		*descr;
    FXTextField		*bigic;
    FXTextField		*miniic;
    FXTextField		*test;
    mode_t			mode;
    mode_t			orig_mode;
    PermFrame *perm;
public:
    enum{
        ID_ACCEPT_SINGLE=FXDialogBox::ID_LAST,
        ID_ACCEPT_MULT,
        ID_SET,
        ID_CLEAR,
        ID_ADD,
        ID_BIG_ICON,
        ID_MINI_ICON,
        ID_BROWSE_OPEN,
        ID_BROWSE_VIEW,
        ID_BROWSE_EDIT,
		ID_RUSR,
        ID_WUSR,
        ID_XUSR,
        ID_RGRP,
        ID_WGRP,
        ID_XGRP,
        ID_ROTH,
        ID_WOTH,
        ID_XOTH,
        ID_LAST
    };

public:
    virtual void create();
    PropertiesBox(FXWindow *win,FXString file,FXString path);
    PropertiesBox(FXWindow *win,FXString *files,int num,FXString path);
    long onCmdAcceptSingle(FXObject*,FXSelector,void*);
    long onCmdAcceptMult(FXObject*,FXSelector,void*);
    long onCmdCheck(FXObject*,FXSelector,void*);
    long onCmdCommand(FXObject*,FXSelector,void*);
    long onCmdBrowseIcon(FXObject*,FXSelector,void*);
    long onCmdBrowse(FXObject*,FXSelector,void*);
	long onUpdPerm(FXObject*,FXSelector,void*);
    long onCmdKeyPress(FXObject*,FXSelector,void*);
};

#endif
