#include "curses.h"

char	rule[] = "----.----";

#ifdef __AUX__
#define wechochar(w, c) (waddch((w),(c)),wrefresh((w)))
#endif

#define	ABORT(s)	{ fputs(s,stderr); abort(); }

static char *pad_init1 = "xxxxxxxxxxYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY********************";
static char *pad_init2 = "xxxxxxxxxxZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ********************";
static char *pad_init3 = "****************************************************************************************************";

main()
{
    int i, j;
    WINDOW *win1 = NULL;
    WINDOW *win2 = NULL;
    WINDOW *pad = NULL;

    /*
     * Test isendwin(), initscr(), and refresh():
     */

/* #ifndef __AUX__ (* isendwin doesn't seem to be false b4 initialization on sun *)
 *    if (!isendwin())
 *	ABORT("isendwin() is false (s/b true)\n");
 *#endif
*/
    initscr();
    refresh();
    noecho();
    crmode();

#ifndef __AUX__
    if (isendwin()) 
	ABORT("isendwin() is true (s/b false)\n");
#endif

    /*
     * Test printw():
     */

    for (i = 0, j = 2 * COLS / 10; i < j; i++)
		printw("%s%d", rule, i%10);

	refresh();
    getch();		/* getch() does an implicit refresh() */

    /*
     * Create a window and test wrefresh()
     */

    win1 = newwin(10,10,10,10);

    mvaddstr(4,0,"This should not be printed");
    wprintw(win1, "1234567890nextline");
    wrefresh(win1);	/* only refresh win1 */
    wgetch(win1);

    mvaddstr(4,0,"The 123456... message should disappear");
    clearok(stdscr, TRUE);
    refresh();			/* overlay stdscr over window */
    getch();

	pad = newpad(LINES + LINES/3, 100);
	for (i = 0; i < LINES/3; i++)
		mvwaddstr(pad, i, 0, pad_init1);

	for (i = LINES/3; i < LINES; i++)
		mvwaddstr(pad, i, 0, pad_init2);

	for (i = LINES; i < LINES + LINES/3; i++)
		mvwaddstr(pad, i, 0, pad_init3);

	wmove(pad, 0, 0);
	prefresh(pad, 0, 0, 0, 0, LINES, COLS);
	wgetch(pad);

	prefresh(pad, LINES/8, 10, 0, 0, LINES, COLS);
	wgetch(pad);

    /*
     * Test line drawing characters:
     */

#if !defined(THINK_C) && !defined(__AUX__)
    wclear(win1);
    wmove(win1,0,0);
    mvwaddch(win1,0,0,ACS_ULCORNER);
    waddch(win1,ACS_HLINE);
    waddch(win1,ACS_TTEE);
    waddch(win1,ACS_HLINE);
    waddch(win1,ACS_URCORNER);
    mvwaddch(win1,1,0,ACS_VLINE);
    waddch(win1,' ');
    waddch(win1,ACS_VLINE);
    waddch(win1,' ');
    waddch(win1,ACS_VLINE);
    mvwaddch(win1,2,0,ACS_LTEE);
    waddch(win1,ACS_HLINE);
    waddch(win1,ACS_PLUS);
    waddch(win1,ACS_HLINE);
    waddch(win1,ACS_RTEE);
    mvwaddch(win1,3,0,ACS_VLINE);
    waddch(win1,' ');
    waddch(win1,ACS_VLINE);
    waddch(win1,' ');
    waddch(win1,ACS_VLINE);
    mvwaddch(win1,4,0,ACS_LLCORNER);
    waddch(win1,ACS_HLINE);
    waddch(win1,ACS_BTEE);
    waddch(win1,ACS_HLINE);
    waddch(win1,ACS_LRCORNER);
    wrefresh(win1);
    wgetch(win1);
#endif

    /*
     * Make 2 boxed windows and display both at the same time:
     */

    wclear(win1);
    box(win1,0,0);
    wnoutrefresh(win1);		/* Update internal but not screen */
    sleep(1);			/* Make the delay noticeable */

    win2 = newwin(10,10,10,40);
    box(win2,'|','-');		/* Cheap box */
    wnoutrefresh(win2);		/* Update second window */
    sleep(1);

    doupdate();			/* Now update both at once */
    getch();

    mvwin(win2,10,30);		/* Move window 2	*/
    touchwin(win1);		/* Reshow window 1	*/
    touchwin(stdscr);		/* Reshow window 1	*/
    wnoutrefresh(stdscr);	/* Update stdscr	*/
    wnoutrefresh(win1);		/* Update window 1	*/
    wnoutrefresh(win2);		/* Update window 2	*/
    doupdate();			/* And display new screen	*/
    getch();

    wmove(win2,3,3);
    wechochar(win2,'*');
    getch();

#ifdef __AUX__
	overwrite(pad, win1);
#else
	copywin(pad, win1, LINES/6, 5, 1, 1, 9, 9, FALSE);
#endif /* __AUX__ */
	wrefresh(win1);
	getch();

    endwin();
#ifndef __AUX__
    if (!isendwin())
	ABORT("isendwin() is true (s/b false)\n");
#endif

    clear();
    delwin(win2);
    win2 = newwin(8,8,11,11);		/* win2 is now inside win1 */
    touchwin(win1);
    move(0,0);
    standout();
    addstr("STANDOUT ");
    standend();
    addstr("STANDEND ");
    attrset(A_UNDERLINE);
    addstr("UNDERLINE ");
    attrset(A_REVERSE);
    addstr("REVERSE ");
    attrset(A_BLINK);
    addstr("BLINK ");
    attrset(A_BOLD);
    addstr("BOLD ");
    attrset(A_DIM);
    addstr("DIM ");
    attrset(A_NORMAL);
    addch('\n');

    attron(A_REVERSE);
    addstr("REVERSE ");
    attron(A_BOLD);
    addstr("BOLD ");
    attron(A_DIM);
    addstr("DIM ");
    attron(A_UNDERLINE);
    addstr("UNDERLINE ");
    attron(A_BLINK);
    addstr("BLINK ");
    attron(A_NORMAL);
    addch('\n');

    attroff(A_REVERSE);
    addstr("REVERSE ");
    attroff(A_BOLD);
    addstr("BOLD ");
    attroff(A_DIM);
    addstr("DIM ");
    attroff(A_UNDERLINE);
    addstr("UNDERLINE ");
    attroff(A_BLINK);
    addstr("BLINK ");
    attroff(A_NORMAL);
    addch('\n');
    beep();
    refresh();
    getch();

    clear();
    for (i = 0; i < LINES; i++) {
		move(i,0);
		printw("The quick brown fox jumps over the lazy dog %d times", i);
    }
    attrset(A_BOLD);
    mvaddstr(4,5,"clrtoeol():");
    clrtoeol();
    mvaddstr(6,5,"delch():");
    delch();
    mvaddstr(8,5,"deleteln() below:");
    move(9,5);
    deleteln();
    mvaddstr(12,6,"insch():");
    insch('X');
    mvaddstr(20,5,"clrtobot():");
    clrtobot();
    refresh();
    getch();

    mvaddstr(14,5,"insertln():");
    insertln();
    refresh();
    getch();

    attrset(A_NORMAL);
    clear();
    scrollok(stdscr, TRUE);
    for (i = 0; i < LINES; i++) {
		move(i,0);
		printw("The quick brown fox jumps over the lazy dog %d times", i);
    }
    refresh();
    getch();
    scroll(stdscr);
    refresh();
    getch();
    scroll(stdscr);
    refresh();
    getch();

    endwin();
#ifndef __AUX__
    if (!isendwin())
	ABORT("isendwin() returned false, should be true!\n");
#endif

    exit(0);
}

