/*
 *  wysidocbookdaemon -- daemon for wysi docbook XML 
 *  Copyright (C) 2003,2005 Junichi Uekawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <pthread.h>
#include <getopt.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include "config.h"

/** lock for input/mozilla process  */
pthread_mutex_t plock = PTHREAD_MUTEX_INITIALIZER;

/** the command-line for mozilla  */
const char * mozillacmdline = NULL;

/** the current file  */
char * currentfile = NULL;

/** the filename  */
char * temporary_filename = NULL;

/** the stylesheet */
char * xsltstylesheet = "/usr/share/xml/docbook/stylesheet/ldp/html/tldp-one-page.xsl";

/** the optional string #xxxx to pass to mozilla URL */
char * optional = NULL;


time_t last_input;
int wait_sleeptime = 3;

#define MAX_DURANCE 20

/* The routine to wait for user input, and sleep. */
int loopexec (void)
{
  time_t last_display = time(NULL);
  time_t current_time;
  int doit;
  
  
  while (1)
    {
      sleep (1);
      pthread_mutex_lock(&plock);

      current_time = time(NULL);
      doit = 0;

      /* if there is any action since last display. */
      if (difftime(last_input, last_display) > 0)
	{
	  if (difftime(current_time, last_input) > wait_sleeptime)
	    {			/* blank-time move */
	      doit = 1;
	    }
	  else if ((difftime(current_time, last_display) > MAX_DURANCE) &&
		   (difftime(current_time, last_input) > 0))
	    {			/* force-update move */
	      doit = 1;
	    }
	}

      if (doit)
	{
	  if (currentfile)
	    {
	      char * buf = NULL;
	      asprintf (&buf, "xsltproc --novalid %s %s > %s", xsltstylesheet, currentfile, temporary_filename);
	      printf("invoke: %s\n", buf);
	      system(buf);
	      free(buf);
	      asprintf (&buf, mozillacmdline, temporary_filename, optional);
	      system (buf);
	      printf("invocation complete\n");
	      free (buf);
	      last_display = current_time;
	    }
	}
      pthread_mutex_unlock(&plock);
    }
}


int
main (int ac, char ** av)
{
  pthread_t t;
  int opt;

  /** value to rotate temporary file.  */
  int loopval = 0;

  
  while ( -1 != (opt = getopt (ac, av, "m:s:x:")))
    {
      switch (opt)
	{
	case 'm': 		/* select mozilla. */
	  mozillacmdline = strdup(optarg);
	  break;
	case 's':		/* the sleep time */
	  wait_sleeptime = atoi(optarg);	  
	  break;
	case 'x':
	  xsltstylesheet = strdup(optarg);
	  break;
	default:
	  fprintf(stderr, "Unknown option -%c\n", opt);
	  exit (1);
	}
    }

  printf ("wysidocbookdaemon Version %s, with wait %i seconds\n",
	  VERSION, wait_sleeptime);  


  if (!mozillacmdline)
    {
      fprintf (stderr, "Mozilla command-line not specified\n");
      exit (1);
    }

  if (temporary_filename) free (temporary_filename);
  asprintf (&temporary_filename, "%s/.wysidocbookdaemon.tmp",
	    getenv("HOME"));

  pthread_create(&t, NULL, loopexec, NULL);
  while (1)
    {
      char * instr = NULL;
      char * my_optional = NULL;
      printf (">");
      scanf("%as %as", &instr, &my_optional);
      pthread_mutex_lock(&plock);
      if (currentfile) free (currentfile);
      currentfile = instr;
      if (optional) free (optional);
      optional = my_optional;
      if (temporary_filename) free (temporary_filename);
      asprintf (&temporary_filename, "%s/.wysidocbookdaemon.tmp.%i",
		getenv("HOME"), loopval++ % 10);

      last_input = time(NULL);
      pthread_mutex_unlock(&plock);
    }
}
