/* awindow.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: awindow.h,v 1.11 2002/03/18 01:14:06 ralf Exp $ */

#ifndef AWINDOW_H
#define AWINDOW_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include "aguix.h"
#include "aguixdefs.h"
#include "lowlevelfunc.h"
#include "text.h"

class AWindow {
public:
  AWindow(AGUIX *parent);
  ~AWindow();
  Display *getDisplay();
  Window getWindow();
  Screen *getScreen();
  GC *getGC();
  AGUIX *getAGUIX();
  int setResizable(int state);
  void setMaxSize(int mwidth,int mheight);
  void setMinSize(int mwidth,int mheight);
  int create(AWindow *parent,int x,int y,int width,int height,int bg,const char *title);
  void close();
  void show();
  void show(Window);
  void hide();
  void hide(Window);
  int isVisible();
  void minimize();
  void toFront();
  void move(int x,int y);
  int getX();
  int getY();
  void resize(int width,int height);
  void sizeChanged(int width,int height);
  int getWidth();
  int getHeight();
  void redraw();
  const char *getTitle();
  void setTitle(const char *new_title);
  const char *getName();
  void setName(const char *new_name);
  const char *getIconname();
  void setIconname(const char *new_iconname);
  GUIElement *add(GUIElement *new_element);
  bool remove(GUIElement *elem);
  int getBG();
  void setBG(int bg);
  void ReactMessage(Message *msg);
  bool handleMessage(XEvent *,Message *msg);
  void resizeSubWin(Window win,int w,int h);
  void moveSubWin(Window win,int x,int y);
  bool hasSubWin(Window win);
  Window getSubWindow(Window parent,int x,int y,int w,int h);
  void removeSubWin(Window subwin);
  void addSubAWindow(AWindow *child);
  void removeSubAWindow(AWindow *child);
  bool isParent(Window childwin,bool);
  GUIElement *findGUIElement(Window);
  void setCursor(int type);
  void unsetCursor();
  
  void invalidFocus();
  void applyFocus(GUIElement *newfocus);
  bool isOwner(GUIElement *f);

  void maximizeX();
  void maximizeY();
  int getBorderWidth();
  void setBorderWidth( int nv );

  int addTextFromString( const char *text,
			 int tx,
			 int ty,
			 int vspace,
			 Text ***return_texts,
			 int *return_count,
			 int *return_y );
  void centerScreen();
protected:
  int x,y,w,h;
  bool onScreen;
  char *title;
  char *name;
  char *iconname;
  int bg;
  int maxw,maxh,minw,minh;
  Window win;
  AGUIX *aguix;
  List *gui;
  List *subwins;
  List *subawins;
  AWindow *parentawindow;
  GUIElement *focusOwner;
  int border;
};

#endif
