/* aguixdefs.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: aguixdefs.h,v 1.13 2002/01/28 00:07:11 ralf Exp $ */

#ifndef AGUIXDEFS_H
#define AGUIXDEFS_H

#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include <ctype.h>

#ifdef HAVE_CONFIG_H

#ifndef CONFIG_H_INCLUDED
#include "../../config.h"
#define CONFIG_H_INCLUDED
#endif // CONFIG_H_INCLUDED

#endif // HAVE_CONFIG_H

//enum {PISNOTHING,PISBUTTON,PISPATH,PISHOTKEY,PISNUMBER,PISFILETYPE};

#define KEYSTATEMASK(x) (x&(ControlMask|Mod1Mask|ShiftMask))

#ifdef DEVELOPER
#define USE_MEM_SYSTEM
#endif // DEVELOPER

/* Workaround for missing nanosleep prototype
 * from:
 * http://www.opensource.apple.com/bugs/X/Libraries/2753843.html
 */
#ifdef __APPLE__ // missing - why?
extern "C" void nanosleep(struct timespec *, struct timespec *);
#endif

#if 0  /* currently not needed */
#ifndef HAVE_NANOSLEEP
/* nanosleep() hack */
#if ( defined(_POSIX_VERSION) && (_POSIX_VERSION < 199309) )
  #define nanosleep(_I, _O) usleep( ((_I)->tv_nsec / 1000) )
#endif /* nanosleep hack */
#endif
#endif /* if 0 */

#define a_min(a,b) (((a)<(b))?(a):(b))
#define a_max(a,b) (((a)>(b))?(a):(b))

#endif
