// This may look like C code, but it's really -*- C++ -*-
/*
 * Copyright (C) 2010 Emweb bvba, Kessel-Lo, Belgium.
 *
 * See the LICENSE file for terms of use.
 */
#include <boost/test/unit_test.hpp>

#include <Wt/WException>
#include <Wt/WColor>

BOOST_AUTO_TEST_CASE( color_test_constructors )
{
  //string constructors
  {
    Wt::WColor c("#f80");
    BOOST_REQUIRE(c.red() == 255);
    BOOST_REQUIRE(c.green() == 136);
    BOOST_REQUIRE(c.blue() == 0);
    BOOST_REQUIRE(c.alpha() == 255); 
  }

  {
    Wt::WColor c("#12a0cf");
    BOOST_REQUIRE(c.red() == 18);
    BOOST_REQUIRE(c.green() == 160);
    BOOST_REQUIRE(c.blue() == 207);
    BOOST_REQUIRE(c.alpha() == 255); 
  }

  {
    Wt::WColor c("#FF0000");
    BOOST_REQUIRE(c.red() == 255);
    BOOST_REQUIRE(c.green() == 0);
    BOOST_REQUIRE(c.blue() == 0);
    BOOST_REQUIRE(c.alpha() == 255); 
  }

  {
    Wt::WColor c("rgb(18,160,207)");
    BOOST_REQUIRE(c.red() == 18);
    BOOST_REQUIRE(c.green() == 160);
    BOOST_REQUIRE(c.blue() == 207);
    BOOST_REQUIRE(c.alpha() == 255); 
  }

  {
    Wt::WColor c("rgb( 18  , 160  ,  207 )");
    BOOST_REQUIRE(c.red() == 18);
    BOOST_REQUIRE(c.green() == 160);
    BOOST_REQUIRE(c.blue() == 207);
    BOOST_REQUIRE(c.alpha() == 255);
  }

  {
    Wt::WColor c("rgb( 50%  , 25%  ,  0%)");
    BOOST_REQUIRE(c.red() == 127);
    BOOST_REQUIRE(c.green() == 63);
    BOOST_REQUIRE(c.blue() == 0);
    BOOST_REQUIRE(c.alpha() == 255); 
  }

  {
    Wt::WColor c("rgba(18,160,207,50)");
    BOOST_REQUIRE(c.red() == 18);
    BOOST_REQUIRE(c.green() == 160);
    BOOST_REQUIRE(c.blue() == 207);
    BOOST_REQUIRE(c.alpha() == 50); 
  }

  {
    Wt::WColor c("rgba(18 , 160  ,  207 , 50)");
    BOOST_REQUIRE(c.red() == 18);
    BOOST_REQUIRE(c.green() == 160);
    BOOST_REQUIRE(c.blue() == 207);
    BOOST_REQUIRE(c.alpha() == 50); 
  }

  {
    Wt::WColor c("rgba( 50%  , 25%  ,  0%, 55)");
    BOOST_REQUIRE(c.red() == 127);
    BOOST_REQUIRE(c.green() == 63);
    BOOST_REQUIRE(c.blue() == 0);
    BOOST_REQUIRE(c.alpha() == 55); 
  }

  //try to mess things up
  {
    Wt::WColor c("#f8 0");
    BOOST_REQUIRE(c.red() == 0 && c.green() == 0 && c.blue() == 0);
  }
  
  {
    Wt::WColor c("#ff80");
    BOOST_REQUIRE(c.red() == 0 && c.green() == 0 && c.blue() == 0);
  }

  {
    Wt::WColor c("rgb(30%,20%)");
    BOOST_REQUIRE(c.red() == 0 && c.green() == 0 && c.blue() == 0);
  }

  {
    Wt::WColor c("rgb(30%,20%,50%,50)");
    BOOST_REQUIRE(c.red() == 0 && c.green() == 0 && c.blue() == 0);
  }

  {
    Wt::WColor c("rgb30%,20%,50%)");
    BOOST_REQUIRE(c.red() == 0 && c.green() == 0 && c.blue() == 0);
  }

  {
    Wt::WColor c("rgb(30%,20%,50%");
    BOOST_REQUIRE(c.red() == 0 && c.green() == 0 && c.blue() == 0);
  }

  {
    Wt::WColor c("rgba(30%,20%,50%,a)");
    BOOST_REQUIRE(c.alpha() == 255);
  }

  {
    Wt::WColor c("rgba(30%,20%,50%)");
    BOOST_REQUIRE(c.red() == 0 && c.green() == 0 && c.blue() == 0);
  }

  {
    Wt::WColor c("rgba(30%,20%,50%,50,x)");
    BOOST_REQUIRE(c.red() == 0 && c.green() == 0 && c.blue() == 0);
  }

  {
    Wt::WColor c("gold");
    BOOST_REQUIRE(c.red() == 0 && c.green() == 0 && c.blue() == 0);
  }
}
