/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef _WF_MACADDR_H
#define _WF_MACADDR_H

#include <iostream>
#include <string>

#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
/* Oh my!! */
#include <sys/types.h> /* for u_char, <sys/socket.h> needs this on FreeBSD */
#include <sys/socket.h> /* for struct sockaddr, <net/if.h> needs this */
#include <net/if.h> /* <netinet/if_ether.h> needs this */
#include <netinet/in.h> /* <netinet/if_ether.h> needs this */
#endif
#include <netinet/if_ether.h> /* for ETHER_ADDR_LEN */
#include <inttypes.h>

/**
 * macaddr: MAC address class.
 */
class wf_macaddr {
 public:
  wf_macaddr();
  wf_macaddr(const string& str);
  virtual ~wf_macaddr() {}
  // wf_macaddr(const wf_macaddr&) {} implicit copy constructor

  bool set(const string& address);
  bool set(const uint8_t* address);
  bool set(const sockaddr* sockaddr);

  const uint8_t* get() const;
  bool isdefined() const;
  bool isnull() const;
  bool isbroadcast() const;

#define WF_MACADDR_NONE 	0x0
#define WF_MACADDR_UPPERCASE	0x1  /* lowercase by default */
#define WF_MACADDR_ONEDIGIT	0x2  /* two digits by default */
  string tostr(unsigned char flags = WF_MACADDR_NONE) const;
  string vendor() const;
  
  virtual ostream& print(ostream& os) const;
  ostream& debugprint(ostream& os) const;

  friend ostream& operator<<(ostream& os, const wf_macaddr& macaddr);
  friend bool operator==(const wf_macaddr& macaddr1, const wf_macaddr& macaddr2);
  friend bool operator!=(const wf_macaddr& macaddr1, const wf_macaddr& macaddr2);
  friend bool operator<(const wf_macaddr& macaddr1, const wf_macaddr& macaddr2);
  friend bool operator>(const wf_macaddr& macaddr1, const wf_macaddr& macaddr2);

  static bool check(const string& str);
  static int compare(const uint8_t* s1, const uint8_t* s2);

 private: 
  static bool check(const char* str); // remove this function ALL@@4

 private:
  uint8_t _addr[ETHER_ADDR_LEN];
  bool _defined;
};

#endif
