/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <iterator>

#if defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
#include <sys/types.h> /* <netinet/in.h> needs this */
#endif
#include <netinet/in.h> /* for IPPROTO_* */

#include "wflisteners.h"
#include "list1.h"
#include "defs.h"


wf_listeners::wf_listeners(const wf_listeners& listeners) {
  list1_deepcopy(elems, listeners.elems);
}

wf_listeners&
wf_listeners::operator=(const wf_listeners& listeners) {
  if (this != &listeners)
    list1_deepcopy(elems, listeners.elems);
  return *this;
}


bool
wf_listeners::probe_local(int proto) {
#ifdef linux
  return probe_local_linux(proto);
#elif defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
  return probe_local_bsd(proto);
#else
  return false;
#endif
}

bool
wf_listeners::probe_local() {
  if (probe_local(IPPROTO_TCP) == false ||
      probe_local(IPPROTO_UDP) == false)
    return false;

  return true;
}

ostream&
wf_listeners::print(ostream& os) const {
  list<wf_listener*>::const_iterator first = elems.begin(), last = elems.end();
  for (; first != last; ++first)
    (*first)->print(os);
  return os;
}
