#!/usr/local/bin/perl
# virt_index.cgi
# Display a menu for some specific virtual server, or the default server

require './proftpd-lib.pl';
&ReadParse();
($conf, $v) = &get_virtual_config($in{'virt'});
&header($text{'virt_title'}, "");

# Display header and icons
print "<center><font size=+2>", $in{'virt'} eq '' ? $text{'virt_header2'} :
      &text('virt_header1', $v->{'value'}),"</font></center>\n";
print "<hr>\n";
print "<h3>$text{'virt_opts'}</h3>\n";
$anon_icon = { "icon" => "images/anon.gif",
	       "name" => $text{'virt_anon'},
	       "link" => "anon_index.cgi?virt=$in{'virt'}" };
$virt_icon = { "icon" => "images/virt.gif",
	       "name" => $text{'virt_virt'},
	       "link" => "edit_vserv.cgi?virt=$in{'virt'}" };
$ed_icon = { "icon" => "images/edit.gif",
	     "name" => $text{'virt_edit'},
	     "link" => "manual_form.cgi?virt=$in{'virt'}" };
&config_icons("virtual", "edit_virt.cgi?virt=$in{'virt'}&",
	      $anon_icon, $in{'virt'} ? ( $virt_icon, $ed_icon ) : ( ) );

# Display per-directory/limit options
@dir = ( &find_directive_struct("Directory", $conf) ,
	 &find_directive_struct("Limit", $conf) );
if (@dir) {
	print "<hr>\n";
	print "<h3>$text{'virt_header'}</h3>\n";
	print "<table width=100% cellpadding=5>\n";
	foreach $d (@dir) {
		if ($i%3 == 0) { print "<tr>\n"; }
		print "<td valign=top align=center width=33%>\n";
		if ($d->{'name'} eq 'Limit') {
			&generate_icon("images/limit.gif",
				&text('virt_limit', $d->{'value'}),
				"limit_index.cgi?limit=".&indexof($d, @$conf).
				"&virt=$in{'virt'}");
			}
		else {
			&generate_icon("images/dir.gif",
				&text('virt_dir', $d->{'value'}),
				"dir_index.cgi?idx=".&indexof($d, @$conf).
				"&virt=$in{'virt'}");
			}
		print "</td>\n";
		if ($i++%3 == 2) { print "</tr>\n"; }
		}
	while($i++%3) { print "<td width=33%></td>\n"; }
	print "</table>\n";
	}

print "<table width=100%><tr><td>\n";

print "<form action=create_dir.cgi>\n";
print "<input type=hidden name=virt value='$in{'virt'}'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'virt_adddir'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";
print "<tr> <td><b>$text{'virt_path'}</b></td>\n";
print "<td><input name=dir size=30>\n";
print "<input type=submit value=\"$text{'create'}\"></td> </tr>\n";
print "</table></td></tr></table></form>\n";

print "</td><td>\n";

print "<form action=create_limit.cgi>\n";
print "<input type=hidden name=virt value='$in{'virt'}'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'virt_addlimit'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";
print "<tr> <td><b>$text{'virt_cmds'}</b></td>\n";
print "<td><input name=cmd size=20>\n";
print "<input type=submit value=\"$text{'create'}\"></td> </tr>\n";
print "</table></td></tr></table></form>\n";

print "</td></tr></table>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

