/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef POPEDITPANEL_H
#define POPEDITPANEL_H

#include <QWidget>
#include <QMap>

class QGridLayout;
class QButtonGroup;

class PopEditBox;

/**
* Panel for displaying values of attributes.
*
* Values are rich text and may contain links. Each attribute has a label
* and an edit button.
*/
class PopEditPanel : public QWidget
{
    Q_OBJECT
public:
    /**
    * Conctructor.
    *
    * @param parent The parent widget.
    */
    PopEditPanel( QWidget* parent );

    /**
    * Destructor.
    */
    ~PopEditPanel();

public:
    /**
    * Remove all widgets from the panel.
    */
    void clear();

    /**
    * Add a label and a value box to the panel.
    *
    * @param id The identifier of the attribute.
    *
    * @param name The label of the attribue.
    */
    void addAttribute( int id, const QString& name );

    /**
    * Clear the values of all attributes.
    */
    void clearValues();

    /**
    * Set the value of the given attribute.
    *
    * @param id The identifier of the attribute.
    *
    * @param value The value of the attribute.
    */
    void setValue( int id, const QString& value );

signals:
    /**
    * Emitted when a link was clicked.
    *
    * @param link The URL of the link.
    */
    void linkClicked( const QString& link );

    /**
    * Emitted when a context menu for a link is needed.
    *
    * @param link The URL of the link.
    *
    * @param pos The position to display the context menu.
    */
    void linkContextMenu( const QString& link, const QPoint& pos );

    /**
    * Emitted when an edit button was clicked.
    *
    * @param id The identifier of the attribute.
    */
    void buttonClicked( int id );

private:
    QGridLayout* m_layout;

    QButtonGroup* m_group;

    QMap<int, PopEditBox*> m_editMap;
};

#endif
