/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "reply.h"

ReplyLine::ReplyLine()
{
}

ReplyLine::~ReplyLine()
{
}

void ReplyLine::addArg( int number )
{
    m_args.append( QVariant( number ) );
}

void ReplyLine::addArg( const QString& string )
{
    m_args.append( QVariant( string ) );
}

Reply::Reply()
{
}

Reply::~Reply()
{
}

void Reply::addLine( const ReplyLine& line )
{
    m_lines.append( line );
}

ReplyRule::ReplyRule( const QString& signature, Multiplicity multiplicity ) :
    m_signature( signature ),
    m_multiplicity( multiplicity )
{
}

ReplyRule::~ReplyRule()
{
}
