/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef GRADIENTWIDGET_H
#define GRADIENTWIDGET_H

#include <QWidget>

namespace WebIssues
{

/**
* Widget with styled gradient background.
*
* It uses the DotNetStyle if available to draw the gradient.
* Otherwise it falls back to plain white background.
*/
class GradientWidget : public QWidget
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    GradientWidget( QWidget* parent );

    /**
    * Destructor.
    */
    ~GradientWidget();

protected: // overrides
    void paintEvent( QPaintEvent* e );
};

}

#endif
