/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _webbase_create_h
#define _webbase_create_h

#include <mysql.h>

#define WEBBASE_SCHEMA_START		0
#define WEBBASE_SCHEMA_ROBOTS		1
#define WEBBASE_SCHEMA_SERVERS		2
#define WEBBASE_SCHEMA_COOKIES		3
#define WEBBASE_SCHEMA_START2URL	4
#define WEBBASE_SCHEMA_URL		5
#define WEBBASE_SCHEMA_URL_COMPLETE	6
#define WEBBASE_SCHEMA_MIME_RESTRICT	7
#define WEBBASE_SCHEMA_MIME2EXT		8
#define WEBBASE_SCHEMA_HOME_RE		9
#define WEBBASE_SCHEMA_STATISTICS	10
#define WEBBASE_SCHEMA_LOCKS		11

#define WEBBASE_SCHEMA_LENGTH		12

void webbase_create(MYSQL* mysql, const char** schema, int schema_length);
void webbase_schema();
const char* webbase_table_schema(int table);
#ifdef WEBBASE_CONTENT_BASE
char** webbase_schema_content(int* lengthp);
#endif /* WEBBASE_CONTENT_BASE */
#endif /* webbase_create_h */
