// -*- C++ -*-
//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:    map_t.h
//
// Purpose: mapping of two classes
//
// Created: 14 Jun 1996 Till Vollmer
//
// $Id: map_t.h,v 1.3 1997/02/12 20:12:51 jfasch Exp $
//
// Description:
//   
//</file>
//
// $Log: map_t.h,v $
// Revision 1.3  1997/02/12 20:12:51  jfasch
// moved to utils
//
// Revision 1.2  1996/07/22 08:18:19  jfasch
// *** empty log message ***
//
// Revision 1.1  1996/07/08 13:16:36  jfasch
// Initial revision
//
//
#ifndef hg_utils_map_t_h
#define hg_utils_map_t_h

#include "arrays.h"

#define Mapsdeclare(Map,A,B)\
class name2(Map,Entry)\
{\
public:\
    name2(Map,Entry) (){}\
    name2(Map,Entry) (const A& it):from_(it){}\
    name2(Map,Entry) (const A& from ,const B& to):from_(from),to_(to){}\
    bool operator == (const name2(Map,Entry) & it) const {return it.from_==from_;}\
    bool operator != (const name2(Map,Entry) & it) const{return !(it.from_==from_);}\
    bool operator < (const name2(Map,Entry) & it) const {return from_<it.from_;}\
    static friend ostream& operator <<( ostream&, const name2(Map,Entry) &);\
    const A& from() const { return from_;}\
    const B& to() const  { return to_;}\
private:\
    A from_;\
    B to_;\
};\
\
inline ostream& operator << ( ostream& s, const name2(Map,Entry) &)\
{\
    return s << endl;\
}\
\
Arraysdeclare(name2(Map,Base),name2(Map,Entry))\
\
class Map: public name2(Map,Base)\
{\
public:\
    Map(){}\
    bool insert(const A& from, const B& to);\
    bool element(const A& from, B& to) const;\
    bool element(const A& from) const;\
    bool remove(const A& from);\
    void removePos(int);\
private:\
};\
\
inline bool Map::insert(const A & from,const B & to)\
{\
    return name2(Map,Base)::insert(name2(Map,Entry)(from,to));\
}\
\
inline bool Map::element(const A& from, B& to) const\
{\
    int pos;\
    if (position(name2(Map,Entry)(from),pos))\
    {\
        to = operator[] (pos).to();\
        return true;\
    }\
    else\
        return false;\
\
}\
inline bool Map::element (const A& from) const {\
   B to ;\
   return element (from, to) ;\
}\
inline bool Map::remove(const A& from)\
{\
    return name2(Map,Base)::remove(name2(Map,Entry)(from));\
}\
inline void Map::removePos(int pos) {\
    remove_(pos);\
}


#define Mapsimplement(Map,A,B)\
Arraysimplement(name2(Map,Base),name2(Map,Entry))

#endif /* hg_path_map_h */
