/* @(#)  Function which displays the header of a vasari format picture
 * @(#)  It should be called after the read_vhd().
 * @(#)  Static strings must be modified if header files are changed
 * @(#) HANDLESHEADER 
 * @(#)
 * @(#) void im_printhd(pheader)
 * @(#) VAS_HDR *pheader;
 * @(#)
 *
 * Copyright: Nicos Dessipris
 * Written on: 15/01/1990
 * Modified on : 3/6/92 Kirk Martinez
 * 16/6/93 J.Cupitt
 *      - prettyprinters for Type, BandFmt, Coding added
 *      - ANSIfied
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <stdio.h>

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Print a VAS_HD.
 */
void
im_printhd( VAS_HD *image )
{
	printf( "****************  IMAGE HEADER *********************\n" );
 
	printf( "Xsize: %d\nYsize: %d\nBands: %d\nBbits: %d\n",
		image->Xsize, image->Ysize, 
		image->Bands, image->Bbits );
	 
	printf( "BandFmt: %d --> %s\nType: %d --> %s\nCoding: %d --> %s\n",
		image->BandFmt, im_BandFmt2char( image->BandFmt ),
		image->Type, im_Type2char( image->Type ),
		image->Coding, im_Coding2char( image->Coding ) );

	printf( "Xres: %g\nYres: %g\n", 
		image->Xres, image->Yres );

	printf( "****************************************************\n" );
}
	 

