/*
 * ===========================
 * VDK Builder
 * Version 1.0.3
 * November 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb2/vdkb_clipdlg.h>
#include <vdkb2/vdkb_widclip.h>
DEFINE_SIGNAL_MAP(VDKBWidgetClipboardDialog,VDKForm)
  ON_SIGNAL(pasteBtn,clicked_signal,OnPasteBtnClick),
  ON_SIGNAL(cancelBtn,clicked_signal,OncancelBtnClick)
  END_SIGNAL_MAP
/*
main form setup
*/
void
VDKBWidgetClipboardDialog::GUISetup(void)
{
  SetSize(150,210);
  Title = _("Widgets clipboard");
  vbox1 = new VDKBox(this,v_box);
  Add(vbox1,0,1,1,0);
  char* widgetListTitles[] = { N_("Widget stack") };
  widgetList = new VDKCustomList(this,1,widgetListTitles,
				 (GtkSelectionMode) GTK_SELECTION_EXTENDED);
  widgetList->SetSize(138,173);
  widgetList->BorderShadow = (GtkShadowType) shadow_in;
  vbox1->Add(widgetList,0,1,1,0);
  separator0 = new VDKSeparator(this,h_separator);
  separator0->Enabled = false;
  vbox1->Add(separator0,0,0,0,0);
  separator0->Visible = false;
  hbox2 = new VDKBox(this,h_box);
  vbox1->Add(hbox2,0,1,1,0);
  hbox2->BorderWidth(0);
  pasteBtn = new VDKCustomButton(this,(char*) NULL,
				  _("_Paste"),16,(GtkPositionType) 0);
  pasteBtn->SetTip(
_("Select a widget, new widget will be pasted in selected container"));
  hbox2->Add(pasteBtn,0,1,1,0);
  cancelBtn = new VDKCustomButton(this,(char*) NULL,
				  _("_Cancel"),16,(GtkPositionType) 0);
  hbox2->Add(cancelBtn,0,1,1,0);
}

/*
form constructor
*/
VDKBWidgetClipboardDialog::VDKBWidgetClipboardDialog(VDKForm* owner,
					 VDKBWidgetClipboardArray* cliparray,
					 char* title):
	VDKForm(owner,title),cliparray(cliparray)
{
}

/*
form destructor
*/
VDKBWidgetClipboardDialog::~VDKBWidgetClipboardDialog()
{
}


/*
form setup
*/
void
VDKBWidgetClipboardDialog::Setup(void)
{
  GUISetup(); // vdkb gui setup
  // put your code below here
  VDKBWidgetClipboardIterator li(*WidgetClipboard);
  for(;li;li++)
    {
      VDKBWidgetClipboardItem item  = li.current();
      char* widgetName = (char*) item.object->Name();
      widgetList->AddRow(&widgetName);
    }
}

// signal response method 
bool
VDKBWidgetClipboardDialog::OnPasteBtnClick(VDKObject* sender)
{
  int many = widgetList->Selections().size();
  int j = 0;
  if(many > 0)
    {
      cliparray->resize(many);
      int t;
      for( t = 0; t < many; t++)
	{
	  int row = widgetList->Selections()[t];
	  VDKBWidgetClipboardItem item = (*WidgetClipboard)[row];
	  (*cliparray)[t] = item;
	}
    }
  else
    {
      j = widgetList->Selected.Row();
      if(j >= 0)
	{
	  cliparray->resize(1);
	  VDKBWidgetClipboardItem item = (*WidgetClipboard)[j];
	  (*cliparray)[0] = item;
	}
    }
  Close();
  return true;
}

// signal response method 
bool
VDKBWidgetClipboardDialog::OncancelBtnClick(VDKObject* sender)
{
  Close();
  return true;
}
