/*
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jrh@jrhudson.demon.co.uk>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by 
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <vdkb2/input.h>
#include <vdk/forms.h>
class VDKForm;

VDKInput::VDKInput(VDKForm* obj,int fd, GdkInputCondition c):
        VDKObject(obj), tag(0), fd(fd),condition(c)
{
  //  tag = gdk_input_add(fd, c, VDKInput::HandleIO, this);
  tag = gtk_input_add_full(fd, c, VDKInput::HandleIO, NULL,this,NULL);
  obj->Objects().add(this);
  Parent(obj);
}

VDKInput::~VDKInput()
{
    release();
}

void VDKInput::HandleIO(gpointer gp, gint source, GdkInputCondition condition)
{
  VDKInput *ip = static_cast<VDKInput*>(gp);
  ip->condition = condition;
  ip->SignalEmit(INP_SIGNAL);
}
