/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_guinotebook_h
#define _vdkb_guinotebook_h

#include <vdkb2/vdkb_evcontain.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdk/menu.h>
#include <vdk/notebook.h>
#include <vdk/value_sem_list.h>
#include <vdk/vdkstring.h>

typedef VDKList<VDKBObject> NBookPages;
typedef VDKListIterator<VDKBObject> NBookPagesIterator;

typedef VDKValueList<VDKString> TabLabelList;
typedef VDKValueListIterator<VDKString> TabLabelListIterator;


class VDKBGuiForm;
class VDKBParser;
class VDKBObjectInspector;

class VDKBGuiNotebook: public VDKBEventContainer
{
 protected:
  NBookPages pagelist;
  VDKMenuItem *delBox;
  VDKMenuItem *addwidget,*delpage,*delwidget,*setsize;
  TabLabelList tablabels;
  // property controls used by object inspector
  VDKCheckButton *scrollable,*popup;
  void Init();
  bool LoadTabLabels(char* buffer,VDKBParser& parser);

 public:
  VDKNotebook* nbook;
  VDKEntry *tablabel;
  static int Counter;
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);


  VDKBGuiNotebook(char* name, VDKForm* owner);
  VDKBGuiNotebook(char* name, VDKBEventContainer* outer);
  virtual ~VDKBGuiNotebook() { nbook->Destroy(); }

  void Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs);
  
  void AddBox();
  void AddWidget(VDKObject* w, int justify = l_justify,
		 int expand = TRUE, int fill = TRUE , 
		 int padding = 0, bool forceArgs = false);
  bool AddNewWidget(VDKObject* sender);
  void PopMenu() { popmenu->Popup(); }
  bool DelBox(VDKObject* sender);
  bool OnButtonPressed(VDKObject* sender, GdkEvent* event);
  virtual int Type() { return vdkbguinotebook_class; }
  virtual int isA() { return vdkbguinotebook_class; }
  virtual char* VDKName() { return "VDKNotebook"; }


  void WriteOnFrm(FILE* fp, VDKBObject* parentobj);
  VDKObjectContainer*  ExtraWidget(VDKBObjectInspector* isp);
  bool OnSetTabLabel(VDKObject*);
  bool OnSetScrollable(VDKObject*);
  bool OnSetPopUp(VDKObject*);
  bool SetBoxSize(VDKObject* sender);
  bool AddNewPage(VDKObject* sender);
  bool RemovePage(VDKObject* sender);
  //
  DECLARE_EVENT_LIST(VDKBGuiNotebook);
  DECLARE_SIGNAL_LIST(VDKBGuiNotebook);
};

#endif

