/*
 * ===========================
 * VDK Builder
 * Version 2.0
 * March 2001
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_cbrowse_h_
#define _vdkb_cbrowse_h_
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
// vdk support
#include <vdk/vdk.h>

class VDKDefaultColor
{
  public:
  VDKString name;
  int red,green,blue;
  VDKDefaultColor():name(""),red(-1),green(-1),blue(-1) {}
  VDKDefaultColor(char* name, int red, int green, int blue):
    name(name),red(red),green(green),blue(blue) {}
  bool operator < (VDKDefaultColor& rgb)
    { return name < rgb.name; }
  bool operator == (VDKDefaultColor& rgb)
    { return name == rgb.name; }
};

typedef VDKArray <VDKCanvas*> CanvasArray;
typedef VDKValueList <VDKDefaultColor> ColorList;
typedef VDKValueListIterator <VDKDefaultColor> ColorListIterator;

// Test FORM  CLASS
class VDKBColorBrowser: public VDKForm
{
// gui object declarations
private:
// gui object declarations
	void GUISetup(void);
  CanvasArray canvasArray;
  ColorList colorList;
  int selectedCanvas;
  bool OnCanvasClick (VDKObject* sender,  GdkEvent*);
  bool ReadRGB ();
  VDKRgb DefaultColorsColorRgb (int t);
  char* DefaultColorsName (int t);
  VDKDefaultColor* color;
public:
	VDKBColorBrowser(VDKForm* , VDKDefaultColor* color, 
		 char* title = NULL);
	~VDKBColorBrowser();
	void Setup(void);
 protected: 
	VDKBox* vbox;
	VDKEventBox* evbox;
	VDKScrolled* scrolled;
	VDKSeparator* separator0;
	VDKBox* hbox4;
	VDKLabel* label;
	VDKCustomButton* accept;
	VDKCustomButton* cancel;
	void OnExpose(VDKForm* sender, GdkRectangle area);
 public:
	DECLARE_SIGNAL_MAP(VDKBColorBrowser);
	bool OncancelClick(VDKObject* sender);
	bool OnacceptClick(VDKObject* sender);
	
	DECLARE_SIGNAL_LIST(VDKBColorBrowser);
	DECLARE_EVENT_LIST(VDKBColorBrowser);
};

#endif
