/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str

  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif


#include <vdkb/vdkb_widpopmenu.h>
#include <vdkb/vdkb_dlgs.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_paned.h>
#include <vdkb/vdkb_notebook.h>
#include <vdkb/vdkb_frame.h>
#include <vdkb/vdkb_table.h>
#include <vdkb/vdkb_clipdlg.h>

extern char* wi_widget_prompts[];
static char buff[256];
extern VDKBWidgetClipboard* WidgetClipboard;
DEFINE_SIGNAL_LIST(VDKBWidgetPopMenu,VDKMenu);
/*
 */
bool
VDKBWidgetPopMenu::MakeInspector(VDKObject*)
{
VDKBObject* vdkobj = dynamic_cast<VDKBObject*>(parent_widget);
if(vdkobj)
  vdkobj->PopObjectBrowser();
return true;
}
/*
 */
bool
VDKBWidgetPopMenu::SelectParentContainer(VDKObject*)
{
  VDKBEventContainer* container =
    dynamic_cast<VDKBEventContainer*>(parent_widget->Parent());
  if(container)
    {
      VDKBGuiForm* ownerform =
	dynamic_cast<VDKBGuiForm*>(parent_widget->Owner());
      if(ownerform)
	{
	  ownerform->Active->ClearMark();
	  ownerform->Active = container;
	  ownerform->Active->Mark();
	  VDKBProjectManager* prjman =
	    dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
	  if(prjman && prjman->objInspector)
	    prjman->objInspector->SetActive(container);
	}
    }
  return true;
}
/*
 */
bool
VDKBWidgetPopMenu::DelWidget(VDKObject*)
{
  VDKBObject*  parent;
  VDKBEventContainer* container =
    dynamic_cast<VDKBEventContainer*>(parent_widget->Parent());
  if(container)
    {

      VDKBGuiForm* ownerform =
	dynamic_cast<VDKBGuiForm*>(parent_widget->Owner());
      if(ownerform)
	{
	  parent = dynamic_cast<VDKBObject*>(parent_widget);
	  if(ownerform->Active == parent)
	    ownerform->Active = NULL;
	  ownerform->Changed = true;
	  // notify to inspector that object is to be deleted
	  // so inspector will be disabled
	  // and (eventually) signal disconnected.
	  VDKBProjectManager* prjman =
	    dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
	  if(prjman && prjman->objInspector)
	    {
	      ownerform->DisconnectWidget(parent);
	      prjman->objInspector->SetActive(NULL);
	    }
	  // removes it from gui widget list
	  container->boxlist.remove(parent_widget);
	  // removes it from his container
	  container->RemoveObject(parent_widget);	 
	  if(prjman && prjman->objInspector)
	    prjman->objInspector->LoadTree(ownerform);
	}
    }
  return true;
}
/*
 */
bool
VDKBWidgetPopMenu::SetWidgetSize(VDKObject*)
{
  char buff[128];
  VDKBGuiForm* ownerform =
    dynamic_cast<VDKBGuiForm*>(parent_widget->Owner());
  if(ownerform && ownerform->Active)
    {
      sprintf(buff,"Setting %s size", (char*) ownerform->Active->Name());
      VDKBPropSizeDialog *dlg =
	new VDKBPropSizeDialog(ownerform,
			       ownerform->Active,
			       buff);
      dlg->Setup();
      dlg->ShowModal();
      ownerform->Changed = true;
    }
  return true;
}

/*
 */
bool
VDKBWidgetPopMenu::Cut(VDKObject*)
{
  /*
    plm patch
  WidgetClipboard->CutWidget(parent_widget);
  return true;
  */
  GtkWidget *widget = gtk_grab_get_current();
  if (widget) 
    gtk_grab_remove(widget);
  WidgetClipboard->CutWidget(parent_widget);
  return true;
}

/*
 */
bool
VDKBWidgetPopMenu::Copy(VDKObject*)
{
  WidgetClipboard->CopyWidget(parent_widget);
  return true;
}
/*
 */
bool
VDKBWidgetPopMenu::Paste(VDKObject*)
{
  // paste stack top widget
  WidgetClipboard->PasteWidget(parent_widget,0);
  return true;
}
/*
paste others widgets on stack.
An empty array is passed to dialog,
it returns the array filled with widget
to be pasted, or an empty array id user
press cancel button.
 */
bool
VDKBWidgetPopMenu::PasteOthers(VDKObject*)
{
  VDKBWidgetClipboardArray cliparray;
  VDKBWidgetClipboardDialog* child =
    new VDKBWidgetClipboardDialog(parent_widget->Owner(),
				  &cliparray,
				  NULL);
  child->Setup();
  child->ShowModal(GTK_WIN_POS_MOUSE);
  if(cliparray.size() > 0)
    {
      if(cliparray.size() == 1)
	{
	  VDKBWidgetClipboardItem item = cliparray[0];
	  // finds widget ordinal position
	  // into clipboard
	  int ndx = WidgetClipboard->at(item);
	  if(ndx >= 0)
	    // paste widget resetting WI
	    WidgetClipboard->PasteWidget(parent_widget,ndx, true);
	}
      else
	{
	  int z = 0;
	  for(; z < cliparray.size(); z++)
	    {
	      VDKBWidgetClipboardItem item = cliparray[z];
	      int ndx = WidgetClipboard->at(item);
	      // finds widget ordinal position
	      // into clipboard
	      if(ndx >= 0)
		// reset WI only on last item
		WidgetClipboard->PasteWidget(parent_widget,
					     ndx,
					     z < (cliparray.size()-1) ?
					     false: true);
	    }
	}
    }
  return true;
}
/*
Overridden popmenu,
enable/disable pasting widget
 */
void
VDKBWidgetPopMenu::Popup(guint button,guint32 activate_time)
{
  VDKBGuiForm* targetform =
    dynamic_cast<VDKBGuiForm*>(parent_widget->Owner());
  // enabled if clipboard contains almost one item
  pastewidget->Enabled = WidgetClipboard->size() > 0;
  // enabled if clipboard contains more than  one item
  pasteothers->Enabled = WidgetClipboard->size() > 1;
/*
  Allowing pasting between form needs more investigation
  and not seems very useful.
  These reasons suggest to deny pasting between forms:
  - if the cutted widget has some signals assigned
  is necessary to disconnect those signals , it can be done
  using Form::DisconnectWidget(VDKBobject*)
  - if the widget has the same name of a widget on target form
  is necessary to create a new widget name before inserting it.
  - there can be others not yet investigated interferences.
*/
  if(pastewidget->Enabled)
    {
      VDKBGuiForm* sourceform =
	dynamic_cast<VDKBGuiForm*>
	((*WidgetClipboard)[0].object->ObjectFromVDK()->Owner());
      pastewidget->Enabled = targetform == sourceform;
      sprintf(buff,"Paste [%s]",
	      pastewidget->Enabled ?
	      (char*) (*WidgetClipboard)[0].object->Name() :
	      "none");
      pastewidget->Caption = buff;
    }
  // call ancestor
  VDKMenu::Popup(button,activate_time);
}
/////////////////////////////////////////////////
/*
 */
VDKBWidgetPopMenu::VDKBWidgetPopMenu(VDKObject* widget):
  VDKMenu(widget->Owner()),parent_widget(widget)

{
  VDKBObject* self = dynamic_cast<VDKBObject*>(parent_widget);
  sprintf(buff,"%s", self ? (char*) self->Name() : "Nop");
  VDKMenuItem *nop = new VDKMenuItem(this,buff);
  Separator();
  nop->Enabled = false;
  setsize = new VDKMenuItem(this,_(wi_widget_prompts[19]));
  Separator();
  selectparent = new VDKMenuItem(this,_(wi_widget_prompts[20]));
  delwidget = new VDKMenuItem(this,_("Remove"));
  copywidget = new VDKMenuItem(this,_("Copy"));
  cutwidget = new VDKMenuItem(this,_("Cut"));
  pastewidget = new VDKMenuItem(this,_("Paste"));
  pasteothers = new VDKMenuItem(this,_("Paste others.."));
  SignalConnect(delwidget,"activate",&VDKBWidgetPopMenu::DelWidget);
  SignalConnect(setsize,"activate",&VDKBWidgetPopMenu::SetWidgetSize);
  SignalConnect(selectparent,"activate",
		&VDKBWidgetPopMenu::SelectParentContainer);
  SignalConnect(copywidget,"activate",&VDKBWidgetPopMenu::Copy);
  SignalConnect(cutwidget,"activate",&VDKBWidgetPopMenu::Cut);
  SignalConnect(pastewidget,"activate",&VDKBWidgetPopMenu::Paste);
  SignalConnect(pasteothers,"activate",&VDKBWidgetPopMenu::PasteOthers);
  /*
      better add it to owner, so will be surely
      destroyed even if never popped
  */
  parent_widget->Owner()->AddItem(this);
}

/////////////////////////////////////////////////////////////
DEFINE_SIGNAL_LIST(VDKBContainerPopMenu,VDKMenu);
/*
 */
VDKBContainerPopMenu::VDKBContainerPopMenu(VDKObject* widget):
  VDKMenu(widget->Owner()),parent_widget(widget)

{
  VDKBObject* self = dynamic_cast<VDKBObject*>(parent_widget);
  sprintf(buff,"%s", self ? (char*) self->Name() : "Nop");
  VDKMenuItem *nop = new VDKMenuItem(this,buff);
  Separator();
  nop->Enabled = false;
}

void
VDKBContainerPopMenu::Setup()
{
  bool canCut = true;
  VDKBEventContainer* box =
    dynamic_cast<VDKBEventContainer*>(parent_widget);
  if(box)
    {
      VDKBEventContainer* outerbox = box->Outerbox();
      if(outerbox)
	canCut =
	  (! dynamic_cast<VDKBPaned*>(outerbox)) &&
	  (! dynamic_cast<VDKBGuiNotebook*>(outerbox)) &&
	  (! dynamic_cast<VDKBFrame*>(outerbox)) &&
	  (! dynamic_cast<VDKBTable*>(outerbox)) ;
    }
  // not yet implemented
  // copywidget = new VDKMenuItem(this,"Copy widget");
  // copywidget->Enabled = false;
  cutwidget = new VDKMenuItem(this,_("Cut widget"));
  cutwidget->Enabled = canCut;
  pastewidget = new VDKMenuItem(this,_("Paste widget"));
  pasteothers = new VDKMenuItem(this,_("Paste others.."));
  SignalConnect(cutwidget,"activate",&VDKBContainerPopMenu::Cut);
  SignalConnect(pastewidget,"activate",&VDKBContainerPopMenu::Paste);
  SignalConnect(pasteothers,"activate",&VDKBContainerPopMenu::PasteOthers);
  // not yet implemented
  // SignalConnect(copywidget,"activate",&VDKBContainerPopMenu::Copy);
}
/*
Overridden popmenu,
enable/disable pasting widget
 */
void
VDKBContainerPopMenu::Popup(guint button,guint32 activate_time)
{
  VDKBGuiForm* targetform =
    dynamic_cast<VDKBGuiForm*>(parent_widget->Owner());
  pastewidget->Enabled = WidgetClipboard->size() > 0;
  pasteothers->Enabled = WidgetClipboard->size() > 1;
/*
  Allowing pasting between form needs more investigation
  and not seems very useful.
  Denies pasting between forms for several reasons:
  - if the cutted widget has sone signals assigned
  is necessary to disconnect those signals, it can be done
  using Form::DisconnectWidget(VDKBobject*)
  - if the widget has the same name of a widget on target form
  is necessary to create a new widget name before inserting it.
  - there can be others not yet investigated interferences.
*/
  if(pastewidget->Enabled)
    {

      VDKBGuiForm* sourceform =
	dynamic_cast<VDKBGuiForm*>
	((*WidgetClipboard)[0].object->ObjectFromVDK()->Owner());
      pastewidget->Enabled = targetform == sourceform;
      sprintf(buff,_("Paste %s::%s"),
	      (*WidgetClipboard)[0].object->VDKName(),
	      (char*) (*WidgetClipboard)[0].object->Name());
      pastewidget->Caption = buff;
    }
  else
    pastewidget->Caption = _("Paste");
  sprintf(buff,_("Cut %s::%s"),
	  targetform->Active ?
	  targetform->Active->VDKName():
	  _("none"),
	  targetform->Active ?
	  (char*) targetform->Active->Name() :
	  _("none"));
  cutwidget->Caption = buff;
  // call ancestor
  VDKMenu::Popup(button,activate_time);
}

/*
 */
bool
VDKBContainerPopMenu::PasteOthers(VDKObject*)
{
  VDKBWidgetClipboardArray cliparray;
  VDKBWidgetClipboardDialog* child =
    new VDKBWidgetClipboardDialog(parent_widget->Owner(),
				  &cliparray,
				  NULL);
  child->Setup();
  child->ShowModal(GTK_WIN_POS_MOUSE);
  if(cliparray.size() > 0)
    {
      if(cliparray.size() == 1)
	{
	  VDKBWidgetClipboardItem item = cliparray[0];
	  // finds widget ordinal position
	  // into clipboard
	  int ndx = WidgetClipboard->at(item);
	  if(ndx >= 0)
	    // paste widget resetting WI
	    WidgetClipboard->PasteWidget(parent_widget,ndx, true);
	}
      else
	{
	  int z = 0;
	  for(; z < cliparray.size(); z++)
	    {
	      VDKBWidgetClipboardItem item = cliparray[z];
	      // finds widget ordinal position
	      // into clipboard
	      int ndx = WidgetClipboard->at(item);
	      if(ndx >= 0)
		// reset WI only on last item
		WidgetClipboard->PasteWidget(parent_widget,
					     ndx,
					     z < (cliparray.size()-1) ?
					     false: true);
	    }
	}
    }
  return true;
}
/*
 */
bool
VDKBContainerPopMenu::Paste(VDKObject*)
{
  // paste stack top widget
  WidgetClipboard->PasteWidget(parent_widget,0);
  return true;
}
/*
 */
bool
VDKBContainerPopMenu::Cut(VDKObject*)
{
/*
    plm patch
  WidgetClipboard->CutWidget(parent_widget);
  return true;
  */
  GtkWidget *widget = gtk_grab_get_current();
  if (widget) 
    gtk_grab_remove(widget);
  WidgetClipboard->CutWidget(parent_widget);
  return true;
}
/*
 */
bool
VDKBContainerPopMenu::Copy(VDKObject*)
{
  // not yet implemented
  // WidgetClipboard->CopyWidget(parent_widget);
  return true;
}



