/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.3 
 * July 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_slider.h>
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb/vdkb_fixed.h>
/*
================================
symbolic constants to templatize
a bit 
================================
*/
// for methods and other stuff
#define CLASS VDKBSlider
// put here vdk class name string
#define VDK_CLASS "VDKSlider"
// put here vdk class name 
#define VDK_ANCESTOR  VDKSlider
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "slider"

extern char* wi_widget_prompts[];
static char buff[128];

/*
substitutes sep1 with sep2 in s
*/
void strreplace(char* s, char sep1, char sep2)
{
  char* sp = s;
  while(s && *sp)
    {
      if(*sp == sep1)
	*sp = sep2;
      sp++;
    }
}
// used to autogenerate default
// button  names and captions

int CLASS::Counter = 0;
/* 
 label button properties names
 */
static char* vdkslider_props[] =
{ 
SLIDER_DIGITS, SLIDER_STEP,
SLIDER_LOWER, SLIDER_UPPER,
SLIDER_UPDATE_POLICY, SLIDER_DEFVALUE,
0
};

char* vdkslider_signals[] = { SIGNAL_VALUE_CHANGED, 0 };
char* vdkslider_nicknames[] = { NICK_VALUE_CHANGED ,0 };
//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDKBEvSlider);
DEFINE_EVENT_LIST(CLASS,VDKBEvSlider);
///////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, 
	     VDKForm* owner, 
	     float def,
	     float lower,
	     float upper,
	     float step):
  VDKBEvSlider(owner), 
  VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list 
  // (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkslider_props[t]; t++)
    proplist.add(VDKBProperty(vdkslider_props[t]));

  sprintf(buff,"%f",def);
  SetPropValue(SLIDER_DEFVALUE,buff);

  sprintf(buff,"%f",lower);
  SetPropValue(SLIDER_LOWER,buff);

  sprintf(buff,"%f",upper);
  SetPropValue(SLIDER_UPPER,buff);

  sprintf(buff,"%f",step);
  SetPropValue(SLIDER_STEP,buff);

  SetPropValue(SLIDER_UPDATE_POLICY,"0");
  SetPropValue(SLIDER_DIGITS,"1");
  // progress bar not expand
  SetPropValue(JUSTIFY_INTERNAL,"l_justify");
  SetPropValue( EXPAND_INTERNAL,CHECK_FALSE);
  SetPropValue(FILL_INTERNAL,CHECK_FALSE);
  SetPropValue(PADDING_INTERNAL,CHECK_FALSE);
  for(t=0; vdkslider_signals[t]; t++)
    siglist.add(VDKBSignal(vdkslider_signals[t],
			   this,
			   vdkslider_nicknames[t]));
  // connects events.
  CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;",
	  PROP_SLIDER_LOWER,(char*) GetProp(SLIDER_LOWER));
  fprintf(fp,"\n\t%s%s;",
	  PROP_SLIDER_UPPER,(char*) GetProp(SLIDER_UPPER));
  fprintf(fp,"\n\t%s%s;",
	  PROP_SLIDER_STEP,(char*) GetProp(SLIDER_STEP));
  fprintf(fp,"\n\t%s%s;",
	   PROP_SLIDER_DIGITS,(char*) GetProp(SLIDER_DIGITS));
  fprintf(fp,"\n\t%s%s;",
	  PROP_SLIDER_UPDATE_POLICY,(char*) GetProp(SLIDER_UPDATE_POLICY));
  fprintf(fp,"\n\t%s%s;",
	  PROP_SLIDER_DEFVALUE,(char*) GetProp(SLIDER_DEFVALUE));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* slider = NULL;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    slider = new CLASS(buff,owner);
  // add widget to form
  return owner->AddToSelf(slider,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  char lower[16],upper[16],step_inc[16],def[16];
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return NULL;
  // get default values
  if(parser.GetParam(arg,buffer,PROP_SLIDER_LOWER))
      strcpy(lower,arg);
  else
    strcpy(lower,"0.0");
  strreplace(lower,',','.');      
  if(parser.GetParam(arg,buffer,PROP_SLIDER_UPPER ))
      strcpy(upper,arg);
  else
    strcpy(upper,"1.0");
  strreplace(upper,',','.');      
  if(parser.GetParam(arg,buffer,PROP_SLIDER_STEP))
    strcpy(step_inc,arg);
  else
    strcpy(step_inc,"0.1");
  strreplace(step_inc,',','.');      
  if(parser.GetParam(arg,buffer,PROP_SLIDER_DEFVALUE))
      strcpy(def,arg);
  else
    strcpy(def,"0.0");
  strreplace(def,',','.');      
  source = new char[4096];
  sprintf(tmp,"\n%s = new %s(this,%s,%s,%s,%s);",
	  obj_name,VDK_CLASS,def,lower,upper,step_inc);
  strcpy(source,tmp);
  
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  if(parser.GetParam(arg,buffer,PROP_SLIDER_DIGITS) && 
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s =  %s;",
	     obj_name,SLIDER_DIGITS,arg);
     strcat(source,tmp);
   }    
  if(parser.GetParam(arg,buffer,PROP_SLIDER_UPDATE_POLICY) && 
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = (VDKUpdateType) %s;",
	     obj_name,SLIDER_UPDATE_POLICY,arg);
     strcat(source,tmp);
   }    
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  float lower = 0.0, upper = 20, step_inc = 0.1, def = 0.0;
  char arg[64];
  CLASS* slider = NULL;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return false;
  // get default values
  if(parser.GetParam(arg,buffer,PROP_SLIDER_LOWER))
    lower = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_SLIDER_UPPER))
    upper = atof(arg);
  if(parser.GetParam(arg,buffer, PROP_SLIDER_STEP))
    step_inc = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_SLIDER_DEFVALUE))
    def = atof(arg);
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      slider = new CLASS(obj_name,owner,def,lower,upper,step_inc);

      if(parser.GetParam(arg,buffer,PROP_SLIDER_DIGITS) && 
	 strcmp(arg,NIHIL_PROP))
	{
	  slider->SetDigits( atoi(arg));
	  slider->SetPropValue(SLIDER_DIGITS,arg);
	}
      if(parser.GetParam(arg,buffer,PROP_SLIDER_UPDATE_POLICY) && 
	 strcmp(arg,NIHIL_PROP))
	{
	  slider->SetUpdatePolicy((VDKUpdateType) atoi(arg));
	  slider->SetPropValue(SLIDER_UPDATE_POLICY,arg);
	}
      // pack widget to container
      return owner->PackToSelf(slider, container, buffer, parser);
    }
  else
    return false;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
static char* update_policy[] = {"continuous","discontinuos","delayed",0};
/*
 */
VDKObjectContainer* 
CLASS::ExtraWidget(VDKBObjectInspector* isp) 
{ 
  inspector = isp;
  VDKLabelButton* button;
  int t=0;
  float bc = 0.1;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,
				  v_box,shadow_etched_in);
  VDKTable *table = new VDKTable(inspector,6,2);
  table->SetSize(219,-1);
  // lower bound setting  
  button = new VDKLabelButton(inspector,_(wi_widget_prompts[52]));
  table->AddToCell(button,0,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetLower);
  lower = new VDKEntry(inspector,0,(char*) GetProp(SLIDER_LOWER));
  lower->SetSize(100,-1);
  table->AddToCell(lower,0,1);
  // upper bound setting
  button = new VDKLabelButton(inspector,_(wi_widget_prompts[53]));
  table->AddToCell(button,1,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetUpper);
  upper = new VDKEntry(inspector,0,(char*) GetProp(SLIDER_UPPER));
  upper->SetSize(100,-1);
  table->AddToCell(upper,1,1);
  // step increment setting
  button = new VDKLabelButton(inspector,_(wi_widget_prompts[54]));
  table->AddToCell(button,2,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetStep);
  bc = atof( (char*) GetProp(SLIDER_STEP));
  step = new VDKSpinButton(inspector, bc,0,50,0.1,0 );
  step->SetSize(100,-1);
  table->AddToCell(step,2,1);
  // update policy setting
  int abc = atoi((char*) GetProp(SLIDER_UPDATE_POLICY ));
  button = new VDKLabelButton(inspector,_(wi_widget_prompts[55]));
  table->AddToCell(button,3,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetUpdatePolicy);
  updatepolicy = new VDKCombo(inspector,NULL);
  updatepolicy->SetSize(100,-1);
  StringList sl;
  for(t = 0;update_policy[t];t++)
    sl.add(VDKString(update_policy[t]));
  updatepolicy->PopdownStrings = sl;
  updatepolicy->SelectItem(abc);
  table->AddToCell(updatepolicy,3,1);
  // precision digits setting
  button = new VDKLabelButton(inspector,_(wi_widget_prompts[56]));
  table->AddToCell(button,4,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetDigits);
  digits = new VDKEntry(inspector, 0, (char*) GetProp(SLIDER_DIGITS) );
  digits->SetSize(100,-1);
  table->AddToCell(digits,4,1);
  // default value setting
  button = new VDKLabelButton(inspector,_(wi_widget_prompts[57]));
  table->AddToCell(button,5,0);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnSetDefValue);
  defvalue = new VDKEntry(inspector, 0, (char*) GetProp(SLIDER_DEFVALUE));
  defvalue->SetSize(100,-1);
  table->AddToCell(defvalue,5,1);
  // finished
  bframe->Add(table,l_justify,false,false,false);
  return bframe; 
}

/*
 */

bool
CLASS::OnSetLower(VDKObject*)
{

  if(strlen(lower->Text) > 0)
    {
      sprintf(buff,"%s",(char*) lower->Text);
      SetPropValue(SLIDER_LOWER,buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool
CLASS::OnSetUpper(VDKObject*)
{
  if(strlen(upper->Text) > 0)
    {
      sprintf(buff,"%s",(char*) upper->Text);
      strreplace(buff,',','.');
      SetPropValue(SLIDER_UPPER,buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool
CLASS::OnSetStep(VDKObject*)
{
  sprintf(buff,"%f",(float) step->ValueAsFloat);
  //  strreplace(buff,',','.');
  SetPropValue(SLIDER_STEP,buff);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetUpdatePolicy(VDKObject*)
{
  int sel = updatepolicy->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  SetPropValue(SLIDER_UPDATE_POLICY,buff);
  inspector->FormNeedToBeChanged();
  return true;
}

/*
 */
bool
CLASS::OnSetDigits(VDKObject*)
{
  if(strlen(digits->Text) > 0)
    {
      sprintf(buff,"%s",(char*) digits->Text);
      SetPropValue(SLIDER_DIGITS,buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}

/*
 */
bool
CLASS::OnSetDefValue(VDKObject*)
{
  if(strlen(defvalue->Text) > 0)
    {
      sprintf(buff,"%s",(char*) defvalue->Text);
      SetPropValue(SLIDER_DEFVALUE,buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}



