/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.6
 * August 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_frmlist.h>
#include <vdkb/vdkb.h>
#include <vdkb/vdkb_prjman.h>

extern char *newform_xpm[];

DEFINE_SIGNAL_MAP(VDKBFormListForm,VDKForm)
ON_SIGNAL(formCustomList,select_row_signal,OnformCustomListSelectRow),
ON_SIGNAL(selectButton,clicked_signal,OnformCustomListSelectRow),
ON_SIGNAL(closeButton,clicked_signal,OncloseButtonClick)
END_SIGNAL_MAP

/*
form constructor
*/
VDKBFormListForm::VDKBFormListForm(VDKForm* owner,
				   VDKBProjectManager *prjman,
				   char* title):
	VDKForm(owner,title),prjman(prjman)
{
}

/*
form destructor
*/
VDKBFormListForm::~VDKBFormListForm()
{
}

void
VDKBFormListForm::GUISetup(void)
{
  SetSize(222,295);
  Title = _("VDKBuilder");
  vbox4 = new VDKBox(this,v_box);
  vbox4->SetSize(220,291);
  Add(vbox4,0,1,1,0);
  char* formCustomListTitles[] = { N_("Project forms list") };
  char* p = _(formCustomListTitles[0]);
  formCustomList = new 
    VDKCustomList(this,1,&p/*formCustomListTitles*/,(GtkSelectionMode) 3);
  formCustomList->SetSize(232,-1);
  vbox4->Add(formCustomList,0,1,1,0);
  separator2 = new VDKSeparator(this,h_separator);
  separator2->SetSize(232,2);
  vbox4->Add(separator2,0,0,0,0);
  hbox5 = new VDKBox(this,h_box);
  hbox5->SetSize(229,27);
  vbox4->Add(hbox5,0,0,0,0);
  hbox5->BorderWidth(0);
  selectButton = new VDKLabelButton(this,_("Edit"));
  hbox5->Add(selectButton,0,1,1,0);
  closeButton = new VDKLabelButton(this,_("Close"));
  closeButton->Relief = (GtkReliefStyle) 0;
  hbox5->Add(closeButton,0,1,1,0);
}
/*
 */
void
VDKBFormListForm::OnShow(VDKForm*)
{
Update();
}
/*
 */
void
VDKBFormListForm::Update(void)
{
  // load list with project forms
  VDKBProject* project;
  if(prjman && (project = prjman->Project()) )
    {
      formCustomList->Clear();
      formCustomList->Freeze();
      // accesses to prj manager unit list
      UnitListIterator li(project->Units());
      for(;li;li++)
	{
	  char *name,*gui;
	  VDKBUnit* unit = li.current();
	  name = (char*) unit->Name();
	  gui = unit->Gui();
	  if(!access(gui,F_OK))
	      formCustomList->AddRow(&name,newform_xpm);
	}
      formCustomList->Thaw();
    }
}
/*
form setup
*/
void
VDKBFormListForm::Setup(void)
{
	GUISetup(); // vdkb gui setup
// put your code below here
}

// signal response method 
bool
VDKBFormListForm::OnformCustomListSelectRow(VDKObject* sender)
{
  VDKBProject* project;
  int ndx = formCustomList->Selected.Row();
  if(ndx < 0)
    return true;
  else if(prjman && (project = prjman->Project()) )
    {
      VDKString name = formCustomList->Tuples[ndx][0];
      name += ".";
      name += FORM_EXT;
      if(!access((char*) name,F_OK))
	{
	  // create a form parsing .frm file (or raise)
	  VDKBGuiForm* form = prjman->CreateForm((char*) name);
	  // make inspector
	  if(form)
	    {
	      if( !prjman->objInspector)
		{
		  prjman->objInspector = new VDKBObjectInspector(prjman,NULL);
		  prjman->objInspector->Setup();
		  prjman->objInspector->Show(); 
		}
	      else if(prjman->objInspector->Iconized)
		prjman->objInspector->Iconized = false;
	      else
		prjman->objInspector->Raise();
	      prjman->objInspector->LoadTree(form);
	      form->Raise();
	    }
	  // set automa
	  VDKBMainForm* mainform = dynamic_cast<VDKBMainForm*>( Owner());
	  if(mainform)
	    mainform->Automa(automa_edit_form_on); 
	}
    }
  return true;
}
// signal response method 
bool
VDKBFormListForm::OnselectButtonClick(VDKObject* sender)
{
return true;
}

// signal response method 
bool
VDKBFormListForm::OncloseButtonClick(VDKObject* sender)
{
Close();
return true;
}
