/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_xmemo_h
#define _vdkb_xmemo_h
#if HAVE_CONFIG_H
#include <config.h>
#endif
#if USE_XDB
#include <vdk/vdk.h>
#include <vdkxdb/vdkxdb.h>
#include <vdkxdb/vdkxtable.h>
#include <vdkxdb/vdkxmemo.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>


class VDKBGuiForm;
class VDKBParser;
class VDKBXMemo: public VDKXMemo, public VDKBObject
{

 protected:
  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *setsize,*delwidget;
  VDKBObjectInspector* inspector;
  VDKCheckButton* wrap,*editable;
  VDKCustomList* tablelist,*fieldlist;
  VDKCustomButton* assignButton;
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBXMemo(char* name,VDKForm* owner);
  virtual ~VDKBXMemo() {}
  virtual int Type() { return vdkbclass_xmemo; }
  virtual char* VDKName() { return "VDKXMemo"; }
  virtual int isA() { return vdkbclass_xmemo; }
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  void PopMenu() { popmenu->Popup(); }
  // designer
  bool OnSetWordWrap(VDKObject*);
  bool OnSetEditable(VDKObject*);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  bool OnAssignButtonClicked(VDKObject*);
  bool OnTableListSelectRow(VDKObject*);
  bool OnTableListUnselectRow(VDKObject*);
  DECLARE_SIGNAL_LIST(VDKBXMemo);
  DECLARE_EVENT_LIST(VDKBXMemo);
};
#endif
#endif
