/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.3
 * July 1999
 * ===========================
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_slider_h
#define _vdkb_slider_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>
#include <vdkb/vdkb_evslider.h>
class VDKBGuiForm;
class VDKBParser;
class VDKBSlider: public VDKBEvSlider, public VDKBObject
{

 protected:
  VDKBWidgetPopMenu *popmenu;
  VDKMenuItem *setsize,*delwidget;
  VDKBObjectInspector* inspector;
  VDKEntry *digits,*lower,*upper,*defvalue;
  VDKSpinButton *step;
  VDKCombo *updatepolicy;
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBSlider(char* name,VDKForm* owner, 
	     float def = 0.0,
	     float lower = 0.0,
	     float upper = 20.0,
	     float step = 0.1);
  virtual ~VDKBSlider() {}
  virtual int Type() { return vdkbclass_slider; }
  virtual char* VDKName() { return "VDKSlider"; }
  virtual int isA() { return vdkbclass_slider; }
  void PopMenu() { popmenu->Popup(); }
  // designer
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  bool OnSetDigits(VDKObject*);
  bool OnSetStep(VDKObject*);
  bool OnSetLower(VDKObject*);
  bool OnSetUpper(VDKObject*);
  bool OnSetUpdatePolicy(VDKObject*);
  bool OnSetDefValue(VDKObject*);
  DECLARE_SIGNAL_LIST(VDKBSlider);
  DECLARE_EVENT_LIST(VDKBSlider);
};
#endif
