/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.6
 * August 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_newprjwiz_h
#define _vdkb_newprjwiz_h
#include <vdk/vdk.h>

typedef
struct VDKBNewProjectInfo
{
VDKString prjname;
bool isValid;
int type;
};



class VDKBNewPrjWiz: public VDKForm
{

private:
// vdkbuilder reserved gui construction
	void GUISetup(void);
	VDKBNewProjectInfo* info;
public:
	bool canClose;
	VDKBNewPrjWiz(VDKForm* owner, char* title,
		VDKBNewProjectInfo* info);
	~VDKBNewPrjWiz();
	void Setup(void);
	bool CanClose() { return canClose; }
protected:
	VDKFrame*  frame1;
	VDKBox*  vbox2;
	VDKFixed*  fixed3;
	VDKLabel*  label7;
	VDKLabel*  label8;
	VDKEntry*  prjrootdir;
	VDKEntry*  prjname;
	VDKLabelButton*  browsebutton;
	VDKSeparator*  separator0;
	VDKLabelButton*  okbutton;
	VDKLabelButton*  cancelbutton;
	VDKPixmap*  pixmap0;
	VDKPixmap*  pixmap1;
	VDKPixmap*  pixmap2;
	VDKPixmap*  pixmap3;
	VDKEntry*  prjpathname;
	VDKLabel*  label2;
	VDKLabel*  label3;
	VDKRadioButtonGroup*  prjtypegroup;
	VDKRadioButton*  plainvdk;
	VDKRadioButton*  console;
	VDKRadioButton*  gnome;
 public:
	DECLARE_SIGNAL_MAP(VDKBNewPrjWiz);
	bool OnbrowsebuttonClick(VDKObject* sender);
	bool OnprjnameChanged(VDKObject* sender);
	bool OnprjrootdirChanged(VDKObject* sender);
	bool OnokbuttonClick(VDKObject* sender);
	bool OncancelbuttonClick(VDKObject* sender);

};


// Vdkb_pwiz APPLICATION  CLASS
class Vdkb_pwizApp: public VDKApplication
{

public:
	Vdkb_pwizApp(int* argc, char** argv);
	~Vdkb_pwizApp();
	void Setup(void);
};
#endif
