/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.3
 * July 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkb_grid_h
#define _vdkb_grid_h
#include <vdk/vdk.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_widpopmenu.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBGrid: public VDKGrid, public VDKBObject
{

 protected:
  VDKBWidgetPopMenu *popmenu;
  VDKBObjectInspector* inspector;
  VDKCheckButton *rowvisible,*colvisible,*editable_check;
  static void OnGlobalButtonClicked(GtkWidget* wid, gpointer gp);
 public:
  static int Counter;
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, 
			   char* buffer,VDKBParser& parser);
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  VDKBGrid(char* name,VDKForm* owner, int rows, int cols, 
	   bool editable = false);
  virtual ~VDKBGrid() {}
  virtual int Type() { return vdkbclass_grid; }
  virtual char* VDKName() { return "VDKGrid"; }
  virtual int isA() { return vdkbclass_grid; }
  void PopMenu() { popmenu->Popup(); }
  // designer
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  bool OnSetRowVisible(VDKObject*);
  bool OnSetColVisible(VDKObject*);
  bool OnSetEditable(VDKObject*);
  DECLARE_SIGNAL_LIST(VDKBGrid);
  DECLARE_EVENT_LIST(VDKBGrid);
};
#endif
