/*
customtree Form
implementation file:customtree.cc
*/
#include <customtree.h>
const int MAX_TITLES = 1;
// in pixmap.cc
extern char *mini_ofolder_xpm[];
extern char *mini_cfolder_xpm[];
// in src/pixdata.cc
extern char *testo_xpm[];
static char buff[128];
///////////////////////////////////////////////////

// Customtree FORM  CLASS
/*
form constructor
*/
CustomtreeForm::CustomtreeForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
}

/*
form destructor
*/
CustomtreeForm::~CustomtreeForm()
{
}

/*
form setup
*/
void
CustomtreeForm::Setup(void)
{
	GUISetup(); // vdkb gui setup
// put your code below here
  // load tree
  BuildTree(NULL);
  // dyna tables
  SignalConnect(quit,"clicked",&CustomtreeForm::Quit);
  // when mouse is released shows multiple selections (if any)
  EventConnect(tree,"button_release_event",
	&CustomtreeForm::ShowExtendedSelection);
  printf("\ntree size:%d",tree->Size());
  fflush(stdout);

}
/*
 */
bool
CustomtreeForm::ExpandNode(VDKObject* )
{
VDKTreeNode node = tree->SelectedNode;
if(node && ! tree->IsLeaf(node))
  {
    if(tree->IsExpanded(node))
      gtk_ctree_collapse_recursive(GTK_CTREE(tree->CustomWidget()),node);
    else
      gtk_ctree_expand_recursive(GTK_CTREE(tree->CustomWidget()),node);
  }
return true;
}
/* 
 */  
bool 
CustomtreeForm::RemoveSelection(VDKObject* )
{
  VDKTreeNode node = NULL;
  VDKTreeNodeArray& selections = tree->Selections();
  if( (selections.size() == 0) && (node = tree->SelectedNode) )
	tree->RemoveNode(node);
  else
    {
      tree->Freeze();
      for(int j = 0; j < selections.size(); j++)
	tree->RemoveNode(selections[j]);
      tree->Thaw();
    }
  if(tree->Size() == 0)
    {
      remove->Enabled = false;
      build->Enabled = true;
    }
  return true;
}
 
/* 
 */  
bool 
CustomtreeForm::ClearTree(VDKObject* obj)
{
  tree->Clear();
  remove->Enabled = false;
  build->Enabled = true;
  return true;
}
/*
 */
bool 
CustomtreeForm::Quit(VDKObject*) { Close(); return true; }

/*
 */
bool 
CustomtreeForm::ShowSelection(VDKObject* obj)
{ 
  VDKCustomTree* aTree = NULL;
  VDKTreeNode node;
  Tuple tuple;
  int t,j;
  // downcast from VDKObj to VDKCustomTree
  aTree = dynamic_cast<VDKCustomTree*>(obj);
  // when called by button surely fails
  aTree = aTree ? aTree : tree;
  
  VDKTreeNodeArray& selections = aTree->Selections();
  if(selections.size() == 0)
    {
      node = aTree->SelectedNode;
      if(node && aTree->IsLeaf(node))
	{
	  tuple = (*aTree)[node];
	  for(t = 0; t < tuple.size(); t++)
	    printf("\ncol:%d, text:%s",t,(char*) tuple[t]);
	  fflush(stdout);
	}
    }
  else
    {
      for(j = 0; j < selections.size(); j++)
	{ 
	  tuple = (*aTree)[selections[j]];
	  for(t = 0; t < tuple.size(); t++)
	    printf("\ncol:%d, text:%s",t,(char*) tuple[t]);
	  fflush(stdout);
	}
    }
  return true;
}
/*
 */ 
bool 
CustomtreeForm::ShowExtendedSelection(VDKObject* obj, GdkEvent*) 
{
  // downcast from VDKObj to VDKCustomTree
  VDKCustomTree* aTree = dynamic_cast<VDKCustomTree*>(obj);
  g_return_val_if_fail(aTree != NULL,false);
  VDKTreeNodeArray& selections = aTree->Selections();
  if(selections.size() > 1)
    ShowSelection(obj);
  printf("\nselection size:%d",selections.size());
  fflush(stdout);
  return true;
}
/* 
 */
#define RAND_RANGE  20.0
bool 
CustomtreeForm::BuildTree(VDKObject*)
{
  VDKTreeNode node; 
  int t = 0,siblings = 3;
  int depth = 2; 
  char* text = &buff[0];
  tree->Freeze();
  // add a root + 3 siblings 
  sprintf(buff,"Folder 1");
  node = tree->AddNode(&text,NULL,
		       true,false, mini_cfolder_xpm, mini_ofolder_xpm);
  for(t = 0; t < siblings; t++)
    {
      sprintf(buff,"File %d",t);
      tree->AddNode(&text,node,false,true,testo_xpm);
    }
  // add a root + depth childs + a sibling
  sprintf(buff,"Folder 2");
  node = tree->AddNode(&text,NULL,
		       true,false, mini_cfolder_xpm, mini_ofolder_xpm); 
  for(t = 0;  t < depth;  t++) 
    {
      sprintf(buff,"Folder %d",t+3);
      node = tree->AddNode(&text,node, 
			   true,false, mini_cfolder_xpm, mini_ofolder_xpm);
    }
  sprintf(buff,"File 1");
  tree->AddNode(&text,node,false,true,testo_xpm);
  // add again a root + 10 siblings
  siblings = 10;
  sprintf(buff,"Folder 5");
  node = tree->AddNode(&text,NULL,
		       true,false, mini_cfolder_xpm, mini_ofolder_xpm);
  for(t = 0; t < siblings; t++)
    {
      sprintf(buff,"File %d",t);
      tree->AddNode(&text,node,false,true,testo_xpm);
    }
  tree->Thaw();
  build->Enabled = false;
  remove->Enabled = true;
  // select first node
  tree->SelectedNode = NULL;
  return true;
}

