/* valanamedargument.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALANAMEDARGUMENT_H__
#define __VALA_VALANAMEDARGUMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_NAMED_ARGUMENT (vala_named_argument_get_type ())
#define VALA_NAMED_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument))
#define VALA_NAMED_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgumentClass))
#define VALA_IS_NAMED_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMED_ARGUMENT))
#define VALA_IS_NAMED_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMED_ARGUMENT))
#define VALA_NAMED_ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgumentClass))

typedef struct _ValaNamedArgumentPrivate ValaNamedArgumentPrivate;

/**
 * Represents a named argument in the source code. A named argument may be used
 * when creating objects and attributes where no parameter list exists.
 */
struct _ValaNamedArgument {
	ValaCodeNode parent_instance;
	ValaNamedArgumentPrivate * priv;
};

struct _ValaNamedArgumentClass {
	ValaCodeNodeClass parent_class;
};


ValaNamedArgument* vala_named_argument_new (const char* name, ValaExpression* argument, ValaSourceReference* source_reference);
const char* vala_named_argument_get_name (ValaNamedArgument* self);
void vala_named_argument_set_name (ValaNamedArgument* self, const char* value);
ValaExpression* vala_named_argument_get_argument (ValaNamedArgument* self);
void vala_named_argument_set_argument (ValaNamedArgument* self, ValaExpression* value);
GType vala_named_argument_get_type (void);


G_END_DECLS

#endif
